/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp;

import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.FTPFile;
import com.enterprisedt.net.ftp.FTPFileParser;
import com.enterprisedt.net.ftp.UnixFileParser;
import com.enterprisedt.net.ftp.VMSFileParser;
import com.enterprisedt.net.ftp.WindowsFileParser;
import com.enterprisedt.util.debug.Logger;
import java.text.ParseException;
import java.util.Locale;

public class FTPFileFactory {
    public static final String cvsId = "@(#)$Id: FTPFileFactory.java,v 1.1 2008-12-16 05:14:15 pengxu_ge Exp $";
    private static Logger log = Logger.getLogger("FTPFileFactory");
    static final String WINDOWS_STR = "WINDOWS";
    static final String UNIX_STR = "UNIX";
    static final String VMS_STR = "VMS";
    private String system;
    private WindowsFileParser windows = new WindowsFileParser();
    private UnixFileParser unix = new UnixFileParser();
    private VMSFileParser vms = new VMSFileParser();
    private FTPFileParser parser = null;
    private FTPFileParser origParser = null;
    private boolean usingVMS = false;
    private boolean rotateParsers = true;
    private Locale[] localesToTry;
    private int localeIndex = 0;

    public FTPFileFactory(String system) throws FTPException {
        this.setParser(system);
    }

    public FTPFileFactory(FTPFileParser parser) {
        this.parser = parser;
        this.origParser = parser;
        this.rotateParsers = false;
    }

    public VMSFileParser getVMSParser() {
        return this.vms;
    }

    public void setLocale(Locale locale) {
        this.windows.setLocale(locale);
        this.unix.setLocale(locale);
        this.vms.setLocale(locale);
        this.parser.setLocale(locale);
    }

    public void setLocales(Locale[] locales) {
        this.localesToTry = locales;
        this.setLocale(locales[0]);
        this.localeIndex = 1;
    }

    private void setParser(String system) {
        this.system = system;
        if (system.toUpperCase().startsWith(WINDOWS_STR)) {
            this.parser = this.windows;
        } else if (system.toUpperCase().startsWith(UNIX_STR)) {
            this.parser = this.unix;
        } else if (system.toUpperCase().startsWith(VMS_STR)) {
            this.parser = this.vms;
            this.usingVMS = true;
        } else {
            this.parser = this.unix;
            log.warn("Unknown SYST '" + system + "' - defaulting to Unix parsing");
        }
        this.origParser = this.parser;
    }

    private void reinitializeParsers() {
        this.windows.setIgnoreDateParseErrors(false);
        this.unix.setIgnoreDateParseErrors(false);
        this.vms.setIgnoreDateParseErrors(false);
        this.parser.setIgnoreDateParseErrors(false);
    }

    public FTPFile[] parse(String[] files) throws ParseException {
        this.reinitializeParsers();
        FTPFile[] temp = new FTPFile[files.length];
        if (files.length == 0) {
            return temp;
        }
        int count = 0;
        boolean checkedUnix = false;
        boolean reparse = false;
        int reparseCount = 1;
        for (int i = 0; i < files.length; ++i) {
            if (reparse) {
                i -= reparseCount;
                reparse = false;
                reparseCount = 1;
            }
            try {
                if (files[i] == null || files[i].trim().length() == 0) continue;
                if (!checkedUnix && this.parser != this.unix && UnixFileParser.isUnix(files[i])) {
                    this.parser = this.unix;
                    checkedUnix = true;
                    log.info("Swapping Windows parser to Unix");
                }
                FTPFile file = null;
                if (this.usingVMS) {
                    reparseCount = 1;
                    StringBuffer filename = new StringBuffer(files[i]);
                    while (i + 1 < files.length && files[i + 1].indexOf(59) < 0) {
                        filename.append(" ").append(files[i + 1]);
                        ++i;
                        ++reparseCount;
                    }
                    file = this.parser.parse(filename.toString());
                } else {
                    file = this.parser.parse(files[i]);
                }
                if (file == null) continue;
                temp[count++] = file;
                continue;
            }
            catch (ParseException ex) {
                if (ex.getMessage().toUpperCase().indexOf("UNPARSEABLE DATE") >= 0) {
                    if (this.localesToTry != null && this.localesToTry.length > this.localeIndex) {
                        log.info("Trying " + this.localesToTry[this.localeIndex].toString() + " locale");
                        this.setLocale(this.localesToTry[this.localeIndex]);
                        ++this.localeIndex;
                        count = 0;
                        i = -1;
                        continue;
                    }
                    if (!this.rotateParsers) {
                        count = 0;
                        i = -1;
                        this.parser = this.origParser;
                        this.parser.setIgnoreDateParseErrors(true);
                        log.debug("Ignoring date parsing errors");
                        continue;
                    }
                }
                StringBuffer msg = new StringBuffer("Failed to parse line '");
                msg.append(files[i]).append("' (").append(ex.getMessage()).append(")");
                log.info(msg.toString());
                if (this.rotateParsers) {
                    this.rotateParsers = false;
                    this.rotateParsers();
                    if (this.localesToTry != null) {
                        this.setLocale(this.localesToTry[0]);
                        this.localeIndex = 1;
                    }
                    count = 0;
                    i = -1;
                    continue;
                }
                throw new ParseException(msg.toString(), ex.getErrorOffset());
            }
        }
        FTPFile[] result = new FTPFile[count];
        System.arraycopy(temp, 0, result, 0, count);
        return result;
    }

    private void rotateParsers() {
        this.usingVMS = false;
        if (this.parser == this.unix) {
            this.parser = this.windows;
            log.info("Rotated parser to Windows");
        } else if (this.parser == this.windows) {
            this.parser = this.unix;
            log.info("Rotated parser to Unix");
        }
    }

    public String getSystem() {
        return this.system;
    }
}

