/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp;

import com.enterprisedt.net.ftp.FTPClient;
import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.FTPProgressMonitor;
import com.enterprisedt.net.ftp.FTPProgressMonitorEx;
import com.enterprisedt.net.ftp.FTPTransferType;
import com.enterprisedt.net.ftp.FileTransferInputStream;
import com.enterprisedt.net.ftp.TransferDirection;
import com.enterprisedt.util.debug.Logger;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;

public class FTPInputStream
extends FileTransferInputStream {
    private static Logger log = Logger.getLogger("FTPInputStream");
    private static final byte[] LINE_SEPARATOR = System.getProperty("line.separator").getBytes();
    private long monitorInterval;
    private FTPClient client;
    private BufferedInputStream in;
    private long size = 0L;
    private boolean isASCII = false;
    private boolean crFound = false;
    private byte[] buffer;
    private int bufpos = 0;
    private int buflen = 0;
    private byte[] chunk;
    private ByteArrayOutputStream out;
    private long monitorCount = 0L;
    private FTPProgressMonitor monitor;
    private FTPProgressMonitorEx monitorEx;
    private boolean started = false;

    public FTPInputStream(FTPClient client, String remoteFile) throws IOException, FTPException {
        this.client = client;
        this.remoteFile = remoteFile;
        try {
            client.initGet(remoteFile);
            this.in = new BufferedInputStream(new DataInputStream(client.getInputStream()));
        }
        catch (IOException ex) {
            client.validateTransferOnError(ex);
            throw ex;
        }
        this.monitorInterval = client.getMonitorInterval();
        this.monitor = client.getProgressMonitor();
        this.chunk = new byte[client.getTransferBufferSize()];
        this.out = new ByteArrayOutputStream(client.getTransferBufferSize());
        this.isASCII = client.getType().equals(FTPTransferType.ASCII);
    }

    public void setMonitor(FTPProgressMonitorEx monitor, long monitorInterval) {
        this.monitor = monitor;
        this.monitorEx = monitor;
        this.monitorInterval = monitorInterval;
    }

    @Override
    public int read() throws IOException {
        if (!this.started) {
            this.start();
        }
        if (this.buffer == null) {
            return -1;
        }
        if (this.bufpos == this.buflen) {
            this.buffer = this.refreshBuffer();
            if (this.buffer == null) {
                return -1;
            }
        }
        return this.buffer[this.bufpos++];
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (!this.started) {
            this.start();
        }
        if (this.buffer == null || len == 0) {
            return -1;
        }
        if (this.bufpos == this.buflen) {
            this.buffer = this.refreshBuffer();
            if (this.buffer == null) {
                return -1;
            }
        }
        int available = 0;
        int remaining = len;
        while ((available = this.buflen - this.bufpos) < remaining) {
            System.arraycopy(this.buffer, this.bufpos, b, off, available);
            remaining -= available;
            off += available;
            this.buffer = this.refreshBuffer();
            if (this.buffer != null) continue;
            return len - remaining;
        }
        System.arraycopy(this.buffer, this.bufpos, b, off, remaining);
        this.bufpos += remaining;
        return len;
    }

    private void start() throws IOException {
        if (this.monitorEx != null) {
            this.monitorEx.transferStarted(TransferDirection.DOWNLOAD, this.remoteFile);
        }
        this.buffer = this.refreshBuffer();
        this.started = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] refreshBuffer() throws IOException {
        this.bufpos = 0;
        if (this.client.isTransferCancelled()) {
            return null;
        }
        int count = this.client.readChunk(this.in, this.chunk, this.chunk.length);
        if (count < 0) {
            if (this.isASCII && this.crFound) {
                ++this.size;
                this.buflen = 1;
                ++this.monitorCount;
                this.crFound = false;
                byte[] tmp = new byte[]{13};
                return tmp;
            }
            return null;
        }
        try {
            if (!this.isASCII) {
                this.size += (long)count;
                this.monitorCount += (long)count;
                this.buflen = count;
                byte[] tmp = this.chunk;
                return tmp;
            }
            this.out.reset();
            boolean lfFound = false;
            for (int i = 0; i < count; ++i) {
                boolean bl = lfFound = this.chunk[i] == 10;
                if (this.crFound) {
                    if (lfFound) {
                        this.out.write(LINE_SEPARATOR, 0, LINE_SEPARATOR.length);
                        this.size += (long)LINE_SEPARATOR.length;
                        this.monitorCount += (long)LINE_SEPARATOR.length;
                    } else {
                        this.out.write(13);
                        ++this.size;
                        ++this.monitorCount;
                    }
                }
                boolean bl2 = this.crFound = this.chunk[i] == 13;
                if (lfFound || this.crFound) continue;
                this.out.write(this.chunk[i]);
                ++this.size;
                ++this.monitorCount;
            }
            byte[] result = this.out.toByteArray();
            this.buflen = result.length;
            byte[] byArray = result;
            return byArray;
        }
        finally {
            if (this.monitor != null && this.monitorCount > this.monitorInterval) {
                this.monitor.bytesTransferred(this.size);
                this.monitorCount = 0L;
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            this.client.forceResumeOff();
            this.client.closeDataSocket(this.in);
            if (this.monitor != null) {
                this.monitor.bytesTransferred(this.size);
            }
            log.debug("Transferred " + this.size + " bytes from remote host");
            try {
                this.client.validateTransfer();
            }
            catch (FTPException ex) {
                throw new IOException(ex.getMessage());
            }
            if (this.monitorEx != null) {
                this.monitorEx.transferComplete(TransferDirection.DOWNLOAD, this.remoteFile);
            }
        }
    }
}

