/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp.test;

import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.FTPFile;
import com.enterprisedt.net.ftp.FTPFileFactory;
import com.enterprisedt.util.debug.Level;
import com.enterprisedt.util.debug.Logger;
import com.enterprisedt.util.safe.SafeCheckUtils;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.text.ParseException;
import java.util.Locale;
import java.util.Vector;

public class FileParserTest {
    public static void main(String[] args) {
        if (args.length < 2) {
            FileParserTest.usage();
        }
        Logger log = Logger.getLogger(FileParserTest.class);
        Logger.setLevel(Level.ALL);
        String type = args[0];
        String filename = args[1];
        String locale = null;
        if (args.length == 3) {
            locale = args[2];
        }
        if (!(type.equalsIgnoreCase("UNIX") || type.equalsIgnoreCase("WINDOWS") || type.equalsIgnoreCase("VMS"))) {
            FileParserTest.usage();
        }
        log.debug("Type=" + type);
        Vector<String> lines = new Vector<String>();
        BufferedReader reader = null;
        String line = null;
        try {
            FTPFileFactory ff = new FTPFileFactory(type);
            if (locale != null) {
                System.out.println("Setting locale to " + locale);
                Locale l = new Locale(locale.toLowerCase(), locale.toUpperCase());
                Locale[] locales = new Locale[]{Locale.ENGLISH, l};
                ff.setLocales(locales);
            } else {
                Locale[] locales = new Locale[]{Locale.ENGLISH};
                ff.setLocales(locales);
            }
            reader = new BufferedReader(new FileReader(SafeCheckUtils.cleanPathString(filename)));
            while ((line = reader.readLine()) != null) {
                lines.addElement(line);
                System.out.println(line);
            }
            Object[] listings = new String[lines.size()];
            lines.copyInto(listings);
            FTPFile[] files = ff.parse((String[])listings);
            for (int i = 0; i < files.length; ++i) {
                System.out.println(files[i].toString());
            }
        }
        catch (IOException ex) {
            System.out.println("Failed to read file: " + filename);
            ex.printStackTrace();
        }
        catch (ParseException ex) {
            System.out.println("Failed to parse line '" + line + "'");
            ex.printStackTrace();
        }
        catch (FTPException ex) {
            System.out.println("Failed to parse line '" + line + "'");
            ex.printStackTrace();
        }
    }

    private static void usage() {
        System.out.println("Usage: FileParserTest UNIX|WINDOWS|VMS filename");
        System.exit(-1);
    }
}

