/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp.test;

import com.enterprisedt.net.ftp.EventListener;
import com.enterprisedt.net.ftp.FTPClientInterface;
import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.FTPFile;
import com.enterprisedt.net.ftp.FTPProgressMonitor;
import com.enterprisedt.net.ftp.FTPTransferType;
import com.enterprisedt.net.ftp.FileTransferClientInterface;
import com.enterprisedt.net.ftp.FileTransferOutputStream;
import com.enterprisedt.net.ftp.WriteMode;
import com.enterprisedt.util.debug.Logger;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.ParseException;
import java.util.Date;

public class FileTransferClientAdapter
implements FTPClientInterface,
EventListener {
    private Logger log = Logger.getLogger("FileTransferClientAdapter");
    protected FileTransferClientInterface client;
    private boolean resume = false;
    private FTPProgressMonitor monitor;

    public FileTransferClientAdapter(FileTransferClientInterface client) {
        this.client = client;
    }

    public FileTransferClientInterface getFileTransferClient() {
        return this.client;
    }

    @Override
    public void cancelResume() throws IOException, FTPException {
        this.resume = false;
    }

    @Override
    public void cancelTransfer() {
        this.log.debug("Cancelling all transfers");
        this.client.cancelAllTransfers();
    }

    @Override
    public void cdup() throws IOException, FTPException {
        this.client.changeToParentDirectory();
    }

    @Override
    public void chdir(String dir) throws IOException, FTPException {
        this.client.changeDirectory(dir);
    }

    @Override
    public void connect() throws IOException, FTPException {
        this.client.connect();
    }

    @Override
    public boolean connected() {
        return this.client.isConnected();
    }

    @Override
    public void delete(String remoteFile) throws IOException, FTPException {
        this.client.deleteFile(remoteFile);
    }

    @Override
    public String[] dir() throws IOException, FTPException {
        return this.client.directoryNameList("", false);
    }

    @Override
    public String[] dir(String dirname) throws IOException, FTPException {
        return this.client.directoryNameList(dirname, false);
    }

    @Override
    public String[] dir(String dirname, boolean full) throws IOException, FTPException {
        return this.client.directoryNameList(dirname, full);
    }

    @Override
    public FTPFile[] dirDetails(String dirname) throws IOException, FTPException, ParseException {
        return this.client.directoryList(dirname);
    }

    @Override
    public boolean exists(String remoteFile) throws IOException, FTPException {
        return this.client.exists(remoteFile);
    }

    @Override
    public void get(String localPath, String remoteFile) throws IOException, FTPException {
        try {
            this.client.downloadFile(localPath, remoteFile, this.resume ? WriteMode.RESUME : WriteMode.OVERWRITE);
        }
        finally {
            this.resume = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void get(OutputStream destStream, String remoteFile) throws IOException, FTPException {
        try (InputStream str = null;){
            str = this.client.downloadStream(remoteFile);
            byte[] buf = new byte[1024];
            int len = 0;
            while ((len = str.read(buf)) >= 0) {
                destStream.write(buf, 0, len);
            }
        }
    }

    @Override
    public byte[] get(String remoteFile) throws IOException, FTPException {
        return this.client.downloadByteArray(remoteFile);
    }

    @Override
    public int getDeleteCount() {
        return this.client.getStatistics().getDeleteCount();
    }

    @Override
    public boolean getDetectTransferMode() {
        return this.client.isDetectContentType();
    }

    @Override
    public int getDownloadCount() {
        return this.client.getStatistics().getDownloadCount();
    }

    @Override
    public String getId() {
        return null;
    }

    @Override
    public long getMonitorInterval() {
        return this.client.getAdvancedSettings().getTransferNotifyInterval();
    }

    @Override
    public String getRemoteHost() {
        return this.client.getRemoteHost();
    }

    @Override
    public int getRemotePort() {
        return this.client.getRemotePort();
    }

    @Override
    public int getTimeout() {
        return this.client.getTimeout();
    }

    @Override
    public FTPTransferType getType() {
        return this.client.getContentType();
    }

    @Override
    public int getUploadCount() {
        return this.client.getStatistics().getUploadCount();
    }

    @Override
    public void keepAlive() throws IOException, FTPException {
    }

    @Override
    public void mkdir(String dir) throws IOException, FTPException {
        this.client.createDirectory(dir);
    }

    @Override
    public Date modtime(String remoteFile) throws IOException, FTPException {
        return this.client.getModifiedTime(remoteFile);
    }

    @Override
    public void setModTime(String path, Date modTime) throws IOException, FTPException {
        this.client.setModifiedTime(path, modTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String put(String localPath, String remoteFile) throws IOException, FTPException {
        try {
            String string = this.client.uploadFile(localPath, remoteFile, this.resume ? WriteMode.RESUME : WriteMode.OVERWRITE);
            return string;
        }
        finally {
            this.resume = false;
        }
    }

    @Override
    public String put(InputStream srcStream, String remoteFile) throws IOException, FTPException {
        return this.put(srcStream, remoteFile, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String put(InputStream srcStream, String remoteFile, boolean append) throws IOException, FTPException {
        try (OutputStream str = null;){
            str = this.client.uploadStream(remoteFile, append ? WriteMode.APPEND : WriteMode.OVERWRITE);
            byte[] buf = new byte[2048];
            int len = 0;
            while ((len = srcStream.read(buf)) >= 0) {
                str.write(buf, 0, len);
            }
            String string = ((FileTransferOutputStream)str).getRemoteFile();
            return string;
        }
    }

    @Override
    public String put(byte[] bytes, String remoteFile) throws IOException, FTPException {
        return this.put(bytes, remoteFile, false);
    }

    @Override
    public String put(byte[] bytes, String remoteFile, boolean append) throws IOException, FTPException {
        ByteArrayInputStream str = new ByteArrayInputStream(bytes);
        return this.put(str, remoteFile, append);
    }

    @Override
    public String put(String localPath, String remoteFile, boolean append) throws IOException, FTPException {
        return this.client.uploadFile(localPath, remoteFile, WriteMode.APPEND);
    }

    @Override
    public String pwd() throws IOException, FTPException {
        return this.client.getRemoteDirectory();
    }

    @Override
    public void quit() throws IOException, FTPException {
        this.client.disconnect();
    }

    @Override
    public void quitImmediately() throws IOException, FTPException {
        this.client.disconnect(true);
    }

    @Override
    public void rename(String from, String to) throws IOException, FTPException {
        this.client.rename(from, to);
    }

    @Override
    public void resetDeleteCount() {
        this.client.getStatistics().clear();
    }

    @Override
    public void resetDownloadCount() {
        this.client.getStatistics().clear();
    }

    @Override
    public void resetUploadCount() {
        this.client.getStatistics().clear();
    }

    @Override
    public void resume() throws FTPException {
        this.resume = true;
    }

    @Override
    public void rmdir(String dir) throws IOException, FTPException {
        this.client.deleteDirectory(dir);
    }

    @Override
    public void setDetectTransferMode(boolean detectTransferMode) {
        this.client.setDetectContentType(detectTransferMode);
    }

    @Override
    public void setId(String id) {
    }

    @Override
    public void setProgressMonitor(FTPProgressMonitor monitor, long interval) {
        this.monitor = monitor;
        this.client.setEventListener(this);
        this.client.getAdvancedSettings().setTransferNotifyInterval((int)interval);
    }

    @Override
    public void setProgressMonitor(FTPProgressMonitor monitor) {
        this.monitor = monitor;
        this.client.setEventListener(this);
    }

    @Override
    public void setRemoteHost(String remoteHost) throws IOException, FTPException {
        this.client.setRemoteHost(remoteHost);
    }

    @Override
    public void setRemotePort(int remotePort) throws FTPException {
        this.client.setRemotePort(remotePort);
    }

    @Override
    public void setTimeout(int timeout) throws IOException, FTPException {
        this.client.setTimeout(timeout);
    }

    @Override
    public void setType(FTPTransferType type) throws IOException, FTPException {
        this.client.setContentType(type);
    }

    @Override
    public long size(String remoteFile) throws IOException, FTPException {
        return this.client.getSize(remoteFile);
    }

    @Override
    public String executeCommand(String command) throws FTPException, IOException {
        return this.client.executeCommand(command);
    }

    @Override
    public String system() throws FTPException, IOException {
        return this.client.getSystemType();
    }

    @Override
    public void setControlEncoding(String controlEncoding) throws FTPException {
        this.client.getAdvancedSettings().setControlEncoding(controlEncoding);
    }

    @Override
    public void bytesTransferred(String connId, String remoteFile, long count) {
        this.log.debug("bytesTransferred(" + remoteFile + ": " + count + " bytes");
        if (this.monitor != null) {
            this.monitor.bytesTransferred(count);
        }
    }

    @Override
    public void commandSent(String connId, String cmd) {
    }

    @Override
    public void downloadCompleted(String connId, String remoteFilename) {
    }

    @Override
    public void downloadStarted(String connId, String remoteFilename) {
    }

    @Override
    public void replyReceived(String connId, String reply) {
    }

    @Override
    public void uploadCompleted(String connId, String remoteFilename) {
    }

    @Override
    public void uploadStarted(String connId, String remoteFilename) {
    }
}

