/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.util.debug;

import com.enterprisedt.BaseIOException;
import com.enterprisedt.util.debug.Appender;
import com.enterprisedt.util.debug.FileAppender;
import com.enterprisedt.util.debug.Level;
import com.enterprisedt.util.debug.StandardOutputAppender;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;

public class Logger {
    public static String cvsId = "@(#)$Id: Logger.java,v 1.1 2008-12-16 05:13:24 pengxu_ge Exp $";
    private static Level globalLevel;
    private static boolean logThreadNames;
    private SimpleDateFormat format = new SimpleDateFormat("d MMM yyyy HH:mm:ss.S");
    private static Hashtable loggers;
    private static Vector appenders;
    private boolean useLog4j = false;
    private boolean logThreadName = false;
    private Date ts = new Date();
    private String clazz;
    private Method[][] logMethods = null;
    private Method toLevelMethod = null;
    private Method isEnabledForMethod = null;
    private Object logger = null;
    private Object[] argsPlain = new Object[1];
    private Object[] argsThrowable = new Object[2];
    private static String[] hex;

    private Logger(String clazz, boolean uselog4j) {
        this.clazz = clazz;
        this.useLog4j = uselog4j;
        if (uselog4j) {
            this.setupLog4j();
        }
    }

    private synchronized void setupLog4j() {
        this.logMethods = new Method[5][2];
        try {
            Class<?> log4jLogger = Class.forName("org.apache.log4j.Logger");
            Class<?> log4jLevel = Class.forName("org.apache.log4j.Level");
            Class<?> log4jPriority = Class.forName("org.apache.log4j.Priority");
            Class[] args = new Class[]{String.class};
            Method getLogger = log4jLogger.getMethod("getLogger", args);
            Object[] invokeArgs = new Object[]{this.clazz};
            this.logger = getLogger.invoke(null, invokeArgs);
            Class[] plainArgs = new Class[]{Object.class};
            Class[] throwableArgs = new Class[]{Object.class, Throwable.class};
            this.logMethods[0][0] = log4jLogger.getMethod("fatal", plainArgs);
            this.logMethods[0][1] = log4jLogger.getMethod("fatal", throwableArgs);
            this.logMethods[1][0] = log4jLogger.getMethod("error", plainArgs);
            this.logMethods[1][1] = log4jLogger.getMethod("error", throwableArgs);
            this.logMethods[2][0] = log4jLogger.getMethod("warn", plainArgs);
            this.logMethods[2][1] = log4jLogger.getMethod("warn", throwableArgs);
            this.logMethods[3][0] = log4jLogger.getMethod("info", plainArgs);
            this.logMethods[3][1] = log4jLogger.getMethod("info", throwableArgs);
            this.logMethods[4][0] = log4jLogger.getMethod("debug", plainArgs);
            this.logMethods[4][1] = log4jLogger.getMethod("debug", throwableArgs);
            Class[] toLevelArgs = new Class[]{Integer.TYPE};
            this.toLevelMethod = log4jLevel.getMethod("toLevel", toLevelArgs);
            Class[] isEnabledForArgs = new Class[]{log4jPriority};
            this.isEnabledForMethod = log4jLogger.getMethod("isEnabledFor", isEnabledForArgs);
        }
        catch (Exception ex) {
            this.useLog4j = false;
            this.error("Failed to initialize log4j logging", ex);
        }
    }

    public static synchronized Level getLevel() {
        return globalLevel;
    }

    public static synchronized void setLevel(Level level) {
        globalLevel = level;
    }

    public static Logger getLogger(Class clazz) {
        return Logger.getLogger(clazz.getName());
    }

    public static synchronized Logger getLogger(String clazz) {
        Logger logger = (Logger)loggers.get(clazz);
        if (logger == null) {
            boolean useLog4j = false;
            try {
                String log4j = System.getProperty("edtftp.log.log4j");
                if (log4j != null && log4j.equalsIgnoreCase("true")) {
                    useLog4j = true;
                }
            }
            catch (SecurityException ex) {
                System.out.println("Could not read property 'edtftp.log.log4j' due to security permissions");
            }
            logger = new Logger(clazz, useLog4j);
            loggers.put(clazz, logger);
        }
        return logger;
    }

    public static synchronized void addAppender(Appender newAppender) {
        if (!appenders.contains(newAppender)) {
            appenders.addElement(newAppender);
        }
    }

    public static synchronized void addFileAppender(String fileName) throws IOException {
        Logger.addAppender(new FileAppender(fileName));
    }

    public static synchronized void addStandardOutputAppender() {
        Logger.addAppender(new StandardOutputAppender());
    }

    public static synchronized void removeAppender(Appender appender) {
        appender.close();
        appenders.removeElement(appender);
    }

    public static synchronized void clearAppenders() {
        appenders.removeAllElements();
    }

    public static synchronized void shutdown() {
        for (int i = 0; i < appenders.size(); ++i) {
            Appender a = (Appender)appenders.elementAt(i);
            a.close();
        }
    }

    public static synchronized void logThreadNames(boolean logThreadNames) {
        Logger.logThreadNames = logThreadNames;
    }

    public synchronized void logThreadName(boolean logThreadName) {
        this.logThreadName = logThreadName;
    }

    public synchronized void log(Level level, String message, Throwable t) {
        if (this.isEnabledFor(level)) {
            if (this.useLog4j) {
                this.log4jLog(level, message, t);
            } else {
                this.ourLog(level, message, t);
            }
        }
    }

    private boolean log4jIsEnabledFor(Level level) {
        if (level.equals(Level.ALL)) {
            level = Level.DEBUG;
        }
        try {
            Object[] toLevelArgs = new Object[]{new Integer(level.getLevel())};
            Object l = this.toLevelMethod.invoke(null, toLevelArgs);
            Object[] isEnabledArgs = new Object[]{l};
            Object isEnabled = this.isEnabledForMethod.invoke(this.logger, isEnabledArgs);
            return (Boolean)isEnabled;
        }
        catch (Exception ex) {
            this.ourLog(Level.ERROR, "Failed to invoke log4j toLevel/isEnabledFor method", ex);
            this.useLog4j = false;
            return false;
        }
    }

    private void log4jLog(Level level, String message, Throwable t) {
        if (level.equals(Level.ALL)) {
            level = Level.DEBUG;
        }
        Object[] args = null;
        int pos = -1;
        if (t == null) {
            args = this.argsPlain;
            pos = 0;
        } else {
            args = this.argsThrowable;
            args[1] = t;
            pos = 1;
        }
        args[0] = message;
        Method method = this.logMethods[level.getLevel()][pos];
        try {
            method.invoke(this.logger, args);
        }
        catch (Exception ex) {
            this.ourLog(Level.ERROR, "Failed to invoke log4j logging method", ex);
            this.ourLog(level, message, t);
            this.useLog4j = false;
        }
    }

    private void ourLog(Level level, String message, Throwable t) {
        this.ts.setTime(System.currentTimeMillis());
        String stamp = this.format.format(this.ts);
        StringBuffer buf = new StringBuffer(level.toString());
        buf.append(" [");
        if (logThreadNames || this.logThreadName) {
            buf.append(Thread.currentThread().getName()).append("_");
        }
        buf.append(this.clazz).append("] ").append(stamp).append(" : ").append(message);
        if (t != null) {
            buf.append(" : ").append(t.getMessage());
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            pw.println();
            t.printStackTrace(pw);
            pw.println();
            buf.append(sw.toString());
        }
        if (appenders.size() == 0) {
            System.out.println(buf.toString());
            while (t != null) {
                t.printStackTrace(System.out);
                if (t instanceof BaseIOException) {
                    if ((t = ((BaseIOException)t).getInnerThrowable()) == null) continue;
                    System.out.println("CAUSED BY:");
                    continue;
                }
                t = null;
            }
        } else {
            for (int i = 0; i < appenders.size(); ++i) {
                Appender a = (Appender)appenders.elementAt(i);
                a.log(buf.toString());
                while (t != null) {
                    a.log(t);
                    if (t instanceof BaseIOException) {
                        if ((t = ((BaseIOException)t).getInnerThrowable()) == null) continue;
                        a.log("CAUSED BY:");
                        continue;
                    }
                    t = null;
                }
            }
        }
    }

    public void info(String message) {
        this.log(Level.INFO, message, null);
    }

    public void info(String message, Throwable t) {
        this.log(Level.INFO, message, t);
    }

    public void warn(String message) {
        this.log(Level.WARN, message, null);
    }

    public void warn(String message, Throwable t) {
        this.log(Level.WARN, message, t);
    }

    public void error(String message) {
        this.log(Level.ERROR, message, null);
    }

    public void error(String message, Throwable t) {
        this.log(Level.ERROR, message, t);
    }

    public void fatal(String message) {
        this.log(Level.FATAL, message, null);
    }

    public void fatal(String message, Throwable t) {
        this.log(Level.FATAL, message, t);
    }

    public void debug(String message) {
        this.log(Level.DEBUG, message, null);
    }

    public void debug(String message, byte[] data) {
        this.log(Level.DEBUG, message, null);
        StringBuffer hexStr = new StringBuffer();
        StringBuffer charStr = new StringBuffer();
        for (int i = 0; i < data.length; ++i) {
            byte b = data[i];
            if (i > 0 && i % 12 == 0) {
                this.log(Level.DEBUG, hexStr.toString() + "  " + charStr.toString(), null);
                hexStr = new StringBuffer();
                charStr = new StringBuffer();
            }
            hexStr.append(hex[b >> 4 & 0xF] + hex[b & 0xF] + " ");
            charStr.append(b >= 32 && b <= 126 ? (char)b : (char)'?');
        }
        this.log(Level.DEBUG, hexStr.toString() + "  " + charStr.toString(), null);
    }

    public void debug(String message, Object arg) {
        if (this.isDebugEnabled()) {
            this.log(Level.DEBUG, MessageFormat.format(message, arg), null);
        }
    }

    public void debug(String message, Object arg0, Object arg1) {
        if (this.isDebugEnabled()) {
            this.log(Level.DEBUG, MessageFormat.format(message, arg0, arg1), null);
        }
    }

    public void debug(String message, Object arg0, Object arg1, Object arg2) {
        if (this.isDebugEnabled()) {
            this.log(Level.DEBUG, MessageFormat.format(message, arg0, arg1, arg2), null);
        }
    }

    public void debug(String message, Object arg0, Object arg1, Object arg2, Object arg3) {
        if (this.isDebugEnabled()) {
            this.log(Level.DEBUG, MessageFormat.format(message, arg0, arg1, arg2, arg3), null);
        }
    }

    public void debug(String message, Object arg0, Object arg1, Object arg2, Object arg3, Object arg4) {
        if (this.isDebugEnabled()) {
            this.log(Level.DEBUG, MessageFormat.format(message, arg0, arg1, arg2, arg3, arg4), null);
        }
    }

    public void debug(String message, Throwable t) {
        this.log(Level.DEBUG, message, t);
    }

    public synchronized boolean isEnabledFor(Level level) {
        if (this.useLog4j) {
            return this.log4jIsEnabledFor(level);
        }
        return globalLevel.isGreaterOrEqual(level);
    }

    public boolean isDebugEnabled() {
        return this.isEnabledFor(Level.DEBUG);
    }

    public boolean isInfoEnabled() {
        return this.isEnabledFor(Level.INFO);
    }

    static {
        logThreadNames = false;
        loggers = new Hashtable(10);
        appenders = new Vector(2);
        String level = Level.OFF.toString();
        try {
            level = System.getProperty("edtftp.log.level", Level.OFF.toString());
        }
        catch (SecurityException ex) {
            System.out.println("Could not read property 'edtftp.log.level' due to security permissions");
        }
        globalLevel = Level.getLevel(level);
        hex = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};
    }
}

