/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.fme.appext;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.fme.service.FtpDocumentInfo;
import com.kingdee.eas.base.fme.service.GCDocumentInfo;
import com.kingdee.eas.base.fme.util.FMEUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FMEDbUtils {
    public static final Log log = LogFactory.getLog(FMEDbUtils.class);
    public static final String DOCUMENT_TABLE = "T_FME_Document";
    public static final String FTPSERVER_TABLE = "T_FME_FtpServer";
    public static final String SAVEPATH_TABLE = "T_FME_SavePath";
    public static final String DOCUMENT_TABLE_COLUMN_DOCUMENTID = "FDocumentId";
    public static final String DOCUMENT_TABLE_COLUMN_PATHID = "FPath";
    public static final String FTPSERVER_TABLE_COLUMN_FRootPath = "FRootPath";
    public static final String SAVEPATH_TABLE_COLUMN_FPathID = "FPathID";
    public static final String SAVEPATH_TABLE_COLUMN_FPathName = "FPathName";
    public static final String SAVEPATH_TABLE_COLUMN_FServerID = "FServerID";
    public static final String UPDATE_FTP_SERVER_ROOT_PATH = " update T_FME_FtpServer set FRootPath=''{0}'' where FServerID=''{1}'' and FRootPath=''{2}''";
    public static final String UPDATE_Document_PATH = " update T_FME_Document set FPath=''{0}'' where FServerID=''{1}'' and FDocumentID=''{2}''";
    public static final String UPDATE_Document_PATH_SERVERID = " update T_FME_Document set FPath=''{0}'',FServerID=''{3}'' where FServerID=''{1}'' and FDocumentID=''{2}''";
    public static final String QUERY_FTP_SERVER_WITH_FTPID_PATH = "select FServerID, FServerName, FServerHost, FServerPort, FServerUser, FServerPswd, FRootPath, FServerStatus, FIsDefault from T_FME_FtpServer where FServerID=''{0}'' and FRootPath=''{1}''";
    public static final String QUERY_FTP_SERVER_WITH_FTPID = "select FServerID, FServerName, FServerHost, FServerPort, FServerUser, FServerPswd, FRootPath, FServerStatus, FIsDefault from T_FME_FtpServer where FServerID=''{0}''";
    public static final String QUERY_Document_Path = "select FDocumentID, FName, FSize, FPath, FDescription, FOperDate, FTypeID, FStatus, FServerID from T_FME_Document where FServerID=''{0}'' and FPath like ''{1}/%''";
    public static final String QUERY_Document_Count_With_PathPrefix = "select FDocumentID, FName, FSize, FPath, FDescription, FOperDate, FTypeID, FStatus, FServerID from T_FME_Document where FPath like ''{0}/%''";
    public static final String QUERY_SavePath_With_PathID = "select FPathID, FPathName, FDisplayName, FServerID, FPathStatus, FSaveType from T_FME_SavePath where FPathID in ({0})";
    public static final String QUERY_SavePath_BY_PathID = "select FPathID, FPathName, FDisplayName, FServerID, FPathStatus, FSaveType from T_FME_SavePath where FPathID = ''{0}''";
    public static final String UPDATE_SAVEPATH_With_NewServerID = "update T_FME_SavePath set FServerID=''{0}'' where FServerID=''{1}''";
    public static final String QUERY_FTPSERVER_SAVEPATH_DIR = "select t1.FServerID as FServerID,t1.FRootPath as FRootPath,t1.FServerStatus as FServerStatus ,t2.FPathName as FPathName from T_FME_FtpServer t1 left join T_FME_SavePath t2  on t1.FServerID=t2.FServerID where t2.FPathID=''{0}''";
    public static final String UPDATE_FILECATEGORY_PATHID = "update T_FME_FileCategory set FPathID=''{0}'' where FPathID=''{1}''";
    public static final String QUERY_FILECATEGORY = "select FID,FPID,FName,FPathID from T_FME_FileCategory where  FID in ( {0} ) ";
    public static final String QUERY_CATEGORYMAP_With_BOTTOM_PATHID = " select t1.FID as FID,t1.FBCID as FBCID, t1.FFCID as FFCID ,t1.FMapName as FMapName,t1.FLevel as FLevel from T_FME_CategoryMap  t1  where t1.FMapName like ''{0}%'' or FBCID in ({1}) order by FLevel ";
    public static final String QUERY_CATEGORYMAP_With_BOTTOM_PATHID_TOP_CLASS = " select t1.FID as FID,t1.FBCID as FBCID, t1.FFCID as FFCID ,t1.FMapName as FMapName,t1.FLevel as FLevel from T_FME_CategoryMap  t1  where t1.FMapName like ''{0}%''  order by FLevel ";
    public static final String CATEGORYMAP_TABLE_COLUMN_FFCID = "FFCID";
    public static final String CATEGORYMAP_TABLE_COLUMN_FMapName = "FMapName";
    public static final String CATEGORYMAP_TABLE_COLUMN_FLevel = "FLevel";
    public static final String CATEGORYMAP_TABLE_COLUMN_FBCID = "FBCID";
    public static final String CATEGORYMAP_TABLE_COLUMN_FID = "FID";
    public static final String FILECATEGORY_TABLE_COLUMN_FPathID = "FPathID";
    public static final String FILECATEGORY_TABLE_COLUMN_FID = "FID";
    public static final String FILECATEGORY_TABLE_COLUMN_FName = "FName";
    public static final String QUERY_DOCUMENT_SQL = "select FDocumentID, FName, FSize, FPath, FDescription, FOperDate, FTypeID, FStatus, FServerID from T_FME_Document where FDocumentID=''{0}''";
    public static final String DOCUMENT_TABLE_COLUMN_FPath = "FPath";
    public static final String DOCUMENT_TABLE_COLUMN_FName = "FName";
    public static final String QUERY_CATEGORYMAP_MAPNAME = "select FMapName from T_FME_CategoryMap where FBCID=''{0}''";
    public static final String UPDATE_CATEGORYMAP_MAPNAME = "update T_FME_CategoryMap set FMapName=''{0}''  where FMapName=''{1}''";
    public static final String DELETE_CATEGORYMAP_BY_MAPNAME = "delete T_FME_CategoryMap  where FMapName like ''{0}%'' and FLevel>={1}";
    public static final String DELETE_FILECATEGORY_BY_FIDS = "delete T_FME_FileCategory  where FID in ({0})";
    public static final String UPDATE_FILECATEGOREY_PARENT_ID = "update T_FME_FileCategory set FPID=''{0}'' ,FPathID=''{1}'' where FID=''{2}''";
    public static final String QUERY_CATEGORY_MAP_SQL_With_FBCID = "select FID,FBCID,FFCID,FMapName,FLevel from T_FME_CategoryMap where FBCID=''{0}''";
    public static final String UPDATE_CATEGORYMAP_MAPNAME_LEVEL = "update T_FME_CategoryMap set FMapName=''{0}'',FLevel={1}  where FID=''{2}''";
    public static final String QUERY_CATEGORYMAP_Current_NODE_TO_ROOT_NODE = " select distinct FBCID,FID,FFCID,FMapName,FLevel from T_FME_CategoryMap  where FMapName like ''{0}%'' and FLevel<={1} order by FLevel ";
    private static final String INSERT_CATEGORYMAP = "insert into T_FME_CategoryMap values(''{0}'',''{1}'',''{2}'',''{3}'',{4})";
    public static final String QUERY_GC_TYPE_1 = "select t1.FDocumentID ,t1.FName,t1.FSize,t1.FPath,t1.FServerID,t1.FStatus,t2.FDisplayName,t2.FID,t2.FBusinessID from T_FME_Document t1  left join T_FME_BusiDoc t2 on t1.FDocumentID=t2.FDocumentID  where t1.FStatus=''2'' and t1.FServerID=''{0}''";
    public static final String QUERY_GC_TYPE_2 = "select  T1.* from T_FME_Document  t1 \twhere t1.FDocumentID not in ( select t2.FDocumentID from T_FME_BusiDoc t2) \tand t1.FServerID=''{0}''";
    public static final String QUERY_GC3_DOCUMENT_SQL = "select FDocumentID from T_FME_Document where FName=''{0}'' and FPath=''{1}'' and FServerID=''{2}''";
    public static final String DELETE_GC3_DOCUMENT_SQL = "delete from T_FME_Document where FName=''{0}'' and FPath=''{1}'' and FServerID=''{2}''";
    public static final String CLEAR_GC_TYPE_1 = "update  T_FME_Document set FStatus=''{0}''  where FDocumentID=''{1}'' ";
    public static final String DELETE_GC2_DOCUMENT_SQL = "delete from T_FME_Document where FDocumentID=''{0}''";
    public static final String QUERY_CATEOGRYMAP_EXIST = "select FID, FBCID,FFCID,FMapName,FLevel from T_FME_CategoryMap where FBCID=''{0}'' and FMapName like ''%{1}''";
    public static final String UPDATE_DOCUMENT_FILETYPE = "update T_FME_Document set FTypeID=''{0}'' where FTypeID=''{1}''";
    public static final String QUERY_TOPN_DOWNLOAD_DOCUMENT = "select a.FBusinessID as BusinessID,b.FDocumentID as DocumentID,b.downloadTime as DownloadTime from T_FME_BusiDoc a right join  (select top {0} FDocumentID as FDocumentId ,count(FOperType) as downloadTime from T_FME_OperLog where FOperType=1 group by FDocumentID order by downloadTime desc ) as b  on a.FDocumentID =b.FDocumentID  where FBusinessID is not NULL order by b.downloadTime desc ";
    public static final String QUERY_BusinessDoc_DOWNLOAD_COUNT = "select a.FDocumentID as FDocumentID,count(a.FOperType) as DownloadTime from T_FME_OperLog a left join T_FME_BusiDoc b on a.FDocumentID =b.FDocumentID where b.FBusinessID=''{0}'' and FOperType=1 group by a.FDocumentID";

    public static boolean updateFMEDocumentRootPath(String ftpID, String targetFtpId, String sourceRootPath, String targetRootPath, Context ctx) throws BOSException, SQLException {
        boolean updateResult = false;
        String querySql = MessageFormat.format(QUERY_FTP_SERVER_WITH_FTPID_PATH, ftpID, sourceRootPath);
        if (log.isInfoEnabled()) {
            log.info((Object)("\u67e5\u8be2\u662f\u5426\u5b58\u5728\u5f85\u4fee\u6539\u7684FtpServer :" + querySql));
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)querySql);
        boolean existRecord = false;
        if (rs.next()) {
            existRecord = true;
        }
        if (existRecord) {
            String updateSql;
            boolean inOneFtp = false;
            if (FMEUtils.isBlankString(targetFtpId) || ftpID.equals(targetFtpId)) {
                inOneFtp = true;
                if (log.isInfoEnabled()) {
                    log.info((Object)"\u5728\u540c\u4e00\u4e2aFTP\u5185\uff0c\u5207\u6362\u6587\u6863\u7684\u6839\u8def\u5f84\uff0c\u76f4\u63a5\u8c03\u6574\u76f8\u5e94\u7684\u8def\u5f84\u540d\u5373\u53ef");
                }
                updateSql = MessageFormat.format(UPDATE_FTP_SERVER_ROOT_PATH, targetRootPath, ftpID, sourceRootPath);
                if (log.isInfoEnabled()) {
                    log.info((Object)("\u4fee\u6539\u76f8\u5e94\u7684FtpServer\u8bb0\u5f55\u4e3a\uff1a" + updateSql));
                }
                DbUtil.execute((Context)ctx, (String)updateSql);
            }
            if ((updateResult = FMEDbUtils.updateDocumentPathWithPathPrefix(ftpID, targetFtpId, sourceRootPath, targetRootPath, ctx)) && !inOneFtp) {
                if (log.isInfoEnabled()) {
                    log.info((Object)"\u5728\u4e0d\u540c\u7684FTP\u4e4b\u95f4\uff0c\u5207\u6362\u5b58\u50a8\u6839\u8def\u5f84\uff0c\u8fdb\u884c\u4fee\u590d\u5904\u7406savePath\u5904\u7406");
                }
                updateSql = MessageFormat.format(UPDATE_SAVEPATH_With_NewServerID, targetFtpId, ftpID);
                if (log.isInfoEnabled()) {
                    log.info((Object)("\u66f4\u65b0Savepath ServerID sql is:\n" + updateSql));
                }
                DbUtil.execute((Context)ctx, (String)updateSql);
            }
        } else {
            if (log.isWarnEnabled()) {
                log.warn((Object)("\u4e0d\u5b58\u5728\u6ee1\u8db3" + querySql + "\u8fc7\u6ee4\u7684\u8bb0\u5f55\uff0c\u4e0d\u9700\u8981\u66f4\u65b0\u6839\u8def\u5f84"));
            }
            updateResult = false;
        }
        return updateResult;
    }

    private static String getFtpServerRootPath(String ftpServerID, Context ctx) throws BOSException, SQLException {
        IRowSet rs1;
        String ftpRootPath = "";
        String sql_queryFtpServer = MessageFormat.format(QUERY_FTP_SERVER_WITH_FTPID, ftpServerID);
        if (log.isInfoEnabled()) {
            log.info((Object)("\u67e5\u8be2\u76f8\u5173\u7684FtpServer_SQL:" + sql_queryFtpServer));
        }
        if ((rs1 = DbUtil.executeQuery((Context)ctx, (String)sql_queryFtpServer)).next()) {
            ftpRootPath = rs1.getString(FTPSERVER_TABLE_COLUMN_FRootPath);
        }
        return ftpRootPath;
    }

    private static String getFtpRootPathAndSavePathDirByPathID(String savePathID, Context ctx) throws BOSException, SQLException {
        IRowSet rs1;
        String ftpRootPath = "";
        String sql_queryFtpServerSavePathDir = MessageFormat.format(QUERY_FTPSERVER_SAVEPATH_DIR, savePathID);
        if (log.isInfoEnabled()) {
            log.info((Object)("\u67e5\u8be2\u76f8\u5173\u7684QUERY_FTPSERVER_SAVEPATH_DIR:" + sql_queryFtpServerSavePathDir));
        }
        if ((rs1 = DbUtil.executeQuery((Context)ctx, (String)sql_queryFtpServerSavePathDir)).next()) {
            ftpRootPath = rs1.getString(FTPSERVER_TABLE_COLUMN_FRootPath) + "/" + rs1.getString(SAVEPATH_TABLE_COLUMN_FPathName);
        }
        return ftpRootPath;
    }

    private static String[] getSavePathNameByPathID(String sourcePathID, String targetPathID, Context ctx) throws BOSException, SQLException {
        String[] retPathName = new String[]{"", ""};
        String sql_querySavePath = MessageFormat.format(QUERY_SavePath_With_PathID, "'" + sourcePathID + "','" + targetPathID + "'");
        if (log.isInfoEnabled()) {
            log.info((Object)("\u67e5\u8be2\u76f8\u5173\u7684SavePath_SQL:" + sql_querySavePath));
        }
        IRowSet rs2 = DbUtil.executeQuery((Context)ctx, (String)sql_querySavePath);
        while (rs2.next()) {
            if (rs2.getString("FPathID").equals(sourcePathID)) {
                retPathName[0] = rs2.getString(SAVEPATH_TABLE_COLUMN_FPathName);
                continue;
            }
            retPathName[1] = rs2.getString(SAVEPATH_TABLE_COLUMN_FPathName);
        }
        if (sourcePathID.equals(targetPathID)) {
            retPathName[1] = retPathName[0];
        }
        return retPathName;
    }

    private static String getSavePathNameByPathID(String sourcePathID, Context ctx) throws BOSException, SQLException {
        String retPathName = "";
        String sql_querySavePath = MessageFormat.format(QUERY_SavePath_With_PathID, "'" + sourcePathID + "'");
        if (log.isInfoEnabled()) {
            log.info((Object)("\u67e5\u8be2\u76f8\u5173\u7684SavePath_SQL:" + sql_querySavePath));
        }
        IRowSet rs2 = DbUtil.executeQuery((Context)ctx, (String)sql_querySavePath);
        while (rs2.next()) {
            retPathName = rs2.getString(SAVEPATH_TABLE_COLUMN_FPathName);
        }
        return retPathName;
    }

    private static ResultSet getSavePathNameByPathIDExt(String sourcePathID, Context ctx) throws BOSException, SQLException {
        String sql_querySavePath = MessageFormat.format(QUERY_SavePath_BY_PathID, sourcePathID);
        if (log.isInfoEnabled()) {
            log.info((Object)("getSavePathNameByPathIDExt:" + sql_querySavePath));
        }
        IRowSet rs2 = DbUtil.executeQuery((Context)ctx, (String)sql_querySavePath);
        return rs2;
    }

    private static boolean updateOneDocumentPathWithNewPathName(String ftpID, String targetFtpID, String documentID, String oldPath, String newPath, Context ctx) throws BOSException, SQLException {
        boolean updateResult = false;
        String updateDocumentSql = "";
        if (targetFtpID == null) {
            if (log.isInfoEnabled()) {
                log.info((Object)("\u5728\u5355\u4e2aFtp" + ftpID + "\u5185\uff0c\u79fb\u52a8\u6587\u6863"));
            }
            updateDocumentSql = MessageFormat.format(UPDATE_Document_PATH, newPath, ftpID, documentID);
        } else {
            log.info((Object)("\u5728Ftp" + ftpID + "\u548c" + targetFtpID + "\uff0c\u79fb\u52a8\u6587\u6863"));
            updateDocumentSql = MessageFormat.format(UPDATE_Document_PATH_SERVERID, newPath, ftpID, documentID, targetFtpID);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("\u4fee\u6539\u76f8\u5e94\u7684Document\u8def\u5f84\u4e3a\uff1a" + updateDocumentSql));
        }
        DbUtil.execute((Context)ctx, (String)updateDocumentSql);
        updateResult = true;
        return updateResult;
    }

    private static boolean updateDocumentPathWithPathPrefix(String ftpID, String targetFtpID, String oldPathPrefix, String newPathPrefix, Context ctx) throws BOSException, SQLException {
        boolean updateResult = false;
        String queryDocumentPath_SQL = MessageFormat.format(QUERY_Document_Path, ftpID, oldPathPrefix);
        if (log.isInfoEnabled()) {
            log.info((Object)("\u67e5\u8be2\u76f8\u5173\u7684DocumentPath_SQL:" + queryDocumentPath_SQL));
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)queryDocumentPath_SQL);
        String documentID = "";
        String oldPath = "";
        String newPath = "";
        String updateDocumentSql = "";
        while (rs.next()) {
            documentID = rs.getString(DOCUMENT_TABLE_COLUMN_DOCUMENTID);
            oldPath = rs.getString("FPath");
            newPath = oldPath.replaceFirst(oldPathPrefix, newPathPrefix);
            if (targetFtpID == null) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("\u5728\u5355\u4e2aFtp" + ftpID + "\u5185\uff0c\u79fb\u52a8\u6587\u6863"));
                }
                updateDocumentSql = MessageFormat.format(UPDATE_Document_PATH, newPath, ftpID, documentID);
            } else {
                log.info((Object)("\u5728Ftp" + ftpID + "\u548c" + targetFtpID + "\uff0c\u79fb\u52a8\u6587\u6863"));
                updateDocumentSql = MessageFormat.format(UPDATE_Document_PATH_SERVERID, newPath, ftpID, documentID, targetFtpID);
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("\u4fee\u6539\u76f8\u5e94\u7684Document\u8def\u5f84\u4e3a\uff1a" + updateDocumentSql));
            }
            DbUtil.execute((Context)ctx, (String)updateDocumentSql);
            updateResult = true;
        }
        return updateResult;
    }

    public static boolean updateDocumentPathName(String ftpID, String targetFtpID, String sourcePathID, String targetPathID, Context ctx) throws BOSException, SQLException {
        boolean updateResult = false;
        String ftpRootPath = "";
        String targetFtpRootPath = "";
        String sourcePathName = "";
        String taregtPathName = "";
        ftpRootPath = FMEDbUtils.getFtpServerRootPath(ftpID, ctx);
        targetFtpRootPath = FMEUtils.isBlankString(targetFtpID) ? ftpRootPath : FMEDbUtils.getFtpServerRootPath(targetFtpID, ctx);
        String[] pathNameArray = FMEDbUtils.getSavePathNameByPathID(sourcePathID, targetPathID, ctx);
        sourcePathName = pathNameArray[0];
        taregtPathName = pathNameArray[1];
        updateResult = FMEDbUtils.updateDocumentPathWithPathPrefix(ftpID, targetFtpID, ftpRootPath + "/" + sourcePathName, targetFtpRootPath + "/" + taregtPathName, ctx);
        if (updateResult) {
            updateResult = FMEDbUtils.updateFileCategoryPathID(sourcePathID, targetPathID, ctx);
        }
        return updateResult;
    }

    public static boolean updateFileCategoryPathID(String oldPathID, String newPathID, Context ctx) throws BOSException, SQLException {
        boolean updateResult = false;
        String updateSql = MessageFormat.format(UPDATE_FILECATEGORY_PATHID, newPathID, oldPathID);
        if (log.isInfoEnabled()) {
            log.info((Object)("updateFileCategoryPathID is:\n" + updateSql));
        }
        DbUtil.execute((Context)ctx, (String)updateSql);
        updateResult = true;
        return updateResult;
    }

    public static boolean updateDocumentFileCategory(String sourceFtpID, String targetFtpID, String sourceBusiCategoryID, String targetBusiCategoryID, Context ctx) throws BOSException, SQLException {
        boolean updateResult = false;
        String ftpRootPath = FMEDbUtils.getFtpServerRootPath(sourceFtpID, ctx);
        String[] sourceCategoryFullPathInfo = FMEDbUtils.getOneCategoryFullPath(sourceBusiCategoryID, ctx);
        String[] targetCategoryFullPathInfo = FMEDbUtils.getOneCategoryFullPath(targetBusiCategoryID, ctx);
        String sourceCategoryFullDir = sourceCategoryFullPathInfo[0];
        String targetCategoryFullDir = targetCategoryFullPathInfo[0];
        String[] pathNameArray = FMEDbUtils.getSavePathNameByPathID(sourceCategoryFullPathInfo[1], targetCategoryFullPathInfo[1], ctx);
        String sourcePathName = pathNameArray[0];
        String taregtPathName = pathNameArray[1];
        updateResult = FMEDbUtils.updateDocumentPathWithPathPrefix(sourceFtpID, targetFtpID, ftpRootPath + "/" + sourcePathName + "/" + sourceCategoryFullDir, ftpRootPath + "/" + taregtPathName + "/" + targetCategoryFullDir, ctx);
        return updateResult;
    }

    public static String[] getOneCategoryFullPath(String sourceBusiCategoryID, Context ctx) throws BOSException, SQLException {
        return FMEDbUtils.getCategoryFullPathIncludeSubCategory(sourceBusiCategoryID, ctx, false);
    }

    public static String[] getCategoryFullPathIncludeSubCategory(String sourceBusiCategoryID, Context ctx, boolean includeSubCategoryPath) throws BOSException, SQLException {
        String[] retCategoryPath = null;
        ResultSet rs = FMEDbUtils.getAllCategoryMapRecordByBusiCategoryID(sourceBusiCategoryID, ctx);
        HashMap<String, Integer> categroyTreeMap = new HashMap<String, Integer>();
        String rootCateogryID = "";
        StringBuffer sb1 = new StringBuffer();
        int categoryCount = 0;
        ArrayList<String[]> subCategoryList = new ArrayList<String[]>();
        int currentCategoryLevel = 0;
        while (rs.next()) {
            String oneFFCID = rs.getString(CATEGORYMAP_TABLE_COLUMN_FFCID);
            int oneLevel = rs.getInt(CATEGORYMAP_TABLE_COLUMN_FLevel);
            String oneFBCID = rs.getString(CATEGORYMAP_TABLE_COLUMN_FBCID);
            if (oneLevel == 1) {
                rootCateogryID = oneFFCID;
            }
            if (oneFBCID.equals(sourceBusiCategoryID)) {
                currentCategoryLevel = oneLevel;
            }
            if (currentCategoryLevel != 0 && currentCategoryLevel < oneLevel) {
                subCategoryList.add(new String[]{oneFFCID, oneFBCID, "" + oneLevel});
            }
            if (sb1.toString().length() > 0) {
                sb1.append(",");
            }
            sb1.append("'" + oneFFCID + "'");
            categroyTreeMap.put(oneFFCID, new Integer(oneLevel));
            ++categoryCount;
        }
        if (categoryCount == 0) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("\u4e1a\u52a1\u5206\u7c7bID" + sourceBusiCategoryID + "\u5bf9\u5e94\u7684\u5b58\u50a8\u8def\u5f84\u4e0d\u5b58\u5728"));
            }
        } else {
            String sql_QueryFileCategory = MessageFormat.format(QUERY_FILECATEGORY, sb1.toString());
            if (log.isInfoEnabled()) {
                log.info((Object)("\u83b7\u53d6 FileCategory \u4e00\u4e2a\u6811\u5f62\u5206\u652fSQL:" + sql_QueryFileCategory));
            }
            IRowSet rs2 = DbUtil.executeQuery((Context)ctx, (String)sql_QueryFileCategory);
            String rootCategoryPathID = "";
            String[] categoryPathNameArray = new String[categoryCount];
            while (rs2.next()) {
                String categoryPathName = rs2.getString("FName");
                String categoryPathID = rs2.getString("FPathID");
                String categoryID = rs2.getString("FID");
                if (rootCateogryID.equals(categoryID)) {
                    rootCategoryPathID = categoryPathID;
                }
                int level = (Integer)categroyTreeMap.get(categoryID);
                categoryPathNameArray[level - 1] = categoryPathName;
            }
            StringBuffer docCategoryDirSB = new StringBuffer();
            int categoryTreeGrade = categoryPathNameArray.length;
            int pathTreeSize = 2;
            if (includeSubCategoryPath) {
                pathTreeSize = categoryTreeGrade - currentCategoryLevel + 2;
            }
            retCategoryPath = new String[pathTreeSize];
            for (int i = 0; i < categoryTreeGrade; ++i) {
                if (i > 0) {
                    docCategoryDirSB.append("/");
                }
                docCategoryDirSB.append(categoryPathNameArray[i]);
                if (i + 1 < currentCategoryLevel) continue;
                if (includeSubCategoryPath) {
                    retCategoryPath[i + 1 - currentCategoryLevel] = docCategoryDirSB.toString();
                    continue;
                }
                if (i + 1 != currentCategoryLevel) continue;
                retCategoryPath[0] = docCategoryDirSB.toString();
            }
            retCategoryPath[pathTreeSize - 1] = rootCategoryPathID;
        }
        return retCategoryPath;
    }

    public static boolean updateOneDocumentPath(String sourceFtpID, String targetFtpID, String sourceFtpPath, String targetFtpPath, String documentID, Context ctx) throws BOSException, SQLException {
        return FMEDbUtils.updateOneDocumentPathWithNewPathName(sourceFtpID, targetFtpID, documentID, sourceFtpPath, targetFtpPath, ctx);
    }

    public static String getDocumentSavePath(String busiCategoryID, Context ctx, boolean withFtpRootPath) throws BOSException, SQLException {
        String retPath = "";
        String[] oneCategoryFullPath = FMEDbUtils.getOneCategoryFullPath(busiCategoryID, ctx);
        String categoryPathDir = oneCategoryFullPath[0];
        String pathID = oneCategoryFullPath[1];
        String savePathDir = "";
        savePathDir = withFtpRootPath ? FMEDbUtils.getFtpRootPathAndSavePathDirByPathID(pathID, ctx) : FMEDbUtils.getSavePathNameByPathID(pathID, ctx);
        retPath = savePathDir + "/" + categoryPathDir;
        return retPath;
    }

    public static String[] getDocumentSavePathIncludingSubCategory(String busiCategoryID, Context ctx, boolean withFtpRootPath) throws BOSException, SQLException {
        String[] retPath = null;
        String[] oneCategoryFullPath = FMEDbUtils.getCategoryFullPathIncludeSubCategory(busiCategoryID, ctx, true);
        int cateogrySize = oneCategoryFullPath.length;
        retPath = new String[cateogrySize - 1];
        String pathID = oneCategoryFullPath[cateogrySize - 1];
        String savePathDir = "";
        savePathDir = withFtpRootPath ? FMEDbUtils.getFtpRootPathAndSavePathDirByPathID(pathID, ctx) : FMEDbUtils.getSavePathNameByPathID(pathID, ctx);
        for (int i = 0; i < cateogrySize - 1; ++i) {
            retPath[i] = savePathDir + "/" + oneCategoryFullPath[i];
        }
        return retPath;
    }

    public static String[] getDocumentPath(String documentID, Context ctx) throws BOSException, SQLException {
        String[] retPath = new String[]{"", ""};
        String querySql = MessageFormat.format(QUERY_DOCUMENT_SQL, documentID);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)querySql);
        if (rs.next()) {
            retPath[0] = rs.getString("FPath");
            retPath[1] = rs.getString("FName");
        }
        return retPath;
    }

    private static String getCategoryMapNameByBCID(String busiCategoryID, Context ctx) throws BOSException, SQLException {
        IRowSet rs;
        String mapName = "";
        String sql_categoryMap_MapName = MessageFormat.format(QUERY_CATEGORYMAP_MAPNAME, busiCategoryID);
        if (log.isInfoEnabled()) {
            log.info((Object)("\u83b7\u53d6 FileCategoryMap\u4e2d\u6307\u5b9a" + busiCategoryID + "\u5bf9\u5e94\u7684MapName SQL:" + sql_categoryMap_MapName));
        }
        if ((rs = DbUtil.executeQuery((Context)ctx, (String)sql_categoryMap_MapName)).next()) {
            mapName = rs.getString(CATEGORYMAP_TABLE_COLUMN_FMapName);
        }
        return mapName;
    }

    private static ResultSet getAllCategoryMapRecordByBusiCategoryID(String busiCategoryID, Context ctx) throws BOSException, SQLException {
        String categoryMapName = FMEDbUtils.getCategoryMapNameByBCID(busiCategoryID, ctx);
        if (log.isInfoEnabled()) {
            log.info((Object)("=========================\u4e1a\u52a1\u5206\u7c7bID" + busiCategoryID + "\u6240\u5bf9\u5e94\u7684\u6620\u5c04\u540d\u79f0\u4e3a\uff1a" + categoryMapName));
        }
        String[] mapNameArray = categoryMapName.split("#/#/");
        StringBuffer parentBCIDSB = new StringBuffer();
        if (mapNameArray.length <= 1) {
            if (log.isInfoEnabled()) {
                log.info((Object)("busiCategoryID:" + busiCategoryID + "---\u5bf9\u5e94MapName:" + categoryMapName + "\u4e3a\u7a7a\uff0c\u6216\u8005\u4e3a\u6839\u8282\u70b9"));
            }
        } else {
            for (int i = 0; i < mapNameArray.length - 1; ++i) {
                if (parentBCIDSB.toString().length() > 0) {
                    parentBCIDSB.append(",");
                }
                parentBCIDSB.append("'" + mapNameArray[i] + "'");
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("\u5f53\u524d\u5206\u7c7b\uff1a" + busiCategoryID + "MapName" + categoryMapName + "\u5bf9\u5e94\u7684\u7236\u5206\u7c7b BCID \u4e3a\uff1a" + parentBCIDSB.toString()));
            }
        }
        String sql_categoryMap_1 = "";
        sql_categoryMap_1 = parentBCIDSB.toString().length() > 0 ? MessageFormat.format(QUERY_CATEGORYMAP_With_BOTTOM_PATHID, categoryMapName, parentBCIDSB.toString()) : MessageFormat.format(QUERY_CATEGORYMAP_With_BOTTOM_PATHID_TOP_CLASS, categoryMapName);
        if (log.isInfoEnabled()) {
            log.info((Object)("\u83b7\u53d6 FileCategoryMap\u4e2d\u6240\u6709\u6811\u5f62\u5206\u652fSQL:" + sql_categoryMap_1));
        }
        return DbUtil.executeQuery((Context)ctx, (String)sql_categoryMap_1);
    }

    private static ResultSet queryDocumentByPathPrefix(String pathPrefix, Context ctx) throws BOSException, SQLException {
        String querySql = MessageFormat.format(QUERY_Document_Count_With_PathPrefix, pathPrefix);
        if (log.isInfoEnabled()) {
            log.info((Object)("querySql is:" + querySql));
        }
        return DbUtil.executeQuery((Context)ctx, (String)querySql);
    }

    public static boolean existDocumentInCategory(String busiCategoryID, Context ctx) throws BOSException, SQLException {
        boolean exist = false;
        String[] docFullPath = FMEDbUtils.getDocumentSavePathIncludingSubCategory(busiCategoryID, ctx, true);
        for (int i = 0; i < docFullPath.length; ++i) {
            ResultSet rs = FMEDbUtils.queryDocumentByPathPrefix(docFullPath[i], ctx);
            if (!rs.next()) continue;
            exist = true;
        }
        return exist;
    }

    private static boolean updateCategoryMapName(String oldMapName, String newMapName, Context ctx) throws BOSException, SQLException {
        boolean updateResult = false;
        String updateSql = MessageFormat.format(UPDATE_CATEGORYMAP_MAPNAME, newMapName, oldMapName);
        if (log.isInfoEnabled()) {
            log.info((Object)("\u66f4\u65b0CategoryMapName sql is:\n" + updateSql));
        }
        DbUtil.execute((Context)ctx, (String)updateSql);
        updateResult = true;
        return updateResult;
    }

    public static boolean deleteCategoryMapAndFileCateogry(String busiCategoryID, Context ctx) throws BOSException, SQLException {
        boolean deleteResult = false;
        ResultSet rs = FMEDbUtils.getAllCategoryMapRecordByBusiCategoryID(busiCategoryID, ctx);
        StringBuffer deleteCategoryIDSB = new StringBuffer();
        String mapName = "";
        int currentMapLevel = 0;
        while (rs.next()) {
            String mapBCID = rs.getString(CATEGORYMAP_TABLE_COLUMN_FBCID);
            String mapFCID = rs.getString(CATEGORYMAP_TABLE_COLUMN_FFCID);
            String tempMapName = rs.getString(CATEGORYMAP_TABLE_COLUMN_FMapName);
            int mapLevel = rs.getInt(CATEGORYMAP_TABLE_COLUMN_FLevel);
            if (mapBCID.equals(busiCategoryID)) {
                currentMapLevel = mapLevel;
                mapName = tempMapName;
            }
            if (mapLevel < currentMapLevel || currentMapLevel == 0) continue;
            if (deleteCategoryIDSB.length() > 0) {
                deleteCategoryIDSB.append(",");
            }
            deleteCategoryIDSB.append("'" + mapFCID + "'");
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("\u9884\u5220\u9664\u7684FileCategory ID \u4e3a\uff1a\n" + deleteCategoryIDSB.toString()));
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("\u9884\u5220\u9664\u7684CategoryMap\u7684\u8bb0\u5f55\u4e2d\uff0cMapName\u524d\u7f00\u4e3a:" + mapName));
        }
        String deleteCategoryMapSQL = MessageFormat.format(DELETE_CATEGORYMAP_BY_MAPNAME, mapName, "" + currentMapLevel);
        if (log.isInfoEnabled()) {
            log.info((Object)("deleteCategoryMapSQL is:\n" + deleteCategoryMapSQL));
        }
        DbUtil.execute((Context)ctx, (String)deleteCategoryMapSQL);
        String deleteFileCategorySQL = MessageFormat.format(DELETE_FILECATEGORY_BY_FIDS, deleteCategoryIDSB.toString());
        if (log.isInfoEnabled()) {
            log.info((Object)("deleteFileCategorySQL is:\n" + deleteFileCategorySQL));
        }
        DbUtil.execute((Context)ctx, (String)deleteFileCategorySQL);
        deleteResult = true;
        return deleteResult;
    }

    public static String getUpdateMapName(String mapName, int removeNum) {
        StringBuffer sb = new StringBuffer();
        String[] mapNameArray = mapName.split("#\\/#\\/");
        if (mapNameArray.length > removeNum) {
            for (int i = 0; i < removeNum; ++i) {
                if (i > 0) {
                    sb.append("#/#/");
                }
                sb.append(mapNameArray[i]);
            }
        } else {
            sb.append(mapName);
        }
        return sb.toString();
    }

    public static String getUpdateSubNodeMapName(String mapName, int removeNum) {
        StringBuffer sb = new StringBuffer();
        String[] mapNameArray = mapName.split("#\\/#\\/");
        for (int i = removeNum; i < mapNameArray.length; ++i) {
            if (i > 0) {
                sb.append("#/#/");
            }
            sb.append(mapNameArray[i]);
        }
        return sb.toString();
    }

    public static boolean modifyCategoryMapParentBCID(String busiCategoryID, String parentCID, String newPathID, Context ctx) throws BOSException, SQLException {
        boolean modifyResult = false;
        ResultSet rs = FMEDbUtils.getAllCategoryMapRecordByBusiCategoryID(busiCategoryID, ctx);
        ArrayList<String> modifyCategoryIDList = new ArrayList<String>();
        ArrayList<String> modifyCategoryBCIDList = new ArrayList<String>();
        String initMapName = "";
        int currentMapLevel = 0;
        String currentCFCID = "";
        while (rs.next()) {
            String mapBCID = rs.getString(CATEGORYMAP_TABLE_COLUMN_FBCID);
            String mapFCID = rs.getString(CATEGORYMAP_TABLE_COLUMN_FFCID);
            String mapFID = rs.getString("FID");
            String mapName = rs.getString(CATEGORYMAP_TABLE_COLUMN_FMapName);
            int mapLevel = rs.getInt(CATEGORYMAP_TABLE_COLUMN_FLevel);
            if (mapBCID.equals(busiCategoryID)) {
                currentCFCID = mapFCID;
                currentMapLevel = mapLevel;
                initMapName = mapName;
            }
            if (mapLevel < currentMapLevel || currentMapLevel <= 0) continue;
            modifyCategoryIDList.add(mapFID);
            modifyCategoryBCIDList.add(mapBCID);
        }
        String updateFileCategorySQL = "";
        if (FMEUtils.isBlankString(parentCID)) {
            if (log.isInfoEnabled()) {
                log.info((Object)"\u65b0\u7684\u7236\u5206\u7c7b\u7684\u4e3a\u6839\u8282\u70b9");
            }
            updateFileCategorySQL = MessageFormat.format(UPDATE_FILECATEGOREY_PARENT_ID, "", newPathID, currentCFCID);
            if (log.isInfoEnabled()) {
                log.info((Object)("\u66f4\u65b0\u8be5\u5206\u7c7b\u8282\u70b9\uff0c\u5bf9\u5e94\u7684\u6620\u5c04\u7684FileCategory \u8bb0\u5f55\u7684FPID,FPathID sql is:\n" + updateFileCategorySQL));
            }
            DbUtil.execute((Context)ctx, (String)updateFileCategorySQL);
            String updateCategoryMapSQL = "";
            StringBuffer newCBIDSB = new StringBuffer();
            for (int k = 0; k < modifyCategoryIDList.size(); ++k) {
                String oneUpdateCategoryMapID = (String)modifyCategoryIDList.get(k);
                String oneUpdateCategoryBCID = (String)modifyCategoryBCIDList.get(k);
                if (newCBIDSB.toString().length() > 0) {
                    newCBIDSB.append("#/#/");
                }
                newCBIDSB.append(oneUpdateCategoryBCID);
                updateCategoryMapSQL = MessageFormat.format(UPDATE_CATEGORYMAP_MAPNAME_LEVEL, newCBIDSB.toString(), "" + (k + 1), oneUpdateCategoryMapID);
                DbUtil.execute((Context)ctx, (String)updateCategoryMapSQL);
            }
            modifyResult = true;
        } else {
            String parentCIDMapFCID = "";
            String parentCIDMapName = "";
            int parentCIDMapLevel = 0;
            ResultSet rs2 = FMEDbUtils.getCategoryMapByFBID(parentCID, ctx);
            if (rs2.next()) {
                parentCIDMapFCID = rs2.getString(CATEGORYMAP_TABLE_COLUMN_FFCID);
                parentCIDMapName = rs2.getString(CATEGORYMAP_TABLE_COLUMN_FMapName);
                parentCIDMapLevel = rs2.getInt(CATEGORYMAP_TABLE_COLUMN_FLevel);
            }
            updateFileCategorySQL = MessageFormat.format(UPDATE_FILECATEGOREY_PARENT_ID, parentCIDMapFCID, "", currentCFCID);
            if (log.isInfoEnabled()) {
                log.info((Object)("\u66f4\u65b0\u8be5\u5206\u7c7b\u8282\u70b9\uff0c\u5bf9\u5e94\u7684\u6620\u5c04\u7684FileCategory \u8bb0\u5f55\u7684FPID,FPathID sql is:\n" + updateFileCategorySQL));
            }
            DbUtil.execute((Context)ctx, (String)updateFileCategorySQL);
            String updateCategoryMapSQL = "";
            StringBuffer newCBIDSB = new StringBuffer();
            for (int k = 0; k < modifyCategoryIDList.size(); ++k) {
                String oneUpdateCategoryMapID = (String)modifyCategoryIDList.get(k);
                String oneUpdateCategoryBCID = (String)modifyCategoryBCIDList.get(k);
                if (newCBIDSB.toString().length() > 0) {
                    newCBIDSB.append("#/#/");
                }
                newCBIDSB.append(oneUpdateCategoryBCID);
                updateCategoryMapSQL = MessageFormat.format(UPDATE_CATEGORYMAP_MAPNAME_LEVEL, parentCIDMapName + "#/#/" + newCBIDSB.toString(), "" + (k + 1 + parentCIDMapLevel), oneUpdateCategoryMapID);
                DbUtil.execute((Context)ctx, (String)updateCategoryMapSQL);
            }
            modifyResult = true;
        }
        return modifyResult;
    }

    public static boolean modifyCategoryMapParentBCIDExt(String busiCategoryID, String parentCID, String newPathID, Context ctx) throws BOSException, SQLException {
        boolean modifyResult = false;
        ResultSet rs = FMEDbUtils.getAllCategoryMapRecordByBusiCategoryID(busiCategoryID, ctx);
        ArrayList<String> modifyCategoryIDList = new ArrayList<String>();
        ArrayList<String> modifyCategoryBCIDList = new ArrayList<String>();
        String initMapName = "";
        int currentMapLevel = 0;
        String currentCFCID = "";
        while (rs.next()) {
            String mapBCID = rs.getString(CATEGORYMAP_TABLE_COLUMN_FBCID);
            String mapFCID = rs.getString(CATEGORYMAP_TABLE_COLUMN_FFCID);
            String mapFID = rs.getString("FID");
            String mapName = rs.getString(CATEGORYMAP_TABLE_COLUMN_FMapName);
            int mapLevel = rs.getInt(CATEGORYMAP_TABLE_COLUMN_FLevel);
            if (mapBCID.equals(busiCategoryID)) {
                currentCFCID = mapFCID;
                currentMapLevel = mapLevel;
                initMapName = mapName;
            }
            if (mapLevel < currentMapLevel || currentMapLevel <= 0) continue;
            modifyCategoryIDList.add(mapFID);
            modifyCategoryBCIDList.add(mapBCID);
        }
        String updateFileCategorySQL = "";
        if (FMEUtils.isBlankString(parentCID)) {
            if (log.isInfoEnabled()) {
                log.info((Object)"\u65b0\u7684\u7236\u5206\u7c7b\u7684\u4e3a\u6839\u8282\u70b9");
            }
            updateFileCategorySQL = MessageFormat.format(UPDATE_FILECATEGOREY_PARENT_ID, "", newPathID, currentCFCID);
            if (log.isInfoEnabled()) {
                log.info((Object)("\u66f4\u65b0\u8be5\u5206\u7c7b\u8282\u70b9\uff0c\u5bf9\u5e94\u7684\u6620\u5c04\u7684FileCategory \u8bb0\u5f55\u7684FPID,FPathID sql is:\n" + updateFileCategorySQL));
            }
            DbUtil.execute((Context)ctx, (String)updateFileCategorySQL);
            String updateCategoryMapSQL = "";
            StringBuffer newCBIDSB = new StringBuffer();
            for (int k = 0; k < modifyCategoryIDList.size(); ++k) {
                String oneUpdateCategoryMapID = (String)modifyCategoryIDList.get(k);
                String oneUpdateCategoryBCID = (String)modifyCategoryBCIDList.get(k);
                if (newCBIDSB.toString().length() > 0) {
                    newCBIDSB.append("#/#/");
                }
                newCBIDSB.append(oneUpdateCategoryBCID);
                updateCategoryMapSQL = MessageFormat.format(UPDATE_CATEGORYMAP_MAPNAME_LEVEL, newCBIDSB.toString(), "" + (k + 1), oneUpdateCategoryMapID);
                DbUtil.execute((Context)ctx, (String)updateCategoryMapSQL);
            }
            modifyResult = true;
        } else {
            String parentCIDMapFCID = "";
            String parentCIDMapName = "";
            int parentCIDMapLevel = 0;
            ResultSet rs2 = FMEDbUtils.getCategoryMapByFBID(parentCID, ctx);
            if (rs2.next()) {
                parentCIDMapFCID = rs2.getString(CATEGORYMAP_TABLE_COLUMN_FFCID);
                parentCIDMapName = rs2.getString(CATEGORYMAP_TABLE_COLUMN_FMapName);
                parentCIDMapLevel = rs2.getInt(CATEGORYMAP_TABLE_COLUMN_FLevel);
            }
            updateFileCategorySQL = MessageFormat.format(UPDATE_FILECATEGOREY_PARENT_ID, parentCIDMapFCID, "", currentCFCID);
            if (log.isInfoEnabled()) {
                log.info((Object)("\u66f4\u65b0\u8be5\u5206\u7c7b\u8282\u70b9\uff0c\u5bf9\u5e94\u7684\u6620\u5c04\u7684FileCategory \u8bb0\u5f55\u7684FPID,FPathID sql is:\n" + updateFileCategorySQL));
            }
            DbUtil.execute((Context)ctx, (String)updateFileCategorySQL);
            String updateCategoryMapSQL = "";
            StringBuffer newCBIDSB = new StringBuffer();
            for (int k = 0; k < modifyCategoryIDList.size(); ++k) {
                String oneUpdateCategoryMapID = (String)modifyCategoryIDList.get(k);
                String oneUpdateCategoryBCID = (String)modifyCategoryBCIDList.get(k);
                if (newCBIDSB.toString().length() > 0) {
                    newCBIDSB.append("#/#/");
                }
                newCBIDSB.append(oneUpdateCategoryBCID);
                updateCategoryMapSQL = MessageFormat.format(UPDATE_CATEGORYMAP_MAPNAME_LEVEL, parentCIDMapName + "#/#/" + newCBIDSB.toString(), "" + (k + 1 + parentCIDMapLevel), oneUpdateCategoryMapID);
                DbUtil.execute((Context)ctx, (String)updateCategoryMapSQL);
            }
            modifyResult = true;
        }
        return modifyResult;
    }

    private static ResultSet getCategoryMapByFBID(String fbid, Context ctx) throws BOSException, SQLException {
        String queryFFID_SQL = MessageFormat.format(QUERY_CATEGORY_MAP_SQL_With_FBCID, fbid);
        if (log.isInfoEnabled()) {
            log.info((Object)("\u67e5\u8be2\u7236BussinesCategoryID Sql is:\n" + queryFFID_SQL));
        }
        return DbUtil.executeQuery((Context)ctx, (String)queryFFID_SQL);
    }

    private static ResultSet getParentCategoryMap(String mapNamePrefix, int level, Context ctx) throws BOSException, SQLException {
        String sql = MessageFormat.format(QUERY_CATEGORYMAP_Current_NODE_TO_ROOT_NODE, mapNamePrefix, "" + level);
        if (log.isInfoEnabled()) {
            log.info((Object)"\u83b7\u53d6\u9884\u514b\u9686\u7684\u7236\u8282\u70b9\u5230\u6839\u8282\u70b9\u7684\u8bb0\u5f55");
        }
        return DbUtil.executeQuery((Context)ctx, (String)sql);
    }

    private static List cloneOneCategoryMapTree(ResultSet oneTreeRs, String newSubMapName, Context ctx) throws BOSException, SQLException {
        ArrayList<String> newCategoryMapID = new ArrayList<String>();
        String sql = "";
        while (oneTreeRs.next()) {
            String FBCID = oneTreeRs.getString(CATEGORYMAP_TABLE_COLUMN_FBCID);
            String FFCID = oneTreeRs.getString(CATEGORYMAP_TABLE_COLUMN_FFCID);
            int level = oneTreeRs.getInt(CATEGORYMAP_TABLE_COLUMN_FLevel);
            BOSUuid cmUUID = BOSUuid.create((String)"DDD77DDD");
            sql = MessageFormat.format(INSERT_CATEGORYMAP, cmUUID.toString(), FBCID, FFCID, newSubMapName, "" + level);
            DbUtil.execute((Context)ctx, (String)sql);
            newCategoryMapID.add(cmUUID.toString());
        }
        return newCategoryMapID;
    }

    public static List getGCType1Info(String serverID, Context ctx) throws BOSException, SQLException {
        ArrayList<GCDocumentInfo> gcDocList = new ArrayList<GCDocumentInfo>();
        String querySQL = MessageFormat.format(QUERY_GC_TYPE_1, serverID);
        if (log.isInfoEnabled()) {
            log.info((Object)("getGCType1Info sql is:\n" + querySQL));
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)querySQL);
        String documentID = "";
        String documentDisplayName = "";
        String documentRealName = "";
        String documentPath = "";
        long documentSize = 0L;
        while (rs.next()) {
            documentID = rs.getString("FDocumentID");
            documentDisplayName = rs.getString("FDisplayName");
            documentRealName = rs.getString("FName");
            documentPath = rs.getString("FPath");
            documentSize = rs.getLong("FSize");
            GCDocumentInfo gcDoc = new GCDocumentInfo("1(\u672a\u5f15\u7528)", documentID, documentDisplayName, documentRealName, documentPath, documentSize, serverID);
            gcDocList.add(gcDoc);
        }
        return gcDocList;
    }

    public static List getGCType2Info(String serverID, Context ctx) throws BOSException, SQLException {
        ArrayList<GCDocumentInfo> gcDocList = new ArrayList<GCDocumentInfo>();
        String querySQL = MessageFormat.format(QUERY_GC_TYPE_2, serverID);
        if (log.isInfoEnabled()) {
            log.info((Object)("QUERY_GC_TYPE_2 sql is:\n" + querySQL));
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)querySQL);
        String documentID = "";
        String documentDisplayName = "(\u6587\u4ef6\u540d\u5df2\u4e22\u5931)";
        String documentRealName = "";
        String documentPath = "";
        long documentSize = 0L;
        while (rs.next()) {
            documentID = rs.getString("FDocumentID");
            documentRealName = rs.getString("FName");
            documentPath = rs.getString("FPath");
            documentSize = rs.getLong("FSize");
            GCDocumentInfo gcDoc = new GCDocumentInfo("2(\u65e0\u4e1a\u52a1\u5e94\u7528)", documentID, documentDisplayName, documentRealName, documentPath, documentSize, serverID);
            gcDocList.add(gcDoc);
        }
        return gcDocList;
    }

    public static List getGCType3Info(FtpDocumentInfo ftpDocumentInfo, Context ctx) throws BOSException, SQLException {
        ArrayList<GCDocumentInfo> gcDocList = new ArrayList<GCDocumentInfo>();
        String serverID = ftpDocumentInfo.getServerID();
        if (ftpDocumentInfo.getDocumentCount() > 0) {
            List ftpDocumentList = ftpDocumentInfo.getDocumentList();
            String documentDisplayName = "(\u6587\u4ef6\u540d\u5df2\u4e22\u5931)";
            String fileName = "";
            String filePath = "";
            for (int i = 0; i < ftpDocumentList.size(); ++i) {
                String oneFile = (String)ftpDocumentList.get(i);
                int fpos = oneFile.lastIndexOf("/");
                if (fpos != -1) {
                    fileName = oneFile.substring(fpos + 1);
                    filePath = oneFile.substring(0, fpos + 1);
                    String querySQL = MessageFormat.format(QUERY_GC3_DOCUMENT_SQL, fileName, filePath, serverID);
                    if (log.isInfoEnabled()) {
                        log.info((Object)("QUERY_GC_TYPE_3 sql is:\n" + querySQL));
                    }
                    IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)querySQL);
                    boolean existGC = true;
                    if (rs.next()) {
                        existGC = false;
                    }
                    if (!existGC) continue;
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Ftp\u670d\u52a1\u5668\uff1a" + serverID + "\u4e0a\u7684\u6587\u4ef6:" + oneFile + "\u5c5e\u4e8e\u5783\u573e\u6587\u4ef6\uff0c\u5728\u6587\u6863\u7ba1\u7406\u5f15\u64ce\u5185\u90e8\uff0c\u4e0d\u5b58\u5728\u76f8\u5e94\u7684\u4e1a\u52a1\u3001\u6570\u636e\u5f15\u7528"));
                    }
                    GCDocumentInfo gcDoc = new GCDocumentInfo("3(\u4e0d\u5b58\u5728\u8bb0\u5f55)", "", documentDisplayName, fileName, filePath, 0L, serverID);
                    gcDocList.add(gcDoc);
                    continue;
                }
                System.out.println("Ftp\u4e0a\u7684\u6587\u6863" + oneFile + "\u4e0d\u7b26\u5408\u8981\u6c42\uff0c\u4e0d\u80fd\u533a\u5206\u8def\u5f84\u3001\u548c\u540d\u79f0");
            }
        } else if (log.isInfoEnabled()) {
            log.info((Object)("Ftp\u670d\u52a1\u5668\uff1a" + serverID + "\u4e0a\u6ca1\u6709\u6587\u4ef6\uff0c\u4e0d\u5b58\u5728\u76f8\u5e94\u7684GCType3\u7c7b\u578b\u7684\u6587\u4ef6"));
        }
        return gcDocList;
    }

    public static boolean clearGCType1Info(String documentID, int clearWay, Context ctx) throws BOSException, SQLException {
        boolean clearResult = false;
        String statusValue = "";
        statusValue = clearWay == 0 ? "0" : "1";
        String clearSQL = MessageFormat.format(CLEAR_GC_TYPE_1, statusValue, documentID);
        if (log.isInfoEnabled()) {
            log.info((Object)("clearGCType1Info sql is:\n" + clearSQL));
        }
        DbUtil.execute((Context)ctx, (String)clearSQL);
        clearResult = true;
        return clearResult;
    }

    public static boolean clearGCType2Info(String documentID, Context ctx) throws BOSException, SQLException {
        boolean clearResult = false;
        String deleteSQL = MessageFormat.format(DELETE_GC2_DOCUMENT_SQL, documentID);
        if (log.isInfoEnabled()) {
            log.info((Object)("clearGCType2Info sql is:\n" + deleteSQL));
        }
        DbUtil.execute((Context)ctx, (String)deleteSQL);
        clearResult = true;
        return false;
    }

    public static boolean existCategoryMap(String busiCategoryID, String parentBCID, String pathID, Context ctx) throws BOSException, SQLException {
        IRowSet rs;
        boolean existResult = false;
        String mapName = "";
        mapName = FMEUtils.isBlankString(parentBCID) ? busiCategoryID : parentBCID + "#/#/" + busiCategoryID;
        String existSQL = MessageFormat.format(QUERY_CATEOGRYMAP_EXIST, busiCategoryID, mapName);
        if (log.isInfoEnabled()) {
            log.info((Object)("existCategoryMap sql is:\n" + existSQL));
        }
        if ((rs = DbUtil.executeQuery((Context)ctx, (String)existSQL)).next()) {
            existResult = true;
        }
        return existResult;
    }

    public static boolean existDocumentInSavePath(String pathID, Context ctx) throws BOSException, SQLException {
        boolean existResult = false;
        ResultSet spRS = FMEDbUtils.getSavePathNameByPathIDExt(pathID, ctx);
        String pathName = "";
        String serverID = "";
        if (spRS.next()) {
            pathName = spRS.getString(SAVEPATH_TABLE_COLUMN_FPathName);
            serverID = spRS.getString(SAVEPATH_TABLE_COLUMN_FServerID);
        }
        if (!FMEUtils.isBlankString(pathName) && !FMEUtils.isBlankString(serverID)) {
            String rootPath = FMEDbUtils.getFtpServerRootPath(serverID, ctx);
            String prefix = rootPath + "/" + pathName;
            ResultSet rs = FMEDbUtils.queryDocumentByPathPrefix(prefix, ctx);
            if (rs.next()) {
                existResult = true;
                if (log.isInfoEnabled()) {
                    log.info((Object)("\u68c0\u7d22T_FME_Document\u7684\u8bb0\u5f55\u4e2d\uff0c\u5b58\u5728\u524d\u7f00\u4e3a\uff1a" + prefix + "\u7684\u8bb0\u5f55"));
                }
            }
        } else {
            existResult = false;
            if (log.isErrorEnabled()) {
                log.info((Object)("\u68c0\u7d22PathID\u4e3a\uff1a" + pathID + "\u7684\u8bb0\u5f55\u4e0d\u5b58\u5728"));
            }
        }
        return existResult;
    }

    public static boolean moveBusinessCategory(String sourcePathID, String sourceCategoryInfo, String targetPathID, String targetCategoryInfo, Context ctx) throws BOSException, SQLException {
        ResultSet rs2;
        boolean moveResult = false;
        String sourceFCID = "";
        String targetFCID = "";
        ResultSet rs1 = FMEDbUtils.getCategoryMapByFBID(sourceCategoryInfo, ctx);
        if (rs1.next()) {
            sourceFCID = rs1.getString(CATEGORYMAP_TABLE_COLUMN_FFCID);
        }
        if ((rs2 = FMEDbUtils.getCategoryMapByFBID(targetCategoryInfo, ctx)).next()) {
            targetFCID = rs2.getString(CATEGORYMAP_TABLE_COLUMN_FFCID);
        }
        if (FMEUtils.isBlankString(sourceFCID)) {
            throw new BOSException("\u79fb\u52a8\u680f\u76eesourcePathID:" + sourcePathID + "\u6216\u8005targetCategoryInfo" + targetCategoryInfo + "\u5bf9\u5e94\u7684FileCategoryID\u4e0d\u5b58\u5728");
        }
        moveResult = FMEDbUtils.modifyCategoryMapParentBCID(sourceCategoryInfo, targetCategoryInfo, targetPathID, ctx);
        return moveResult;
    }

    public static List getTopNDownloadDocInfo(int nValue, Context ctx) throws BOSException, SQLException {
        ArrayList retList = new ArrayList();
        if (nValue <= 0) {
            System.out.println("getTopNDownloadDocInfo set nValue <=0 " + nValue);
            return retList;
        }
        String queryFFID_SQL = MessageFormat.format(QUERY_TOPN_DOWNLOAD_DOCUMENT, "" + nValue);
        if (log.isInfoEnabled()) {
            log.info((Object)("Query Top " + nValue + " Download document Sql is:\n" + queryFFID_SQL));
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)queryFFID_SQL);
        String docId = "";
        String busiID = "";
        int downloadCount = 0;
        while (rs.next()) {
            docId = rs.getString("DocumentID");
            busiID = rs.getString("BusinessID");
            downloadCount = rs.getInt("DownloadTime");
            HashMap<String, Object> oneMap = new HashMap<String, Object>();
            oneMap.put("documentID", docId);
            oneMap.put("businessID", busiID);
            oneMap.put("downloadAcount", new Integer(downloadCount));
            retList.add(oneMap);
        }
        return retList;
    }

    public static Map getBusinessDocDownloadCount(String businessID, Context ctx) throws BOSException, SQLException {
        HashMap<String, Integer> countMap = new HashMap<String, Integer>();
        String queryFFID_SQL = MessageFormat.format(QUERY_BusinessDoc_DOWNLOAD_COUNT, businessID);
        if (log.isInfoEnabled()) {
            log.info((Object)("Query businessID " + businessID + " Download count Sql is:\n" + queryFFID_SQL));
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)queryFFID_SQL);
        String docId = "";
        int downloadCount = 0;
        while (rs.next()) {
            docId = rs.getString("FDocumentID");
            downloadCount = rs.getInt("DownloadTime");
            countMap.put(docId, new Integer(downloadCount));
        }
        return countMap;
    }
}

