/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.fme.dao;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.fme.app.BusiDocCollection;
import com.kingdee.eas.base.fme.app.BusiDocFactory;
import com.kingdee.eas.base.fme.app.BusiDocInfo;
import com.kingdee.eas.base.fme.app.CategoryMapCollection;
import com.kingdee.eas.base.fme.app.CategoryMapFactory;
import com.kingdee.eas.base.fme.app.CategoryMapInfo;
import com.kingdee.eas.base.fme.app.DocumentCollection;
import com.kingdee.eas.base.fme.app.DocumentFactory;
import com.kingdee.eas.base.fme.app.DocumentIconCollection;
import com.kingdee.eas.base.fme.app.DocumentIconFactory;
import com.kingdee.eas.base.fme.app.DocumentIconInfo;
import com.kingdee.eas.base.fme.app.DocumentInfo;
import com.kingdee.eas.base.fme.app.FileCategoryCollection;
import com.kingdee.eas.base.fme.app.FileCategoryFactory;
import com.kingdee.eas.base.fme.app.FileCategoryInfo;
import com.kingdee.eas.base.fme.app.FtpServerCollection;
import com.kingdee.eas.base.fme.app.FtpServerFactory;
import com.kingdee.eas.base.fme.app.FtpServerInfo;
import com.kingdee.eas.base.fme.app.IBusiDoc;
import com.kingdee.eas.base.fme.app.ICategoryMap;
import com.kingdee.eas.base.fme.app.IDocument;
import com.kingdee.eas.base.fme.app.IDocumentIcon;
import com.kingdee.eas.base.fme.app.IFileCategory;
import com.kingdee.eas.base.fme.app.IFtpServer;
import com.kingdee.eas.base.fme.app.IOperLog;
import com.kingdee.eas.base.fme.app.ISavePath;
import com.kingdee.eas.base.fme.app.OperLogCollection;
import com.kingdee.eas.base.fme.app.OperLogFactory;
import com.kingdee.eas.base.fme.app.OperLogInfo;
import com.kingdee.eas.base.fme.app.SavePathCollection;
import com.kingdee.eas.base.fme.app.SavePathFactory;
import com.kingdee.eas.base.fme.app.SavePathInfo;
import com.kingdee.eas.base.fme.appext.FMEServerFactory;
import com.kingdee.eas.base.fme.appext.IConsoleServer;
import com.kingdee.eas.base.fme.bo.DocumentBO;
import com.kingdee.eas.base.fme.dao.IFMEDao;
import com.kingdee.eas.base.fme.ftp.FtpConfig;
import com.kingdee.eas.base.fme.model.Category;
import com.kingdee.eas.base.fme.model.CategoryMap;
import com.kingdee.eas.base.fme.model.DocumentIcon;
import com.kingdee.eas.base.fme.model.FtpServer;
import com.kingdee.eas.base.fme.model.OperLog;
import com.kingdee.eas.base.fme.model.SavePath;
import com.kingdee.eas.base.fme.service.ServiceResult;
import com.kingdee.eas.base.fme.util.FMEUIUtils;
import com.kingdee.eas.base.fme.util.FMEUtils;
import com.kingdee.eas.base.fme.util.FtpUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FMEDaoImpl
implements IFMEDao {
    private static final Log log = LogFactory.getLog(FMEDaoImpl.class);
    private Context ctx = null;
    public static final String QUERY_BUSIDOC_OSQL = "select ID,BusinessID,DocumentID,DisplayName where BusinessID=''{0}'' and DocumentID=''{1}''";
    public static final String QUERY_DOC_REF_OSQL = "select ID,BusinessID,DocumentID,DisplayName where DocumentID=''{0}''";
    public static final String DELETE_BUSIDOC_OSQL = "where BusinessID=''{0}'' and DocumentID=''{1}''";
    public static final String QUERY_BUSINESS_LINK_DOC_OSQL = "select DocumentID,DisplayName where BusinessID=''{0}''";
    public static final String QUERY_BUSINESS_AND_DOC_OSQL = "select DocumentID,DisplayName where BusinessID=''{0}'' and DocumentID=''{1}''";
    public static final String QUERY_DOCUMENT_OSQL = "select DocumentID,Name,Size,Path,Description,OperDate,TypeID,Status,ServerID where {0} ";
    public static final String QUERY_DOCUMENT_WITH_TYPEID = "select DocumentID, Name, Size, Path, Description, OperDate, TypeID, Status, ServerID where TypeID=''{0}''";
    public static final String QUERY_FTPSERVER_BYNAME = "select ServerID,ServerName,ServerHost,ServerPort,ServerUser,ServerPswd,RootPath,ServerStatus,IsDefault,AccessAddress,InternetIP where ServerName = ''{0}''";
    private IFtpServer ftpServer = null;
    public static final String QUERY_FTPSERVER_NORMAL = "select ServerID,ServerName,ServerHost,ServerPort,ServerUser,ServerPswd,RootPath,ServerStatus,IsDefault,AccessAddress,InternetIP where ServerStatus='0'";
    public static final String QUERY_FTPSERVER_BYID = "select ServerID,ServerName,ServerHost,ServerPort,ServerUser,ServerPswd,RootPath,ServerStatus,IsDefault,AccessAddress,InternetIP  where ServerID = ''{0}''";
    private ISavePath savePath = null;
    private IDocumentIcon documentIcon = null;
    public static final String SAVEPATH_SQL_QUERY = "select PathID, PathName, DisplayName, ServerID, PathStatus, SaveType  where PathStatus='0'";
    public static final String SAVEPATH_SQL_QUERY_WITH_PATHID = "select PathID, PathName, DisplayName, ServerID, PathStatus, SaveType  where PathStatus=''0'' and PathID=''{0}''";
    public static final String SAVEPATH_SQL_QUERY_WITH_PATHID_SERVERID = "select PathID, PathName, DisplayName, ServerID, PathStatus, SaveType  where PathName=''{0}'' and ServerID=''{1}''";
    private IFileCategory category = null;
    public static final String FILECATEGORY_SQL_QUERY = "select ID, PID, Name, Desc, Status, PathID  where Status='0'";
    public static final String FILECATEGORY_SQL_QUERY_WITH_ID = "select ID, PID, Name, Desc, Status, PathID  where Status=''0'' and ID=''{0}''";
    private IOperLog operLog = null;
    public static final String OPERLOG_QUERY_SQL = "select ID, DocumentID, OperType, StaffID, OperDate  where DocumentID=''{0}'' and OperType={1}";
    private ICategoryMap categoryMap = null;
    public static final String QUERY_CATEGORY_MAP_SQL = "select ID, BCID, FCID, MapName, Level  where MapName=''{0}'' order by Level ";
    public static final String QUERY_CATEGORY_MAP_SQL_IN = "select ID, BCID, FCID, MapName, Level  where MapName in ({0}) order by Level ";
    public static final String QUERY_CATEGORY_MAP_SQL_BCID = "select ID, BCID, FCID, MapName, Level  where BCID=''{0}'' order by Level ";
    private IDocument documentIntance = null;
    public static final String DOCUMENTICON_SQL_QUERY = "select DocumentIconid, DocTypeName, DocExtName, IconName, Status, IconPath,IconSaveType ";
    public static final String DOCUMENTICON_SQL_QUERY_WITH_DOCUMENTICONID = "select DocumentIconid, DocTypeName, DocExtName, IconName, Status,IconPath,IconSaveType  where  DocumentIconid=''{0}''";
    public static final String DOCUMENT_SQL_QUERY_WITH_DOCUMENTICONID = "select DocTypeName where DocTypeName=''{0}'' ";
    public static final String DOCEXTNAME_SQL_QUERY = "select DocExtName ";
    public static final String DOCUMENTICONMAP_SQL_QUERY = "select DocExtName,IconName,IconPath";

    public FMEDaoImpl(Context ctx) {
        this.ctx = ctx;
    }

    @Override
    public String[] insert(DocumentBO[] docBO) throws Exception {
        if (log.isInfoEnabled()) {
            log.info((Object)("\u6267\u884cFMEDaoImpl Insert " + docBO.toString()));
        }
        IDocument doc = null;
        IBusiDoc busiDoc = null;
        String[] resultDocId = new String[docBO.length];
        try {
            if (log.isInfoEnabled()) {
                log.info((Object)("\u5f53\u524d\u7684Ctx is:" + this.ctx));
            }
            if (this.ctx == null) {
                doc = DocumentFactory.getRemoteInstance();
                busiDoc = BusiDocFactory.getRemoteInstance();
            } else {
                doc = DocumentFactory.getLocalInstance(this.ctx);
                busiDoc = BusiDocFactory.getLocalInstance(this.ctx);
            }
            DocumentInfo docInfo = null;
            for (int i = 0; i < docBO.length; ++i) {
                DocumentBO oneBO = docBO[i];
                if (oneBO == null) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)"\u589e\u52a0\u7684\u6587\u6863\u4fe1\u606f\u5bf9\u8c61\u4e3anull");
                    }
                    throw new Exception("FMEDaoImpl \u8c03\u7528\u65b9\u6cd5insert \u8f93\u5165\u5bf9\u8c61\u4e3anull");
                }
                docInfo = new DocumentInfo();
                BOSUuid documentUUID = BOSUuid.create((String)"DDD00DDD");
                IObjectPK pk = null;
                String documentID = oneBO.getDocumentID();
                boolean needAddDocument = true;
                if (documentID != null && documentID.trim().length() > 0) {
                    pk = FMEUtils.getObjectPK("DocumentID", documentID);
                    boolean isExists = doc.exists(pk);
                    if (isExists) {
                        DocumentInfo currentDocInfo;
                        String currentDocStatus;
                        if (log.isInfoEnabled()) {
                            log.info((Object)("\u8be5\u6587\u4ef6" + documentID + "\u5df2\u7ecf\u5b58\u5728\u4e86\uff0c\u4e0d\u9700\u8981\u7ee7\u7eed\u4e0a\u4f20\u4fdd\u5b58"));
                        }
                        if ((currentDocStatus = (currentDocInfo = doc.getValue(pk)).getStatus()).equalsIgnoreCase("3")) {
                            if (log.isInfoEnabled()) {
                                log.info((Object)"\u8be5\u6587\u4ef6\u5c5e\u4e8e\u672a\u4e0a\u4f20\u3001\u6216\u8005\u4e0a\u4f20\u4e0d\u6210\u529f\u7684\u6587\u4ef6\uff0c\u9700\u8981\u91cd\u65b0\u8c03\u6574\u72b6\u6001");
                            }
                            currentDocInfo.setStatus("0");
                            doc.update(pk, currentDocInfo);
                            this.insertOperLog(documentID, 3);
                        }
                        documentUUID = BOSUuid.read((String)documentID);
                        needAddDocument = false;
                    } else {
                        if (log.isInfoEnabled()) {
                            log.info((Object)("\u8be5\u6587\u4ef6" + documentID + "\u4e0d\u5b58\u5728\u4e86\uff0c\u9700\u8981\u4e0a\u4f20\u4fdd\u5b58"));
                        }
                        documentUUID = BOSUuid.read((String)documentID);
                        System.out.println("========================documentID is:" + documentID);
                        System.out.println("========================uuid is:" + documentUUID.toString());
                        docInfo.setDocumentID(documentUUID);
                    }
                } else {
                    docInfo.setDocumentID(documentUUID);
                }
                if (needAddDocument) {
                    docInfo.setName(oneBO.getName());
                    docInfo.setSize(oneBO.getSize());
                    docInfo.setPath(oneBO.getPath());
                    docInfo.setStatus("" + oneBO.getStatus());
                    docInfo.setDescription(oneBO.getDescription());
                    docInfo.setOperDate(FMEUtils.getCurrrentDate());
                    String fileTypeID = oneBO.getTypeID();
                    docInfo.setTypeID(fileTypeID);
                    String serverID = oneBO.getServerID();
                    docInfo.setServerID(serverID);
                    pk = doc.addnew(docInfo);
                    this.insertOperLog(documentID, 0);
                }
                if (pk != null) {
                    BusiDocInfo bdInfo = new BusiDocInfo();
                    BOSUuid busiDoc_UUID = BOSUuid.create((String)"DDD44DDD");
                    bdInfo.setID(busiDoc_UUID);
                    System.out.println("-------------------------documentUUID is:" + documentUUID.toString());
                    bdInfo.setDocumentID(documentUUID.toString());
                    bdInfo.setBusinessID(oneBO.getBusinessID());
                    bdInfo.setDisplayName(oneBO.getDisplayName());
                    IObjectPK insertPK = busiDoc.addnew(bdInfo);
                    if (insertPK == null) continue;
                    resultDocId[i] = busiDoc_UUID.toString();
                    continue;
                }
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)"\u4fdd\u5b58\u6587\u4ef6\u57fa\u672c\u4fe1\u606f\u6ca1\u6709\u6210\u529f\uff0c\u4e0d\u9700\u8981\u4fdd\u5b58\u6587\u4ef6\u5e94\u7528\u4fe1\u606f");
            }
        }
        catch (BOSException se) {
            if (log.isErrorEnabled()) {
                log.error((Object)"\u4fdd\u5b58\u4e0a\u4f20\u6587\u4ef6\u8d44\u6599\u5e93\u4fe1\u606f\u4fdd\u5b58\u5f02\u5e38", (Throwable)se);
            }
            throw new Exception("FMEDaoImpl \u6267\u884cinsert\u629b\u51fa\u5f02\u5e38", se);
        }
        return resultDocId;
    }

    @Override
    public String[] update(DocumentBO[] docArray) throws Exception {
        IBusiDoc busiDoc = null;
        String[] resultBDId = new String[docArray.length];
        try {
            busiDoc = this.ctx == null ? BusiDocFactory.getRemoteInstance() : BusiDocFactory.getLocalInstance(this.ctx);
            for (int i = 0; i < docArray.length; ++i) {
                DocumentBO oneBO = docArray[i];
                String businessID = oneBO.getBusinessID();
                String documentID = oneBO.getDocumentID();
                String newDisplayName = oneBO.getDisplayName();
                BusiDocInfo bdInfo = busiDoc.getValue(MessageFormat.format(QUERY_BUSIDOC_OSQL, businessID, documentID));
                if (bdInfo == null) continue;
                bdInfo.setDisplayName(newDisplayName);
                String updateBDID = bdInfo.getID().toString();
                busiDoc.update(FMEUtils.getObjectPK("ID", updateBDID), bdInfo);
                this.insertOperLog(documentID, 3);
                resultBDId[i] = updateBDID;
            }
        }
        catch (BOSException bs) {
            if (log.isErrorEnabled()) {
                log.error((Object)"FMEDaoImpl \u8c03\u7528update \u65b9\u6cd5\u629b\u51fa\u5f02\u5e38", (Throwable)bs);
            }
            throw new Exception("FMEDaoImpl \u8c03\u7528update \u65b9\u6cd5\u629b\u51fa\u5f02\u5e38", bs);
        }
        return resultBDId;
    }

    @Override
    public String[] updateDocumentTypeID(DocumentBO[] docArray) throws Exception {
        IDocument doc = null;
        String[] resultBDId = new String[docArray.length];
        try {
            doc = this.ctx == null ? DocumentFactory.getRemoteInstance() : DocumentFactory.getLocalInstance(this.ctx);
            for (int i = 0; i < docArray.length; ++i) {
                DocumentBO oneBO = docArray[i];
                String documentID = oneBO.getDocumentID();
                DocumentInfo docInfo = doc.getValue(FMEUtils.getObjectPK("DocumentID", documentID));
                docInfo.setTypeID(oneBO.getTypeID());
                doc.update(FMEUtils.getObjectPK("DocumentID", documentID), docInfo);
                this.insertOperLog(documentID, 3);
                resultBDId[i] = documentID;
            }
        }
        catch (BOSException bs) {
            if (log.isErrorEnabled()) {
                log.error((Object)"FMEDaoImpl \u8c03\u7528updateDocumentTypeID \u65b9\u6cd5\u629b\u51fa\u5f02\u5e38", (Throwable)bs);
            }
            throw new Exception("FMEDaoImpl \u8c03\u7528updateDocumentTypeID \u65b9\u6cd5\u629b\u51fa\u5f02\u5e38", bs);
        }
        return resultBDId;
    }

    @Override
    public String[] updateDocumentTypeIDBySameServer(DocumentBO[] docArray) throws Exception {
        IDocument doc = null;
        String[] resultBDId = new String[docArray.length];
        try {
            doc = null == this.ctx ? DocumentFactory.getRemoteInstance() : DocumentFactory.getLocalInstance(this.ctx);
            for (int i = 0; i < docArray.length; ++i) {
                DocumentBO oneBO = docArray[i];
                String documentID = oneBO.getDocumentID();
                DocumentInfo docInfo = doc.getValue(FMEUtils.getObjectPK("DocumentID", documentID));
                docInfo.setTypeID(oneBO.getTypeID());
                docInfo.setPath(oneBO.getPath());
                doc.update(FMEUtils.getObjectPK("DocumentID", documentID), docInfo);
                this.insertOperLog(documentID, 3);
                resultBDId[i] = documentID;
            }
        }
        catch (BOSException bs) {
            if (log.isErrorEnabled()) {
                log.error((Object)"FMEDaoImpl \u8c03\u7528updateDocumentTypeIDBySameServer \u65b9\u6cd5\u629b\u51fa\u5f02\u5e38", (Throwable)bs);
            }
            throw new Exception("FMEDaoImpl \u8c03\u7528updateDocumentTypeIDBySameServer \u65b9\u6cd5\u629b\u51fa\u5f02\u5e38", bs);
        }
        return resultBDId;
    }

    @Override
    public String[] updateDocumentTypeID(String oldTypeID, String newTypeID) throws Exception {
        IDocument doc = null;
        String[] resultBDId = null;
        try {
            doc = this.ctx == null ? DocumentFactory.getRemoteInstance() : DocumentFactory.getLocalInstance(this.ctx);
            String osql = MessageFormat.format(QUERY_DOCUMENT_WITH_TYPEID, oldTypeID);
            DocumentCollection coll = doc.getCollection(osql);
            resultBDId = new String[coll.size()];
            for (int i = 0; i < coll.size(); ++i) {
                DocumentInfo docInfo = coll.get(i);
                String documentID = docInfo.getDocumentID().toString();
                docInfo.setTypeID(newTypeID);
                doc.update(FMEUtils.getObjectPK("DocumentID", documentID), docInfo);
                this.insertOperLog(documentID, 3);
                resultBDId[i] = documentID;
            }
        }
        catch (BOSException bs) {
            if (log.isErrorEnabled()) {
                log.error((Object)"FMEDaoImpl updateDocumentTypeID \u65b9\u6cd5\u629b\u51fa\u5f02\u5e38", (Throwable)bs);
            }
            throw new Exception("FMEDaoImpl updateDocumentTypeID \u65b9\u6cd5\u629b\u51fa\u5f02\u5e38", bs);
        }
        return resultBDId;
    }

    @Override
    public int delete(String businessID, String documentID, int deleteType) throws Exception {
        int deleteResult = -1;
        IDocument doc = null;
        IBusiDoc busiDoc = null;
        try {
            if (businessID == null || businessID.trim().length() <= 0 || documentID == null || documentID.trim().length() <= 0) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)"FMEDAOImpl \u5220\u9664\u4f20\u5165\u53c2\u6570\u4e3a\u7a7a");
                }
                throw new Exception("FMEDAOImpl \u5220\u9664\u4f20\u5165\u53c2\u6570\u4e3anull \u6216\u8005\u7a7a businessID is:" + businessID + " documentID is:" + documentID);
            }
            if (this.ctx == null) {
                doc = DocumentFactory.getRemoteInstance();
                busiDoc = BusiDocFactory.getRemoteInstance();
            } else {
                doc = DocumentFactory.getLocalInstance(this.ctx);
                busiDoc = BusiDocFactory.getLocalInstance(this.ctx);
            }
            String queryOSQL = MessageFormat.format(QUERY_BUSIDOC_OSQL, businessID, documentID);
            if (log.isInfoEnabled()) {
                log.info((Object)("\u67e5\u8be2\u64cd\u4f5c:" + queryOSQL));
            }
            BusiDocInfo bdInfo = null;
            try {
                bdInfo = busiDoc.getValue(queryOSQL);
            }
            catch (BOSException se) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"\u83b7\u53d6\u5220\u9664\u7684\u7684\u6587\u4ef6\u4e1a\u52a1\u6570\u636e\u629b\u51fa\u5f02\u5e38", (Throwable)se);
                }
                deleteResult = -1;
                throw new Exception("\u83b7\u53d6\u5220\u9664\u7684\u7684\u6587\u4ef6\u4e1a\u52a1\u6570\u636e\u629b\u51fa\u5f02\u5e38,\u53ef\u80fd\u76f8\u5e94\u7684\u8bb0\u5f55\u4e0d\u5b58\u5728" + queryOSQL);
            }
            if (bdInfo != null) {
                IObjectPK[] deletePK = busiDoc.delete(MessageFormat.format(DELETE_BUSIDOC_OSQL, businessID, documentID));
                if (deletePK.length > 0) {
                    String queryRefDocSQL = MessageFormat.format(QUERY_DOC_REF_OSQL, documentID);
                    BusiDocCollection bdColl = busiDoc.getCollection(queryRefDocSQL);
                    if (bdColl != null && bdColl.size() > 0) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("\u6587\u4ef6ID\u4e3a:" + documentID + "\u7684\u6587\u4ef6\uff0c\u8fd8\u5b58\u5728\u88ab\u5176\u5b83\u5e94\u7528\u7cfb\u7edf\u5e94\u7528\uff0c\u4e0d\u9700\u8981\u8fdb\u884c\u5220\u9664"));
                        }
                        deleteResult = 2;
                    } else {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("\u6587\u4ef6ID\u4e3a:" + documentID + "\u7684\u6587\u4ef6,\u5df2\u7ecf\u4e0d\u5b58\u5728\u5f15\u7528\uff0c\u53ef\u4ee5\u76f4\u63a5\u5220\u9664"));
                        }
                        IObjectPK deleteDocumentPK = FMEUtils.getObjectPK("DocumentID", documentID);
                        DocumentInfo docInfo = doc.getValue(deleteDocumentPK);
                        String deleteStatus = "";
                        switch (deleteType) {
                            case 0: {
                                docInfo.setStatus("1");
                                deleteStatus = "\u7269\u7406\u5220\u9664\u72b6\u6001";
                                deleteResult = 0;
                                break;
                            }
                            case 1: {
                                docInfo.setStatus("2");
                                deleteStatus = "\u4e0d\u53ef\u7528\u72b6\u6001";
                                deleteResult = 1;
                                break;
                            }
                            default: {
                                docInfo.setStatus("2");
                                deleteStatus = "\u4e0d\u53ef\u7528\u72b6\u6001";
                                deleteResult = 1;
                            }
                        }
                        doc.update(deleteDocumentPK, docInfo);
                        this.insertOperLog(documentID, 2);
                        if (log.isInfoEnabled()) {
                            log.info((Object)("\u6587\u4ef6\u8d44\u6599\u5df2\u7ecf\u8c03\u6574\u4e3a\uff1a" + deleteStatus));
                        }
                    }
                }
            } else {
                if (log.isWarnEnabled()) {
                    log.warn((Object)("\u5220\u9664businessID =" + businessID + " documentID=" + documentID + " \u6ca1\u6709\u76f8\u5173\u7684\u8bb0\u5f55"));
                }
                deleteResult = 1;
            }
        }
        catch (BOSException bs) {
            if (log.isErrorEnabled()) {
                log.error((Object)"FMEDaoImpl \u8c03\u7528delete \u65b9\u6cd5\u629b\u51fa\u5f02\u5e38", (Throwable)bs);
            }
            deleteResult = -1;
            throw new Exception("FMEDaoImpl \u8c03\u7528delete \u65b9\u6cd5\u629b\u51fa\u5f02\u5e38", bs);
        }
        return deleteResult;
    }

    @Override
    public DocumentBO[] query(String businessID) throws Exception {
        Object doc = null;
        Object busiDoc = null;
        DocumentBO[] boArray = null;
        boArray = this.queryDocumentBO(businessID);
        return boArray;
    }

    private DocumentBO[] queryDocumentBO(String businessID) {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT ");
        sb.append("T_FME_BusiDoc.FBusinessID AS T_FME_BusiDoc_FBusinessID, ");
        sb.append("T_FME_BusiDoc.FDisplayName AS T_FME_BusiDoc_FDisplayName, ");
        sb.append("T_FME_BusiDoc.FDocumentID AS T_FME_BusiDoc_FDocumentID, ");
        sb.append("T_FME_Document.FName AS T_FME_Document_FName, ");
        sb.append("T_FME_Document.FSize AS T_FME_Document_FSize, ");
        sb.append("T_FME_Document.FPath AS T_FME_Document_FPath, ");
        sb.append("T_FME_Document.FDescription AS T_FME_Document_FDescription, ");
        sb.append("T_FME_Document.FStatus AS T_FME_Document_FStatus, ");
        sb.append("T_FME_Document.FTypeID AS T_FME_Document_FTypeID, ");
        sb.append("T_FME_Document.FServerID AS T_FME_Document_FServerID, ");
        sb.append("T_FME_OperLog.FOperDate AS T_FME_OperLog_FOperDate, ");
        sb.append("T_PM_User.FName_L2 AS T_PM_User_FName_L2 ");
        sb.append("FROM T_FME_BusiDoc T_FME_BusiDoc ");
        sb.append("RIGHT OUTER JOIN T_FME_OperLog T_FME_OperLog ON T_FME_BusiDoc.FDocumentID = T_FME_OperLog.FDocumentID ");
        sb.append("RIGHT OUTER JOIN T_FME_Document T_FME_Document ON T_FME_OperLog.FDocumentID = T_FME_Document.FDocumentID ");
        sb.append("LEFT OUTER JOIN T_PM_User T_PM_User ON T_PM_User.FID = T_FME_OperLog.FStaffID ");
        sb.append("WHERE ");
        sb.append("T_FME_OperLog.FOperType = 0 ");
        sb.append("and  T_FME_Document.FStatus = '0' ");
        sb.append("and  T_FME_BusiDoc.FBusinessID = '").append(businessID).append("' ");
        DocumentBO[] boArray = null;
        try {
            IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sb.toString());
            int count = rs.size();
            if (count > 0) {
                boArray = new DocumentBO[count];
                int i = 0;
                while (rs.next()) {
                    DocumentBO docBO = new DocumentBO();
                    docBO.setBusinessID(businessID);
                    docBO.setDisplayName(rs.getString("T_FME_BusiDoc_FDisplayName"));
                    docBO.setDocumentID(rs.getString("T_FME_BusiDoc_FDocumentID"));
                    docBO.setName(rs.getString("T_FME_Document_FName"));
                    docBO.setSize(rs.getInt("T_FME_Document_FSize"));
                    docBO.setPath(rs.getString("T_FME_Document_FPath"));
                    docBO.setDescription(rs.getString("T_FME_Document_FDescription"));
                    docBO.setStatus(rs.getString("T_FME_Document_FStatus").toCharArray()[0]);
                    docBO.setTypeID(rs.getString("T_FME_Document_FTypeID"));
                    docBO.setServerID(rs.getString("T_FME_Document_FServerID"));
                    docBO.setOperDate2Str(String.valueOf(rs.getTimestamp("T_FME_OperLog_FOperDate").getTime()));
                    docBO.setCreateDate(rs.getString("T_FME_OperLog_FOperDate").substring(0, 16));
                    docBO.setCreaterName(null == rs.getString("T_PM_User_FName_L2") ? "" : rs.getString("T_PM_User_FName_L2"));
                    boArray[i] = docBO;
                    ++i;
                }
            }
        }
        catch (BOSException e) {
            log.error((Object)e.getMessage());
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage());
        }
        return boArray;
    }

    @Override
    public String[] insertUnloadDocument(DocumentBO docBO) throws Exception {
        IDocument doc = null;
        String[] resultDocId = new String[2];
        try {
            if (log.isInfoEnabled()) {
                log.info((Object)("FMEDaoImpl \u83b7\u53d6Context :" + this.ctx));
            }
            doc = this.ctx == null ? DocumentFactory.getRemoteInstance() : DocumentFactory.getLocalInstance(this.ctx);
            DocumentInfo docInfo = null;
            DocumentBO oneBO = docBO;
            if (oneBO == null) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"\u589e\u52a0\u7684\u6587\u6863\u4fe1\u606f\u5bf9\u8c61\u4e3anull");
                }
                throw new Exception("FMEDaoImpl \u8c03\u7528\u65b9\u6cd5insert \u8f93\u5165\u5bf9\u8c61\u4e3anull");
            }
            docInfo = new DocumentInfo();
            BOSUuid documentUUID = BOSUuid.create((String)"DDD00DDD");
            docInfo.setDocumentID(documentUUID);
            docInfo.setName(oneBO.getName());
            docInfo.setSize(oneBO.getSize());
            String newPathID = oneBO.getNewPathID();
            System.out.println("\u4e0a\u4f20\u6587\u6863\u6587\u6863\u7684PathID is:" + newPathID);
            String[] pathArray = this.getSavePathServerCategoryInfo(newPathID, oneBO.getNewCategoryInfo());
            String path = pathArray[0];
            String serverID = pathArray[1];
            String categoryID = pathArray[2];
            docInfo.setPath(path);
            docInfo.setTypeID(categoryID);
            docInfo.setServerID(serverID);
            docInfo.setStatus("3");
            docInfo.setDescription(oneBO.getDescription());
            docInfo.setOperDate(FMEUtils.getCurrrentDate());
            IObjectPK pk = doc.addnew(docInfo);
            this.insertOperLog(documentUUID.toString(), 0);
            if (pk != null) {
                resultDocId[0] = documentUUID.toString();
                resultDocId[1] = path;
            }
        }
        catch (BOSException se) {
            if (log.isErrorEnabled()) {
                log.error((Object)"\u4fdd\u5b58\u672a\u4e0a\u4f20\u6587\u4ef6\u8d44\u6599\u5e93\u4fe1\u606f\u4fdd\u5b58\u5f02\u5e38", (Throwable)se);
            }
            throw new Exception("FMEDaoImpl \u6267\u884cinsertUnloadDocument\u629b\u51fa\u5f02\u5e38", se);
        }
        return resultDocId;
    }

    @Override
    public List insertUnloadDocument(DocumentBO[] docBOArray) throws Exception {
        ArrayList<String[]> insertResult = new ArrayList<String[]>();
        IDocument doc = null;
        try {
            if (log.isInfoEnabled()) {
                log.info((Object)("FMEDaoImpl \u83b7\u53d6Context :" + this.ctx));
            }
            doc = this.ctx == null ? DocumentFactory.getRemoteInstance() : DocumentFactory.getLocalInstance(this.ctx);
            int initUploadFileCount = docBOArray.length;
            if (log.isInfoEnabled()) {
                log.info((Object)("\u9884\u4e0a\u4f20\u6587\u4ef6\uff1a" + initUploadFileCount + "\u4e2a"));
            }
            String path = "";
            String serverID = "";
            String categoryID = "";
            if (initUploadFileCount > 0) {
                String newPathID = docBOArray[0].getNewPathID();
                System.out.println("\u4e0a\u4f20\u6587\u6863\u6587\u6863\u7684PathID is:" + newPathID);
                String[] realPathInfo = this.getSavePathServerCategoryInfo(newPathID, docBOArray[0].getNewCategoryInfo());
                path = realPathInfo[0];
                serverID = realPathInfo[1];
                categoryID = realPathInfo[2];
            }
            for (int i = 0; i < initUploadFileCount; ++i) {
                String[] resultDocId = new String[2];
                DocumentInfo docInfo = null;
                DocumentBO oneBO = docBOArray[i];
                if (oneBO == null) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)"\u589e\u52a0\u7684\u6587\u6863\u4fe1\u606f\u5bf9\u8c61\u4e3anull");
                    }
                    throw new Exception("FMEDaoImpl \u8c03\u7528\u65b9\u6cd5insert \u8f93\u5165\u5bf9\u8c61\u4e3anull");
                }
                docInfo = new DocumentInfo();
                BOSUuid documentUUID = BOSUuid.create((String)"DDD00DDD");
                docInfo.setDocumentID(documentUUID);
                String tempDocumentID = documentUUID.toString();
                docInfo.setName(oneBO.getName());
                docInfo.setSize(oneBO.getSize());
                docInfo.setStatus("3");
                docInfo.setDescription(oneBO.getDescription());
                docInfo.setOperDate(FMEUtils.getCurrrentDate());
                docInfo.setPath(path);
                docInfo.setTypeID(categoryID);
                docInfo.setServerID(serverID);
                if (StringUtils.isEmpty((String)oneBO.getCreaterId())) {
                    this.insertOperLog(tempDocumentID, 0);
                } else {
                    this.insertOperLog(tempDocumentID, 0, oneBO.getCreaterId());
                }
                IObjectPK pk = doc.addnew(docInfo);
                if (pk != null) {
                    resultDocId[0] = tempDocumentID;
                    resultDocId[1] = path;
                }
                insertResult.add(resultDocId);
            }
        }
        catch (BOSException se) {
            if (log.isErrorEnabled()) {
                log.error((Object)"\u4fdd\u5b58\u672a\u4e0a\u4f20\u6587\u4ef6\u8d44\u6599\u5e93\u4fe1\u606f\u4fdd\u5b58\u5f02\u5e38", (Throwable)se);
            }
            throw new Exception("FMEDaoImpl \u6267\u884cinsertUnloadDocument\u629b\u51fa\u5f02\u5e38", se);
        }
        return insertResult;
    }

    @Override
    public String[] getSavePathServerCategoryInfo(String newPathID, String newCategoryInfo) throws Exception {
        String[] retInfo = new String[3];
        StringBuffer sbRealPath = new StringBuffer();
        String serverID = "";
        String categoryID = "";
        if (FMEUIUtils.isBlankString(newPathID) || FMEUIUtils.isBlankString(newCategoryInfo)) {
            if (log.isInfoEnabled()) {
                log.info((Object)"\u65e9\u671f1.0\u7248\u672c\u7684\u8c03\u7528\u5904\u7406\uff0c\u83b7\u53d6\u7b2c\u4e00\u4e2aFTP\u914d\u7f6e\u4fe1\u606f\uff0c\u4e0d\u652f\u6301\u76f8\u5e94\u7684\u5206\u7c7b\u4fe1\u606f");
            }
            String rootFtpPath = "";
            try {
                FtpConfig fc = this.getDefaultFtpServer();
                rootFtpPath = fc.getRootPath();
                serverID = fc.getFtpid();
            }
            catch (Exception se) {
                System.out.println("\u83b7\u53d6Ftp\u6839\u8def\u5f84\u629b\u51fa\u5f02\u5e38:" + se.getMessage());
            }
            String path = FtpUtils.getDefaultSavePath(rootFtpPath, FMEUtils.getCurrentContextUser(this.ctx));
            sbRealPath.append(path);
            categoryID = BOSUuid.create((String)"DDD77DDD").toString();
        } else {
            SavePath spObj = this.querySavePathByPathID(newPathID);
            if (spObj != null) {
                serverID = spObj.getServerID();
                FtpConfig ftpConfig = this.queryFtpServerByServerID(serverID);
                String ftpRootPath = ftpConfig.getRootPath();
                sbRealPath.append(ftpRootPath).append("/");
                String pathName = spObj.getPathName();
                sbRealPath.append(pathName).append("/");
                String fileCategoryPath = "";
                if (FtpUtils.isBlankString(newCategoryInfo)) {
                    fileCategoryPath = FMEUtils.getCurrentContextUser(this.ctx);
                    categoryID = BOSUuid.create((String)"DDD77DDD").toString();
                } else {
                    String[] categoryArray = this.getFileCategoryPathByInfo(newCategoryInfo, newPathID);
                    fileCategoryPath = categoryArray[0];
                    categoryID = categoryArray[1];
                }
                sbRealPath.append(fileCategoryPath);
            } else {
                throw new Exception("\u6307\u5b9a\u7684\u8def\u5f84ID" + newPathID + "\u4e0d\u5b58\u5728\uff0c\u6216\u8005\u5904\u4e8e\u975e\u6b63\u5e38\u72b6\u6001");
            }
        }
        retInfo[0] = sbRealPath.toString();
        retInfo[1] = serverID;
        retInfo[2] = categoryID;
        return retInfo;
    }

    @Override
    public String[] getFileCategoryPathByInfo(String busiCategoryInfo, String newPathID) throws Exception {
        StringBuffer fileCategoryPath = new StringBuffer();
        String rootPathID = "";
        String lastPathID = "";
        String lastCategoryID = "";
        String newCategoryInfo = "";
        List oneCategoryMapList = this.queryCategoryMapByBusiCID(busiCategoryInfo);
        if (oneCategoryMapList.size() == 1) {
            CategoryMap oneCategory = (CategoryMap)oneCategoryMapList.get(0);
            newCategoryInfo = oneCategory.getMapName();
            if (log.isInfoEnabled()) {
                log.info((Object)("FMEApplet\u4f20\u5165\u7684 categoryInfo:" + busiCategoryInfo + "\u5bf9\u5e94\u7684\u5b58\u50a8\u8def\u5f84:" + newCategoryInfo));
            }
        } else {
            if (log.isInfoEnabled()) {
                log.info((Object)("\u76f8\u5e94\u7684\u5206\u7c7b\u5b58\u50a8\u8def\u5f84" + busiCategoryInfo + "\u4e0d\u5b58\u5728\uff0c\u91cd\u73b0\u521b\u5efa"));
            }
            newCategoryInfo = busiCategoryInfo;
        }
        String[] categoryInfoArray = newCategoryInfo.split("#\\/#\\/");
        int ciArrayCount = categoryInfoArray.length;
        List queryCMap = this.queryCategoryMap(newCategoryInfo);
        int cListSize = queryCMap.size();
        if (cListSize > 0) {
            if (log.isInfoEnabled()) {
                log.info((Object)("\u5206\u7c7b\u4fe1\u606f" + newCategoryInfo + "\u5df2\u7ecf\u5b58\u5728\uff0c\u4e0d\u9700\u8981\u5bf9\u5e94\u7684\u521b\u5efa\u65b0\u7684\u8bb0\u5f55"));
            }
            if (ciArrayCount != cListSize) {
                throw new Exception("\u83b7\u53d6\u5206\u7c7b\u8def\u5f84\u4fe1\u606f\uff0c\u4f20\u5165\u7684\u5206\u7c7b\u7684\u7ea7\u6b21" + ciArrayCount + "\uff0c\u8ddf\u6570\u636e\u5e93\u4e2d\u5b58\u5728\u7684\u8bb0\u5f55" + cListSize + "\u4e0d\u4e00\u81f4");
            }
            for (int i = 0; i < cListSize; ++i) {
                CategoryMap oneMap = (CategoryMap)queryCMap.get(i);
                String FCID = oneMap.getFCID();
                Category oneC = this.queryFileCategoryByID(FCID);
                fileCategoryPath.append(oneC.getName());
                fileCategoryPath.append("/");
                if (oneMap.getLevel() == 1) {
                    rootPathID = oneC.getPathID();
                }
                if (i + 1 != cListSize) continue;
                lastPathID = oneC.getPathID();
                lastCategoryID = oneC.getID();
            }
        } else {
            if (log.isInfoEnabled()) {
                log.info((Object)"\u4e0d\u5b58\u5728\u76f8\u5e94\u7684\u4e1a\u52a1\u5206\u7c7b\u6620\u5c04\u8bb0\u5f55\uff0c\u65b0\u589e\u76f8\u5e94\u7684\u4e1a\u52a1\u5206\u7c7b\u8bb0\u5f55");
            }
            String pcID = "";
            String pathID = "";
            if (log.isInfoEnabled()) {
                log.info((Object)("============\u8f93\u5165\u7684\u5206\u7c7b\u4fe1\u606f\uff1a" + newCategoryInfo + "\u6620\u5c04\u5230" + ciArrayCount + "\u7ea7\u8def\u5f84"));
            }
            for (int n = 0; n < ciArrayCount; ++n) {
                pathID = n == 0 ? newPathID : "";
                String oneCName = categoryInfoArray[n];
                List insertNewCategoryList = this.insertFileCategory("", oneCName, "0", pcID, pathID);
                String newFCID = (String)insertNewCategoryList.get(0);
                String newCName = (String)insertNewCategoryList.get(1);
                pcID = newFCID;
                this.insertCategoryMap(oneCName, newFCID, newCategoryInfo, n + 1);
                fileCategoryPath.append(newCName);
                fileCategoryPath.append("/");
                if (n + 1 != ciArrayCount) continue;
                lastCategoryID = newFCID;
            }
        }
        return new String[]{fileCategoryPath.toString(), lastCategoryID};
    }

    @Override
    public DocumentBO queryDocumentByDocumentID(String documentID) throws Exception {
        IDocument doc = null;
        DocumentBO docBO = null;
        try {
            doc = this.ctx == null ? DocumentFactory.getRemoteInstance() : DocumentFactory.getLocalInstance(this.ctx);
            docBO = new DocumentBO();
            String queryDocumentOSQL = "";
            if (!FMEUtils.isBlankString(documentID)) {
                docBO.setDocumentID(documentID);
                queryDocumentOSQL = MessageFormat.format(QUERY_DOCUMENT_OSQL, " DocumentID='" + documentID + "'");
                DocumentInfo docInfo = doc.getValue(queryDocumentOSQL);
                docBO.setName(docInfo.getName());
                docBO.setBusinessID("");
                docBO.setDisplayName(docInfo.getName());
                docBO.setSize(docInfo.getSize());
                docBO.setPath(docInfo.getPath());
                docBO.setDescription(docInfo.getDescription());
                docBO.setStatus(docInfo.getStatus().toCharArray()[0]);
                String categoryID = docInfo.getTypeID().toString();
                docBO.setTypeID(categoryID);
                docBO.setServerID(docInfo.getServerID().toString());
            } else if (log.isWarnEnabled()) {
                log.warn((Object)("\u67e5\u8be2\u6307\u5b9a\u6761\u4ef6\u7684\u6587\u6863\u5e94\u7528\u8bb0\u5f55\u4e0d\u5b58\u5728:" + queryDocumentOSQL));
            }
        }
        catch (BOSException bs) {
            if (log.isErrorEnabled()) {
                log.error((Object)"FMEDaoImpl \u8c03\u7528query \u65b9\u6cd5\u629b\u51fa\u5f02\u5e38", (Throwable)bs);
            }
            throw new Exception("FMEDaoImpl \u8c03\u7528query \u65b9\u6cd5\u629b\u51fa\u5f02\u5e38", bs);
        }
        return docBO;
    }

    @Override
    public DocumentBO query(String businessID, String documentID) throws Exception {
        IDocument doc = null;
        IBusiDoc busiDoc = null;
        DocumentBO docBO = null;
        try {
            if (this.ctx == null) {
                doc = DocumentFactory.getRemoteInstance();
                busiDoc = BusiDocFactory.getRemoteInstance();
            } else {
                doc = DocumentFactory.getLocalInstance(this.ctx);
                busiDoc = BusiDocFactory.getLocalInstance(this.ctx);
            }
            docBO = new DocumentBO();
            if (!FMEUtils.isBlankString(businessID) && !FMEUtils.isBlankString(documentID)) {
                String querOSQL = MessageFormat.format(QUERY_BUSINESS_AND_DOC_OSQL, businessID, documentID);
                BusiDocInfo bdInfo = busiDoc.getValue(querOSQL);
                if (bdInfo != null) {
                    docBO.setBusinessID(businessID);
                    docBO.setDisplayName(bdInfo.getDisplayName());
                    docBO.setDocumentID(documentID);
                    String queryDocumentOSQL = MessageFormat.format(QUERY_DOCUMENT_OSQL, " DocumentID='" + documentID + "'");
                    DocumentInfo docInfo = doc.getValue(queryDocumentOSQL);
                    docBO.setName(docInfo.getName());
                    docBO.setSize(docInfo.getSize());
                    docBO.setPath(docInfo.getPath());
                    docBO.setDescription(docInfo.getDescription());
                    docBO.setStatus(docInfo.getStatus().toCharArray()[0]);
                    String categoryID = docInfo.getTypeID().toString();
                    docBO.setTypeID(categoryID);
                    docBO.setServerID(docInfo.getServerID().toString());
                } else if (log.isWarnEnabled()) {
                    log.warn((Object)("\u67e5\u8be2\u6307\u5b9a\u6761\u4ef6\u7684\u6587\u6863\u5e94\u7528\u8bb0\u5f55\u4e0d\u5b58\u5728:" + querOSQL));
                }
            } else if (log.isWarnEnabled()) {
                log.warn((Object)("\u67e5\u8be2\u4e1a\u52a1ID\u4e3a:" + businessID + " \u6216\u8005\u6587\u6863ID:" + documentID + " \u4e3a\u7a7a"));
            }
        }
        catch (BOSException bs) {
            if (log.isErrorEnabled()) {
                log.error((Object)"FMEDaoImpl \u8c03\u7528query \u65b9\u6cd5\u629b\u51fa\u5f02\u5e38", (Throwable)bs);
            }
            throw new Exception("FMEDaoImpl \u8c03\u7528query \u65b9\u6cd5\u629b\u51fa\u5f02\u5e38", bs);
        }
        return docBO;
    }

    @Override
    public String[] insertBusiDoc(String businessID, String[] documentIDArray, String[] displayName) throws Exception {
        IBusiDoc busiDoc = null;
        Object docBO = null;
        String[] retBDID = null;
        try {
            busiDoc = this.ctx == null ? BusiDocFactory.getRemoteInstance() : BusiDocFactory.getLocalInstance(this.ctx);
            int busidocCount = documentIDArray.length;
            retBDID = new String[busidocCount];
            BusiDocInfo bdInfo = null;
            System.out.println("\u9700\u8981\u589e\u52a0\u7684\u6587\u4ef6\u5e94\u7528\u8bb0\u5f55\u4e3a:" + busidocCount);
            for (int i = 0; i < busidocCount; ++i) {
                bdInfo = new BusiDocInfo();
                BOSUuid busiDocUUID = BOSUuid.create((String)"DDD44DDD");
                bdInfo.setID(busiDocUUID);
                bdInfo.setDocumentID(documentIDArray[i]);
                bdInfo.setBusinessID(businessID);
                bdInfo.setDisplayName(displayName[i]);
                retBDID[i] = busiDocUUID.toString();
                IObjectPK onePK = busiDoc.addnew(bdInfo);
                if (onePK != null) continue;
                if (log.isErrorEnabled()) {
                    log.error((Object)("FMEDao Imple insertBusiDoc \u4fdd\u5b58\u5e94\u7528\u8bb0\u5f55\u629b\u51fa\u5f02\u5e38" + onePK));
                }
                break;
            }
        }
        catch (BOSException bs) {
            if (log.isErrorEnabled()) {
                log.error((Object)"FMEDaoImpl \u8c03\u7528insertBusiDoc \u65b9\u6cd5\u629b\u51fa\u5f02\u5e38", (Throwable)bs);
            }
            throw new Exception("FMEDaoImpl \u8c03\u7528insertBusiDoc \u65b9\u6cd5\u629b\u51fa\u5f02\u5e38", bs);
        }
        return retBDID;
    }

    @Override
    public FtpConfig getDefaultFtpServer() throws Exception {
        IFtpServer ftpServer = null;
        FtpConfig ftpConfig = new FtpConfig();
        try {
            ftpServer = this.ctx == null ? FtpServerFactory.getRemoteInstance() : FtpServerFactory.getLocalInstance(this.ctx);
            FtpServerCollection ftc = ftpServer.getCollection();
            int ftcSize = ftc.size();
            if (ftcSize == 1) {
                FtpServerInfo fsInfo = ftc.get(0);
                ftpConfig.setFtpid(fsInfo.getServerID().toString());
                ftpConfig.setFtpname(fsInfo.getServerName());
                ftpConfig.setHost(fsInfo.getServerHost());
                ftpConfig.setUsername(fsInfo.getServerUser());
                ftpConfig.setPassword(fsInfo.getServerPswd());
                ftpConfig.setStatus("" + fsInfo.getServerStatus());
                ftpConfig.setRootPath(fsInfo.getRootPath());
                ftpConfig.setPort(fsInfo.getServerPort());
                ftpConfig.setAccessaddress(fsInfo.getAccessAddress());
                ftpConfig.setInternetIP(fsInfo.getInternetIP());
            } else if (ftc.size() > 1) {
                boolean hasDefault = false;
                for (int i = 0; i < ftcSize; ++i) {
                    FtpServerInfo fsInfo = ftc.get(i);
                    if (fsInfo.getIsDefault() != 1) continue;
                    ftpConfig.setFtpid(fsInfo.getServerID().toString());
                    ftpConfig.setFtpname(fsInfo.getServerName());
                    ftpConfig.setHost(fsInfo.getServerHost());
                    ftpConfig.setUsername(fsInfo.getServerUser());
                    ftpConfig.setPassword(fsInfo.getServerPswd());
                    ftpConfig.setStatus("" + fsInfo.getServerStatus());
                    ftpConfig.setRootPath(fsInfo.getRootPath());
                    ftpConfig.setPort(fsInfo.getServerPort());
                    ftpConfig.setAccessaddress(fsInfo.getAccessAddress());
                    ftpConfig.setInternetIP(fsInfo.getInternetIP());
                    hasDefault = true;
                    break;
                }
                if (!hasDefault) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)"\u6ca1\u6709\u7f3a\u7701\u7684Ftp\u670d\u52a1\u5668\uff0c\u76f4\u63a5\u83b7\u53d6\u7b2c\u4e00\u4e2a");
                    }
                    FtpServerInfo fsInfo = ftc.get(0);
                    ftpConfig.setFtpid(fsInfo.getServerID().toString());
                    ftpConfig.setFtpname(fsInfo.getServerName());
                    ftpConfig.setHost(fsInfo.getServerHost());
                    ftpConfig.setUsername(fsInfo.getServerUser());
                    ftpConfig.setPassword(fsInfo.getServerPswd());
                    ftpConfig.setStatus("" + fsInfo.getServerStatus());
                    ftpConfig.setRootPath(fsInfo.getRootPath());
                    ftpConfig.setPort(fsInfo.getServerPort());
                    ftpConfig.setAccessaddress(fsInfo.getAccessAddress());
                    ftpConfig.setInternetIP(fsInfo.getInternetIP());
                }
            } else if (log.isErrorEnabled()) {
                log.error((Object)"\u6ca1\u6709\u914d\u7f6eFtp\u4fe1\u606f\uff0c\u8bf7\u5728\u7ba1\u7406\u63a7\u5236\u53f0\uff0c\u6267\u884c\u76f8\u5e94\u7684Ftp\u914d\u7f6e");
            }
        }
        catch (BOSException bs) {
            if (log.isErrorEnabled()) {
                log.error((Object)"FMEDaoImpl \u8c03\u7528getDefaultFtpServer \u65b9\u6cd5\u629b\u51fa\u5f02\u5e38", (Throwable)bs);
            }
            throw new Exception("FMEDaoImpl \u8c03\u7528getDefaultFtpServer \u65b9\u6cd5\u629b\u51fa\u5f02\u5e38", bs);
        }
        return ftpConfig;
    }

    @Override
    public String insertFtpServer(FtpConfig ftpConfig) throws Exception {
        IFtpServer ftpServer = null;
        String ftpServerID = "";
        try {
            ftpServer = this.ctx == null ? FtpServerFactory.getRemoteInstance() : FtpServerFactory.getLocalInstance(this.ctx);
            FtpConfig queryFtpConfig = this.queryFtpServer(ftpConfig.getFtpname());
            FtpServerInfo fsInfo = new FtpServerInfo();
            if (queryFtpConfig == null) {
                System.out.println("\u4e0d\u5b58\u5728\u76f8\u540c\u540d\u79f0\u7684\u8bb0\u5f55\uff0c\u76f4\u63a5\u63d2\u5165");
                BOSUuid ftpServerUUID = BOSUuid.create((String)"DDD22DDD");
                String serverID = ftpConfig.getFtpid();
                if (FMEUtils.isBlankString(serverID)) {
                    fsInfo.setServerID(ftpServerUUID.toString());
                } else {
                    fsInfo.setServerID(serverID);
                }
                fsInfo.setServerName(ftpConfig.getFtpname());
                fsInfo.setServerPort(ftpConfig.getPort());
                fsInfo.setServerHost(ftpConfig.getHost());
                fsInfo.setServerUser(ftpConfig.getUsername());
                fsInfo.setServerPswd(ftpConfig.getPassword());
                fsInfo.setRootPath(ftpConfig.getRootPath());
                fsInfo.setServerStatus(ftpConfig.getStatus());
                fsInfo.setIsDefault((short)ftpConfig.getIsDefault());
                fsInfo.setAccessAddress(ftpConfig.getAccessaddress());
                fsInfo.setInternetIP(ftpConfig.getInternetIP());
                IObjectPK onePK = ftpServer.addnew(fsInfo);
                if (onePK != null) {
                    ftpServerID = onePK.toString();
                }
            } else {
                System.out.println("\u5b58\u5728\u76f8\u540c\u540d\u79f0\u7684\u8bb0\u5f55\uff0c\u76f4\u63a5\u4fee\u6539");
                ftpConfig.setFtpid(queryFtpConfig.getFtpid());
                ftpServerID = this.updateFtpServer(ftpConfig);
            }
        }
        catch (BOSException bs) {
            if (log.isErrorEnabled()) {
                log.error((Object)"FMEDaoImpl \u8c03\u7528insertFtpServer \u65b9\u6cd5\u629b\u51fa\u5f02\u5e38", (Throwable)bs);
            }
            throw new Exception("FMEDaoImpl \u8c03\u7528insertFtpServer \u65b9\u6cd5\u629b\u51fa\u5f02\u5e38", bs);
        }
        return ftpServerID;
    }

    @Override
    public String updateFtpServer(FtpConfig ftpConfig) throws Exception {
        IFtpServer ftpServer = null;
        String updateID = "";
        String ftpName = ftpConfig.getFtpname();
        try {
            ftpServer = this.ctx == null ? FtpServerFactory.getRemoteInstance() : FtpServerFactory.getLocalInstance(this.ctx);
            String queryOSQL = MessageFormat.format(QUERY_FTPSERVER_BYNAME, ftpName);
            FtpServerInfo fsInfo = ftpServer.getValue(queryOSQL);
            if (fsInfo != null) {
                fsInfo.setServerName(ftpConfig.getFtpname());
                fsInfo.setServerPort(ftpConfig.getPort());
                fsInfo.setServerHost(ftpConfig.getHost());
                fsInfo.setServerUser(ftpConfig.getUsername());
                fsInfo.setServerPswd(ftpConfig.getPassword());
                fsInfo.setRootPath(ftpConfig.getRootPath());
                fsInfo.setIsDefault((short)ftpConfig.getIsDefault());
                fsInfo.setAccessAddress(ftpConfig.getAccessaddress());
                fsInfo.setInternetIP(ftpConfig.getInternetIP());
            } else if (log.isErrorEnabled()) {
                log.error((Object)("\u67e5\u8be2\u6587\u4ef6\u670d\u52a1\u5668\u914d\u7f6e\u629b\u51fa\u5f02\u5e38:" + queryOSQL));
            }
            IObjectPK onePK = FMEUtils.getObjectPK("ServerID", fsInfo.getServerID().toString());
            ftpServer.update(onePK, fsInfo);
            updateID = onePK.toString();
        }
        catch (BOSException bs) {
            if (log.isErrorEnabled()) {
                log.error((Object)"FMEDaoImpl \u8c03\u7528updateFtpServer \u65b9\u6cd5\u629b\u51fa\u5f02\u5e38", (Throwable)bs);
            }
            throw new Exception("FMEDaoImpl \u8c03\u7528updateFtpServer \u65b9\u6cd5\u629b\u51fa\u5f02\u5e38", bs);
        }
        return updateID;
    }

    public FtpConfig queryFtpServerBySql(String osql) throws Exception {
        FtpConfig ftpConfig;
        block5: {
            IFtpServer ftpServer = null;
            ftpConfig = null;
            try {
                ftpServer = this.ctx == null ? FtpServerFactory.getRemoteInstance() : FtpServerFactory.getLocalInstance(this.ctx);
                FtpServerInfo fsInfo = ftpServer.getValue(osql);
                if (fsInfo != null) {
                    ftpConfig = new FtpConfig();
                    ftpConfig.setFtpid(fsInfo.getServerID().toString());
                    ftpConfig.setFtpname(fsInfo.getServerName());
                    ftpConfig.setHost(fsInfo.getServerHost());
                    ftpConfig.setUsername(fsInfo.getServerUser());
                    ftpConfig.setPassword(fsInfo.getServerPswd());
                    ftpConfig.setStatus("" + fsInfo.getServerStatus());
                    ftpConfig.setRootPath(fsInfo.getRootPath());
                    ftpConfig.setPort(fsInfo.getServerPort());
                    ftpConfig.setIsDefault(fsInfo.getIsDefault());
                    ftpConfig.setAccessaddress(fsInfo.getAccessAddress());
                    ftpConfig.setInternetIP(fsInfo.getInternetIP());
                } else if (log.isErrorEnabled()) {
                    log.error((Object)("\u67e5\u8be2\u6587\u4ef6\u670d\u52a1\u5668\u914d\u7f6e\u629b\u51fa\u5f02\u5e38:" + osql));
                }
            }
            catch (BOSException bs) {
                if (!log.isErrorEnabled()) break block5;
                log.error((Object)"FMEDaoImpl \u8c03\u7528queryFtpServer \u65b9\u6cd5\u629b\u51fa\u5f02\u5e38", (Throwable)bs);
            }
        }
        return ftpConfig;
    }

    private IFtpServer getFtpServer() throws BOSException {
        if (this.ftpServer == null) {
            this.ftpServer = this.ctx == null ? FtpServerFactory.getRemoteInstance() : FtpServerFactory.getLocalInstance(this.ctx);
        }
        return this.ftpServer;
    }

    @Override
    public List queryFtpServer() throws Exception {
        ArrayList<FtpServer> ftpServerList;
        block3: {
            ftpServerList = new ArrayList<FtpServer>();
            try {
                IFtpServer ftpserver = this.getFtpServer();
                FtpServerCollection coll = ftpserver.getCollection(QUERY_FTPSERVER_NORMAL);
                Iterator iter = coll.iterator();
                while (iter.hasNext()) {
                    FtpServerInfo oneInfo = (FtpServerInfo)iter.next();
                    FtpServer oneFS = new FtpServer();
                    oneFS.setServerID(oneInfo.getServerID());
                    oneFS.setServerName(oneInfo.getServerName());
                    oneFS.setServerHost(oneInfo.getServerHost());
                    oneFS.setServerPort(oneInfo.getServerPort());
                    oneFS.setRootPath(oneInfo.getRootPath());
                    oneFS.setServerStatus(oneInfo.getServerStatus());
                    oneFS.setIsDefault(oneInfo.getIsDefault());
                    oneFS.setAccessaddress(oneInfo.getAccessAddress());
                    oneFS.setInternetIP(oneInfo.getInternetIP());
                    ftpServerList.add(oneFS);
                }
            }
            catch (Exception se) {
                if (!log.isErrorEnabled()) break block3;
                log.error((Object)("FMEDaoImpl \u67e5\u8be2QueryFtpServer \u629b\u51fa\u5f02\u5e38:" + se.getMessage()), (Throwable)se);
            }
        }
        return ftpServerList;
    }

    @Override
    public FtpConfig queryFtpServer(String ftpName) throws Exception {
        if (FtpUtils.isBlankString(ftpName)) {
            throw new Exception("\u8f93\u5165FtpName\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u67e5\u627e\u76f8\u5e94\u7684\u914d\u7f6e\u4fe1\u606f");
        }
        String queryOSQL = MessageFormat.format(QUERY_FTPSERVER_BYNAME, ftpName);
        return this.queryFtpServerBySql(queryOSQL);
    }

    @Override
    public FtpConfig queryFtpServerByServerID(String serverID) throws Exception {
        if (FtpUtils.isBlankString(serverID)) {
            throw new Exception("\u8f93\u5165serverID\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u67e5\u627e\u76f8\u5e94\u7684\u914d\u7f6e\u4fe1\u606f");
        }
        String queryOSQL = MessageFormat.format(QUERY_FTPSERVER_BYID, serverID);
        if (log.isInfoEnabled()) {
            log.info((Object)("queryFtpServerByServerID================= osql is:" + queryOSQL));
        }
        return this.queryFtpServerBySql(queryOSQL);
    }

    @Override
    public boolean deleteFtpServer(String ftpName) throws Exception {
        IFtpServer ftpServer = null;
        boolean deleteResult = false;
        if (ftpName == null || ftpName.trim().length() <= 0) {
            System.out.println("\u8f93\u5165FtpName\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5220\u9664\u76f8\u5e94\u7684\u914d\u7f6e\u4fe1\u606f");
            return deleteResult;
        }
        try {
            ftpServer = this.ctx == null ? FtpServerFactory.getRemoteInstance() : FtpServerFactory.getLocalInstance(this.ctx);
            String queryOSQL = MessageFormat.format(QUERY_FTPSERVER_BYNAME, ftpName);
            FtpServerInfo fsInfo = ftpServer.getValue(queryOSQL);
            if (fsInfo != null) {
                IObjectPK onePK = FMEUtils.getObjectPK("ServerID", fsInfo.getServerID().toString());
                ftpServer.delete(onePK);
                deleteResult = true;
            } else if (log.isErrorEnabled()) {
                log.error((Object)("\u67e5\u8be2\u6587\u4ef6\u670d\u52a1\u5668\u914d\u7f6e\u629b\u51fa\u5f02\u5e38:" + queryOSQL));
            }
        }
        catch (BOSException bs) {
            if (log.isErrorEnabled()) {
                log.error((Object)"FMEDaoImpl \u8c03\u7528deleteFtpServer \u65b9\u6cd5\u629b\u51fa\u5f02\u5e38", (Throwable)bs);
            }
            throw new Exception("FMEDaoImpl \u8c03\u7528deleteFtpServer \u65b9\u6cd5\u629b\u51fa\u5f02\u5e38", bs);
        }
        return deleteResult;
    }

    private ISavePath getSavePath() throws BOSException {
        if (this.savePath == null) {
            this.savePath = this.ctx == null ? SavePathFactory.getRemoteInstance() : SavePathFactory.getLocalInstance(this.ctx);
        }
        return this.savePath;
    }

    private IDocumentIcon getDocumentIcon() throws BOSException {
        if (this.documentIcon == null) {
            this.documentIcon = this.ctx == null ? DocumentIconFactory.getRemoteInstance() : DocumentIconFactory.getLocalInstance(this.ctx);
        }
        return this.documentIcon;
    }

    @Override
    public String[] insertSavePath(String pathDisplayName, String serverID, String status, int saveType) throws Exception {
        return this.insertSavePath(pathDisplayName, serverID, null, status, saveType);
    }

    @Override
    public String[] insertSavePath(String pathDisplayName, String serverID, String pathName, String status, int saveType) throws Exception {
        String[] retArray = new String[2];
        String insertPathID = null;
        if (FtpUtils.isBlankString(pathDisplayName)) {
            throw new Exception("\u6dfb\u52a0\u7684\u4fdd\u5b58\u8def\u5f84\u4e3a\u7a7a");
        }
        try {
            ISavePath savePathObj = this.getSavePath();
            SavePathInfo spInfo = new SavePathInfo();
            BOSUuid pathUUID = BOSUuid.create((String)"DDD55DDD");
            spInfo.setPathID(pathUUID);
            if (FMEUtils.isBlankString(pathName)) {
                pathName = FMEUtils.getRandomPathName(pathUUID.toString());
                if (log.isInfoEnabled()) {
                    log.info((Object)("\u589e\u52a0\u5b58\u50a8\u8def\u5f84\uff0c\u6ca1\u6709\u8bbe\u7f6e\u76f8\u5e94\u7684\u5b58\u50a8\u8def\u5f84\u5b9e\u9645\u8def\u5f84\uff0c\u5185\u90e8\u81ea\u52a8\u751f\u6210" + pathName));
                }
            }
            spInfo.setPathName(pathName);
            spInfo.setDisplayName(pathDisplayName);
            spInfo.setSaveType(saveType);
            spInfo.setServerID(serverID);
            spInfo.setPathStatus(status);
            IObjectPK pk = savePathObj.addnew(spInfo);
            if (pk != null) {
                insertPathID = pathUUID.toString();
            }
        }
        catch (BOSException bs) {
            if (log.isErrorEnabled()) {
                log.error((Object)"FMEDaoImpl \u8c03\u7528 insertSavePath \u65b9\u6cd5\u629b\u51fa\u5f02\u5e38", (Throwable)bs);
            }
            throw new Exception("FMEDaoImpl \u8c03\u7528 insertSavePath \u65b9\u6cd5\u629b\u51fa\u5f02\u5e38", bs);
        }
        retArray[0] = insertPathID;
        retArray[1] = pathName;
        return retArray;
    }

    @Override
    public boolean updateSavePath(String pathID, String pathDisplayName, String serverID, String pathName, String status, int saveType) throws Exception {
        boolean updateResult = false;
        if (FtpUtils.isBlankString(pathDisplayName)) {
            throw new Exception("\u4fee\u6539\u4fdd\u5b58\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            ISavePath savePathObj = this.getSavePath();
            IObjectPK onePK = FMEUtils.getObjectPK("PathID", pathID);
            SavePathInfo spInfo = savePathObj.getValue(onePK);
            if (spInfo != null) {
                spInfo.setDisplayName(pathDisplayName);
                if (!FtpUtils.isBlankString(serverID)) {
                    spInfo.setServerID(serverID);
                } else if (log.isWarnEnabled()) {
                    log.warn((Object)"\u66f4\u65b0\u6587\u6863\u5b58\u50a8\u8def\u5f84\uff0c\u5bf9\u5e94\u7684ServerID\u4e3a\u7a7a");
                }
                if (!FtpUtils.isBlankString(pathName)) {
                    spInfo.setPathName(pathName);
                } else if (log.isWarnEnabled()) {
                    log.warn((Object)"\u66f4\u65b0\u6587\u6863\u5b58\u50a8\u8def\u5f84\uff0c\u5bf9\u5e94\u7684pathName\u4e3a\u7a7a");
                }
                if (!FtpUtils.isBlankString(status)) {
                    spInfo.setPathStatus(status);
                } else if (log.isWarnEnabled()) {
                    log.warn((Object)"\u66f4\u65b0\u6587\u6863\u5b58\u50a8\u8def\u5f84\uff0c\u5bf9\u5e94\u7684status\u4e3a\u7a7a");
                }
                if (saveType >= 0 && saveType <= 5) {
                    spInfo.setSaveType(saveType);
                } else if (log.isWarnEnabled()) {
                    log.warn((Object)"\u66f4\u65b0\u6587\u6863\u5b58\u50a8\u8def\u5f84\uff0c\u5bf9\u5e94\u7684saveType\u4e3a\u672a\u77e5\u7c7b\u578b");
                }
            } else if (log.isErrorEnabled()) {
                log.error((Object)("\u4fee\u6539\u4fdd\u5b58\u5b58\u50a8\u8def\u5f84\u629b\u51fa\u5bf9\u8c61\u4e3a\u7a7a\uff0c\u4e0d\u5b58\u5728\u76f8\u5e94PathID\u7684\u8bb0\u5f55:" + pathID));
            }
            savePathObj.update(onePK, spInfo);
            updateResult = true;
        }
        catch (BOSException bs) {
            if (log.isErrorEnabled()) {
                log.error((Object)"FMEDaoImpl \u8c03\u7528 updateSavePath \u65b9\u6cd5\u629b\u51fa\u5f02\u5e38", (Throwable)bs);
            }
            throw new Exception("FMEDaoImpl \u8c03\u7528 updateSavePath \u65b9\u6cd5\u629b\u51fa\u5f02\u5e38", bs);
        }
        return updateResult;
    }

    @Override
    public boolean updateSavePath(String pathID, String pathDisplayName, String serverID, String status, int saveType) throws Exception {
        return this.updateSavePath(pathID, pathDisplayName, serverID, null, status, saveType);
    }

    @Override
    public String deleteSavePath(String pathID) throws Exception {
        String delPathID = null;
        if (FtpUtils.isBlankString(pathID)) {
            throw new Exception("\u5220\u9664\u4fdd\u5b58\u8def\u5f84\u5bf9\u5e94\u7684PathID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            ISavePath savePathObj = this.getSavePath();
            IObjectPK onePK = FMEUtils.getObjectPK("PathID", pathID);
            savePathObj.delete(onePK);
            delPathID = onePK.toString();
        }
        catch (BOSException bs) {
            if (log.isErrorEnabled()) {
                log.error((Object)"FMEDaoImpl \u8c03\u7528 deleteSavePath \u65b9\u6cd5\u629b\u51fa\u5f02\u5e38", (Throwable)bs);
            }
            throw new Exception("FMEDaoImpl \u8c03\u7528 deleteSavePath \u65b9\u6cd5\u629b\u51fa\u5f02\u5e38", bs);
        }
        return delPathID;
    }

    @Override
    public List querySavePath() throws Exception {
        ArrayList<SavePath> querySavePath = new ArrayList<SavePath>();
        try {
            List ftpServer = this.queryFtpServer();
            HashMap<String, String> ftpMap = new HashMap<String, String>();
            for (int i = 0; i < ftpServer.size(); ++i) {
                FtpServer oneFS = (FtpServer)ftpServer.get(i);
                if (ftpMap.containsKey(oneFS.getServerID())) continue;
                ftpMap.put(oneFS.getServerID(), oneFS.getServerName());
            }
            ISavePath savePathObj = this.getSavePath();
            SavePathCollection coll = savePathObj.getCollection(SAVEPATH_SQL_QUERY);
            Iterator iter = coll.iterator();
            while (iter.hasNext()) {
                SavePathInfo onespInfo = (SavePathInfo)iter.next();
                SavePath sp = new SavePath();
                sp.setPathID(onespInfo.getPathID().toString());
                sp.setPathName(onespInfo.getPathName());
                sp.setPathDisplayName(onespInfo.getDisplayName());
                sp.setServerID(onespInfo.getServerID());
                sp.setServerName((String)ftpMap.get(onespInfo.getServerID()));
                sp.setStatus(onespInfo.getPathStatus());
                sp.setSaveType(onespInfo.getSaveType());
                querySavePath.add(sp);
            }
        }
        catch (BOSException bs) {
            if (log.isErrorEnabled()) {
                log.error((Object)"FMEDaoImpl \u8c03\u7528 deleteSavePath \u65b9\u6cd5\u629b\u51fa\u5f02\u5e38", (Throwable)bs);
            }
            throw new Exception("FMEDaoImpl \u8c03\u7528 deleteSavePath \u65b9\u6cd5\u629b\u51fa\u5f02\u5e38", bs);
        }
        return querySavePath;
    }

    @Override
    public SavePath querySavePathByPathID(String pathID) throws Exception {
        SavePath sp = new SavePath();
        try {
            ISavePath savePathObj = this.getSavePath();
            if (pathID != null) {
                pathID = pathID.replaceAll(" ", "+");
            }
            String osql = MessageFormat.format(SAVEPATH_SQL_QUERY_WITH_PATHID, pathID);
            if (log.isInfoEnabled()) {
                log.info((Object)("\u67e5\u8be2SavePath OSQL is:" + osql));
            }
            SavePathInfo onespInfo = savePathObj.getValue(osql);
            sp.setPathID(onespInfo.getPathID().toString());
            sp.setPathName(onespInfo.getPathName());
            sp.setPathDisplayName(onespInfo.getDisplayName());
            sp.setServerID(onespInfo.getServerID());
            sp.setStatus(onespInfo.getPathStatus());
            sp.setSaveType(onespInfo.getSaveType());
        }
        catch (BOSException bs) {
            if (log.isErrorEnabled()) {
                log.error((Object)("FMEDaoImpl \u8c03\u7528 querySavePathByPathID \u65b9\u6cd5\u629b\u51fa\u5f02\u5e38" + bs.getMessage()), (Throwable)bs);
            }
            throw new Exception("FMEDaoImpl \u8c03\u7528 querySavePathByPathID \u65b9\u6cd5\u629b\u51fa\u5f02\u5e38" + bs.getMessage(), bs);
        }
        return sp;
    }

    @Override
    public boolean existSavePathNameRecord(String pathID, String pathName, String serverID) throws Exception {
        boolean existSameRecord = false;
        try {
            ISavePath savePathObj = this.getSavePath();
            String osql = MessageFormat.format(SAVEPATH_SQL_QUERY_WITH_PATHID_SERVERID, pathName, serverID);
            if (log.isInfoEnabled()) {
                log.info((Object)("\u67e5\u8be2SavePath OSQL is:" + osql));
            }
            SavePathCollection coll = savePathObj.getCollection(osql);
            Iterator iter = coll.iterator();
            while (iter.hasNext()) {
                SavePathInfo onesp = (SavePathInfo)iter.next();
                String pathIDValue = onesp.getPathID().toString();
                if (pathID.equals(pathIDValue)) continue;
                existSameRecord = true;
                if (log.isInfoEnabled()) {
                    log.info((Object)("\u5b58\u5728\u5177\u6709\u8ddfpathID" + pathID + "\u76f8\u540cpathName,serverID\u7684\u5b58\u50a8\u8def\u5f84:" + pathIDValue));
                }
                break;
            }
        }
        catch (BOSException bs) {
            if (log.isErrorEnabled()) {
                log.error((Object)("FMEDaoImpl \u8c03\u7528 existSavePathNameRecord \u65b9\u6cd5\u629b\u51fa\u5f02\u5e38" + bs.getMessage()), (Throwable)bs);
            }
            throw new Exception("FMEDaoImpl \u8c03\u7528 existSavePathNameRecord \u65b9\u6cd5\u629b\u51fa\u5f02\u5e38" + bs.getMessage(), bs);
        }
        return existSameRecord;
    }

    private IFileCategory getFileCategory() throws BOSException {
        if (this.category == null) {
            this.category = this.ctx == null ? FileCategoryFactory.getRemoteInstance() : FileCategoryFactory.getLocalInstance(this.ctx);
        }
        return this.category;
    }

    @Override
    public List insertFileCategory(String categoryName, String categoryDesc, String status, String pcID, String pathID) throws Exception {
        ArrayList<String> insertResult = new ArrayList<String>();
        String insertCategoryID = null;
        if (FtpUtils.isBlankString(categoryDesc)) {
            throw new Exception("\u6dfb\u52a0\u7684\u5206\u7c7b\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            IFileCategory categoryObj = this.getFileCategory();
            FileCategoryInfo categoryInfo = new FileCategoryInfo();
            BOSUuid categoryUUID = BOSUuid.create((String)"DDD66DDD");
            categoryInfo.setID(categoryUUID);
            categoryInfo.setPID(pcID);
            if (FMEUtils.isBlankString(categoryName)) {
                categoryName = FMEUtils.getRandomPathName(categoryUUID.toString());
                categoryInfo.setName(categoryName);
            } else {
                categoryInfo.setName(categoryName);
            }
            categoryInfo.setDesc(categoryDesc);
            categoryInfo.setStatus(status);
            categoryInfo.setPathID(pathID);
            IObjectPK pk = categoryObj.addnew(categoryInfo);
            if (pk != null) {
                insertCategoryID = categoryUUID.toString();
            }
        }
        catch (BOSException bs) {
            if (log.isErrorEnabled()) {
                log.error((Object)"FMEDaoImpl \u8c03\u7528 insertFileCategory \u65b9\u6cd5\u629b\u51fa\u5f02\u5e38", (Throwable)bs);
            }
            throw new Exception("FMEDaoImpl \u8c03\u7528 insertFileCategory \u65b9\u6cd5\u629b\u51fa\u5f02\u5e38", bs);
        }
        insertResult.add(insertCategoryID);
        insertResult.add(categoryName);
        return insertResult;
    }

    @Override
    public String updateFileCategory(String cID, String cName, String cDesc, String status, String pcID, String pathID) throws Exception {
        String updateCID = null;
        if (FtpUtils.isBlankString(cDesc)) {
            throw new Exception("\u4fee\u6539\u6587\u4ef6\u5206\u7c7b\u63cf\u8ff0" + cDesc + "\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            IFileCategory categoryObj = this.getFileCategory();
            IObjectPK onePK = FMEUtils.getObjectPK("ID", cID);
            FileCategoryInfo fcInfo = categoryObj.getValue(onePK);
            if (fcInfo != null) {
                if (!FtpUtils.isBlankString(cName)) {
                    fcInfo.setName(cName);
                }
                fcInfo.setDesc(cDesc);
                if (!FtpUtils.isBlankString(status)) {
                    fcInfo.setStatus(status);
                } else if (log.isWarnEnabled()) {
                    log.warn((Object)"\u66f4\u65b0\u6587\u6863\u5206\u7c7b\uff0c\u5bf9\u5e94\u7684status\u4e3a\u7a7a");
                }
                fcInfo.setPID(pcID);
                if (!FtpUtils.isBlankString(pathID)) {
                    fcInfo.setPathID(pathID);
                } else if (log.isWarnEnabled()) {
                    log.warn((Object)"\u66f4\u65b0\u6587\u6863\u5206\u7c7b\uff0c\u5bf9\u5e94\u7684pathID\u4e3a\u7a7a");
                }
            } else if (log.isErrorEnabled()) {
                log.error((Object)("\u4fee\u6539\u6587\u4ef6\u5206\u7c7b\u629b\u51fa\u5bf9\u8c61\u4e3a\u7a7a\uff0c\u4e0d\u5b58\u5728\u76f8\u5e94cID\u7684\u8bb0\u5f55:" + cID));
            }
            categoryObj.update(onePK, fcInfo);
            updateCID = cID;
        }
        catch (BOSException bs) {
            if (log.isErrorEnabled()) {
                log.error((Object)"FMEDaoImpl \u8c03\u7528 updateFileCategory \u65b9\u6cd5\u629b\u51fa\u5f02\u5e38", (Throwable)bs);
            }
            throw new Exception("FMEDaoImpl \u8c03\u7528 updateFileCategory \u65b9\u6cd5\u629b\u51fa\u5f02\u5e38", bs);
        }
        return updateCID;
    }

    @Override
    public String deleteFileCategory(String cID) throws Exception {
        String delCategoryID = null;
        if (FtpUtils.isBlankString(cID)) {
            throw new Exception("\u5220\u9664\u6587\u4ef6\u5206\u7c7b\u5bf9\u5e94\u7684cID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            IFileCategory categoryObj = this.getFileCategory();
            IObjectPK onePK = FMEUtils.getObjectPK("ID", cID);
            categoryObj.delete(onePK);
            delCategoryID = onePK.toString();
        }
        catch (BOSException bs) {
            if (log.isErrorEnabled()) {
                log.error((Object)"FMEDaoImpl \u8c03\u7528 deleteFileCategory \u65b9\u6cd5\u629b\u51fa\u5f02\u5e38", (Throwable)bs);
            }
            throw new Exception("FMEDaoImpl \u8c03\u7528 deleteFileCategory \u65b9\u6cd5\u629b\u51fa\u5f02\u5e38", bs);
        }
        return delCategoryID;
    }

    private List queryFileCategoryWithOSQL(String osql) throws Exception {
        ArrayList<Category> queryFileCategory = new ArrayList<Category>();
        try {
            IFileCategory categoryObj = this.getFileCategory();
            if (log.isInfoEnabled()) {
                log.info((Object)("queryFileCategoryWithOSQL osql is:\n" + osql));
            }
            FileCategoryCollection coll = categoryObj.getCollection(osql);
            Iterator iter = coll.iterator();
            while (iter.hasNext()) {
                FileCategoryInfo oneInfo = (FileCategoryInfo)iter.next();
                Category sp = new Category();
                sp.setID(oneInfo.getID().toString());
                sp.setPID(oneInfo.getPID());
                sp.setName(oneInfo.getName());
                sp.setStatus(oneInfo.getStatus());
                sp.setDescription(oneInfo.getDesc());
                sp.setPathID(oneInfo.getPathID());
                queryFileCategory.add(sp);
            }
        }
        catch (BOSException bs) {
            if (log.isErrorEnabled()) {
                log.error((Object)"FMEDaoImpl \u8c03\u7528 queryFileCategory \u65b9\u6cd5\u629b\u51fa\u5f02\u5e38", (Throwable)bs);
            }
            throw new Exception("FMEDaoImpl \u8c03\u7528 queryFileCategory \u65b9\u6cd5\u629b\u51fa\u5f02\u5e38", bs);
        }
        return queryFileCategory;
    }

    @Override
    public Category queryFileCategoryByID(String cID) throws Exception {
        Category sp = null;
        try {
            IFileCategory categoryObj = this.getFileCategory();
            if (log.isInfoEnabled()) {
                log.info((Object)("queryFileCategoryByID CID is:\n" + cID));
            }
            sp = new Category();
            IObjectPK onePK = FMEUtils.getObjectPK("ID", cID);
            FileCategoryInfo oneInfo = categoryObj.getValue(onePK);
            sp.setID(oneInfo.getID().toString());
            sp.setPID(oneInfo.getPID());
            sp.setName(oneInfo.getName());
            sp.setStatus(oneInfo.getStatus());
            sp.setDescription(oneInfo.getDesc());
            sp.setPathID(oneInfo.getPathID());
        }
        catch (BOSException bs) {
            if (log.isErrorEnabled()) {
                log.error((Object)"FMEDaoImpl \u8c03\u7528 queryFileCategoryByID \u65b9\u6cd5\u629b\u51fa\u5f02\u5e38", (Throwable)bs);
            }
            throw new Exception("FMEDaoImpl \u8c03\u7528 queryFileCategoryByID \u65b9\u6cd5\u629b\u51fa\u5f02\u5e38", bs);
        }
        return sp;
    }

    @Override
    public List queryFileCategory() throws Exception {
        return this.queryFileCategoryWithOSQL(FILECATEGORY_SQL_QUERY);
    }

    @Override
    public List queryFileCategory(String cID) throws Exception {
        String sql = MessageFormat.format(FILECATEGORY_SQL_QUERY_WITH_ID, cID);
        return this.queryFileCategoryWithOSQL(sql);
    }

    private IOperLog getOperLog() throws BOSException {
        if (this.operLog == null) {
            this.operLog = this.ctx == null ? OperLogFactory.getRemoteInstance() : OperLogFactory.getLocalInstance(this.ctx);
        }
        return this.operLog;
    }

    @Override
    public String insertOperLog(String documentID, int operType) throws Exception {
        String staffID = FMEUtils.getCurrentContextUser(this.ctx);
        return this.insertOperLog(documentID, operType, staffID);
    }

    @Override
    public String insertOperLog(String documentID, int operType, String staffID) throws Exception {
        String insertOperLogID = null;
        if (FtpUtils.isBlankString(documentID)) {
            throw new Exception("\u6dfb\u52a0\u7684\u64cd\u4f5c\u65e5\u5fd7\uff0cdocumentID" + documentID + "\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            IOperLog categoryObj = this.getOperLog();
            OperLogInfo logInfo = new OperLogInfo();
            BOSUuid logUUID = BOSUuid.create((String)"DDD33DDD");
            logInfo.setID(logUUID);
            logInfo.setDocumentID(documentID);
            logInfo.setOperType((short)operType);
            logInfo.setStaffID(staffID);
            logInfo.setOperDate(FMEUtils.getCurrrentDate());
            IObjectPK pk = categoryObj.addnew(logInfo);
            if (pk != null) {
                insertOperLogID = logUUID.toString();
            }
        }
        catch (BOSException bs) {
            if (log.isErrorEnabled()) {
                log.error((Object)"FMEDaoImpl \u8c03\u7528 insertOperLog \u65b9\u6cd5\u629b\u51fa\u5f02\u5e38", (Throwable)bs);
            }
            throw new Exception("FMEDaoImpl \u8c03\u7528 insertOperLog \u65b9\u6cd5\u629b\u51fa\u5f02\u5e38", bs);
        }
        return insertOperLogID;
    }

    @Override
    public List queryOperLog(String documentID, int operType) throws Exception {
        ArrayList<OperLog> queryList = new ArrayList<OperLog>();
        try {
            IOperLog categoryObj = this.getOperLog();
            String osql = MessageFormat.format(OPERLOG_QUERY_SQL, documentID, operType + "");
            OperLogCollection coll = categoryObj.getCollection(osql);
            Iterator iter = coll.iterator();
            while (iter.hasNext()) {
                OperLogInfo oneInfo = (OperLogInfo)iter.next();
                OperLog sp = new OperLog();
                sp.setID(oneInfo.getID().toString());
                sp.setDocumentID(oneInfo.getDocumentID());
                sp.setStaffID(oneInfo.getStaffID());
                sp.setOperType(oneInfo.getOperType());
                sp.setOperDate(oneInfo.getOperDate());
                queryList.add(sp);
            }
        }
        catch (BOSException bs) {
            if (log.isErrorEnabled()) {
                log.error((Object)"FMEDaoImpl \u8c03\u7528 queryOperLog \u65b9\u6cd5\u629b\u51fa\u5f02\u5e38", (Throwable)bs);
            }
            throw new Exception("FMEDaoImpl \u8c03\u7528 queryOperLog \u65b9\u6cd5\u629b\u51fa\u5f02\u5e38", bs);
        }
        return queryList;
    }

    private ICategoryMap getCategoryMap() throws BOSException {
        if (this.categoryMap == null) {
            this.categoryMap = this.ctx == null ? CategoryMapFactory.getRemoteInstance() : CategoryMapFactory.getLocalInstance(this.ctx);
        }
        return this.categoryMap;
    }

    @Override
    public String insertCategoryMap(String busiCategoryID, String fmeCategoryID, String fullCategoryInfo, int level) throws Exception {
        String mapID = null;
        if (FtpUtils.isBlankString(fullCategoryInfo)) {
            throw new Exception("\u6dfb\u52a0\u5206\u7c7b\u6620\u5c04\u8bb0\u5f55\uff0cfullCategoryInfo" + fullCategoryInfo + "\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            ICategoryMap categoryMObj = this.getCategoryMap();
            CategoryMapInfo mapInfo = new CategoryMapInfo();
            BOSUuid logUUID = BOSUuid.create((String)"DDD77DDD");
            mapInfo.setID(logUUID);
            mapInfo.setBCID(busiCategoryID);
            mapInfo.setFCID(fmeCategoryID);
            mapInfo.setMapName(fullCategoryInfo);
            mapInfo.setLevel(level);
            IObjectPK pk = categoryMObj.addnew(mapInfo);
            if (pk != null) {
                mapID = logUUID.toString();
            }
        }
        catch (BOSException bs) {
            if (log.isErrorEnabled()) {
                log.error((Object)"FMEDaoImpl \u8c03\u7528 insertCategoryMap \u65b9\u6cd5\u629b\u51fa\u5f02\u5e38", (Throwable)bs);
            }
            throw new Exception("FMEDaoImpl \u8c03\u7528 insertCategoryMap \u65b9\u6cd5\u629b\u51fa\u5f02\u5e38", bs);
        }
        return mapID;
    }

    @Override
    public String updateCategoryMap(String fID, String busiCategoryID, String fmeCategoryID, String fullCategoryInfo, int level) throws Exception {
        String updateCID = null;
        if (FtpUtils.isBlankString(fullCategoryInfo)) {
            throw new Exception("\u4fee\u6539\u5206\u7c7b\u6620\u5c04" + fullCategoryInfo + "\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            ICategoryMap categoryObj = this.getCategoryMap();
            IObjectPK onePK = FMEUtils.getObjectPK("ID", fID);
            CategoryMapInfo fcInfo = categoryObj.getValue(onePK);
            if (fcInfo != null) {
                if (!FtpUtils.isBlankString(busiCategoryID)) {
                    fcInfo.setFCID(busiCategoryID);
                } else if (log.isWarnEnabled()) {
                    log.warn((Object)"\u66f4\u65b0\u6587\u6863\u5206\u7c7b\u6620\u5c04\uff0c\u5bf9\u5e94\u7684busiCategoryID\u4e3a\u7a7a");
                }
                if (!FtpUtils.isBlankString(fmeCategoryID)) {
                    fcInfo.setFCID(fmeCategoryID);
                } else if (log.isWarnEnabled()) {
                    log.warn((Object)"\u66f4\u65b0\u6587\u6863\u5206\u7c7b\u6620\u5c04\uff0c\u5bf9\u5e94\u7684fmeCategoryID\u4e3a\u7a7a");
                }
                if (!FtpUtils.isBlankString(fullCategoryInfo)) {
                    fcInfo.setMapName(fullCategoryInfo);
                } else if (log.isWarnEnabled()) {
                    log.warn((Object)"\u66f4\u65b0\u6587\u6863\u5206\u7c7b\u6620\u5c04\uff0c\u5bf9\u5e94\u7684fullCategoryInfo\u4e3a\u7a7a");
                }
                if (level >= 1) {
                    fcInfo.setLevel(level);
                } else if (log.isWarnEnabled()) {
                    log.warn((Object)("\u66f4\u65b0\u6587\u6863\u5206\u7c7b\u6620\u5c04\uff0c\u5bf9\u5e94\u7684\u7ea7\u6b21level\u4e3a\u7a7a" + level));
                }
            } else if (log.isErrorEnabled()) {
                log.error((Object)("\u66f4\u65b0\u6587\u6863\u5206\u7c7b\u6620\u5c04\uff0c\u4e0d\u5b58\u5728\u76f8\u5e94fID\u7684\u8bb0\u5f55:" + fID));
            }
            categoryObj.update(onePK, fcInfo);
            updateCID = fID;
        }
        catch (BOSException bs) {
            if (log.isErrorEnabled()) {
                log.error((Object)"FMEDaoImpl \u8c03\u7528 updateCategoryMap \u65b9\u6cd5\u629b\u51fa\u5f02\u5e38", (Throwable)bs);
            }
            throw new Exception("FMEDaoImpl \u8c03\u7528 updateCategoryMap \u65b9\u6cd5\u629b\u51fa\u5f02\u5e38", bs);
        }
        return updateCID;
    }

    @Override
    public boolean deleteCategoryMap(String fID) throws Exception {
        boolean delCategoryMID = false;
        if (FtpUtils.isBlankString(fID)) {
            throw new Exception("\u5220\u9664\u6587\u4ef6\u5206\u7c7b\u6620\u5c04\u5bf9\u5e94\u7684fID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            ICategoryMap categoryObj = this.getCategoryMap();
            IObjectPK onePK = FMEUtils.getObjectPK("ID", fID);
            categoryObj.delete(onePK);
            delCategoryMID = true;
        }
        catch (BOSException bs) {
            if (log.isErrorEnabled()) {
                log.error((Object)"FMEDaoImpl \u8c03\u7528 deleteCategoryMap \u65b9\u6cd5\u629b\u51fa\u5f02\u5e38", (Throwable)bs);
            }
            throw new Exception("FMEDaoImpl \u8c03\u7528 deleteCategoryMap \u65b9\u6cd5\u629b\u51fa\u5f02\u5e38", bs);
        }
        return delCategoryMID;
    }

    private List queryCategoryMapWithOSQL(String osql) throws Exception {
        ArrayList<CategoryMap> queryList = new ArrayList<CategoryMap>();
        try {
            ICategoryMap categoryObj = this.getCategoryMap();
            CategoryMapCollection coll = categoryObj.getCollection(osql);
            Iterator iter = coll.iterator();
            while (iter.hasNext()) {
                CategoryMapInfo oneInfo = (CategoryMapInfo)iter.next();
                CategoryMap oneMap = new CategoryMap();
                oneMap.setID(oneInfo.getID().toString());
                oneMap.setBCID(oneInfo.getBCID());
                oneMap.setFCID(oneInfo.getFCID());
                oneMap.setMapName(oneInfo.getMapName());
                oneMap.setLevel(oneInfo.getLevel());
                queryList.add(oneMap);
            }
        }
        catch (BOSException bs) {
            if (log.isErrorEnabled()) {
                log.error((Object)"FMEDaoImpl \u8c03\u7528 queryCategoryMap \u65b9\u6cd5\u629b\u51fa\u5f02\u5e38", (Throwable)bs);
            }
            throw new Exception("FMEDaoImpl \u8c03\u7528 queryCategoryMap \u65b9\u6cd5\u629b\u51fa\u5f02\u5e38", bs);
        }
        return queryList;
    }

    @Override
    public List queryCategoryMap(String categoryInfo) throws Exception {
        StringBuffer sb = new StringBuffer();
        StringBuffer sb2 = new StringBuffer();
        String[] categoryInfoArray = categoryInfo.split("#/#/");
        for (int i = 0; i < categoryInfoArray.length; ++i) {
            if (sb.toString().length() > 0) {
                sb.append("#/#/");
            }
            sb.append(categoryInfoArray[i]);
            if (sb2.toString().length() > 0) {
                sb2.append(",");
            }
            sb2.append("'" + sb.toString() + "'");
        }
        String osql = MessageFormat.format(QUERY_CATEGORY_MAP_SQL_IN, sb2.toString());
        if (log.isInfoEnabled()) {
            log.info((Object)("\u67e5\u8be2CategoryInfo osql is:\n" + osql));
        }
        return this.queryCategoryMapWithOSQL(osql);
    }

    @Override
    public List queryCategoryMapByBusiCID(String busiCategoryID) throws Exception {
        String osql = MessageFormat.format(QUERY_CATEGORY_MAP_SQL_BCID, busiCategoryID);
        return this.queryCategoryMapWithOSQL(osql);
    }

    @Override
    public String getServerIDByPathID(String pathID) throws Exception {
        if (log.isErrorEnabled()) {
            log.error((Object)("\u4e25\u91cd\u8b66\u544a\uff1a------------------getServerIDByPathID \u88ab\u8c03\u7528\u6b21\u6570\uff1a-------------------pathID--------" + pathID));
        }
        SavePath sp = this.querySavePathByPathID(pathID);
        String serverID = null;
        if (sp == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("\u67e5\u627epathID\u4e3a\uff1a" + pathID + "\u7684\u5b58\u50a8\u8def\u5f84\u4e0d\u5b58\u5728"));
            }
        } else {
            serverID = sp.getServerID();
        }
        return serverID;
    }

    @Override
    public FtpConfig getFtpConfigByPathID(String pathID) throws Exception {
        String serverID = this.getServerIDByPathID(pathID);
        System.out.println("FMEDaoImpl::getFtpConfigByPathID()------pathID=" + pathID + ",serverID=" + serverID);
        if (log.isInfoEnabled()) {
            log.info((Object)("\u901a\u8fc7PathId:" + pathID + "\u83b7\u53d6\u5bf9\u5e94\u7684\uff1aServerID:" + serverID));
        }
        FtpConfig ftpConfig = this.queryFtpServerByServerID(serverID);
        if (log.isInfoEnabled()) {
            log.info((Object)("\u901a\u8fc7\uff1aServerID:" + serverID + "\u83b7\u53d6\u670d\u52a1\u5668FtpConfig: host " + ftpConfig.getHost()));
        }
        return ftpConfig;
    }

    private IDocument getDocumentInstance() throws BOSException {
        if (this.documentIntance == null) {
            this.documentIntance = this.ctx == null ? DocumentFactory.getRemoteInstance() : DocumentFactory.getLocalInstance(this.ctx);
        }
        return this.documentIntance;
    }

    @Override
    public String[] insertDocumentIcon(String docTypeName, String docExtName, String iconName, String status, String iconPath, int iconSaveType) throws Exception {
        String[] retArray = new String[2];
        String insertDocumentIconID = null;
        if (FtpUtils.isBlankString(iconPath)) {
            throw new Exception("\u6dfb\u52a0\u7684\u4fdd\u5b58\u8def\u5f84\u4e3a\u7a7a");
        }
        try {
            IDocumentIcon documentIconObj = this.getDocumentIcon();
            DocumentIconInfo diInfo = new DocumentIconInfo();
            BOSUuid documentIconUUID = BOSUuid.create((String)"DDD88DDD");
            diInfo.setDocumentIconid(documentIconUUID);
            diInfo.setDocTypeName(docTypeName);
            diInfo.setDocExtName(docExtName);
            diInfo.setIconName(iconName);
            diInfo.setStatus(status);
            diInfo.setIconPath(iconPath);
            diInfo.setIconSaveType(iconSaveType);
            IObjectPK pk = documentIconObj.addnew(diInfo);
            if (pk != null) {
                insertDocumentIconID = documentIconUUID.toString();
            }
        }
        catch (BOSException bs) {
            if (log.isErrorEnabled()) {
                log.error((Object)"FMEDaoImpl \u8c03\u7528 insertDocumentIcon \u65b9\u6cd5\u629b\u51fa\u5f02\u5e38", (Throwable)bs);
            }
            throw new Exception("FMEDaoImpl \u8c03\u7528 insertDocumentIcon \u65b9\u6cd5\u629b\u51fa\u5f02\u5e38", bs);
        }
        retArray[0] = insertDocumentIconID;
        retArray[1] = docTypeName;
        return retArray;
    }

    @Override
    public String deleteDocumentIcon(String documentIconID) throws Exception {
        String delDocumentIconID = null;
        if (FtpUtils.isBlankString(documentIconID)) {
            throw new Exception("\u5220\u9664\u6587\u6863\u56fe\u6807\u5bf9\u5e94\u7684documentIconID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            IDocumentIcon documentIConObj = this.getDocumentIcon();
            IObjectPK onePK = FMEUtils.getObjectPK("DocumentIconid", documentIconID);
            documentIConObj.delete(onePK);
            delDocumentIconID = onePK.toString();
        }
        catch (BOSException bs) {
            if (log.isErrorEnabled()) {
                log.error((Object)"FMEDaoImpl \u8c03\u7528 deleteDocumentICon \u65b9\u6cd5\u629b\u51fa\u5f02\u5e38", (Throwable)bs);
            }
            throw new Exception("FMEDaoImpl \u8c03\u7528 deleteDocumentIcon \u65b9\u6cd5\u629b\u51fa\u5f02\u5e38", bs);
        }
        return delDocumentIconID;
    }

    @Override
    public boolean updateDocumentIcon(String documentIconid, String docTypeName, String docExtName, String iconName, String status, String iconPath, int iconSaveType) throws Exception {
        boolean updateResult = false;
        if (FtpUtils.isBlankString(docTypeName)) {
            throw new Exception("\u4fee\u6539\u6587\u6863\u56fe\u6807\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            IDocumentIcon documentIconObj = this.getDocumentIcon();
            IObjectPK onePK = FMEUtils.getObjectPK("DocumentIConid", documentIconid);
            DocumentIconInfo diInfo = documentIconObj.getValue(onePK);
            if (diInfo != null) {
                diInfo.setDocTypeName(docTypeName);
                if (!FtpUtils.isBlankString(docExtName)) {
                    diInfo.setDocExtName(docExtName);
                } else if (log.isWarnEnabled()) {
                    log.warn((Object)"\u66f4\u65b0\u6587\u6863\u56fe\u6807\uff0c\u5bf9\u5e94\u7684docextname\u4e3a\u7a7a");
                }
                if (!FtpUtils.isBlankString(iconName)) {
                    diInfo.setIconName(iconName);
                } else if (log.isWarnEnabled()) {
                    log.warn((Object)"\u66f4\u65b0\u6587\u6863\u56fe\u6807\uff0c\u5bf9\u5e94\u7684iconName\u4e3a\u7a7a");
                }
                if (!FtpUtils.isBlankString(status)) {
                    diInfo.setStatus(status);
                } else if (log.isWarnEnabled()) {
                    log.warn((Object)"\u66f4\u65b0\u6587\u6863\u56fe\u6807\uff0c\u5bf9\u5e94\u7684status\u4e3a\u7a7a");
                }
                if (!FtpUtils.isBlankString(iconPath)) {
                    diInfo.setIconName(iconPath);
                } else if (log.isWarnEnabled()) {
                    log.warn((Object)"\u66f4\u65b0\u6587\u6863\u56fe\u6807\uff0c\u5bf9\u5e94\u7684iconpath\u4e3a\u7a7a");
                }
                if (iconSaveType >= 0 && iconSaveType <= 2) {
                    diInfo.setIconSaveType(iconSaveType);
                } else if (log.isWarnEnabled()) {
                    log.warn((Object)"\u66f4\u65b0\u6587\u6863\u56fe\u6807\uff0c\u5bf9\u5e94\u7684iconsaveType\u4e3a\u672a\u77e5\u7c7b\u578b");
                }
            } else if (log.isErrorEnabled()) {
                log.error((Object)("\u4fee\u6539\u4fdd\u5b58\u6587\u6863\u56fe\u6807\u629b\u51fa\u5bf9\u8c61\u4e3a\u7a7a\uff0c\u4e0d\u5b58\u5728\u76f8\u5e94documenticonID\u7684\u8bb0\u5f55:" + documentIconid));
            }
            documentIconObj.update(onePK, diInfo);
            updateResult = true;
        }
        catch (BOSException bs) {
            if (log.isErrorEnabled()) {
                log.error((Object)"FMEDaoImpl \u8c03\u7528 updatedocumenticon \u65b9\u6cd5\u629b\u51fa\u5f02\u5e38", (Throwable)bs);
            }
            throw new Exception("FMEDaoImpl \u8c03\u7528 updateDocumentIcon \u65b9\u6cd5\u629b\u51fa\u5f02\u5e38", bs);
        }
        return updateResult;
    }

    @Override
    public List queryDocumentIcon() throws Exception {
        ArrayList<DocumentIcon> queryDocumentIcon = new ArrayList<DocumentIcon>();
        try {
            IDocumentIcon documentIconObj = this.getDocumentIcon();
            DocumentIconCollection dill = documentIconObj.getCollection(DOCUMENTICON_SQL_QUERY);
            Iterator iter = dill.iterator();
            while (iter.hasNext()) {
                DocumentIconInfo onediInfo = (DocumentIconInfo)iter.next();
                DocumentIcon di = new DocumentIcon();
                di.setDocumentIconID(onediInfo.getDocumentIconid().toString());
                di.setDocTypeName(onediInfo.getDocTypeName().toString());
                di.setDocExtName(onediInfo.getDocExtName().toString());
                di.setIconName(onediInfo.getIconName().toString());
                di.setStatus(onediInfo.getStatus().toString());
                di.setIconPath(onediInfo.getIconPath().toString());
                di.setIconSaveType(onediInfo.getIconSaveType());
                queryDocumentIcon.add(di);
            }
        }
        catch (BOSException bs) {
            if (log.isErrorEnabled()) {
                log.error((Object)"FMEDaoImpl \u8c03\u7528 querydocumentIcon \u65b9\u6cd5\u629b\u51fa\u5f02\u5e38", (Throwable)bs);
            }
            throw new Exception("FMEDaoImpl \u8c03\u7528 querydocumentIcon \u65b9\u6cd5\u629b\u51fa\u5f02\u5e38", bs);
        }
        return queryDocumentIcon;
    }

    @Override
    public DocumentIcon queryDocumentIconByDocumentIconID(String documentIconID) throws Exception {
        DocumentIcon di = new DocumentIcon();
        try {
            IDocumentIcon documentIconObj = this.getDocumentIcon();
            String osql = MessageFormat.format(DOCUMENTICON_SQL_QUERY_WITH_DOCUMENTICONID, documentIconID);
            if (log.isInfoEnabled()) {
                log.info((Object)("\u67e5\u8be2DocumentIcon OSQL is:" + osql));
            }
            DocumentIconInfo onediInfo = documentIconObj.getValue(osql);
            di.setDocumentIconID(onediInfo.getDocumentIconid().toString());
            di.setDocTypeName(onediInfo.getDocTypeName().toString());
            di.setDocExtName(onediInfo.getDocExtName().toString());
            di.setIconName(onediInfo.getIconName().toString());
            di.setStatus(onediInfo.getStatus().toString());
            di.setIconPath(onediInfo.getIconPath().toString());
            di.setIconSaveType(onediInfo.getIconSaveType());
        }
        catch (BOSException bs) {
            if (log.isErrorEnabled()) {
                log.error((Object)("FMEDaoImpl \u8c03\u7528 queryDocumentIconByDocumentIconID\u65b9\u6cd5\u629b\u51fa\u5f02\u5e38" + bs.getMessage()), (Throwable)bs);
            }
            throw new Exception("FMEDaoImpl \u8c03\u7528 queryDocumentIconByDocumentIconID \u65b9\u6cd5\u629b\u51fa\u5f02\u5e38" + bs.getMessage(), bs);
        }
        return di;
    }

    @Override
    public boolean existDocumentIconNameRecord(String docTypeName) throws Exception {
        boolean existSameRecord = false;
        try {
            DocumentIconCollection coll;
            Iterator iter;
            IDocumentIcon documentIconObj = this.getDocumentIcon();
            String osql = MessageFormat.format(DOCUMENT_SQL_QUERY_WITH_DOCUMENTICONID, docTypeName);
            if (log.isInfoEnabled()) {
                log.info((Object)("\u67e5\u8be2DcumentIcon OSQL is:" + osql));
            }
            if ((iter = (coll = documentIconObj.getCollection(osql)).iterator()).hasNext()) {
                existSameRecord = true;
            }
        }
        catch (BOSException bs) {
            if (log.isErrorEnabled()) {
                log.error((Object)("FMEDaoImpl \u8c03\u7528 existDocumentIconNameRecord\u65b9\u6cd5\u629b\u51fa\u5f02\u5e38" + bs.getMessage()), (Throwable)bs);
            }
            throw new Exception("FMEDaoImpl \u8c03\u7528 existDocumentIconNameRecord\u65b9\u6cd5\u629b\u51fa\u5f02\u5e38" + bs.getMessage(), bs);
        }
        return existSameRecord;
    }

    @Override
    public ArrayList getDocExtName() throws Exception {
        ArrayList<String> al = new ArrayList<String>();
        try {
            IDocumentIcon documentIconObj = this.getDocumentIcon();
            DocumentIconCollection coll = documentIconObj.getCollection(DOCEXTNAME_SQL_QUERY);
            Iterator it = coll.iterator();
            while (it.hasNext()) {
                DocumentIconInfo onedi = (DocumentIconInfo)it.next();
                String docextname = onedi.getDocExtName();
                String[] det = docextname.split(";");
                for (int i = 0; i < det.length; ++i) {
                    al.add(det[i]);
                }
            }
        }
        catch (BOSException bs) {
            if (log.isErrorEnabled()) {
                log.error((Object)("FMEDaoImpl \u8c03\u7528 getDocExtName\u65b9\u6cd5\u629b\u51fa\u5f02\u5e38" + bs.getMessage()), (Throwable)bs);
            }
            throw new Exception("FMEDaoImpl \u8c03\u7528 getDocExtName\u65b9\u6cd5\u629b\u51fa\u5f02\u5e38" + bs.getMessage(), bs);
        }
        return al;
    }

    @Override
    public Map getIcon() throws Exception {
        HashMap<String, String> mp = new HashMap<String, String>();
        try {
            IDocumentIcon documentIconObj = this.getDocumentIcon();
            DocumentIconCollection coll = documentIconObj.getCollection(DOCUMENTICONMAP_SQL_QUERY);
            Iterator it = coll.iterator();
            while (it.hasNext()) {
                DocumentIconInfo onedi = (DocumentIconInfo)it.next();
                String docextname = onedi.getDocExtName();
                String iconname = onedi.getIconName();
                String iconpath = onedi.getIconPath();
                String iconnamepath = iconpath + iconname + ".gif";
                String[] det = docextname.split(";");
                for (int i = 0; i < det.length; ++i) {
                    mp.put(det[i], iconnamepath);
                }
            }
        }
        catch (BOSException bs) {
            if (log.isErrorEnabled()) {
                log.error((Object)("FMEDaoImpl \u8c03\u7528 getIcon\u65b9\u6cd5\u629b\u51fa\u5f02\u5e38" + bs.getMessage()), (Throwable)bs);
            }
            throw new Exception("FMEDaoImpl \u8c03\u7528 getIcon\u65b9\u6cd5\u629b\u51fa\u5f02\u5e38" + bs.getMessage(), bs);
        }
        return mp;
    }

    public ServiceResult downloadFile(String businessID, String documentID) throws Exception {
        return null;
    }

    @Override
    public ServiceResult download(String businessID, String documentID) throws Exception {
        return null;
    }

    @Override
    public DocumentBO[] queryWithDownloadCount(String businessID) throws Exception {
        DocumentBO[] oneBO = this.query(businessID);
        if (oneBO != null && oneBO.length > 0) {
            IConsoleServer server = FMEServerFactory.getConsoleServerInstance(this.ctx);
            Map downloadMap = server.getBusinessDocDownloadCount(businessID);
            for (int i = 0; i < oneBO.length; ++i) {
                DocumentBO boObj = oneBO[i];
                String docId = boObj.getDocumentID();
                if (downloadMap.containsKey(docId)) {
                    int downloadCount = (Integer)downloadMap.get(docId);
                    boObj.setDownloadCount(downloadCount);
                    continue;
                }
                boObj.setDownloadCount(0);
            }
        } else if (log.isErrorEnabled()) {
            log.error((Object)("\u83b7\u53d6\u6307\u5b9aBusinessID:" + businessID + "\u7684\u6587\u4ef6\u4e2a\u6570\u4e3a\u7a7a\uff0c\u4e0d\u9700\u8981\u7edf\u8ba1\u4e0b\u8f7d\u6b21\u6570"));
        }
        return oneBO;
    }
}

