/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.fme.dao;

import com.kingdee.bos.Context;
import com.kingdee.eas.base.fme.bo.ASFMEObject;
import com.kingdee.eas.base.fme.bo.DocumentBO;
import com.kingdee.eas.base.fme.dao.FMEDaoFactory;
import com.kingdee.eas.base.fme.dao.IFMEDao;
import com.kingdee.eas.base.fme.service.FMEServiceFactory;
import com.kingdee.eas.base.fme.service.IFMEService;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public class WebDAOService {
    private IFMEDao dao;
    private IFMEService fmeService;
    private Context ctx;
    private HttpServletRequest request;

    public WebDAOService(HttpServletRequest request) {
        this.request = request;
        this.ctx = WebContextUtil.getWebContext((HttpServletRequest)request).getEasContext();
        if (this.ctx != null) {
            this.dao = FMEDaoFactory.getFMEDaoInstance(this.ctx);
            this.fmeService = FMEServiceFactory.getServiceInstance(this.ctx);
        }
    }

    public ASFMEObject executeAppletService(ASFMEObject ufo) {
        ASFMEObject retObj = new ASFMEObject();
        try {
            int operTag = ufo.getOperTag();
            retObj.setOperTag(operTag);
            System.out.println("================================================WebDAOService executeAppletService==============" + operTag + "===================");
            switch (operTag) {
                case 0: {
                    DocumentBO oneBO = ufo.getDboArray()[0];
                    String[] result = this.dao.insertUnloadDocument(oneBO);
                    System.out.println("insertUnloadDocument " + operTag + " Result:" + result);
                    oneBO.setDocumentID(result[0]);
                    retObj.setResultArray(result);
                    break;
                }
                case 1: {
                    System.out.println("insert====" + operTag);
                    String[] insertResult = this.dao.insert(ufo.getDboArray());
                    retObj.setResultArray(insertResult);
                    break;
                }
                case 2: {
                    System.out.println("update====" + operTag);
                    String[] updateResult = this.dao.update(ufo.getDboArray());
                    retObj.setResultArray(updateResult);
                    break;
                }
                case 3: {
                    System.out.println("delete====" + operTag);
                    int deleteResult = this.dao.delete(ufo.getBusinessID(), ufo.getDocumentID(), ufo.getDeleteType());
                    retObj.setIntResult(deleteResult);
                    break;
                }
                case 4: {
                    System.out.println("query====" + operTag);
                    DocumentBO[] queryBOArray = this.dao.query(ufo.getBusinessID());
                    retObj.setDboArray(queryBOArray);
                    break;
                }
                case 5: {
                    System.out.println("query====" + operTag);
                    DocumentBO oneDocBO = this.dao.query(ufo.getBusinessID(), ufo.getDocumentID());
                    retObj.setDboArray(new DocumentBO[]{oneDocBO});
                    break;
                }
                case 6: {
                    System.out.println("insertBusiDoc====" + operTag);
                    String[] insertBDResult = this.dao.insertBusiDoc(ufo.getBusinessID(), ufo.getDocumentIDArray(), ufo.getDisplayNameArray());
                    retObj.setResultArray(insertBDResult);
                    break;
                }
                case 7: {
                    System.out.println("getDefaultFtpServer====" + operTag);
                    retObj.setConfig(this.dao.getDefaultFtpServer());
                    break;
                }
                case 8: {
                    System.out.println("insertUnloadDocument====" + operTag);
                    List insertResultList = this.dao.insertUnloadDocument(ufo.getDboArray());
                    retObj.setReturnList(insertResultList);
                    break;
                }
                case 9: {
                    String pathID = ufo.getStringElement();
                    System.out.println("getServerIDByPathID====" + operTag + "====pathID:" + pathID);
                    String serverID = this.dao.getServerIDByPathID(pathID);
                    retObj.setStringElement(serverID);
                    break;
                }
                case 10: {
                    String serverID = ufo.getStringElement();
                    System.out.println("queryFtpServerByServerID FtpConfig====" + operTag + "====serverID is:" + serverID);
                    retObj.setConfig(this.dao.queryFtpServerByServerID(serverID));
                    break;
                }
                case 11: {
                    String pathID = ufo.getStringElement();
                    System.out.println("getFtpConfigByPathID ====" + operTag + "====pathID:" + pathID);
                    retObj.setConfig(this.dao.getFtpConfigByPathID(pathID));
                    break;
                }
                case 12: {
                    String documentID = ufo.getDocumentID();
                    int operType = ufo.getIntResult();
                    System.out.println("insertOperLog ====" + operTag + "====documentID:" + documentID + "operType is:" + operType);
                    retObj.setOperStringResult(this.dao.insertOperLog(documentID, operType));
                    break;
                }
                case 13: {
                    retObj.setMapObj(this.dao.getIcon());
                    break;
                }
                case 14: {
                    String businessID = ufo.getBusinessID();
                    String documentID = ufo.getDocumentID();
                    int operType = ufo.getIntResult();
                    System.out.println("insertOperLog ====" + operTag + "====documentID:" + documentID + "operType is:" + operType);
                    retObj.setServiceResult(this.fmeService.downloadFileInServer(businessID, documentID, this.request));
                    break;
                }
                case 15: {
                    String businessID = ufo.getBusinessID();
                    System.out.println("insertOperLog ====" + operTag + "====businessID:" + businessID);
                    retObj.setDboArray(this.dao.queryWithDownloadCount(businessID));
                    break;
                }
                default: {
                    System.out.println("\u5c1a\u672a\u652f\u6301\u7684OperTag" + operTag);
                    break;
                }
            }
        }
        catch (Exception se) {
            System.out.println("========================================WebDAOService executeAppletService=============throw Exception:" + se.getMessage());
            se.printStackTrace();
        }
        return retObj;
    }
}

