/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.fme.search;

import com.kingdee.bos.Context;
import com.kingdee.eas.base.fme.ftp.FMEFtpFactory;
import com.kingdee.eas.base.fme.ftp.FtpConfig;
import com.kingdee.eas.base.fme.ftp.IFMEFtp;
import com.kingdee.eas.cp.eip.fts.FullTextModuleEnum;
import com.kingdee.eas.cp.eip.fts.app.BusinessDataObject;
import com.kingdee.eas.cp.eip.fts.business.BusinessResource;
import com.kingdee.eas.cp.eip.fts.documents.I_TextExtractor;
import com.kingdee.eas.cp.eip.fts.documents.RichTextDocumentManager;
import com.kingdee.eas.cp.eip.fts.utils.FtsContext;
import com.kingdee.eas.cp.eip.fts.utils.Utils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class FMEDocumentResource
extends BusinessResource {
    Logger logger = Logger.getLogger(FMEDocumentResource.class);
    private String localDirectoryAndFileName = null;

    public FMEDocumentResource() {
        this.fullTextModuleEnum = FullTextModuleEnum.FME;
    }

    protected List query(Context context, FtsContext ctx) {
        ArrayList<BusinessDataObject> list = new ArrayList<BusinessDataObject>();
        BusinessDataObject obj = null;
        String businessid = "";
        try {
            Timestamp max = this.getLastRunTime();
            Object cur = null;
            this.logger.info((Object)"FMEDocumentResource:: before excuting sql from T_FME_Document");
            IRowSet rowset = DbUtil.executeQuery((Context)context, (String)"select FDocumentID,FName,FPath,FDescription,FOperdate,FServerID from T_FME_Document");
            this.logger.info((Object)"FMEDocumentResource:: after excuting sql from T_FME_Document");
            RichTextDocumentManager richMgr = new RichTextDocumentManager();
            I_TextExtractor textExt = null;
            String ctxStr = "";
            int contentSizeLimit = 0x300000;
            while (rowset.next()) {
                this.logger.info((Object)("FMEDocumentResource:: into rowset while section, documentId:" + rowset.getString("FDocumentID")));
                obj = new BusinessDataObject();
                obj.setUuid(rowset.getString("FDocumentID"));
                obj.setKeyWord(this.fullTextModuleEnum.getAlias(this.context.getLocale()));
                String title = StringUtils.defaultString((String)this.getTile(rowset.getString("FDescription"))) + StringUtils.defaultString((String)this.fullTextModuleEnum.getAlias(this.context.getLocale()));
                obj.setTitle(title);
                String fileName = rowset.getString("FName");
                String path = rowset.getString("FPath");
                this.logger.info((Object)("FMEDocumentResource:: before getFileType" + fileName));
                String fileType = this.getFileType(fileName);
                this.logger.info((Object)("FMEDocumentResource:: before getTextExtractor" + fileType));
                textExt = richMgr.getTextExtractor(fileType);
                if (textExt != null) {
                    String serverId = rowset.getString("FServerID");
                    this.logger.info((Object)("FMEDocumentResource:: before getFile" + serverId + ", " + path + ", " + fileName));
                    byte[] content = this.getFile(serverId, path, fileName, fileType);
                    this.logger.info((Object)"FMEDocumentResource:: before setContent");
                    if (content != null) {
                        if (content.length < contentSizeLimit) {
                            obj.setContent(ctxStr + textExt.extractText(Utils.unpack((byte[])content)).getContent());
                        } else {
                            byte[] limitContent = new byte[contentSizeLimit];
                            System.arraycopy(content, 0, limitContent, 0, contentSizeLimit);
                            obj.setContent(ctxStr + textExt.extractText(Utils.unpack((byte[])limitContent)).getContent());
                        }
                    }
                } else {
                    obj.setContent(title);
                }
                IRowSet row = DbUtil.executeQuery((Context)context, (String)("select fbusinessid from t_fme_busidoc where fdocumentid='" + rowset.getString("FDocumentID") + "'"));
                while (row.next()) {
                    businessid = row.getString("fbusinessid");
                }
                this.logger.info((Object)("FMEDocumentResource:: before deleteFile:" + this.localDirectoryAndFileName));
                this.deleteFile(this.localDirectoryAndFileName);
                obj.setPath("/easGui?uuid=" + businessid + "&type=fts");
                obj.setGategory(this.fullTextModuleEnum.getValue());
                obj.setPeritemName("EnrollBill_View");
                obj.setCreateTime(rowset.getTimestamp("FOperdate"));
                list.add(obj);
            }
        }
        catch (Exception e) {
            this.logger.info((Object)"\u951f\u4fa5\u7889\u62f7\u951f\u65a4\u62f7\u951f\u65a4\u62f7\u951f\u4fa5\u7889\u62f7\u951f\u65a4\u62f7b\u951f\u65a4\u62f7\u951f\u65a4\u62f7\u5931\u951f\u65a4\u62f7 :", (Throwable)e);
        }
        return list;
    }

    private String getTile(String title) {
        if (title != null && !" ".equals(title)) {
            String returnTitle;
            block4: {
                int beginIndex = title.lastIndexOf("\\") + 1;
                int endIndex = title.lastIndexOf(".") - 1;
                returnTitle = "";
                this.logger.info((Object)("FMEDocumentResource:: title=" + title));
                this.logger.info((Object)("FMEDocumentResource:: beginIndex=" + beginIndex + ", endIndex=" + endIndex));
                try {
                    if (endIndex > beginIndex) {
                        returnTitle = title.substring(beginIndex, endIndex);
                    }
                }
                catch (Exception e) {
                    if (!title.endsWith("/")) break block4;
                    title = title.substring(0, title.length() - 1);
                    beginIndex = title.lastIndexOf("/") + 1;
                    endIndex = title.length();
                    if (endIndex <= beginIndex) break block4;
                    returnTitle = title.substring(beginIndex, endIndex);
                }
            }
            return returnTitle;
        }
        return "";
    }

    private String getFileType(String fileName) {
        int beginIndex = fileName.lastIndexOf(".");
        String fileType = fileName.substring(beginIndex);
        return fileType;
    }

    private byte[] getFile(String serverID, String path, String fileName, String filetype) {
        byte[] content = null;
        Map ftpMap = this.getFtpInfo();
        if (ftpMap.get(serverID) == null) {
            return content;
        }
        String ftpInfo = ftpMap.get(serverID).toString();
        String[] ftpInfoArray = ftpInfo.split(";");
        String serverHost = ftpInfoArray[0];
        int serverPort = Integer.parseInt(ftpInfoArray[1]);
        String serverUserName = ftpInfoArray[2];
        String serverPassWord = ftpInfoArray[3];
        FtpConfig config = new FtpConfig();
        config.setFtpid(serverID);
        config.setHost(serverHost);
        config.setPort(serverPort);
        config.setUsername(serverUserName);
        config.setPassword(serverPassWord);
        config.setIsDefault(1);
        IFMEFtp ftp = FMEFtpFactory.getFMEFtpInstanceWithFtpConfig(config);
        this.localDirectoryAndFileName = new StringBuffer().append(System.getProperty("eas.deploy")).append(File.separator).append("fts.").append(filetype).toString();
        String ftpDirectoryAndFileName = path + fileName;
        File ftpFile = null;
        try {
            boolean downloadResult = ftp.downloadStreamByFileName(ftpDirectoryAndFileName, this.localDirectoryAndFileName);
            if (downloadResult) {
                ftpFile = new File(this.localDirectoryAndFileName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (ftpFile != null) {
            content = this.fileToByte(ftpFile);
        } else {
            this.logger.info((Object)"\u951f\u65a4\u62f7\u951f\u65a4\u62f7\u951f\u4fa5\u7877\u62f7\u951f\u9636\u7b79\u62f7\u951f\u5c4a\u5e38");
        }
        return content;
    }

    private Map getFtpInfo() {
        HashMap<String, String> ftpInfoMap = new HashMap<String, String>();
        try {
            IRowSet rowset = DbUtil.executeQuery((Context)this.context, (String)"select FServerHost,FServerPort,FServerUser,FServerPswd,FServerID from T_FME_FtpServer");
            while (rowset.next()) {
                StringBuffer sb = new StringBuffer();
                String serverID = rowset.getString("FServerID");
                String serverHost = rowset.getString("FServerHost");
                String serverPort = String.valueOf(rowset.getInt("FServerPort"));
                String serverUser = rowset.getString("FServerUser");
                String serverPassWord = rowset.getString("FServerPswd");
                sb.append(serverHost).append(";").append(serverPort).append(";").append(serverUser).append(";").append(serverPassWord);
                ftpInfoMap.put(serverID, sb.toString());
            }
        }
        catch (Exception e) {
            this.logger.info((Object)"\u951f\u65a4\u62f7\u53d6FTP\u951f\u65a4\u62f7\u606f\u5931\u951f\u65a4\u62f7:", (Throwable)e);
        }
        return ftpInfoMap;
    }

    private byte[] fileToByte(File f) {
        byte[] fileArray = null;
        if (f == null) {
            return null;
        }
        try {
            int n;
            FileInputStream stream = new FileInputStream(f);
            ByteArrayOutputStream out = new ByteArrayOutputStream(1000);
            byte[] b = new byte[1000];
            while ((n = stream.read(b)) != -1) {
                out.write(b, 0, n);
            }
            stream.close();
            out.close();
            fileArray = out.toByteArray();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return fileArray;
    }

    private void deleteFile(String fileName) {
        if (fileName == null || "".equals(fileName)) {
            return;
        }
        File file = new File(fileName);
        if (file.exists()) {
            file.delete();
        }
    }
}

