/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.fme.servlet;

import com.enterprisedt.util.safe.SafeCheckUtils;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.fme.bo.DocumentBO;
import com.kingdee.eas.base.fme.dao.FMEDaoFactory;
import com.kingdee.eas.base.fme.dao.IFMEDao;
import com.kingdee.eas.base.fme.ftp.FtpConfig;
import com.kingdee.eas.base.fme.service.FMEServiceFactory;
import com.kingdee.eas.base.fme.service.IFMEService;
import com.kingdee.eas.base.fme.service.ServiceResult;
import com.kingdee.eas.base.fme.uimodel.FMEParameter;
import com.kingdee.eas.base.fme.util.FMEUIUtils;
import com.kingdee.eas.base.fme.util.FileConvertUtil;
import com.kingdee.eas.base.fme.util.FtpUtils;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class FMEForFlexServlet
extends HttpServlet {
    private static final Logger logger = Logger.getLogger(FMEForFlexServlet.class);
    private int maxPostSize = 0x7D000000;
    private int viewOnlineSize = 0xA00000;
    private static String remoteServiceProtocol = null;
    private static String remoteServiceHost = null;
    private static String remoteServicePort = null;
    private static String remoteServiceContextPath = null;
    private static long fileLastModifyTime = -1L;
    boolean isConvertFileOnUpload = "true".equalsIgnoreCase(System.getProperty("convertFileOnUploadToFtp", "true"));
    boolean isConvertFileByRemoteService = "true".equalsIgnoreCase(System.getProperty("convertFileByRemoteService", "true"));
    String maxConvertFileSize = System.getProperty("maxConvertFileSize", String.valueOf(0x800000));
    public static final String FLEX_PARAM_busiID = "busiID";
    public static final String FLEX_PARAM_documentID = "documentID";
    public static final String FLEX_PARAM_allowPrint = "allowPrint";
    public static final String FLEX_PARAM_saveType = "saveType";
    public static final String FLEX_PARAM_operType = "operType";
    public static final String FLEX_PARAM_newPathID = "newPathID";
    public static final String FLEX_PARAM_newCategoryInfo = "newCategoryInfo";

    public void destroy() {
        super.destroy();
    }

    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        int operTypeIntValue;
        String operType = request.getParameter(FLEX_PARAM_operType);
        if (FMEUIUtils.isBlankString(operType)) {
            operType = "0";
        }
        if ((operTypeIntValue = Integer.parseInt(operType)) == 2 || operTypeIntValue == 3) {
            this.loadInitFMEFile(request, response);
        } else if (operTypeIntValue == 12) {
            this.downloadFromFtp(request, response);
        } else if (operTypeIntValue == 13) {
            this.deleteFileFromFtp(request, response);
        } else if (operTypeIntValue == 14) {
            this.viewFileOnline(request, response);
        } else if (operTypeIntValue == 15) {
            this.isFileTypeLegal(request, response);
        } else if (operTypeIntValue == 16) {
            this.getDocumenIconMap(request, response);
        } else if (operTypeIntValue == 17) {
            this.insertBusiDoc(request, response);
        } else {
            this.uploadFile(request, response);
        }
    }

    private void getDocumenIconMap(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        System.out.println("getDocumenIconMap !");
        response.setContentType("text/html;charset=UTF-8");
        PrintWriter out = response.getWriter();
        Context ctx = FMEForFlexServlet.getContext(request);
        IFMEService fmeService = FMEServiceFactory.getServiceInstance(ctx);
        JSONObject retObj = new JSONObject();
        try {
            Map docIconMap = fmeService.getDocumenIconMap();
            if (docIconMap != null && docIconMap.size() > 0) {
                JSONArray oneArray = new JSONArray();
                for (String key : docIconMap.keySet()) {
                    String[] fileTypes;
                    File srcFile = new File(SafeCheckUtils.cleanPathString((String)docIconMap.get(key)));
                    String srcFileName = srcFile.getName();
                    if (!srcFile.exists()) continue;
                    File destFile = new File(System.getProperty("EAS_HOME") + "/server/deploy/easweb.ear/eas_web.war/bs/fme/flexPanel/userImages", srcFileName);
                    if (!destFile.exists()) {
                        FileUtils.copyFileToDirectory((File)srcFile, (File)destFile.getParentFile());
                    }
                    if (!(destFile = new File(System.getProperty("EAS_HOME") + "/server/deploy/portal.ear/plt_cp.war/res/flexPanel/userImages", srcFileName)).exists()) {
                        FileUtils.copyFileToDirectory((File)srcFile, (File)destFile.getParentFile());
                    }
                    for (String fileType : fileTypes = key.split(";")) {
                        JSONObject oneObj = new JSONObject();
                        oneObj.put("key", fileType);
                        oneObj.put("value", "./userImages/" + srcFileName);
                        oneArray.put(oneObj);
                    }
                }
                retObj.put("retCode", 0);
                retObj.put("retResult", oneArray);
            } else {
                retObj.put("retCode", 2);
                retObj.put("retResult", "no document icon exists");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                retObj.put("retCode", 1);
                retObj.put("retResult", e.getMessage());
            }
            catch (JSONException e1) {
                e1.printStackTrace();
            }
        }
        out.write(retObj.toString());
    }

    private void loadInitFMEFile(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        JSONObject retObj;
        PrintWriter out;
        block8: {
            System.out.println("loadFMEFile !");
            response.setContentType("text/html;charset=UTF-8");
            out = response.getWriter();
            Context ctx = FMEForFlexServlet.getContext(request);
            String businessID = request.getParameter(FLEX_PARAM_busiID);
            businessID = FMEForFlexServlet.getRequestParams(businessID);
            IFMEService fmeService = FMEServiceFactory.getServiceInstance(ctx);
            DocumentBO[] docBOArray = fmeService.getFileInfo(businessID);
            retObj = new JSONObject();
            try {
                if (docBOArray != null && docBOArray.length > 0) {
                    JSONArray oneArray = new JSONArray();
                    for (int i = 0; i < docBOArray.length; ++i) {
                        JSONObject oneObj = new JSONObject();
                        DocumentBO oneBO = docBOArray[i];
                        oneObj.put("uuid", oneBO.getDocumentID());
                        oneObj.put("name", oneBO.getName());
                        oneObj.put("sizeInt", oneBO.getSize());
                        oneObj.put("createrName", oneBO.getCreaterName());
                        oneObj.put("createDate", oneBO.getCreateDate());
                        oneObj.put("sizeStr", FtpUtils.getFileSize(oneBO.getSize()));
                        String disText = oneBO.getCreaterName() + ("".equals(oneBO.getCreaterName()) ? "" : ",") + oneBO.getCreateDate() + "(" + FtpUtils.getFileSize(oneBO.getSize()) + ")";
                        oneObj.put("size", disText);
                        oneObj.put("status", "\u5728\u7ebf");
                        oneObj.put("online", true);
                        oneObj.put("busiId", oneBO.getBusinessID());
                        oneObj.put("docId", oneBO.getDocumentID());
                        oneObj.put("displayName", oneBO.getDisplayName());
                        String fileType = "unknow";
                        try {
                            fileType = oneBO.getDisplayName().substring(oneBO.getDisplayName().lastIndexOf("."));
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                        oneObj.put("fileType", fileType);
                        oneArray.put(oneObj);
                    }
                    retObj.put("retCode", 0);
                    retObj.put("retResult", oneArray);
                    break block8;
                }
                retObj.put("retCode", 2);
                retObj.put("retResult", "query businessID:" + businessID + " no document list exists");
            }
            catch (JSONException e) {
                e.printStackTrace();
                try {
                    retObj.put("retCode", 1);
                    retObj.put("retResult", e.getMessage());
                }
                catch (JSONException e1) {
                    e1.printStackTrace();
                }
            }
        }
        out.write(retObj.toString());
    }

    private void uploadFile(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String isAsynConvertFile;
        String convertFileOnUpload;
        System.out.println("Access !");
        response.setContentType("text/html;charset=UTF-8");
        PrintWriter out = response.getWriter();
        out.print("\u5df2\u8fde\u63a5\u4e0a!");
        DiskFileItemFactory factory = new DiskFileItemFactory();
        String path = System.getProperty("java.io.tmpdir");
        factory.setRepository(new File(path));
        factory.setSizeThreshold(0x200000);
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
        upload.setHeaderEncoding(request.getCharacterEncoding());
        upload.setSizeMax((long)this.maxPostSize);
        String saveType = request.getParameter(FLEX_PARAM_saveType);
        if (FMEUIUtils.isBlankString(saveType)) {
            saveType = "0";
        }
        if (FMEUIUtils.isBlankString(convertFileOnUpload = request.getParameter("convertFileOnUpload"))) {
            convertFileOnUpload = "false";
        }
        if (FMEUIUtils.isBlankString(isAsynConvertFile = request.getParameter("asynConvertFile"))) {
            isAsynConvertFile = "false";
        }
        try {
            List fileItems = upload.parseRequest(request);
            logger.info((Object)("FileItem size is :" + fileItems.size()));
            for (FileItem item : fileItems) {
                String name = item.getName();
                String fieldName = item.getFieldName();
                logger.info((Object)("FileItem name is :" + name));
                logger.info((Object)("FileItem fieldName is :" + fieldName));
                if (item.isFormField()) continue;
                boolean isUpload = false;
                if (this.isConvertFileOnUpload && "true".equalsIgnoreCase(convertFileOnUpload)) {
                    long itemSize = item.getSize();
                    if (itemSize <= (long)this.viewOnlineSize) {
                        String fileType = name.substring(name.lastIndexOf(".") + 1);
                        if (this.isFileTypeLegal(fileType, item.getSize())) {
                            if (this.isConvertFileByRemoteService) {
                                int retValue = this.convertFileByRemoteServiceAfterUpload(item, request, "true".equalsIgnoreCase(isAsynConvertFile));
                                if (retValue == 2) {
                                    out.write("Failed, remte convert service not OK.");
                                }
                            } else {
                                this.uploadToWebDirAndConvertBeforeToFtp(item, request);
                            }
                            isUpload = true;
                        } else {
                            logger.info((Object)("file type is [" + fileType + "], ignore convert it"));
                        }
                    } else {
                        logger.info((Object)("item size is [" + itemSize + "], ignore convert it"));
                    }
                }
                if (isUpload) continue;
                if (saveType.equals("0")) {
                    this.uploadToWebDir(item, request);
                    continue;
                }
                this.uploadToFtp(item, request);
            }
            out.write("Finished");
            out.flush();
        }
        catch (FileUploadException e) {
            e.printStackTrace();
            System.out.println(e.getMessage() + "\u7ed3\u675f");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertBusiDoc(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        System.out.println("insertBusiDoc !");
        response.setContentType("text/html;charset=UTF-8");
        PrintWriter out = response.getWriter();
        try {
            String queryBusiID = request.getParameter("queryBusiID");
            queryBusiID = FMEForFlexServlet.getRequestParams(queryBusiID);
            if (queryBusiID != null && queryBusiID.length() > 0) {
                String businessID = request.getParameter(FLEX_PARAM_busiID);
                businessID = FMEForFlexServlet.getRequestParams(businessID);
                logger.info((Object)("BusinessID=" + businessID + " and queryBusinessID=" + queryBusiID));
                if (!queryBusiID.equals(businessID)) {
                    Context ctx = FMEForFlexServlet.getContext(request);
                    IFMEService fmeService = FMEServiceFactory.getServiceInstance(ctx);
                    DocumentBO[] docBOArray = fmeService.getFileInfo(queryBusiID);
                    if (docBOArray != null && docBOArray.length > 0) {
                        String[] documentIDArray = new String[docBOArray.length];
                        String[] displayNameArray = new String[docBOArray.length];
                        for (int i = 0; i < docBOArray.length; ++i) {
                            DocumentBO oneBO = docBOArray[i];
                            documentIDArray[i] = oneBO.getDocumentID();
                            displayNameArray[i] = oneBO.getDisplayName();
                        }
                        IFMEDao dao = FMEDaoFactory.getFMEDaoInstance(ctx);
                        String[] insertBDResult = dao.insertBusiDoc(businessID, documentIDArray, displayNameArray);
                        out.write("OK!" + insertBDResult.toString());
                    } else {
                        logger.warn((Object)("Not find any document by ID [" + queryBusiID + "]"));
                    }
                }
            }
        }
        catch (Exception e) {
            out.write("Error!" + e.getMessage());
            e.printStackTrace();
            logger.error((Object)"insertBusiDoc error!!!", (Throwable)e);
        }
        finally {
            out.flush();
            out.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getRemoteServiceInfo() {
        File propFile = new File(System.getProperty("EAS_HOME") + "/server/properties/remoteFileConvertService.properties");
        if (!propFile.exists()) {
            return null;
        }
        if (fileLastModifyTime != propFile.lastModified()) {
            logger.info((Object)("File [" + propFile.getPath() + "] lastModify time changed, try reload it"));
            fileLastModifyTime = propFile.lastModified();
            remoteServiceProtocol = null;
            remoteServiceHost = null;
            remoteServicePort = null;
            remoteServiceContextPath = null;
        }
        if (remoteServiceProtocol == null || remoteServiceHost == null || remoteServicePort == null || remoteServiceContextPath == null) {
            Properties prop = new Properties();
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(propFile);
                prop.load(fis);
                if (remoteServiceProtocol == null) {
                    remoteServiceProtocol = prop.getProperty("remoteServiceProtocol", "http");
                }
                if (remoteServiceHost == null) {
                    remoteServiceHost = prop.getProperty("remoteServiceHost");
                }
                if (remoteServicePort == null) {
                    remoteServicePort = prop.getProperty("remoteServicePort");
                }
                if (remoteServiceContextPath == null) {
                    remoteServiceContextPath = prop.getProperty("remoteServiceContextPath", "convertFileServlet");
                }
                if (remoteServiceHost == null || remoteServicePort == null) {
                    String string = null;
                    return string;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                logger.error((Object)ex);
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return remoteServiceProtocol + "://" + remoteServiceHost + ":" + remoteServicePort + "/" + remoteServiceContextPath;
    }

    private ServiceResult uploadToFtp(FileItem item, HttpServletRequest request) {
        ServiceResult sr = null;
        String name = item.getName();
        try {
            InputStream fis = item.getInputStream();
            Context ctx = FMEForFlexServlet.getContext(request);
            String businessID = request.getParameter(FLEX_PARAM_busiID);
            businessID = FMEForFlexServlet.getRequestParams(businessID);
            IFMEService fmeService = FMEServiceFactory.getServiceInstance(ctx);
            FMEParameter param = new FMEParameter();
            param.setClientType(1);
            param.setNewBusinessID(businessID);
            String newPathID = request.getParameter(FLEX_PARAM_newPathID);
            param.setNewPathID(FMEUIUtils.isBlankString(newPathID) ? null : newPathID);
            String newCategoryInfo = request.getParameter(FLEX_PARAM_newCategoryInfo);
            param.setNewCategoryInfo(FMEUIUtils.isBlankString(newCategoryInfo) ? null : newCategoryInfo);
            sr = fmeService.uploadFile(fis, name, businessID, param);
        }
        catch (Exception e) {
            System.out.println("uploadToFtp throws Exception:" + e.getMessage());
            e.printStackTrace();
        }
        return sr;
    }

    private void downloadFromFtp(HttpServletRequest request, HttpServletResponse response) {
        try {
            Context ctx = FMEForFlexServlet.getContext(request);
            String businessID = request.getParameter(FLEX_PARAM_busiID);
            businessID = FMEForFlexServlet.getRequestParams(businessID);
            String documentID = request.getParameter(FLEX_PARAM_documentID);
            IFMEService fmeService = FMEServiceFactory.getServiceInstance(ctx);
            response.setContentType("application/jar");
            ServiceResult serviceResult = fmeService.downloadFileByOutputStream(documentID, request, response);
        }
        catch (Exception e) {
            System.out.println("download from Ftp throws Exception:" + e.getMessage());
            e.printStackTrace();
        }
    }

    private void deleteFileFromFtp(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html;charset=UTF-8");
        PrintWriter out = response.getWriter();
        try {
            Context ctx = FMEForFlexServlet.getContext(request);
            String businessID = request.getParameter(FLEX_PARAM_busiID);
            businessID = FMEForFlexServlet.getRequestParams(businessID);
            String documentID = request.getParameter(FLEX_PARAM_documentID);
            IFMEService fmeService = FMEServiceFactory.getServiceInstance(ctx);
            boolean b = false;
            b = documentID != null && documentID.length() > 0 ? fmeService.deleteFile(businessID, documentID, 0) : fmeService.deleteFile(new String[]{businessID});
            out.write(String.valueOf(b));
        }
        catch (Exception e) {
            System.out.println("download from Ftp throws Exception:" + e.getMessage());
            e.printStackTrace();
            out.write("false");
        }
    }

    private void viewFileOnline(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!this.isConvertFileOnUpload) {
            try {
                PrintWriter out = response.getWriter();
                Context ctx = FMEForFlexServlet.getContext(request);
                String businessID = request.getParameter(FLEX_PARAM_busiID);
                businessID = FMEForFlexServlet.getRequestParams(businessID);
                String documentID = request.getParameter(FLEX_PARAM_documentID);
                String allowPrint = request.getParameter(FLEX_PARAM_allowPrint);
                IFMEService fmeService = FMEServiceFactory.getServiceInstance(ctx);
                response.setContentType("application/jar");
                ServiceResult sr = fmeService.downloadFileInServer(businessID, documentID, request, true);
                if (sr.isResult()) {
                    String filePath = SafeCheckUtils.cleanPathString(sr.getResultDetail());
                    File file = new File(filePath);
                    FileConvertUtil.convertFile(file.getParent(), file.getName());
                    String basePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + request.getContextPath() + "/bs/fme/" + ("true".equalsIgnoreCase(allowPrint) ? "flexPaper" : "flexPaperReadOnly") + "/onlineView.jsp";
                    String fileName = file.getName();
                    String swfFileName = fileName.substring(0, fileName.lastIndexOf(".")) + ".swf";
                    DocumentBO oneBO = fmeService.getDocumentByDocumentID(businessID, documentID);
                    String docInfo = oneBO.getCreaterName() + "  " + oneBO.getCreateDate() + "  " + FtpUtils.getFileSize(oneBO.getSize());
                    String finalFilePath = basePath + "?swfFilePath=../temp/" + file.getParentFile().getName() + "/swfFiles/" + swfFileName + "&docName=" + URLEncoder.encode(oneBO.getDisplayName()) + "&docInfo=" + URLEncoder.encode(docInfo);
                    response.addHeader("finalFilePath", finalFilePath);
                    out.write(finalFilePath);
                }
            }
            catch (Exception e) {
                System.out.println("download from Ftp throws Exception:" + e.getMessage());
                e.printStackTrace();
            }
        } else {
            try {
                PrintWriter out = response.getWriter();
                Context ctx = FMEForFlexServlet.getContext(request);
                String businessID = request.getParameter(FLEX_PARAM_busiID);
                businessID = FMEForFlexServlet.getRequestParams(businessID);
                String documentID = request.getParameter(FLEX_PARAM_documentID);
                String allowPrint = request.getParameter(FLEX_PARAM_allowPrint);
                IFMEService fmeService = FMEServiceFactory.getServiceInstance(ctx);
                if (!fmeService.isFileInFtpServer(businessID, documentID, true)) {
                    if (!FileConvertUtil.testConnection(remoteServiceHost, Integer.valueOf(remoteServicePort))) {
                        out.write("Failed, remte convert service not OK.");
                    } else {
                        FtpConfig ftpConfig = fmeService.getFtpConfig(businessID, documentID);
                        DocumentBO oneBO = fmeService.getDocumentByDocumentID(businessID, documentID);
                        String remoteFile = oneBO.getPath() + oneBO.getName();
                        boolean retValue = this.invokeRemoteServiceConvertFile(ftpConfig, oneBO.getPath(), oneBO.getServerID(), String.valueOf(oneBO.getSize()), remoteFile);
                        if (!retValue) {
                            out.write("Failed, convert file error");
                            return;
                        }
                    }
                }
                response.setContentType("application/jar");
                ServiceResult sr = fmeService.downloadFileInServer(businessID, documentID, request, true, true);
                if (sr.isResult()) {
                    String filePath = SafeCheckUtils.cleanPathString(sr.getResultDetail());
                    File file = new File(SafeCheckUtils.cleanPathString(filePath));
                    String basePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + request.getContextPath() + "/bs/fme/" + ("true".equalsIgnoreCase(allowPrint) ? "flexPaper" : "flexPaperReadOnly") + "/onlineView.jsp";
                    DocumentBO[] docBOArray = fmeService.getFileInfo(businessID);
                    String docInfos = "";
                    for (DocumentBO oneBO : docBOArray) {
                        if (!oneBO.getDocumentID().equals(documentID)) continue;
                        String docInfo = oneBO.getCreaterName() + "  " + oneBO.getCreateDate() + "  " + FtpUtils.getFileSize(oneBO.getSize());
                        docInfos = "&docName=" + URLEncoder.encode(oneBO.getDisplayName()) + "&docInfo=" + URLEncoder.encode(docInfo) + "&iconType=" + this.getIconType(oneBO.getName());
                    }
                    String finalFilePath = basePath + "?swfFilePath=../temp/" + file.getParentFile().getName() + "/" + file.getName() + docInfos;
                    response.addHeader("finalFilePath", finalFilePath);
                    out.write(finalFilePath);
                } else {
                    out.write("Failed, download swf file from ftp server failed.");
                }
            }
            catch (Exception e) {
                System.out.println("download from Ftp throws Exception:" + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    private String getIconType(String fileName) {
        String fileType = "";
        try {
            fileType = fileName.substring(fileName.lastIndexOf(".") + 1).toUpperCase();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (fileType.equalsIgnoreCase("PDF")) {
            return "icon-pdf";
        }
        if (fileType.equalsIgnoreCase("DOC") || fileType.equalsIgnoreCase("DOCX")) {
            return "icon-doc";
        }
        if (fileType.equalsIgnoreCase("PPT") || fileType.equalsIgnoreCase("PPTX")) {
            return "icon-ppt";
        }
        if (fileType.equalsIgnoreCase("XLS") || fileType.equalsIgnoreCase("XLSX")) {
            return "icon-exl";
        }
        if (fileType.equalsIgnoreCase("RAR") || fileType.equalsIgnoreCase("ZIP") || fileType.equalsIgnoreCase("7ZIP")) {
            return "icon-rar";
        }
        return "icon-file";
    }

    public static Context getContext(HttpServletRequest request) {
        Context ctx = WebContextUtil.getWebContext((HttpServletRequest)request).getEasContext();
        return ctx;
    }

    private void uploadToWebDir(FileItem item, HttpServletRequest request) {
        String name = item.getName();
        System.out.println(name);
        try {
            String fileName = FMEUIUtils.getRandomFileName(FMEUIUtils.getFileExtName(name));
            String tempDir = this.getWebTempDir(request);
            File parDir = new File(tempDir);
            if (!parDir.exists()) {
                parDir.mkdirs();
            }
            item.write(new File(tempDir + fileName));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void isFileTypeLegal(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter out = response.getWriter();
        String fileType = request.getParameter("fileType");
        String fileSize = request.getParameter("fileSize");
        long lFileSize = -1L;
        try {
            lFileSize = Long.valueOf(fileSize);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            if (!this.isConfigRemoteService()) {
                out.write("RemoteService not exist");
                return;
            }
            if (!this.isRemoteServiceRunning()) {
                out.write("RemoteService not running");
                return;
            }
            boolean isFileTypeLegal = this.isFileTypeLegal(fileType, lFileSize);
            if (isFileTypeLegal) {
                out.write("true");
            } else {
                out.write("false");
            }
        }
        catch (Exception ex) {
            logger.error((Object)"", (Throwable)ex);
            out.write("false");
        }
        finally {
            out.flush();
            out.close();
        }
    }

    private boolean isConfigRemoteService() {
        String remoteServiceUrl = this.getRemoteServiceInfo();
        return remoteServiceUrl != null;
    }

    private boolean isRemoteServiceRunning() {
        return this.testConnection(remoteServiceHost, Integer.valueOf(remoteServicePort), 3000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean testConnection(String ip, int port, int socketTimeout) {
        Socket socket = new Socket();
        try {
            InetSocketAddress addr = new InetSocketAddress(ip, port);
            socket.connect(addr, socketTimeout);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                socket.close();
            }
            catch (Exception exception) {}
        }
    }

    private boolean isFileTypeLegal(String fileType, long fileSize) throws IOException {
        String remoteServiceUrl;
        if (this.maxConvertFileSize != null && fileSize != -1L) {
            try {
                if (fileSize > Long.valueOf(this.maxConvertFileSize)) {
                    logger.error((Object)"File size too large, ignore convert it...");
                    return false;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if ((remoteServiceUrl = this.getRemoteServiceInfo()) == null) {
            return false;
        }
        if (!this.isRemoteServiceRunning()) {
            return false;
        }
        URL u = new URL(remoteServiceUrl);
        URLConnection cn = u.openConnection();
        cn.addRequestProperty("convertPatternName", "openoffice");
        cn.addRequestProperty(FLEX_PARAM_operType, "isFileTypeLegal");
        cn.addRequestProperty("fileType", fileType);
        cn.setReadTimeout(30000);
        cn.setConnectTimeout(3000);
        cn.connect();
        String httpRes = cn.getHeaderField(0);
        System.out.println("isFileTypeLeagal httpRes=" + httpRes);
        if (httpRes != null && httpRes.indexOf("200") > 0) {
            String isFileTypeLeagal = cn.getHeaderField("isFileTypeLeagal");
            return "true".equalsIgnoreCase(isFileTypeLeagal);
        }
        return false;
    }

    private boolean invokeRemoteServiceConvertFile(FtpConfig ftpConfig, String pathID, String serverID, String fileSize, String remoteFile) throws Exception {
        return this.invokeRemoteServiceConvertFile(ftpConfig, pathID, serverID, fileSize, remoteFile, false);
    }

    private boolean invokeRemoteServiceConvertFile(FtpConfig ftpConfig, String pathID, String serverID, String fileSize, String remoteFile, boolean isAsynConvert) throws Exception {
        String remoteServiceUrl = this.getRemoteServiceInfo();
        if (remoteServiceUrl == null) {
            return false;
        }
        if (!this.isRemoteServiceRunning()) {
            return false;
        }
        URL u = new URL(remoteServiceUrl);
        URLConnection cn = u.openConnection();
        cn.setReadTimeout(600000);
        cn.setConnectTimeout(1800);
        cn.addRequestProperty("ftpid", ftpConfig.getFtpid());
        cn.addRequestProperty("ftpname", ftpConfig.getFtpname());
        cn.addRequestProperty("username", ftpConfig.getUsername());
        cn.addRequestProperty("password", ftpConfig.getPassword());
        cn.addRequestProperty("ftpPort", String.valueOf(ftpConfig.getPort()));
        cn.addRequestProperty("status", ftpConfig.getStatus());
        cn.addRequestProperty("rootpath", ftpConfig.getRootPath());
        cn.addRequestProperty("accessaddress", ftpConfig.getAccessaddress());
        cn.addRequestProperty("ftpHost", ftpConfig.getHost());
        cn.addRequestProperty("internetIP", ftpConfig.getInternetIP());
        cn.addRequestProperty("pathID", pathID);
        cn.addRequestProperty("serverID", serverID);
        cn.addRequestProperty("convertPatternName", "openoffice");
        cn.addRequestProperty("fileOriginalSize", fileSize);
        cn.addRequestProperty("remoteFile", remoteFile);
        cn.addRequestProperty("FtpPreConvertHandler", "FtpPreConvertHandler");
        if (isAsynConvert) {
            cn.addRequestProperty("asynConvertFile", "true");
        } else {
            cn.addRequestProperty("asynConvertFile", "false");
        }
        cn.connect();
        String httpRes = cn.getHeaderField(0);
        System.out.println("invokeRemoteServiceConvertFile httpRes=" + httpRes);
        if (httpRes != null && httpRes.indexOf("200") > 0) {
            String strLine = "";
            String strResponse = "";
            InputStream in = cn.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(in, "UTF-8"));
            while ((strLine = reader.readLine()) != null) {
                strResponse = strResponse + strLine + "\n";
            }
            return !strResponse.toLowerCase().startsWith("failed");
        }
        return false;
    }

    private int convertFileByRemoteServiceAfterUpload(FileItem item, HttpServletRequest request, boolean asyn) {
        try {
            if (!FileConvertUtil.testConnection(remoteServiceHost, Integer.valueOf(remoteServicePort))) {
                return 2;
            }
            String name = item.getName();
            InputStream fis = item.getInputStream();
            Context ctx = FMEForFlexServlet.getContext(request);
            String businessID = request.getParameter(FLEX_PARAM_busiID);
            businessID = FMEForFlexServlet.getRequestParams(businessID);
            IFMEService fmeService = FMEServiceFactory.getServiceInstance(ctx);
            FMEParameter param = new FMEParameter();
            param.setClientType(1);
            param.setNewBusinessID(businessID);
            param.setNewPathID(null);
            param.setNewCategoryInfo(null);
            ServiceResult sr = fmeService.uploadFile(fis, name, businessID, param);
            String[] documentIDs = sr.getResultID();
            FtpConfig ftpConfig = fmeService.getFtpConfig(businessID, documentIDs[0]);
            DocumentBO oneBO = fmeService.getDocumentByDocumentID(businessID, documentIDs[0]);
            String remoteFile = oneBO.getPath() + oneBO.getName();
            if (asyn) {
                this.invokeRemoteServiceConvertFile(ftpConfig, oneBO.getPath(), oneBO.getServerID(), String.valueOf(oneBO.getSize()), remoteFile, true);
                return 1;
            }
            if (this.invokeRemoteServiceConvertFile(ftpConfig, oneBO.getPath(), oneBO.getServerID(), String.valueOf(oneBO.getSize()), remoteFile)) {
                return 1;
            }
            return 3;
        }
        catch (Exception e) {
            System.out.println("uploadToFtp throws Exception:" + e.getMessage());
            e.printStackTrace();
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int uploadToWebDirAndConvertBeforeToFtp(FileItem item, HttpServletRequest request) {
        String name = item.getName();
        String remoteFileName = FMEUIUtils.getRandomFileName(FMEUIUtils.getFileExtName(name));
        File srcFile = null;
        File swfFile = null;
        FileInputStream fis = null;
        FileInputStream swfFis = null;
        try {
            String tempDir = this.getWebTempDir(request);
            String dateTempDir = tempDir + this.dateToString() + File.separator;
            File parDir = new File(dateTempDir);
            if (!parDir.exists()) {
                parDir.mkdirs();
            }
            srcFile = new File(dateTempDir + remoteFileName);
            item.write(srcFile);
            FileConvertUtil.convertFile(dateTempDir, remoteFileName);
            Context ctx = FMEForFlexServlet.getContext(request);
            String businessID = request.getParameter(FLEX_PARAM_busiID);
            businessID = FMEForFlexServlet.getRequestParams(businessID);
            IFMEService fmeService = FMEServiceFactory.getServiceInstance(ctx);
            FMEParameter param = new FMEParameter();
            param.setClientType(1);
            param.setNewBusinessID(businessID);
            param.setNewPathID(null);
            param.setNewCategoryInfo(null);
            fis = new FileInputStream(srcFile);
            String srcFileName = srcFile.getName();
            String swfFileName = srcFile.getParent() + File.separator + "swfFiles" + File.separator + srcFileName.substring(0, srcFileName.lastIndexOf(".")) + ".swf";
            swfFile = new File(swfFileName);
            swfFis = new FileInputStream(swfFile);
            ServiceResult serviceResult = fmeService.uploadFile(fis, name, businessID, param, remoteFileName, swfFis);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (swfFis != null) {
                try {
                    swfFis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (srcFile != null) {
                srcFile.delete();
            }
            if (swfFile != null) {
                swfFile.delete();
            }
        }
        return 1;
    }

    public static String getRequestParams(String initValue) {
        String retValue = initValue.replaceAll(" ", "+");
        if (retValue.indexOf("'") == 0 && retValue.endsWith("'")) {
            retValue = retValue.substring(1, retValue.length() - 1);
        }
        return retValue;
    }

    private String dateToString() {
        Date time = new Date();
        String returnTimeStr = new SimpleDateFormat("yyyy-MM-dd").format(time);
        return returnTimeStr;
    }

    private String getWebTempDir(HttpServletRequest request) {
        String path = request.getRealPath("/");
        int fpos = path.indexOf("easweb.ear");
        String rootPath = "";
        if (fpos != -1) {
            rootPath = path.substring(0, fpos);
        }
        String tempDir = rootPath + "easweb.ear" + File.separator + "eas_web.war" + File.separator + "bs" + File.separator + "fme" + File.separator + "temp" + File.separator;
        return tempDir;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    public String getServletInfo() {
        return "Short description";
    }
}

