/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.fme.ui;

import com.kingdee.eas.base.fme.action.FMEDownloadServiceAction;
import com.kingdee.eas.base.fme.dao.AppletDAOFacade;
import com.kingdee.eas.base.fme.ftp.FMEFtpFactory;
import com.kingdee.eas.base.fme.service.ServiceResult;
import com.kingdee.eas.base.fme.ui.FMEClientUI;
import com.kingdee.eas.base.fme.ui.FMEUIPanel;
import com.kingdee.eas.base.fme.ui.IFMEUI;
import com.kingdee.eas.base.fme.uimodel.DownloadRecord;
import com.kingdee.eas.base.fme.uimodel.FMEParameter;
import com.kingdee.eas.base.fme.util.FtpUtils;
import java.awt.FileDialog;
import java.awt.Frame;
import javax.swing.JPanel;
import org.json.JSONArray;

public abstract class AbstractFMEUI
extends JPanel
implements IFMEUI {
    protected FMEUIPanel fmePanel;
    protected FMEClientUI applet;
    protected boolean cancelProgress = false;
    private FMEParameter param = new FMEParameter();
    protected DownloadRecord downloadRecord;
    protected boolean upload = true;
    protected String downloadIndex = "";
    protected boolean showDownloadCount = false;
    protected String showDownloadCountFormat = "";

    public AbstractFMEUI(int clientType, int onlineCreate, int onlineOpen) {
        this.param.setClientType(clientType);
        this.param.setOnlineCreate(onlineCreate);
        this.param.setOnlineOpen(onlineOpen);
        this.downloadRecord = new DownloadRecord();
    }

    @Override
    public void uploadFile(String businessId) {
    }

    @Override
    public String getUploadFileInfo() {
        return "";
    }

    @Override
    public void loadDownloadFile(String businessID) {
    }

    public FMEClientUI getApplet() {
        return this.applet;
    }

    public void setApplet(FMEClientUI applet) {
        this.applet = applet;
    }

    public void releaseResource() {
        try {
            FMEFtpFactory.freeCacheFtpResource(this.param.getNewPathID());
            FMEFtpFactory.freeCacheFtpResource(this.param.getQueryPathID());
        }
        catch (Exception se) {
            System.out.println("\u6e05\u9664FTP\u8d44\u6e90\u629b\u51fa\u5f02\u5e38:" + se.getMessage());
        }
    }

    @Override
    public boolean cancelUploadFile(String businessID) {
        return false;
    }

    public int getWaitingUploadFileCount() {
        return 0;
    }

    @Override
    public void notifyDownloadStatus(ServiceResult sr) {
        if (sr.isResult()) {
            sr.setResultFlag(1);
        } else {
            sr.setResultFlag(2);
        }
        this.applet.notifyOuterDownloadStatus(sr);
    }

    @Override
    public boolean downloadFile(String index, String fileName, String fileDocumentID) {
        return this.downloadFile(index, fileName, fileDocumentID, "");
    }

    @Override
    public boolean downloadFile(String index, String fileName, String fileDocumentID, String downloadTempDir) {
        boolean beginDown = false;
        String downloadFileName = this.getDownloadFilePath(downloadTempDir, fileName, index);
        if (FtpUtils.isBlankString(downloadFileName)) {
            System.out.println("\u6ca1\u6709\u6307\u5b9a\u4e0b\u8f7d\u8def\u5f84\uff0c\u4e0d\u80fd\u591f\u4e0b\u8f7d");
            beginDown = false;
        } else {
            String businessID = this.getParam().getQueryBusinessID();
            System.out.println("\u4e0b\u8f7d\u7684\u6587\u4ef6BusinessID is:" + businessID);
            if (FtpUtils.isBlankString(businessID)) {
                System.out.println("\u4e0b\u8f7d\u6587\u4ef6\u6307\u5b9a\u7684BusinessID\u4e3a\u7a7a");
            } else {
                this.downloadRecord.addOneDownloadRecord(index, true, businessID, fileDocumentID, downloadFileName);
                this.upload = true;
                this.downloadIndex = index;
                this.beginDownloadStatus();
                this.fmePanel.setFMEFileElementDownloadPath(index, downloadFileName);
                FMEDownloadServiceAction downloadCommand = new FMEDownloadServiceAction(this, downloadFileName, businessID, fileDocumentID, this.getClientType(), index);
                Thread ts = new Thread(downloadCommand);
                ts.start();
            }
            beginDown = true;
        }
        return beginDown;
    }

    @Override
    public ServiceResult downloadFileInServer(String index, String fileName, String fileDocumentID) {
        System.out.println("AbstractFMEUI::downloadFileInServer()--parameters are ,index=" + index + ",fileName=" + fileName + ",fileDocumentID=" + fileDocumentID);
        String businessID = this.getParam().getQueryBusinessID();
        System.out.println("\u4e0b\u8f7d\u7684\u6587\u4ef6BusinessID is:" + businessID);
        if (FtpUtils.isBlankString(businessID)) {
            System.out.println("\u4e0b\u8f7d\u6587\u4ef6\u6307\u5b9a\u7684BusinessID\u4e3a\u7a7a");
        } else {
            this.upload = true;
            this.downloadIndex = index;
            try {
                AppletDAOFacade dao = new AppletDAOFacade();
                ServiceResult downResult = dao.download(businessID, fileDocumentID);
                return downResult;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public String getDownloadFilePath(String tempDirPath, String fileName, String fileIndex) {
        String saveFile = "";
        if (FtpUtils.isBlankString(tempDirPath)) {
            Frame myFrame = new Frame();
            FileDialog saveDF = new FileDialog(myFrame, "\u8bf7\u9009\u62e9\u4e0b\u8f7d\u6587\u4ef6\u4f4d\u7f6e", 1);
            saveDF.setFile(fileName);
            saveDF.setDirectory(null);
            saveDF.setVisible(true);
            saveFile = saveDF.getFile();
            if (saveFile != null) {
                saveFile = saveDF.getDirectory() + saveFile;
                saveDF.setVisible(false);
                System.out.println("\u4fdd\u5b58\u6587\u4ef6\u4e3a:" + saveFile);
            }
        } else {
            fileName = FtpUtils.getDefaultDownloadFileName(fileIndex, fileName);
            System.out.println("getDownloadFilePath :\u6839\u636e\u7f3a\u7701\u8def\u5f84\u4e0b\u8f7d\u6587\u4ef6\uff0c\u9700\u8981\u589e\u52a0\u6269\u5c55\u7d22\u5f15\u540e\u7f00\uff1a" + fileName);
            saveFile = tempDirPath + fileName;
        }
        return saveFile;
    }

    @Override
    public boolean sameQueryAndNewBusinessID() {
        String queryBID = this.getQueryBusinessID();
        String newBID = this.getNewBusinessID();
        boolean isSame = false;
        if (queryBID != null && newBID != null && queryBID.equals(newBID)) {
            isSame = true;
        }
        return isSame;
    }

    public FMEParameter getParam() {
        return this.param;
    }

    public void setParam(FMEParameter param) {
        this.param = param;
    }

    @Override
    public int getOperType() {
        return this.param.getOperType();
    }

    @Override
    public void setQueryBusinessID(String businessID) {
        if (businessID != null && businessID.trim().length() > 0) {
            this.param.setQueryBusinessID(businessID);
        } else {
            System.out.println("\u8bbe\u7f6e\u7684BusinessID\u4e3anull\uff0c\u6216\u8005\u4e3a\u7a7a");
        }
    }

    @Override
    public String getQueryBusinessID() {
        return this.param.getQueryBusinessID();
    }

    @Override
    public void setNewBusinessID(String businessID) {
        if (businessID != null && businessID.trim().length() > 0) {
            this.param.setNewBusinessID(businessID);
        } else {
            System.out.println("\u8bbe\u7f6e\u7684NewBusinessID\u4e3anull\uff0c\u6216\u8005\u4e3a\u7a7a");
        }
    }

    @Override
    public String getNewBusinessID() {
        return this.param.getNewBusinessID();
    }

    public int getClientType() {
        return this.param.getClientType();
    }

    public void setClientType(int clientType) {
        this.param.setClientType(clientType);
    }

    public boolean isShowDownloadCount() {
        return this.showDownloadCount;
    }

    public void setShowDownloadCount(boolean showDownloadCount) {
        this.showDownloadCount = showDownloadCount;
    }

    public String getShowDownloadCountFormat() {
        return this.showDownloadCountFormat;
    }

    public void setShowDownloadCountFormat(String showDownloadCountFormat) {
        this.showDownloadCountFormat = showDownloadCountFormat;
    }

    public void beginDownloadStatus() {
        ServiceResult sr = new ServiceResult();
        sr.setResultFlag(0);
        sr.setResult(true, "\u6b63\u5728\u4fdd\u5b58\u9644\u4ef6...");
        this.applet.notifyOuterDownloadStatus(sr);
    }

    public abstract JSONArray getUnloadFileInfo();

    public abstract void loadUnloadFile(String var1);

    public void initDocumentIcon() {
        this.fmePanel.initDocumentMap();
    }

    @Override
    public void saveNewFile(String filePath) {
        try {
            this.fmePanel.addOneFile(filePath);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void saveOpenFile(String[] filePath, String[] documentID) {
    }
}

