/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.fme.ui;

import com.kingdee.eas.base.fme.action.FMEQueryServiceAction;
import com.kingdee.eas.base.fme.bo.DocumentBO;
import com.kingdee.eas.base.fme.ftp.FMEFtpInputStream;
import com.kingdee.eas.base.fme.service.ServiceResult;
import com.kingdee.eas.base.fme.ui.AbstractFMEUI;
import com.kingdee.eas.base.fme.ui.FMEUIPanel;
import com.kingdee.eas.base.fme.util.FMEUIUtils;
import com.kingdee.eas.base.fme.util.FtpUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.json.JSONArray;

public class FMEDownloadPanel
extends AbstractFMEUI
implements ActionListener {
    private JButton loadFileB;
    private JButton loginB;
    private GridBagConstraints gbdc = null;
    private JLabel messageLabel = null;
    private JPanel progressPanel = null;
    private JLabel progressLabel = null;
    private String[] uploadFileUUIDArray = null;
    private static final int DOWNLOAD_FILE_HEIGHT = 100;
    private static final int PER_FILE_HEIGHT = 35;
    private int currentUUID = 0;

    public FMEDownloadPanel(int clientType, int onlineCreate, int onlineOpen) {
        super(clientType, onlineCreate, onlineOpen);
        this.setLayout(new GridBagLayout());
        this.createFileInfoPanel(clientType);
        this.setPreferredSize(new Dimension(600, 100));
        this.gbdc = new GridBagConstraints();
        this.gbdc.fill = 1;
        this.gbdc.weightx = 0.0;
        this.gbdc.weighty = 0.0;
        this.add((Component)this.fmePanel, this.gbdc);
        this.gbdc.gridx = 0;
        this.gbdc.gridheight = 1;
        this.add((Component)this.createOperStatuePanel(), this.gbdc);
        this.setBackground(Color.white);
        this.setForeground(Color.white);
    }

    public void resizePanel(int fileSize, int uiPanelHeight) {
        int panelHeight = uiPanelHeight + 10;
        this.getApplet().resSizeAppletSize(600, panelHeight);
        this.getApplet().validate();
        this.getApplet().repaint();
        this.setPreferredSize(new Dimension(600, panelHeight));
        this.validate();
        this.repaint();
        this.getApplet().validate();
        this.getApplet().repaint();
    }

    private JPanel createOperStatuePanel() {
        JPanel operPanel = new JPanel(new FlowLayout());
        operPanel.setBackground(Color.white);
        operPanel.setForeground(Color.white);
        this.loadFileB = new JButton("\u52a0\u8f7d\u6587\u4ef6");
        operPanel.add(this.loadFileB);
        this.loadFileB.addActionListener(this);
        this.loginB = new JButton("\u767b\u9646");
        this.loginB.addActionListener(this);
        operPanel.add(this.loginB);
        if (this.getClientType() == 1) {
            this.loginB.setVisible(false);
            this.loadFileB.setVisible(false);
        }
        this.messageLabel = new JLabel("");
        operPanel.add(this.messageLabel);
        this.progressPanel = new JPanel();
        this.progressLabel = new JLabel();
        this.progressPanel.add(this.progressLabel);
        operPanel.add(this.progressLabel);
        return operPanel;
    }

    private void createFileInfoPanel(int clientType) {
        this.fmePanel = new FMEUIPanel(clientType);
        this.fmePanel.setPanelType(1);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.loadFileB) {
            this.loadDownloadFile("");
        } else {
            System.out.println("\u64cd\u4f5c\u5bf9\u8c61:" + src.getClass());
        }
    }

    @Override
    public void loadDownloadFile(String busiID) {
        String businessID = "";
        businessID = FMEUIUtils.isBlankString(busiID) ? this.getParam().getQueryBusinessID() : busiID;
        System.out.println("\u9884\u4e0b\u8f7d\u7684\u6587\u4ef6BusinessID is:" + businessID);
        boolean showDownloadCount = this.isShowDownloadCount();
        String showDownloadCountFormat = this.getShowDownloadCountFormat();
        FMEQueryServiceAction querySA = new FMEQueryServiceAction(businessID, this.getClientType(), showDownloadCount);
        DocumentBO[] boinfo = querySA.queryBO();
        if (boinfo != null && boinfo.length > 0) {
            try {
                this.fmePanel.loadFMEDocument(boinfo, showDownloadCount, showDownloadCountFormat);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.validate();
            this.repaint();
            this.getParent().validate();
            this.getParent().repaint();
            this.updateUI();
        } else {
            System.out.println("\u9700\u8981\u52a0\u8f7d\u7684\u4e1a\u52a1ID" + businessID + "\u5bf9\u5e94\u6ca1\u6709\u6587\u4ef6");
        }
    }

    @Override
    public void showFMEMessage(String message) {
        this.messageLabel.setText(message);
    }

    @Override
    public void updateProgress(FMEFtpInputStream fdis) {
        String percentV = fdis.getProgressPercentValue();
        String velocityV = fdis.getProgressVelocityValue();
        String downloadIndex = fdis.getProgressIndex();
        this.fmePanel.updateDownInfo(downloadIndex, percentV, velocityV);
    }

    @Override
    public boolean cancelProgress() {
        return this.cancelProgress;
    }

    @Override
    public void notifyServiceResult(ServiceResult serviceResult) {
        String errorInfo = serviceResult.getResultMessge();
        if (!errorInfo.equalsIgnoreCase("\u4fdd\u5b58\u6587\u4ef6\u88ab\u53d6\u6d88!")) {
            this.fmePanel.updateDownInfo(serviceResult.getFileIndex(), "-1%", "", serviceResult.getResultMessge());
        }
    }

    @Override
    public String getDownloadFilePath(String tempDirPath, String fileName, String fileIndex) {
        String saveFile = "";
        if (FtpUtils.isBlankString(tempDirPath)) {
            Frame myFrame = new Frame();
            FileDialog saveDF = new FileDialog(myFrame, "\u8bf7\u9009\u62e9\u4e0b\u8f7d\u6587\u4ef6\u4f4d\u7f6e", 1);
            saveDF.setFile(fileName);
            saveDF.setDirectory(null);
            saveDF.setVisible(true);
            saveFile = saveDF.getFile();
            if (saveFile != null) {
                saveFile = saveDF.getDirectory() + saveFile;
                saveDF.setVisible(false);
                System.out.println("\u4fdd\u5b58\u6587\u4ef6\u4e3a:" + saveFile);
            }
        } else {
            fileName = FtpUtils.getDefaultDownloadFileName(fileIndex, fileName);
            System.out.println("getDownloadFilePath :\u6839\u636e\u7f3a\u7701\u8def\u5f84\u4e0b\u8f7d\u6587\u4ef6\uff0c\u9700\u8981\u589e\u52a0\u6269\u5c55\u7d22\u5f15\u540e\u7f00\uff1a" + fileName);
            saveFile = tempDirPath + fileName;
        }
        return saveFile;
    }

    @Override
    public boolean removeServerFile(String index, String documentID) {
        return false;
    }

    @Override
    public String renameServerFile(String index, String documentID, String newName) {
        return null;
    }

    @Override
    public void stopProgress() {
        this.cancelProgress = true;
    }

    @Override
    public void resetProgress() {
        this.cancelProgress = false;
    }

    @Override
    public JSONArray getUnloadFileInfo() {
        return null;
    }

    @Override
    public void loadUnloadFile(String unloadFileInfo) {
    }
}

