/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.fme.ui;

import com.kingdee.eas.base.fme.action.FMEGetFtpConfigServiceAction;
import com.kingdee.eas.base.fme.action.FMEIconQueryServiceAction;
import com.kingdee.eas.base.fme.action.FMEOpenFileAction;
import com.kingdee.eas.base.fme.bo.DocumentBO;
import com.kingdee.eas.base.fme.ftp.FtpConfig;
import com.kingdee.eas.base.fme.getResult.ComparatorByOperDateStr;
import com.kingdee.eas.base.fme.service.ServiceResult;
import com.kingdee.eas.base.fme.ui.AbstractFMEUI;
import com.kingdee.eas.base.fme.ui.FMECustomLabel;
import com.kingdee.eas.base.fme.ui.FMEDownloadPanel;
import com.kingdee.eas.base.fme.ui.FMEUploadPanel;
import com.kingdee.eas.base.fme.ui.IFMEUI;
import com.kingdee.eas.base.fme.uimodel.FMEElementDomain;
import com.kingdee.eas.base.fme.uimodel.FMEFileElement;
import com.kingdee.eas.base.fme.uimodel.FMEFileObject;
import com.kingdee.eas.base.fme.uimodel.NeedOperObject;
import com.kingdee.eas.base.fme.util.FMEUIUtils;
import com.kingdee.eas.base.fme.util.FtpUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.json.JSONArray;

public class FMEUIPanel
extends JPanel
implements ActionListener,
FocusListener,
MouseListener {
    private FMEElementDomain fmeElement;
    private Map fmeValue;
    private Map fmeExtraSize;
    private ImageIcon iconUP = null;
    private ImageIcon iconDOWN = null;
    private ImageIcon iconFILE = null;
    private ImageIcon iconDB;
    private ImageIcon iconEXCEL;
    private ImageIcon iconHTML;
    private ImageIcon iconMDB;
    private ImageIcon iconMSG;
    private ImageIcon iconPDF;
    private ImageIcon iconPIC;
    private ImageIcon iconPPT;
    private ImageIcon iconPSD;
    private ImageIcon iconRAR;
    private ImageIcon iconTXT;
    private ImageIcon iconUNKNOWN;
    private ImageIcon iconVISIO;
    private ImageIcon iconVOICE;
    private ImageIcon iconWORD;
    private GridBagConstraints gbdc = null;
    private int fileCount = 0;
    public static final int INIT_HEIGHT = 10;
    public static final int INIT_WIDTH = 600;
    public static final int NULL_PATH_WIDTH = 50;
    public static final int PER_ROW_HEIGHT = 30;
    public static final int FILENAME_PANEL_WIDTH = 200;
    public static final int FILESIZE_PANEL_WIDTH = 200;
    public static final int FILEPATH_PANEL_WIDTH = 50;
    public static final int FILENAME_PNAEL_EXTRA_HEIGHT = 18;
    private JTextField renameTF = null;
    private int panelType = 0;
    private int extraHeightSum = 0;
    private int operFileCount = 0;
    private boolean onRenaming = false;
    private Map iconMap = null;
    private int clientType;
    private int openFileType = 0;
    private static final String FME_ELEMENT_KEY = "FFF00FFF";

    public FMEUIPanel(int clientType) {
        this.initOperFileCount();
        this.fmeElement = new FMEElementDomain();
        this.fmeValue = new HashMap();
        this.fmeExtraSize = new HashMap();
        URL imgurl1 = IFMEUI.class.getResource("/com/kingdee/eas/base/fme/image/up.gif");
        this.iconUP = new ImageIcon(imgurl1);
        URL imgurl2 = IFMEUI.class.getResource("/com/kingdee/eas/base/fme/image/down.gif");
        this.iconDOWN = new ImageIcon(imgurl2);
        URL imgurl3 = IFMEUI.class.getResource("/com/kingdee/eas/base/fme/image/file.gif");
        this.iconFILE = new ImageIcon(imgurl3);
        this.initIcon();
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(600, 10));
        this.gbdc = new GridBagConstraints();
        this.gbdc.anchor = 13;
        this.gbdc.fill = 1;
        this.gbdc.weightx = 0.0;
        this.gbdc.weighty = 0.0;
        this.setBackground(Color.white);
        this.setForeground(Color.white);
        this.addMouseListener(this);
        this.clientType = clientType;
    }

    private void selectIcon(JPanel onePanel, String ft) {
        if (ft.equalsIgnoreCase("db")) {
            onePanel.add(new JLabel(this.iconDB));
        } else if (ft.equalsIgnoreCase("xls")) {
            onePanel.add(new JLabel(this.iconEXCEL));
        } else if (ft.equalsIgnoreCase("html") || ft.equalsIgnoreCase("xhtml") || ft.equalsIgnoreCase("htm") || ft.equalsIgnoreCase("shtml")) {
            onePanel.add(new JLabel(this.iconHTML));
        } else if (ft.equalsIgnoreCase("mdb")) {
            onePanel.add(new JLabel(this.iconMDB));
        } else if (ft.equalsIgnoreCase("msg")) {
            onePanel.add(new JLabel(this.iconMSG));
        } else if (ft.equalsIgnoreCase("pdf")) {
            onePanel.add(new JLabel(this.iconPDF));
        } else if (ft.equalsIgnoreCase("bmp") || ft.equalsIgnoreCase("gif") || ft.equalsIgnoreCase("jpg") || ft.equalsIgnoreCase("png")) {
            onePanel.add(new JLabel(this.iconPIC));
        } else if (ft.equalsIgnoreCase("ppt")) {
            onePanel.add(new JLabel(this.iconPPT));
        } else if (ft.equalsIgnoreCase("psd")) {
            onePanel.add(new JLabel(this.iconPSD));
        } else if (ft.equalsIgnoreCase("rar") || ft.equalsIgnoreCase("jar") || ft.equalsIgnoreCase("zip") || ft.equalsIgnoreCase("gz")) {
            onePanel.add(new JLabel(this.iconRAR));
        } else if (ft.equalsIgnoreCase("txt")) {
            onePanel.add(new JLabel(this.iconTXT));
        } else if (ft.equalsIgnoreCase("vsd")) {
            onePanel.add(new JLabel(this.iconVISIO));
        } else if (ft.equalsIgnoreCase("avi") || ft.equalsIgnoreCase("wmv") || ft.equalsIgnoreCase("mpeg") || ft.equalsIgnoreCase("rm") || ft.equalsIgnoreCase("rmvb")) {
            onePanel.add(new JLabel(this.iconVOICE));
        } else if (ft.equalsIgnoreCase("doc") || ft.equalsIgnoreCase("docx") || ft.equalsIgnoreCase("dot")) {
            onePanel.add(new JLabel(this.iconWORD));
        } else {
            onePanel.add(new JLabel(this.iconUNKNOWN));
        }
    }

    public void initDocumentMap() {
        try {
            FMEIconQueryServiceAction queryAction = new FMEIconQueryServiceAction(this.clientType);
            this.iconMap = queryAction.queryIcon();
        }
        catch (Exception se) {
            System.out.println("FMEUIPanel \u83b7\u53d6Iconmap throws Exception:" + se.getMessage());
        }
    }

    private void initIcon() {
        URL imgurl1 = IFMEUI.class.getResource("/com/kingdee/eas/base/fme/image/icon_db.gif");
        this.iconDB = new ImageIcon(imgurl1);
        URL imgurl2 = IFMEUI.class.getResource("/com/kingdee/eas/base/fme/image/icon_excel.gif");
        this.iconEXCEL = new ImageIcon(imgurl2);
        URL imgurl3 = IFMEUI.class.getResource("/com/kingdee/eas/base/fme/image/icon_html.gif");
        this.iconHTML = new ImageIcon(imgurl3);
        URL imgurl4 = IFMEUI.class.getResource("/com/kingdee/eas/base/fme/image/icon_mdb.gif");
        this.iconMDB = new ImageIcon(imgurl4);
        URL imgurl5 = IFMEUI.class.getResource("/com/kingdee/eas/base/fme/image/icon_msg.gif");
        this.iconMSG = new ImageIcon(imgurl5);
        URL imgurl6 = IFMEUI.class.getResource("/com/kingdee/eas/base/fme/image/icon_pdf.gif");
        this.iconPDF = new ImageIcon(imgurl6);
        URL imgurl7 = IFMEUI.class.getResource("/com/kingdee/eas/base/fme/image/icon_pic.gif");
        this.iconPIC = new ImageIcon(imgurl7);
        URL imgurl8 = IFMEUI.class.getResource("/com/kingdee/eas/base/fme/image/icon_ppt.gif");
        this.iconPPT = new ImageIcon(imgurl8);
        URL imgurl9 = IFMEUI.class.getResource("/com/kingdee/eas/base/fme/image/icon_psd.gif");
        this.iconPSD = new ImageIcon(imgurl9);
        URL imgurl10 = IFMEUI.class.getResource("/com/kingdee/eas/base/fme/image/icon_rar.gif");
        this.iconRAR = new ImageIcon(imgurl10);
        URL imgurl11 = IFMEUI.class.getResource("/com/kingdee/eas/base/fme/image/icon_txt.gif");
        this.iconTXT = new ImageIcon(imgurl11);
        URL imgurl12 = IFMEUI.class.getResource("/com/kingdee/eas/base/fme/image/icon_unknown.gif");
        this.iconUNKNOWN = new ImageIcon(imgurl12);
        URL imgurl13 = IFMEUI.class.getResource("/com/kingdee/eas/base/fme/image/icon_visio.gif");
        this.iconVISIO = new ImageIcon(imgurl13);
        URL imgurl14 = IFMEUI.class.getResource("/com/kingdee/eas/base/fme/image/icon_voice.gif");
        this.iconVOICE = new ImageIcon(imgurl14);
        URL imgurl15 = IFMEUI.class.getResource("/com/kingdee/eas/base/fme/image/icon_word.gif");
        this.iconWORD = new ImageIcon(imgurl15);
    }

    public void loadFMEDocument(DocumentBO[] boArray, int loadType, boolean showDownloadTime, String showDownloadCountFormat) throws Exception {
        this.initOperFileCount();
        Arrays.sort(boArray, new ComparatorByOperDateStr());
        if (loadType == 3) {
            this.loadFMEDocument(boArray, showDownloadTime, showDownloadCountFormat);
        } else {
            this.loadFMEDocumentWithOperation(boArray);
        }
    }

    private void initOperFileCount() {
        this.operFileCount = 0;
    }

    private void increaseOperFileCount() {
        ++this.operFileCount;
    }

    private int getNextOperFileCount() {
        ++this.operFileCount;
        return this.operFileCount;
    }

    private void initReloadFMEPanel() {
        this.removeAll();
        this.fileCount = 0;
        this.extraHeightSum = 0;
        this.fmeElement = new FMEElementDomain();
        this.fmeValue = new HashMap();
        this.fmeExtraSize = new HashMap();
        this.setPreferredSize(new Dimension(600, 10));
    }

    public void loadFMEDocumentWithOperation(DocumentBO[] boArray) throws Exception {
        System.out.println("============loadFMEDocumentWithOperation===============");
        this.initReloadFMEPanel();
        int boSize = boArray.length;
        int extraHeightAll = 0;
        System.out.println("\u52a0\u8f7d\u6587\u4ef6\u6709:" + boSize + "\u4e2a");
        for (int i = 0; i < boSize; ++i) {
            DocumentBO oneBO = boArray[i];
            JPanel onePanel = new JPanel();
            onePanel.setBackground(Color.white);
            onePanel.setForeground(Color.white);
            String uuid = "" + onePanel.hashCode();
            FlowLayout fLT = new FlowLayout();
            fLT.setAlignment(0);
            onePanel.setLayout(fLT);
            String ft = FtpUtils.getFileType(oneBO.getDisplayName());
            if (this.iconMap != null) {
                if (this.iconMap.get(ft) != null) {
                    this.selectDefineIcon(onePanel, this.iconMap.get(ft).toString());
                } else {
                    this.selectIcon(onePanel, ft);
                }
            } else {
                this.selectIcon(onePanel, ft);
            }
            JLabel pathLabel = new JLabel("");
            pathLabel.setFocusable(true);
            pathLabel.setPreferredSize(new Dimension(50, 30));
            pathLabel.setHorizontalTextPosition(0);
            pathLabel.setVisible(false);
            onePanel.add(pathLabel);
            FMECustomLabel nameLabel = new FMECustomLabel();
            nameLabel.setFocusable(true);
            nameLabel.setPreferredSize(new Dimension(200, 30));
            nameLabel.setHorizontalTextPosition(0);
            int lineSize = this.getNameLabel(nameLabel, oneBO.getDisplayName(), false);
            int extraHeight = 0;
            extraHeightAll += extraHeight;
            nameLabel.setPreferredSize(new Dimension(200, 30));
            ((JComponent)nameLabel).setToolTipText(uuid);
            AbstractFMEUI fmeUP = (AbstractFMEUI)this.getParent();
            int allowDownload = fmeUP.getParam().getAllowDownload();
            if (allowDownload == 1) {
                nameLabel.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        int clickCount = e.getClickCount();
                        if (clickCount == 2) {
                            try {
                                FMECustomLabel fmecLable = (FMECustomLabel)e.getSource();
                                if (fmecLable.enabled) {
                                    FMEUIPanel.this.openDownloadFile(((JLabel)e.getSource()).getToolTipText());
                                }
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        }
                    }

                    @Override
                    public void mouseEntered(MouseEvent e) {
                        FMEUIPanel.this.setCursor(Cursor.getPredefinedCursor(12));
                    }

                    @Override
                    public void mouseExited(MouseEvent e) {
                        FMEUIPanel.this.setCursor(Cursor.getPredefinedCursor(0));
                    }
                });
            }
            onePanel.add(nameLabel);
            String disText = oneBO.getCreaterName() + ("".equals(oneBO.getCreaterName()) ? "" : ",") + oneBO.getCreateDate() + "(" + FtpUtils.getFileSize(oneBO.getSize()) + ")";
            FMECustomLabel sizeLabel = new FMECustomLabel(disText);
            ((JComponent)sizeLabel).setToolTipText(FtpUtils.getFileSize(oneBO.getSize()));
            sizeLabel.setFocusable(true);
            sizeLabel.setPreferredSize(new Dimension(200, 30));
            sizeLabel.setHorizontalTextPosition(0);
            onePanel.add(sizeLabel);
            FMECustomLabel renameLinkLabel = new FMECustomLabel("\u91cd\u547d\u540d", false);
            renameLinkLabel.enabled = fmeUP.getParam().isAllowUpload();
            renameLinkLabel.setToolTipText(uuid);
            String allowEdit = fmeUP.getParam().getAllowEdit();
            renameLinkLabel.setVisible(null == allowEdit ? true : '1' == allowEdit.charAt(i));
            renameLinkLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    try {
                        FMECustomLabel fmecLable = (FMECustomLabel)e.getSource();
                        if (fmecLable.enabled) {
                            FMEUIPanel.this.renameServerFile(((JLabel)e.getSource()).getToolTipText());
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            });
            onePanel.add(renameLinkLabel);
            FMECustomLabel cancelDownloadLinkLabel = new FMECustomLabel("\u53d6\u6d88", false);
            cancelDownloadLinkLabel.setToolTipText(uuid);
            cancelDownloadLinkLabel.setVisible(false);
            cancelDownloadLinkLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    try {
                        FMECustomLabel fmecLable = (FMECustomLabel)e.getSource();
                        if (fmecLable.enabled) {
                            FMEUIPanel.this.cancelDownloadFile(((JLabel)e.getSource()).getToolTipText());
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            });
            onePanel.add(cancelDownloadLinkLabel);
            FMECustomLabel deleteLinkLabel = new FMECustomLabel("\u5220\u9664", false);
            deleteLinkLabel.enabled = fmeUP.getParam().isAllowUpload();
            deleteLinkLabel.setToolTipText(uuid);
            String allowDelete = fmeUP.getParam().getAllowDelete();
            if (null == allowDelete) {
                deleteLinkLabel.setVisible(true);
            } else {
                deleteLinkLabel.setVisible('1' == allowDelete.charAt(i));
            }
            deleteLinkLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    try {
                        int s;
                        FMECustomLabel fmecLable = (FMECustomLabel)e.getSource();
                        if (fmecLable.enabled && (s = JOptionPane.showConfirmDialog(null, "\u786e\u8ba4\u5220\u9664\u5417?", "\u5220\u9664\u9644\u4ef6\u786e\u8ba4", 0)) == 0) {
                            FMEUIPanel.this.removeElement(((JLabel)e.getSource()).getToolTipText());
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            });
            onePanel.add(deleteLinkLabel);
            FMECustomLabel openFileLinkLabel = new FMECustomLabel("\u6253\u5f00", false);
            openFileLinkLabel.setToolTipText(uuid);
            openFileLinkLabel.setVisible(false);
            openFileLinkLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    try {
                        FMECustomLabel fmecLable = (FMECustomLabel)e.getSource();
                        if (fmecLable.enabled) {
                            FMEUIPanel.this.openDownloadFile(((JLabel)e.getSource()).getToolTipText());
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            });
            onePanel.add(openFileLinkLabel);
            FMECustomLabel openFileLinkOnlineLabel = new FMECustomLabel("\u5728\u7ebf\u7f16\u8f91", false);
            openFileLinkOnlineLabel.enabled = fmeUP.getParam().isAllowUpload();
            openFileLinkOnlineLabel.setToolTipText(uuid);
            final int allowPrint = fmeUP.getParam().getAllowPrint();
            final int allowCopy = fmeUP.getParam().getAllowCopy();
            openFileLinkOnlineLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    try {
                        FMECustomLabel fmecLable = (FMECustomLabel)e.getSource();
                        if (fmecLable.enabled) {
                            FMEUIPanel.this.downloadFileForOpenAndEdit(((JLabel)e.getSource()).getToolTipText(), allowPrint, allowCopy);
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            });
            onePanel.add(openFileLinkOnlineLabel);
            int onlineOpen = fmeUP.getParam().getOnlineOpen();
            if (onlineOpen != 1) {
                openFileLinkLabel.setVisible(true);
                openFileLinkOnlineLabel.setVisible(false);
            } else {
                openFileLinkLabel.setVisible(false);
                openFileLinkOnlineLabel.setVisible(FMEUIUtils.isOfficeFileType(ft) ? (null == allowEdit ? true : '1' == allowEdit.charAt(i)) : false);
            }
            onePanel.add(new FMECustomLabel(""));
            onePanel.add(new FMECustomLabel(""));
            onePanel.setPreferredSize(new Dimension(600, 30 + extraHeight));
            this.gbdc.gridx = 0;
            this.gbdc.gridheight = 1;
            this.add((Component)onePanel, this.gbdc);
            this.fmeElement.put(uuid, onePanel);
            this.fmeExtraSize.put(uuid, new Integer(extraHeight));
            this.increaseOperFileCount();
            FMEFileElement oneElement = new FMEFileElement(uuid, oneBO.getName(), oneBO.getDisplayName(), "" + oneBO.getSize(), oneBO.getDocumentID());
            oneElement.setOnServer(true);
            oneElement.setIntSize(oneBO.getSize());
            oneElement.setBusinessID(oneBO.getBusinessID());
            oneElement.setFileIndex(this.getNextOperFileCount());
            this.fmeValue.put(uuid, oneElement);
        }
        this.fileCount = boSize;
        this.reSizePanel(extraHeightAll);
        this.validate();
        this.repaint();
    }

    public void loadFMEDocument(DocumentBO[] boArray, boolean showDownloadTime, String showDownloadCountFormat) throws Exception {
        System.out.println("=============loadFMEDocument==============");
        this.removeAll();
        int boSize = boArray.length;
        this.fileCount = 0;
        this.extraHeightSum = 0;
        this.fmeElement = new FMEElementDomain();
        this.fmeValue = new HashMap();
        this.fmeExtraSize = new HashMap();
        int extraHeightAll = 0;
        this.setPreferredSize(new Dimension(600, 10));
        System.out.println("\u52a0\u8f7d\u6587\u4ef6\u6709:" + boSize + "\u4e2a");
        for (int i = 0; i < boSize; ++i) {
            int downloadCount;
            DocumentBO oneBO = boArray[i];
            JPanel onePanel = new JPanel();
            onePanel.setBackground(Color.white);
            onePanel.setForeground(Color.white);
            FlowLayout fLT = new FlowLayout();
            fLT.setAlignment(0);
            onePanel.setLayout(fLT);
            String ft = FtpUtils.getFileType(oneBO.getDisplayName());
            if (this.iconMap != null) {
                if (this.iconMap.get(ft) != null) {
                    this.selectDefineIcon(onePanel, this.iconMap.get(ft).toString());
                } else {
                    this.selectIcon(onePanel, ft);
                }
            } else {
                this.selectIcon(onePanel, ft);
            }
            JLabel pathLabel = new JLabel("");
            pathLabel.setFocusable(true);
            pathLabel.setPreferredSize(new Dimension(50, 30));
            pathLabel.setHorizontalTextPosition(0);
            pathLabel.setVisible(false);
            onePanel.add(pathLabel);
            FMECustomLabel nameLabel = new FMECustomLabel();
            nameLabel.setFocusable(true);
            nameLabel.setPreferredSize(new Dimension(200, 30));
            nameLabel.setHorizontalTextPosition(0);
            String showName = oneBO.getDisplayName();
            if (showDownloadTime && (downloadCount = oneBO.getDownloadCount()) > 0) {
                if (showDownloadCountFormat != null) {
                    if (showDownloadCountFormat.indexOf("N") != -1) {
                        String replaceShowDownloadCountFormat = URLDecoder.decode(showDownloadCountFormat.replaceAll("N", String.valueOf(downloadCount)), "UTF-8");
                        showName = showName + "(" + replaceShowDownloadCountFormat + ")";
                    } else {
                        showName = showName + "(" + downloadCount + ")";
                    }
                } else {
                    showName = showName + "(" + downloadCount + ")";
                }
            }
            int lineSize = this.getNameLabel(nameLabel, showName, false);
            int extraHeight = 0;
            extraHeightAll += extraHeight;
            nameLabel.setPreferredSize(new Dimension(200, 30));
            onePanel.add(nameLabel);
            String disText = oneBO.getCreaterName() + ("".equals(oneBO.getCreaterName()) ? "" : ",") + oneBO.getCreateDate() + "(" + FtpUtils.getFileSize(oneBO.getSize()) + ")";
            FMECustomLabel sizeLabel = new FMECustomLabel(disText);
            ((JComponent)sizeLabel).setToolTipText(FtpUtils.getFileSize(oneBO.getSize()));
            sizeLabel.setFocusable(true);
            sizeLabel.setPreferredSize(new Dimension(200, 30));
            sizeLabel.setHorizontalTextPosition(0);
            onePanel.add(sizeLabel);
            String uuid = "" + onePanel.hashCode();
            JButton renameB = new JButton("\u91cd\u547d\u540d");
            renameB.setVisible(false);
            renameB.setToolTipText(uuid);
            renameB.setVisible(false);
            renameB.addActionListener(this);
            onePanel.add(renameB);
            FMECustomLabel cancelDownloadLinkLabel = new FMECustomLabel("\u53d6\u6d88", false);
            cancelDownloadLinkLabel.setToolTipText(uuid);
            cancelDownloadLinkLabel.setVisible(false);
            cancelDownloadLinkLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    try {
                        FMECustomLabel fmecLable = (FMECustomLabel)e.getSource();
                        if (fmecLable.enabled) {
                            FMEUIPanel.this.cancelDownloadFile(((JLabel)e.getSource()).getToolTipText());
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            });
            onePanel.add(cancelDownloadLinkLabel);
            FMECustomLabel downloadLinkLabel = new FMECustomLabel("\u4fdd\u5b58", false);
            downloadLinkLabel.setToolTipText(uuid);
            downloadLinkLabel.setVisible(true);
            downloadLinkLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    try {
                        FMECustomLabel fmecLable = (FMECustomLabel)e.getSource();
                        if (fmecLable.enabled) {
                            FMEUIPanel.this.downloadFile(((JLabel)e.getSource()).getToolTipText());
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            });
            onePanel.add(downloadLinkLabel);
            FMECustomLabel openFileLinkLabel = new FMECustomLabel("\u6253\u5f00", false);
            openFileLinkLabel.setToolTipText(uuid);
            openFileLinkLabel.setVisible(true);
            openFileLinkLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    try {
                        FMECustomLabel fmecLable = (FMECustomLabel)e.getSource();
                        if (fmecLable.enabled) {
                            FMEUIPanel.this.openDownloadFile(((JLabel)e.getSource()).getToolTipText());
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            });
            onePanel.add(openFileLinkLabel);
            FMECustomLabel openFileLinkOnlineLabel = new FMECustomLabel("\u5728\u7ebf\u6253\u5f00", false);
            openFileLinkOnlineLabel.setToolTipText(uuid);
            openFileLinkOnlineLabel.setVisible(true);
            AbstractFMEUI fmeUP = (AbstractFMEUI)this.getParent();
            final int allowPrint = fmeUP.getParam().getAllowPrint();
            final int allowCopy = fmeUP.getParam().getAllowCopy();
            openFileLinkOnlineLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    try {
                        FMECustomLabel fmecLable = (FMECustomLabel)e.getSource();
                        if (fmecLable.enabled) {
                            FMEUIPanel.this.downloadFileForOpen(((JLabel)e.getSource()).getToolTipText(), allowPrint, allowCopy);
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            });
            onePanel.add(openFileLinkOnlineLabel);
            int allowDownload = fmeUP.getParam().getAllowDownload();
            if (allowDownload == 1) {
                downloadLinkLabel.setVisible(true);
            } else {
                downloadLinkLabel.setVisible(false);
            }
            int onlineOpen = fmeUP.getParam().getOnlineOpen();
            if (onlineOpen != 1) {
                openFileLinkLabel.setVisible(true);
                openFileLinkOnlineLabel.setVisible(false);
            } else {
                openFileLinkLabel.setVisible(false);
                if (FMEUIUtils.isOnlineOpenType(ft)) {
                    System.out.println("\u5f53\u524d\u6587\u4ef6\u7c7b\u578b\u652f\u6301\u5728\u7ebf\u6253\u5f00\uff0c\u5f53\u524d\u6587\u4ef6\u7c7b\u578b\u4e3a:" + ft);
                    openFileLinkOnlineLabel.setVisible(true);
                } else {
                    System.out.println("\u5f53\u524d\u6587\u4ef6\u7c7b\u578b\u4e0d\u652f\u6301\u5728\u7ebf\u6253\u5f00\uff0c\u5f53\u524d\u6587\u4ef6\u7c7b\u578b\u4e3a:" + ft);
                    openFileLinkOnlineLabel.setVisible(false);
                }
            }
            onePanel.add(new FMECustomLabel(""));
            onePanel.add(new FMECustomLabel(""));
            onePanel.setPreferredSize(new Dimension(600, 30 + extraHeight));
            this.gbdc.gridx = 0;
            this.gbdc.gridheight = 1;
            this.add((Component)onePanel, this.gbdc);
            this.fmeElement.put(uuid, onePanel);
            this.fmeExtraSize.put(uuid, new Integer(extraHeight));
            FMEFileElement oneElement = new FMEFileElement(uuid, oneBO.getName(), oneBO.getDisplayName(), "" + oneBO.getSize(), oneBO.getDocumentID());
            oneElement.setFileIndex(this.getNextOperFileCount());
            this.fmeValue.put(uuid, oneElement);
        }
        this.fileCount = boSize;
        this.reSizePanel(extraHeightAll);
        this.validate();
        this.repaint();
    }

    public int getNameLabel(JLabel jLabel1, String longString, boolean htmlType) {
        int labelRowCount = 1;
        StringBuffer builder = new StringBuffer();
        if (htmlType) {
            builder.append("<html>");
        }
        char[] chars = longString.toCharArray();
        FontMetrics fontMetrics = jLabel1.getFontMetrics(jLabel1.getFont());
        int beginIndex = 0;
        int limit = 1;
        while (true) {
            if (chars.length - beginIndex < limit) {
                System.out.println("\u6700\u6709\u4e00\u6279\u5b57\u7b26");
                limit = chars.length - beginIndex;
            }
            if ((double)fontMetrics.charsWidth(chars, beginIndex, limit) < jLabel1.getPreferredSize().getWidth()) {
                if (beginIndex + limit >= chars.length) {
                    break;
                }
            } else {
                builder.append(chars, beginIndex, limit - 1);
                if (htmlType) {
                    builder.append("<br></br>");
                } else {
                    builder.append("\r\n");
                }
                ++labelRowCount;
                beginIndex += limit - 1;
                limit = 1;
            }
            ++limit;
        }
        builder.append(chars, beginIndex, limit);
        if (htmlType) {
            builder.append("</html>");
        }
        String outStr = builder.toString();
        outStr = outStr.replaceAll("\n", "");
        outStr = outStr.replaceAll("\t", "");
        outStr = outStr.replaceAll("\r", "");
        System.out.println("\u8f93\u51fa\u7ed3\u679c\u4e3a\uff1a" + outStr);
        jLabel1.setText(outStr);
        return labelRowCount;
    }

    public void addOneFile(String filePath) throws Exception {
        long fileNumSize = FtpUtils.getFileNumberSize(filePath);
        String fileSize = FtpUtils.getFileSize(fileNumSize);
        String fileName = FtpUtils.getFileNameFromAbsolutePath(filePath);
        JPanel onePanel = new JPanel();
        onePanel.setBackground(Color.white);
        onePanel.setForeground(Color.white);
        String uuid = "" + onePanel.hashCode();
        FlowLayout fLT = new FlowLayout();
        fLT.setAlignment(0);
        onePanel.setLayout(fLT);
        String ft = FtpUtils.getFileType(filePath);
        if (this.iconMap != null) {
            if (this.iconMap.get(ft) != null) {
                this.selectDefineIcon(onePanel, this.iconMap.get(ft).toString());
            } else {
                this.selectIcon(onePanel, ft);
            }
        } else {
            this.selectIcon(onePanel, ft);
        }
        JLabel pathLabel = new JLabel(filePath);
        pathLabel.setFocusable(true);
        pathLabel.setPreferredSize(new Dimension(50, 30));
        pathLabel.setHorizontalTextPosition(0);
        pathLabel.setToolTipText(filePath);
        pathLabel.setVisible(false);
        onePanel.add(pathLabel);
        FMECustomLabel nameLabel = new FMECustomLabel();
        nameLabel.setFocusable(true);
        nameLabel.setPreferredSize(new Dimension(200, 30));
        nameLabel.setHorizontalTextPosition(0);
        int lineSize = this.getNameLabel(nameLabel, filePath, false);
        int extraHeight = 0;
        nameLabel.setPreferredSize(new Dimension(200, 30));
        ((JComponent)nameLabel).setToolTipText(filePath);
        nameLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int clickCount = e.getClickCount();
                if (clickCount == 2) {
                    try {
                        FMECustomLabel fmecLable = (FMECustomLabel)e.getSource();
                        if (fmecLable.enabled) {
                            FMEUIPanel.this.invokeSystemOpenFile(((JLabel)e.getSource()).getToolTipText());
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                FMEUIPanel.this.setCursor(Cursor.getPredefinedCursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                FMEUIPanel.this.setCursor(Cursor.getPredefinedCursor(0));
            }
        });
        onePanel.add(nameLabel);
        FMECustomLabel sizeLabel = new FMECustomLabel(fileSize);
        sizeLabel.setFocusable(true);
        sizeLabel.setPreferredSize(new Dimension(200, 30));
        sizeLabel.setHorizontalTextPosition(0);
        onePanel.add(sizeLabel);
        FMECustomLabel renameLinkLabel = new FMECustomLabel("\u91cd\u547d\u540d", false);
        renameLinkLabel.setToolTipText(uuid);
        renameLinkLabel.setVisible(false);
        renameLinkLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    FMECustomLabel fmecLable = (FMECustomLabel)e.getSource();
                    if (fmecLable.enabled) {
                        FMEUIPanel.this.renameServerFile(((JLabel)e.getSource()).getToolTipText());
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        onePanel.add(renameLinkLabel);
        FMECustomLabel deleteLinkLabel = new FMECustomLabel("\u5220\u9664", false);
        deleteLinkLabel.setToolTipText(uuid);
        deleteLinkLabel.setVisible(true);
        deleteLinkLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    int s;
                    FMECustomLabel fmecLable = (FMECustomLabel)e.getSource();
                    if (fmecLable.enabled && (s = JOptionPane.showConfirmDialog(null, "\u786e\u8ba4\u5220\u9664\u5417?", "\u5220\u9664\u9644\u4ef6\u786e\u8ba4", 0)) == 0) {
                        FMEUIPanel.this.removeElement(((JLabel)e.getSource()).getToolTipText());
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        onePanel.add(deleteLinkLabel);
        FMECustomLabel downloadLinkLabel = new FMECustomLabel("\u6253\u5f00", false);
        downloadLinkLabel.setToolTipText(uuid);
        downloadLinkLabel.setVisible(false);
        downloadLinkLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    FMECustomLabel fmecLable = (FMECustomLabel)e.getSource();
                    if (fmecLable.enabled) {
                        FMEUIPanel.this.openDownloadFile(((JLabel)e.getSource()).getToolTipText());
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        onePanel.add(downloadLinkLabel);
        FMECustomLabel vpLabel = new FMECustomLabel("");
        vpLabel.setFocusable(true);
        vpLabel.setPreferredSize(new Dimension(100, 30));
        onePanel.add(vpLabel);
        onePanel.setPreferredSize(new Dimension(600, 30 + extraHeight));
        this.gbdc.gridx = 0;
        this.gbdc.gridheight = 1;
        this.add((Component)onePanel, this.gbdc);
        ++this.fileCount;
        System.out.println("++++++++++++++++++++++++++++++++++++++\u589e\u52a0Panel\u5927\u5c0f\u4e3a:" + extraHeight);
        this.reSizePanel(extraHeight);
        this.fmeElement.put(uuid, onePanel);
        this.fmeExtraSize.put(uuid, new Integer(extraHeight));
        String blankDocumentID = "";
        FMEFileElement fileElement = new FMEFileElement(uuid, filePath, fileName, fileSize, blankDocumentID);
        fileElement.setIntSize(fileNumSize);
        fileElement.setFileIndex(this.getNextOperFileCount());
        this.fmeValue.put(uuid, fileElement);
        this.validate();
        this.repaint();
    }

    public void addOneFile(FMEFileElement fileEl) throws Exception {
        long fileNumSize = fileEl.getIntSize();
        String fileSize = fileEl.getSize();
        String filePath = fileEl.getPath();
        String fileName = fileEl.getName();
        JPanel onePanel = new JPanel();
        onePanel.setBackground(Color.white);
        onePanel.setForeground(Color.white);
        String uuid = "" + onePanel.hashCode();
        fileEl.setUuid(uuid);
        FlowLayout fLT = new FlowLayout();
        fLT.setAlignment(0);
        onePanel.setLayout(fLT);
        String ft = FtpUtils.getFileType(fileName);
        if (this.iconMap != null) {
            if (this.iconMap.get(ft) != null) {
                this.selectDefineIcon(onePanel, this.iconMap.get(ft).toString());
            } else {
                this.selectIcon(onePanel, ft);
            }
        } else {
            this.selectIcon(onePanel, ft);
        }
        JLabel pathLabel = new JLabel(filePath);
        pathLabel.setFocusable(true);
        pathLabel.setPreferredSize(new Dimension(50, 30));
        pathLabel.setHorizontalTextPosition(0);
        pathLabel.setToolTipText(filePath);
        pathLabel.setVisible(false);
        onePanel.add(pathLabel);
        FMECustomLabel nameLabel = new FMECustomLabel();
        nameLabel.setFocusable(true);
        nameLabel.setPreferredSize(new Dimension(200, 30));
        nameLabel.setHorizontalTextPosition(0);
        int lineSize = this.getNameLabel(nameLabel, filePath, false);
        int extraHeight = 0;
        nameLabel.setPreferredSize(new Dimension(200, 30));
        ((JComponent)nameLabel).setToolTipText(filePath);
        nameLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int clickCount = e.getClickCount();
                if (clickCount == 2) {
                    try {
                        FMECustomLabel fmecLable = (FMECustomLabel)e.getSource();
                        if (fmecLable.enabled) {
                            FMEUIPanel.this.invokeSystemOpenFile(((JLabel)e.getSource()).getToolTipText());
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                FMEUIPanel.this.setCursor(Cursor.getPredefinedCursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                FMEUIPanel.this.setCursor(Cursor.getPredefinedCursor(0));
            }
        });
        onePanel.add(nameLabel);
        FMECustomLabel sizeLabel = new FMECustomLabel(fileSize);
        sizeLabel.setFocusable(true);
        sizeLabel.setPreferredSize(new Dimension(200, 30));
        sizeLabel.setHorizontalTextPosition(0);
        onePanel.add(sizeLabel);
        FMECustomLabel renameLinkLabel = new FMECustomLabel("\u91cd\u547d\u540d", false);
        renameLinkLabel.setToolTipText(uuid);
        renameLinkLabel.setVisible(false);
        renameLinkLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    FMECustomLabel fmecLable = (FMECustomLabel)e.getSource();
                    if (fmecLable.enabled) {
                        FMEUIPanel.this.renameServerFile(((JLabel)e.getSource()).getToolTipText());
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        onePanel.add(renameLinkLabel);
        FMECustomLabel deleteLinkLabel = new FMECustomLabel("\u5220\u9664", false);
        deleteLinkLabel.setToolTipText(uuid);
        deleteLinkLabel.setVisible(true);
        deleteLinkLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    int s;
                    FMECustomLabel fmecLable = (FMECustomLabel)e.getSource();
                    if (fmecLable.enabled && (s = JOptionPane.showConfirmDialog(null, "\u786e\u8ba4\u5220\u9664\u5417?", "\u5220\u9664\u9644\u4ef6\u786e\u8ba4", 0)) == 0) {
                        FMEUIPanel.this.removeElement(((JLabel)e.getSource()).getToolTipText());
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        onePanel.add(deleteLinkLabel);
        FMECustomLabel downloadLinkLabel = new FMECustomLabel("\u6253\u5f00", false);
        downloadLinkLabel.setToolTipText(uuid);
        downloadLinkLabel.setVisible(false);
        downloadLinkLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    FMECustomLabel fmecLable = (FMECustomLabel)e.getSource();
                    if (fmecLable.enabled) {
                        FMEUIPanel.this.openDownloadFile(((JLabel)e.getSource()).getToolTipText());
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        onePanel.add(downloadLinkLabel);
        FMECustomLabel vpLabel = new FMECustomLabel("");
        vpLabel.setFocusable(true);
        vpLabel.setPreferredSize(new Dimension(100, 30));
        onePanel.add(vpLabel);
        onePanel.setPreferredSize(new Dimension(600, 30 + extraHeight));
        this.gbdc.gridx = 0;
        this.gbdc.gridheight = 1;
        this.add((Component)onePanel, this.gbdc);
        ++this.fileCount;
        System.out.println("++++++++++++++++++++++++++++++++++++++\u589e\u52a0Panel\u5927\u5c0f\u4e3a:" + extraHeight);
        this.reSizePanel(extraHeight);
        this.fmeElement.put(uuid, onePanel);
        this.fmeExtraSize.put(uuid, new Integer(extraHeight));
        this.fmeValue.put(uuid, fileEl);
        this.validate();
        this.repaint();
    }

    private void selectDefineIcon(JPanel onePanel, String ft) throws Exception {
        ft = ft.replaceAll("\\\\", "/");
        ImageIcon image = new ImageIcon(ft);
        onePanel.add(new JLabel(image));
    }

    private void reSizePanel(int extraSize) {
        this.extraHeightSum += extraSize;
        int okHeight = this.fileCount * 30 + this.extraHeightSum;
        System.out.println("############################extraHeightSum\u9ad8\u5ea6\u4e3a:" + this.extraHeightSum);
        System.out.println("############################Panel\u6700\u7ec8\u9ad8\u5ea6\u4e3a:" + okHeight);
        this.setPreferredSize(new Dimension(600, okHeight));
        Container ct = this.getParent();
        if (ct != null) {
            if (ct instanceof FMEUploadPanel) {
                ((FMEUploadPanel)ct).resizePanel(this.fileCount, okHeight);
            } else if (ct instanceof FMEDownloadPanel) {
                ((FMEDownloadPanel)ct).resizePanel(this.fileCount, okHeight);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src instanceof JButton) {
            JButton oneB = (JButton)src;
            String bName = oneB.getText();
            String bIndex = oneB.getToolTipText();
            if (bName.equalsIgnoreCase("\u5220\u9664")) {
                System.out.println("\u5220\u9664" + bIndex);
                this.removeElement(bIndex);
            } else if (bName.equalsIgnoreCase("\u91cd\u547d\u540d")) {
                System.out.println("\u91cd\u547d\u540d" + bIndex);
                this.renameServerFile(bIndex);
            } else if (bName.equalsIgnoreCase("\u4fdd\u5b58")) {
                System.out.println("\u6267\u884c\u4e0b\u8f7d" + bIndex);
                this.downloadFile(bIndex);
            }
        }
    }

    private void renameServerFile(String bIndex) {
        JPanel onePanel = this.fmeElement.get(bIndex);
        FMEFileElement ffe = (FMEFileElement)this.fmeValue.get(bIndex);
        this.renameTF = new JTextField(16);
        this.renameTF.setToolTipText(bIndex);
        String fileName = ffe.getName();
        System.out.println("\u8f93\u5165Txt is:" + fileName);
        this.renameTF.setText(fileName);
        this.renameTF.setSize(18, 35);
        this.renameTF.setEditable(true);
        JLabel nameL = (JLabel)onePanel.getComponent(2);
        nameL.setVisible(false);
        onePanel.add((Component)this.renameTF, 2);
        this.renameTF.setFocusable(true);
        this.renameTF.addFocusListener(this);
        this.renameTF.addMouseListener(this);
        this.renameTF.grabFocus();
        this.setRenameDisabled(bIndex);
    }

    public void setFMEFileElementDownloadPath(String bIndex, String downloadPath) {
        FMEFileElement fileEle = (FMEFileElement)this.fmeValue.get(bIndex);
        fileEle.setDownloadPath(downloadPath);
    }

    public void setFMEFileElementOpenDownloadFlag(String bIndex, boolean isOpenDownload) {
        FMEFileElement fileEle = (FMEFileElement)this.fmeValue.get(bIndex);
        fileEle.setOpenDownload(isOpenDownload);
    }

    private void downloadFile(String bIndex) {
        FMEFileElement fileEle = (FMEFileElement)this.fmeValue.get(bIndex);
        String fileName = fileEle.getName();
        String documentID = fileEle.getDocid();
        this.fmeElement.clearFMEPanelResultInfo(bIndex);
        System.out.println("\u9884\u4e0b\u8f7d\u7684\u6587\u4ef6\u4e3a:" + fileName + "---" + documentID);
        IFMEUI fmeUP = (IFMEUI)((Object)this.getParent());
        fmeUP.resetProgress();
        boolean beginDownload = fmeUP.downloadFile(bIndex, fileName, documentID);
        if (beginDownload) {
            this.changeDownloadOperLabel(bIndex, true);
        } else {
            System.out.println("\u4e0b\u8f7d\u6ca1\u6709\u9009\u62e9\u4fdd\u5b58\u76ee\u5f55\uff0c\u4e0d\u9700\u8981\u4e0b\u8f7d");
        }
    }

    private void downloadFileForOpen(String bIndex, String savePath) {
        FMEFileElement fileEle = (FMEFileElement)this.fmeValue.get(bIndex);
        String fileName = fileEle.getName();
        String documentID = fileEle.getDocid();
        String openFileName = savePath + FtpUtils.getDefaultDownloadFileName(bIndex, fileName);
        File openFile = new File(openFileName);
        if (fileEle.isDownloadFinished()) {
            System.out.println("\u8be5\u6587\u4ef6\u5df2\u7ecf\u4e0b\u8f7d\u5b8c\u6bd5\uff0c\u53ef\u4ee5\u76f4\u63a5\u6253\u5f00");
            if (!openFile.exists()) {
                fileEle.setDownloadFinished(false);
                System.out.println("\u4e0b\u8f7d\u6587\u4ef6\u88ab\u5220\u9664\uff0c\u8bbe\u7f6e\u72b6\u6001\u4e3a\u4e0b\u8f7d\u672a\u5b8c\u6210......");
            }
        } else if (openFile.exists()) {
            boolean removeHistoryFile = openFile.delete();
            System.out.println("\u5728\u7ebf\u6253\u5f00\u6587\u4ef6\uff0c\u53d1\u73b0\u4e34\u65f6\u76ee\u5f55\u4e2d\uff0c\u5b58\u5728\u5df2\u7ecf\u4fdd\u5b58\u8fc7\u7684\u6587\u4ef6\uff0c\u9700\u8981\u5220\u9664,\u5220\u9664\u7ed3\u679c\u4e3a\uff1a" + removeHistoryFile);
        }
        if (openFile.exists()) {
            System.out.println("========================\u6587\u4ef6\u5df2\u7ecf\u4e0b\u8f7d\u5b8c\u6bd5\uff0c\u76f4\u63a5\u6253\u5f00,\u9488\u5bf9\u540c\u540d\u6587\u4ef6\u5df2\u7ecf\u89e3\u51b3\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002");
            this.fmeElement.setFMEPanelResultInfo(bIndex, "");
            this.invokeSystemOpenFile(openFileName);
        } else {
            System.out.println("\u8bbe\u7f6e\u6253\u5f00\uff0c\u4e0b\u8f7d\u6587\u4ef6\u4e3a:==============================" + fileEle.getName());
            fileEle.setOpenDownload(true);
            this.fmeElement.clearFMEPanelResultInfo(bIndex);
            System.out.println("\u9884\u4e0b\u8f7d\u7684\u6587\u4ef6\u4e3a:" + fileName + "---" + documentID);
            IFMEUI fmeUP = (IFMEUI)((Object)this.getParent());
            fmeUP.resetProgress();
            boolean beginDownload = fmeUP.downloadFile(bIndex, fileName, documentID, savePath);
            if (beginDownload) {
                this.changeDownloadOperLabel(bIndex, true);
            } else {
                System.out.println("\u4e0b\u8f7d\u6ca1\u6709\u9009\u62e9\u4fdd\u5b58\u76ee\u5f55\uff0c\u4e0d\u9700\u8981\u4e0b\u8f7d");
            }
        }
    }

    private void openAudioFile(FMEFileElement fileEle, String businessID) throws Exception {
        String audioBusinessID = businessID;
        String audioDocumentID = fileEle.getDocid();
        System.out.println("-----------------------------------------------------------------");
        System.out.println("audioDocumentID is:" + audioDocumentID);
        FMEGetFtpConfigServiceAction fts = new FMEGetFtpConfigServiceAction(audioBusinessID, audioDocumentID, this.clientType);
        FtpConfig config = fts.getConfig();
        DocumentBO oneDocumentObject = fts.getDocumentByDocumentID();
        String audioFilePath = oneDocumentObject.getPath();
        System.out.println("audioFilePath is:" + audioFilePath);
        System.out.println("serverid is:" + oneDocumentObject.getServerID());
        String audioFileName = oneDocumentObject.getName();
        System.out.println("audioFileName is:" + audioFileName);
        System.out.println("-----------------------------------------------------------------");
        AbstractFMEUI fme = (AbstractFMEUI)this.getParent();
        if (config == null) {
            fme.getApplet().openFileFail();
        } else {
            String ftpUser = config.getUsername();
            String ftpPswd = config.getPassword();
            String serverHost = config.getHost();
            int serverPort = config.getPort();
            boolean isOnServer = fts.isOnServer(oneDocumentObject.getServerID(), audioFilePath, audioFileName);
            fme.getApplet().openAudioFile(ftpUser, ftpPswd, serverHost, serverPort, audioFilePath, audioFileName, isOnServer);
        }
    }

    private void downloadFileForOpen(String bIndex, int allowPrint, int allowCopy) {
        FMEFileElement fileEle = (FMEFileElement)this.fmeValue.get(bIndex);
        String fileName = fileEle.getName();
        String documentID = fileEle.getDocid();
        System.out.println("\u8bbe\u7f6e\u6253\u5f00\uff0c\u4e0b\u8f7d\u6587\u4ef6\u4e3a:==============================" + fileEle.getName());
        fileEle.setOpenDownload(true);
        this.fmeElement.clearFMEPanelResultInfo(bIndex);
        IFMEUI fmeUP = (IFMEUI)((Object)this.getParent());
        boolean isAudioFile = FMEUIUtils.isAudioFileType(fileName);
        if (isAudioFile) {
            System.out.println("\u5f53\u524d\u6253\u5f00\u6587\u4ef6\u662f\u89c6\u9891\u6587\u4ef6\uff0c\u5e94\u8be5\u8c03\u7528openAudioFile\u65b9\u6cd5");
            String businessID = fmeUP.getQueryBusinessID();
            System.out.println("\u83b7\u53d6businessID\u4e3a\uff1a" + businessID);
            try {
                this.openAudioFile(fileEle, businessID);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            System.out.println("\u9884\u4e0b\u8f7d\u7684\u6587\u4ef6\u4e3a:" + fileName + "---" + documentID);
            fmeUP.resetProgress();
            ServiceResult sr = fmeUP.downloadFileInServer(bIndex, fileName, documentID);
            if (sr != null) {
                String url;
                System.out.println("---------------online open onlien edit------------- :" + sr.getResultDetail());
                String clientTempPath = FMEUIUtils.replaceEscapeChar(FMEUIUtils.getClientTempDir() + fileName);
                AbstractFMEUI fme = (AbstractFMEUI)this.getParent();
                String path = url = sr.getResultDetail();
                url = null == url || "".equals(url.trim()) ? "" : FMEUIUtils.getLocationURL() + url.substring(url.indexOf("bs"));
                boolean isPrint = false;
                if (allowPrint == 1) {
                    isPrint = true;
                }
                boolean isCopy = false;
                if (allowCopy == 1) {
                    isCopy = true;
                }
                if (FMEUIUtils.isPdfFile(fileName)) {
                    System.out.println("\u5f53\u524d\u6253\u5f00\u7684\u662fPDF\u6587\u4ef6\uff0c\u8c03\u7528pdf\u6253\u5f00\u7a0b\u5e8f");
                    System.out.println("\u83b7\u53d6\u7684\u6253\u5f00\u8def\u5f84\u4e3a\uff1a" + path);
                    if (path == null || path.trim().length() == 0) {
                        fme.getApplet().openFileFail();
                    } else {
                        int fpos = path.indexOf("bs");
                        if (fpos != -1) {
                            path = path.substring(fpos - 1);
                        }
                        path = path.replaceAll("\\\\", "/");
                        fme.getApplet().openPdfFile(path, sr.isResult());
                    }
                } else if (FMEUIUtils.isSwfFile(fileName)) {
                    System.out.println("\u5f53\u524d\u6253\u5f00\u7684\u662fSWF\u6587\u4ef6\uff0c\u8c03\u7528swf\u6253\u5f00\u7a0b\u5e8f");
                    System.out.println("\u83b7\u53d6\u7684\u6253\u5f00\u8def\u5f84\u4e3a\uff1a" + path);
                    if (path == null || path.trim().length() == 0) {
                        fme.getApplet().openFileFail();
                    } else {
                        int fpos = path.indexOf("bs");
                        if (fpos != -1) {
                            path = path.substring(fpos - 1);
                        }
                        path = path.replaceAll("\\\\", "/");
                        fme.getApplet().openSwfFile(path, sr.isResult());
                    }
                } else {
                    fme.getApplet().openFile(url, documentID, clientTempPath, false, isPrint, isCopy, sr.isResult());
                }
            } else {
                System.out.println("\u4e0b\u8f7d\u5931\u8d25!");
            }
        }
    }

    private void downloadFileForOpenAndEdit(String bIndex, int allowPrint, int allowCopy) {
        FMEFileElement fileEle = (FMEFileElement)this.fmeValue.get(bIndex);
        String fileName = fileEle.getName();
        String documentID = fileEle.getDocid();
        String businessId = fileEle.getBusinessID();
        System.out.println("\u8bbe\u7f6e\u6253\u5f00\uff0c\u4e0b\u8f7d\u6587\u4ef6\u4e3a:==============================" + fileEle.getName());
        fileEle.setOpenDownload(true);
        IFMEUI fmeUP = (IFMEUI)((Object)this.getParent());
        this.fmeElement.clearFMEPanelResultInfo(bIndex);
        boolean isAudioFile = FMEUIUtils.isAudioFileType(fileName);
        ServiceResult sr = fmeUP.downloadFileInServer(bIndex, fileName, documentID);
        if (isAudioFile) {
            System.out.println("\u5f53\u524d\u6253\u5f00\u6587\u4ef6\u662f\u89c6\u9891\u6587\u4ef6\uff0c\u5e94\u8be5\u8c03\u7528openAudioFile\u65b9\u6cd5");
            String businessID = fmeUP.getQueryBusinessID();
            System.out.println("\u83b7\u53d6businessID\u4e3a\uff1a" + businessID);
            try {
                this.openAudioFile(fileEle, businessID);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            System.out.println("\u9884\u4e0b\u8f7d\u7684\u6587\u4ef6\u4e3a:" + fileName + "---" + documentID);
            fmeUP.resetProgress();
            if (sr != null) {
                String url;
                String clientTempPath = FMEUIUtils.replaceEscapeChar(FMEUIUtils.getClientTempDir() + fileName);
                AbstractFMEUI fme = (AbstractFMEUI)this.getParent();
                String path = url = sr.getResultDetail();
                url = null == url || "".equals(url.trim()) ? "" : FMEUIUtils.getLocationURL() + url.substring(url.indexOf("bs"));
                boolean isPrint = false;
                if (allowPrint == 1) {
                    isPrint = true;
                }
                boolean isCopy = false;
                if (allowCopy == 1) {
                    isCopy = true;
                }
                if (FMEUIUtils.isPdfFile(fileName)) {
                    System.out.println("\u5f53\u524d\u6253\u5f00\u7684\u662fPDF\u6587\u4ef6\uff0c\u8c03\u7528pdf\u6253\u5f00\u7a0b\u5e8f");
                    if (path == null || path.trim().length() == 0) {
                        fme.getApplet().openFileFail();
                    } else {
                        int fpos = path.indexOf("bs");
                        if (fpos != -1) {
                            path = path.substring(fpos - 1);
                        }
                        path = path.replaceAll("\\\\", "/");
                        fme.getApplet().openPdfFile(path, sr.isResult());
                    }
                } else {
                    fme.getApplet().openFile(url, documentID, clientTempPath, true, isPrint, isCopy, sr.isResult(), businessId);
                }
            } else {
                System.out.println("\u4e0b\u8f7d\u5931\u8d25!");
            }
        }
    }

    private void downloadFileForOpenNoProgress_old(String bIndex, String savePath) {
        FMEFileElement fileEle = (FMEFileElement)this.fmeValue.get(bIndex);
        String fileName = fileEle.getName();
        String documentID = fileEle.getDocid();
        String openFileName = savePath + FtpUtils.getDefaultDownloadFileName(bIndex, fileName);
        File openFile = new File(openFileName);
        if (fileEle.isDownloadFinished()) {
            System.out.println("\u8be5\u6587\u4ef6\u5df2\u7ecf\u4e0b\u8f7d\u5b8c\u6bd5\uff0c\u53ef\u4ee5\u76f4\u63a5\u6253\u5f00");
            if (!openFile.exists()) {
                fileEle.setDownloadFinished(false);
                System.out.println("\u4e0b\u8f7d\u6587\u4ef6\u88ab\u5220\u9664\uff0c\u8bbe\u7f6e\u72b6\u6001\u4e3a\u4e0b\u8f7d\u672a\u5b8c\u6210......");
            }
        } else if (openFile.exists()) {
            boolean removeHistoryFile = openFile.delete();
            System.out.println("\u5728\u7ebf\u6253\u5f00\u6587\u4ef6\uff0c\u53d1\u73b0\u4e34\u65f6\u76ee\u5f55\u4e2d\uff0c\u5b58\u5728\u5df2\u7ecf\u4fdd\u5b58\u8fc7\u7684\u6587\u4ef6\uff0c\u9700\u8981\u5220\u9664,\u5220\u9664\u7ed3\u679c\u4e3a\uff1a" + removeHistoryFile);
        }
        if (openFile.exists()) {
            System.out.println("========================\u6587\u4ef6\u5df2\u7ecf\u4e0b\u8f7d\u5b8c\u6bd5\uff0c\u76f4\u63a5\u6253\u5f00,\u9488\u5bf9\u540c\u540d\u6587\u4ef6\u5df2\u7ecf\u89e3\u51b3\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002");
            this.fmeElement.setFMEPanelResultInfo(bIndex, "");
            this.invokeSystemOpenFile(openFileName);
        } else {
            System.out.println("\u8bbe\u7f6e\u6253\u5f00\uff0c\u4e0b\u8f7d\u6587\u4ef6\u4e3a:==============================" + fileEle.getName());
            fileEle.setOpenDownload(true);
            this.fmeElement.clearFMEPanelResultInfo(bIndex);
            System.out.println("\u9884\u4e0b\u8f7d\u7684\u6587\u4ef6\u4e3a:" + fileName + "---" + documentID);
            IFMEUI fmeUP = (IFMEUI)((Object)this.getParent());
            fmeUP.resetProgress();
            boolean beginDownload = fmeUP.downloadFile(bIndex, fileName, documentID, savePath);
            if (beginDownload) {
                this.changeDownloadOperLabel(bIndex, true);
            } else {
                System.out.println("\u4e0b\u8f7d\u6ca1\u6709\u9009\u62e9\u4fdd\u5b58\u76ee\u5f55\uff0c\u4e0d\u9700\u8981\u4e0b\u8f7d");
            }
        }
    }

    private void openDownloadFile(String bIndex) {
        String tempDir = FMEUIUtils.getClientTempDir();
        System.out.println("\u4e34\u65f6\u4e0b\u8f7d\u8def\u5f84\u4e3a:" + tempDir);
        this.downloadFileForOpen(bIndex, tempDir);
    }

    private void openDownloadFileNoProgress_old(String bIndex) {
        String tempDir = FMEUIUtils.getClientTempDir();
        System.out.println("\u4e34\u65f6\u4e0b\u8f7d\u8def\u5f84\u4e3a:" + tempDir);
        this.downloadFileForOpenNoProgress_old(bIndex, tempDir);
    }

    private void invokeSystemOpenFile(String downloadFilePath) {
        try {
            FMEOpenFileAction action = new FMEOpenFileAction(downloadFilePath);
            Thread actionThread = new Thread(action);
            actionThread.start();
        }
        catch (Exception se) {
            System.out.println("\u6253\u5f00\u6587\u4ef6\u6267\u884c\u629b\u51fa\u5f02\u5e38:" + se.getMessage());
            se.printStackTrace();
        }
    }

    private void removeElement(String panelIndex) {
        JPanel onePanel = this.fmeElement.get(panelIndex);
        FMEFileElement ffElement = (FMEFileElement)this.fmeValue.get(panelIndex);
        boolean onServerFile = ffElement.isOnServer();
        boolean deleteResult = false;
        if (onServerFile) {
            String docID = ffElement.getDocid();
            System.out.println("\u4ece\u670d\u52a1\u5668\u4e0a\u5220\u9664\u6587\u4ef6: docID " + docID);
            IFMEUI fmeUP = (IFMEUI)((Object)this.getParent());
            int operType = fmeUP.getOperType();
            if (operType == 0 || operType == 2) {
                System.out.println("removeElement :\u5f53\u524d\u64cd\u4f5c\u7c7b\u578b\u4e3a:" + operType + "\u9700\u8981 \u5220\u9664\u670d\u52a1\u7aef\u6587\u4ef6\u5e94\u7528");
                deleteResult = fmeUP.removeServerFile(panelIndex, docID);
            } else if (operType == 1) {
                if (fmeUP.sameQueryAndNewBusinessID()) {
                    System.out.println("removeElement \u8f6c\u53d1\u72b6\u6001[\u6682\u5b58\u5904\u7406]\uff0cQueryBID,NewBID\u4e00\u81f4\uff0c\u9700\u8981 \u5220\u9664\u670d\u52a1\u7aef\u6587\u4ef6\u5e94\u7528");
                    deleteResult = fmeUP.removeServerFile(panelIndex, docID);
                } else {
                    System.out.println("removeElement :\u5f53\u524d\u64cd\u4f5c\u7c7b\u578b\u4e3a:" + operType + "\u4e0d\u9700\u8981 \u5220\u9664\u670d\u52a1\u7aef\u6587\u4ef6\u5e94\u7528");
                    deleteResult = true;
                }
            }
        } else {
            deleteResult = true;
            System.out.println("\u8be5\u6587\u4ef6\u4e0d\u505a\u670d\u52a1\u5668\u4e0a\uff0c\u4e0d\u9700\u8981\u670d\u52a1\u7aef\u5220\u9664");
        }
        System.out.println("\u9996\u5148\u4ece\u663e\u793a\u5217\u8868\u4e2d\u5220\u9664\u6587\u4ef6" + panelIndex);
        if (deleteResult) {
            this.remove(onePanel);
            this.fmeElement.remove(panelIndex);
            this.fmeValue.remove(panelIndex);
            --this.fileCount;
            if (this.fileCount == 0) {
                this.initOperFileCount();
                this.setPreferredSize(new Dimension(600, 30));
                System.out.println("\u6587\u4ef6\u5220\u9664\u4e3a0\uff0c\u505a\u6e05\u96f6\u64cd\u4f5c");
            }
            this.validate();
            this.repaint();
            Object fmeExtraValue = this.fmeExtraSize.get(panelIndex);
            if (fmeExtraValue != null) {
                int extraHeight = (Integer)fmeExtraValue;
                this.fmeExtraSize.remove(panelIndex);
                System.out.println("--------------------------------------------------Panel\u9ad8\u5ea6\u51cf\u5c11" + extraHeight);
                this.reSizePanel(-extraHeight);
            } else {
                System.out.println("\u5220\u9664\u754c\u9762\u64cd\u4f5c\u629b\u51fa\u5f02\u5e38\uff0c\u5b58\u5728\u95ee\u9898");
            }
        } else {
            System.out.println("\u5220\u9664\u6587\u4ef6\u5931\u8d25,\u8bf7\u544a\u77e5\u7cfb\u7edf\u7ba1\u7406\u5458");
            IFMEUI fmeUP = (IFMEUI)((Object)this.getParent());
            ServiceResult sr = new ServiceResult();
            sr.setResult(false, "\u5220\u9664\u6587\u4ef6\u5931\u8d25,\u8bf7\u544a\u77e5\u7cfb\u7edf\u7ba1\u7406\u5458");
            fmeUP.notifyServiceResult(sr);
        }
    }

    public FMEFileObject getUploadFileInfo() {
        Iterator iter = this.fmeValue.keySet().iterator();
        ArrayList<NeedOperObject> operObjArray = new ArrayList<NeedOperObject>();
        while (iter.hasNext()) {
            String oneKey = (String)iter.next();
            FMEFileElement fileElement = (FMEFileElement)this.fmeValue.get(oneKey);
            if (fileElement.isOnServer()) continue;
            NeedOperObject oneOperObj = new NeedOperObject(fileElement);
            operObjArray.add(oneOperObj);
        }
        int fileSize = operObjArray.size();
        Object[] needOperObjArray = new NeedOperObject[fileSize];
        operObjArray.toArray(needOperObjArray);
        Arrays.sort(needOperObjArray);
        FMEFileObject fuObj = new FMEFileObject(fileSize);
        for (int i = 0; i < needOperObjArray.length; ++i) {
            fuObj.addFileInfo(i, ((NeedOperObject)needOperObjArray[i]).getFfElement());
        }
        return fuObj;
    }

    public JSONArray getUploadFileInfo_JSON() {
        Iterator iter = this.fmeValue.keySet().iterator();
        JSONArray operObjArray = new JSONArray();
        while (iter.hasNext()) {
            String oneKey = (String)iter.next();
            FMEFileElement fileElement = (FMEFileElement)this.fmeValue.get(oneKey);
            if (fileElement.isOnServer()) continue;
            operObjArray.put(fileElement.toJSON().toString());
        }
        return operObjArray;
    }

    public FMEFileObject getReplyFileInfo(String newBusinessID) {
        ArrayList<FMEFileElement> needReplyFile = new ArrayList<FMEFileElement>();
        for (String oneKey : this.fmeValue.keySet()) {
            FMEFileElement fileElement = (FMEFileElement)this.fmeValue.get(oneKey);
            if (!fileElement.isOnServer()) continue;
            String businessID = fileElement.getBusinessID();
            String docID = fileElement.getDocid();
            System.out.println("\u67e5\u8be2BID is:" + businessID);
            System.out.println("\u65b0\u589eBID is:" + newBusinessID);
            System.out.println("docID is:" + docID);
            if (newBusinessID.equals(businessID)) {
                if (FtpUtils.isBlankString(docID)) {
                    System.out.println("\u65b0\u589e\u6587\u4ef6" + businessID + "\uff0c\u4e2d\u9014\u88ab\u4e2d\u6b62\uff0c\u9700\u8981\u91cd\u65b0\u4fdd\u5b58\u4e86");
                    needReplyFile.add(fileElement);
                    continue;
                }
                System.out.println("\u540c\u4e00BusinessID\u7684\u4e1a\u52a1\uff0c\u4e0d\u9700\u8981\u91cd\u65b0\u4fdd\u5b58\u4e86");
                continue;
            }
            System.out.println("\u4e0d\u540c\u4e00BusinessID\u7684\u4e1a\u52a1\u7684\u5f15\u7528\uff0c\u9700\u8981\u91cd\u65b0\u751f\u4ea7BusiDoc\u8bb0\u5f55");
            fileElement.setBusinessID(newBusinessID);
            needReplyFile.add(fileElement);
        }
        int fileSize = needReplyFile.size();
        FMEFileObject fuObj = new FMEFileObject(fileSize);
        for (int i = 0; i < fileSize; ++i) {
            fuObj.addFileInfo(i, (FMEFileElement)needReplyFile.get(i));
        }
        return fuObj;
    }

    public int getWaitingUploadFileCount() {
        int wuFCount = 0;
        for (String oneKey : this.fmeValue.keySet()) {
            FMEFileElement fileElement = (FMEFileElement)this.fmeValue.get(oneKey);
            if (fileElement.isOnServer()) continue;
            ++wuFCount;
        }
        return wuFCount;
    }

    public void updateUploadInfo(String uuid, String percentValue, String velocityValue) {
        JPanel updateP = this.fmeElement.get(uuid);
        int comCount = updateP.getComponentCount();
        if (comCount >= 8) {
            ((JLabel)updateP.getComponent(7)).setText(percentValue + "(" + velocityValue + ")");
            FMEFileElement ffElement = (FMEFileElement)this.fmeValue.get(uuid);
            if (percentValue.equalsIgnoreCase("100%")) {
                System.out.println("\u64cd\u4f5c\u8fbe\u5230100%\u7684\u6587\u4ef6\u4e3a\uff1a=====================" + ffElement.getName());
                ((JLabel)updateP.getComponent(7)).setText(percentValue);
                JLabel nameLabel = (JLabel)updateP.getComponent(2);
                String nameTextValue = ((FMEFileElement)this.fmeValue.get(uuid)).getName();
                nameLabel.setHorizontalTextPosition(0);
                int lineSize = this.getNameLabel(nameLabel, nameTextValue, false);
                int extraHeight = 0;
                nameLabel.setPreferredSize(new Dimension(200, 30));
                updateP.setPreferredSize(new Dimension(600, 30 + extraHeight));
                this.fmeExtraSize.put(uuid, new Integer(extraHeight));
                this.reSizePanel(extraHeight);
                ((FMEFileElement)this.fmeValue.get(uuid)).setOnServer(true);
                if (this.panelType == 0) {
                    JLabel iconP = (JLabel)updateP.getComponent(0);
                    updateP.getComponent(4).setVisible(true);
                }
            }
            this.validate();
            this.repaint();
        }
    }

    public void updateDownInfo(String uuid, String percentValue, String velocityValue) {
        this.updateDownInfo(uuid, percentValue, velocityValue, "");
    }

    public void updateDownInfo(String uuid, String percentValue, String velocityValue, String donwResultInfo) {
        JPanel updateP = this.fmeElement.get(uuid);
        int comCount = updateP.getComponentCount();
        if (comCount >= 10) {
            ((JLabel)updateP.getComponent(9)).setText(percentValue + "(" + velocityValue + ")");
            FMEFileElement ffElement = (FMEFileElement)this.fmeValue.get(uuid);
            if (percentValue.equalsIgnoreCase("100%")) {
                System.out.println("\u4e0b\u8f7d\u6587\u4ef6\u8fbe\u5230100%\u7684\u6587\u4ef6\u4e3a\uff1a=====================" + ffElement.getName());
                ffElement.setDownloadFinished(true);
                ((JLabel)updateP.getComponent(9)).setText(percentValue);
                ((JLabel)updateP.getComponent(10)).setVisible(true);
                boolean isOpenDownload = ffElement.isOpenDownload();
                System.out.println("\u662f\u5426\u662f\u6253\u5f00\u4e0b\u8f7d\u5b8c\u6210\u72b6\u6001\uff1a" + isOpenDownload);
                if (!isOpenDownload) {
                    ((JLabel)updateP.getComponent(10)).setText("\u4fdd\u5b58\u5b8c\u6210!");
                } else {
                    ((JLabel)updateP.getComponent(10)).setText("");
                }
                String downloadFilePath = ffElement.getDownloadPath();
                System.out.println("&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&\u5f53\u524d\u6587\u4ef6\u72b6\u6001\u4e3aisOpenDownload:" + isOpenDownload);
                if (isOpenDownload) {
                    System.out.println("&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&\u9884\u6253\u5f00\u7684\u6587\u4ef6\u5927\u5c0f\u4e3a\uff1a" + downloadFilePath);
                    this.invokeSystemOpenFile(downloadFilePath);
                    ffElement.setOpenDownload(false);
                }
                this.changeDownloadOperLabel(uuid, false);
            }
            if (percentValue.equalsIgnoreCase("-1%")) {
                System.out.println("***********************************************\u4e0b\u8f7d\u5931\u8d25\u4e86");
                ((JLabel)updateP.getComponent(9)).setText("");
                ((JLabel)updateP.getComponent(10)).setVisible(true);
                ((JLabel)updateP.getComponent(10)).setText(donwResultInfo);
                this.changeDownloadOperLabel(uuid, false);
            }
            this.validate();
            this.repaint();
            this.changeDownloadOperLabel(uuid, false);
        } else {
            System.out.println("----------------------------------------comCount :---------------------------" + comCount + "<10");
        }
    }

    public void setUploadFileResult(String[] fileIndex, String[] fileDocumentID, String businessID) {
        if (fileDocumentID == null) {
            System.out.println("\u5f53\u524d\u4e0d\u9700\u8981\u66f4\u65b0,\u4e3a\u5df2\u7ecf\u4e0a\u4f20\u7684");
            return;
        }
        for (int i = 0; i < fileIndex.length; ++i) {
            FMEFileElement oneFmeValue;
            String oneIndex = fileIndex[i];
            if (fileDocumentID.length < i) break;
            String fileDocID = fileDocumentID[i];
            if (fileDocID == null) {
                System.out.println("setUploadFileResult=====================--------------------)))))))))))))))))\u8be5ID\u5bf9\u5e94\u7684\u6587\u4ef6\u88ab\u53d6\u6d88\u4e0a\u4f20\u4e86");
                fileDocID = "";
            }
            if ((oneFmeValue = (FMEFileElement)this.fmeValue.get(oneIndex)) != null) {
                oneFmeValue.setDocid(fileDocID);
                oneFmeValue.setBusinessID(businessID);
                if (FtpUtils.isBlankString(fileDocID)) {
                    System.out.println("\u8be5\u6587\u4ef6\u5c5e\u4e8e\u88ab\u4e2d\u6b62\u6587\u4ef6\uff0c\u4e0d\u9700\u8981\u66f4\u65b0");
                    oneFmeValue.setOnServer(false);
                    continue;
                }
                oneFmeValue.setOnServer(true);
                continue;
            }
            System.out.println("\u9884\u8bbe\u7f6e\u7684fmeValue\u4e0d\u5b58\u5728\u7a7aDocumentID");
        }
    }

    public int getPanelType() {
        return this.panelType;
    }

    public void setPanelType(int panelType) {
        this.panelType = panelType;
    }

    public int getOpenFileType() {
        return this.openFileType;
    }

    public void setOpenFileType(int openFileType) {
        this.openFileType = openFileType;
    }

    public String getUploadFileJSONInfo() {
        StringBuffer sb = new StringBuffer();
        int fileCount = 0;
        long allSize = 0L;
        ArrayList<FMEFileElement> hasUploadFile = new ArrayList<FMEFileElement>();
        for (String oneKey : this.fmeValue.keySet()) {
            FMEFileElement fileElement = (FMEFileElement)this.fmeValue.get(oneKey);
            if (!fileElement.isOnServer()) continue;
            hasUploadFile.add(fileElement);
            ++fileCount;
            allSize += fileElement.getIntSize();
        }
        sb.append("{'").append("count':'").append(fileCount).append("',").append("'size':'").append(FtpUtils.getFileSize(allSize)).append("'}");
        return sb.toString();
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        Object src = e.getSource();
        if (src == this.renameTF) {
            System.out.println("renameTF\u5931\u53bb\u7126\u70b9");
            if (this.renameTF.isVisible()) {
                this.doRenameOperation();
            }
        }
    }

    private void doRenameOperation() {
        String newName = this.renameTF.getText();
        String bIndex = this.renameTF.getToolTipText();
        JPanel onePanel = this.fmeElement.get(bIndex);
        FMEFileElement ffe = (FMEFileElement)this.fmeValue.get(bIndex);
        String fileName = ffe.getName();
        System.out.println("\u8f93\u5165Txt is:" + fileName);
        IFMEUI fmeUP = (IFMEUI)((Object)this.getParent());
        if (FtpUtils.isBlankString(newName)) {
            newName = fileName;
            fmeUP.showFMEMessage("\u91cd\u547d\u540d\u540d\u79f0\u4e3a\u7a7a\u65e0\u6548\uff01");
        } else {
            int fileNameLength = newName.length();
            if (fileNameLength > 255) {
                newName = FtpUtils.getSuitableFileName(newName);
                fmeUP.showFMEMessage("\u6587\u4ef6\u540d\u8d85\u8fc7\u6700\u5927\u957f\u5ea6\u9650\u5236\uff0c\u81ea\u52a8\u622a\u53d6\u5230255\u4e2a\u5b57\u7b26");
            } else {
                fmeUP.showFMEMessage("");
            }
        }
        if (fileName.equalsIgnoreCase(newName)) {
            System.out.println("\u6587\u4ef6\u540d\u76f8\u540c\uff0c\u4e0d\u9700\u8981\u91cd\u547d\u540d");
        } else {
            System.out.println("\u6587\u4ef6\u540d\u4e0d\u76f8\u540c\uff0c\u9700\u8981\u91cd\u547d\u540d");
            ffe.setName(newName);
            String docID = ffe.getDocid();
            System.out.println("\u91cd\u547d\u540d\u4e0d\u9700\u8981\u63d0\u4ea4\u670d\u52a1\u7aef\uff0c\u53ea\u9488\u5bf9\u8f6c\u53d1\u4f7f\u7528");
            String renameResult = fmeUP.renameServerFile(bIndex, docID, newName);
            System.out.println("\u91cd\u547d\u540d\u6587\u4ef6:" + newName + " \u7ed3\u679c\u4e3a:" + renameResult);
        }
        JLabel nameLabel = (JLabel)onePanel.getComponent(3);
        nameLabel.setVisible(true);
        nameLabel.setPreferredSize(new Dimension(200, 30));
        nameLabel.setHorizontalTextPosition(0);
        int lineSize = this.getNameLabel(nameLabel, newName, false);
        System.out.println("\u5f53\u524d\u5b57\u8282\u884c\u6570\u4e3a:" + lineSize);
        int extraHeight = 0;
        nameLabel.setPreferredSize(new Dimension(200, 30));
        this.renameTF.setVisible(false);
        onePanel.remove(this.renameTF);
        onePanel.setPreferredSize(new Dimension(600, 30));
        int adjustHeight = 0;
        this.fmeExtraSize.put(bIndex, new Integer(extraHeight));
        this.reSizePanel(adjustHeight);
        this.validate();
        this.repaint();
        this.setEnabled();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        Object clickObj = e.getSource();
        if (clickObj != null && this.renameTF != null && clickObj != this.renameTF && this.renameTF != null && this.renameTF.isVisible()) {
            System.out.println("\u6267\u884c\u91cd\u547d\u540d\u64cd\u4f5c");
            this.doRenameOperation();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    public void cancelDownloadFile(String index) {
        IFMEUI fmeUP = (IFMEUI)((Object)this.getParent());
        fmeUP.stopProgress();
        this.changeDownloadOperLabel(index, false);
    }

    public void changeDownloadOperLabel(String index, boolean downloading) {
        JPanel downloadPanel = this.fmeElement.get(index);
        JLabel cancelDownloadLabel = (JLabel)downloadPanel.getComponent(5);
        cancelDownloadLabel.setVisible(downloading);
        JLabel downloadLabel = (JLabel)downloadPanel.getComponent(6);
        AbstractFMEUI fmeUP = (AbstractFMEUI)this.getParent();
        int allowDownload = fmeUP.getParam().getAllowDownload();
        if (1 == allowDownload) {
            String allowDelete = fmeUP.getParam().getAllowDelete();
            if (null == allowDelete) {
                downloadLabel.setVisible(!downloading);
            } else {
                int comCount = this.getComponentCount();
                if (comCount > 0) {
                    for (int i = 0; i < comCount; ++i) {
                        JPanel onePanel = (JPanel)this.getComponent(i);
                        if (null == onePanel.getComponent(6)) {
                            downloadLabel.setVisible(!downloading);
                            break;
                        }
                        FMECustomLabel downloadFMECLabel = (FMECustomLabel)onePanel.getComponent(6);
                        String currentUUID = downloadFMECLabel.getToolTipText();
                        if (!currentUUID.equals(index)) continue;
                        downloadLabel.setVisible('1' == allowDelete.charAt(i));
                        break;
                    }
                }
            }
        }
        FMECustomLabel openFileFMECLabel = (FMECustomLabel)downloadPanel.getComponent(7);
        if (downloading) {
            openFileFMECLabel.setDisabled();
        } else {
            openFileFMECLabel.setEnabled();
        }
        if (downloading) {
            this.disableOtherDownloadLabel(index);
        } else {
            this.enabelOtherDownloadLabel(index);
        }
    }

    public void disableOtherDownloadLabel(String index) {
        int comCount = this.getComponentCount();
        if (comCount > 0) {
            for (int i = 0; i < comCount; ++i) {
                JPanel onePanel = (JPanel)this.getComponent(i);
                FMECustomLabel downloadFMECLabel = (FMECustomLabel)onePanel.getComponent(6);
                FMECustomLabel openFileFMECLabel = (FMECustomLabel)onePanel.getComponent(7);
                String currentUUID = downloadFMECLabel.getToolTipText();
                if (currentUUID.equals(index)) continue;
                downloadFMECLabel.setDisabled();
                openFileFMECLabel.setDisabled();
            }
        }
    }

    public void enabelOtherDownloadLabel(String index) {
        int comCount = this.getComponentCount();
        if (comCount > 0) {
            for (int i = 0; i < comCount; ++i) {
                JPanel onePanel = (JPanel)this.getComponent(i);
                FMECustomLabel downloadFMECLabel = (FMECustomLabel)onePanel.getComponent(6);
                FMECustomLabel openFileFMECLabel = (FMECustomLabel)onePanel.getComponent(7);
                String currentUUID = downloadFMECLabel.getToolTipText();
                if (currentUUID.equals(index)) continue;
                downloadFMECLabel.setEnabled();
                openFileFMECLabel.setEnabled();
            }
        }
    }

    public void setRenameDisabled(String bIndex) {
        int comCount = this.getComponentCount();
        if (comCount > 0) {
            for (int i = 0; i < comCount; ++i) {
                FMECustomLabel downloadFMECLabel;
                FMECustomLabel deleteFMECLabel;
                FMECustomLabel renameFMECLabel;
                JPanel onePanel = (JPanel)this.getComponent(i);
                FMECustomLabel oneFMECLabel = (FMECustomLabel)onePanel.getComponent(5);
                String currentUUID = oneFMECLabel.getToolTipText();
                if (currentUUID.equals(bIndex)) {
                    renameFMECLabel = (FMECustomLabel)onePanel.getComponent(5);
                    renameFMECLabel.setDisabled();
                    deleteFMECLabel = (FMECustomLabel)onePanel.getComponent(6);
                    deleteFMECLabel.setDisabled();
                    downloadFMECLabel = (FMECustomLabel)onePanel.getComponent(7);
                    downloadFMECLabel.setDisabled();
                    continue;
                }
                renameFMECLabel = (FMECustomLabel)onePanel.getComponent(4);
                renameFMECLabel.setDisabled();
                deleteFMECLabel = (FMECustomLabel)onePanel.getComponent(5);
                deleteFMECLabel.setDisabled();
                downloadFMECLabel = (FMECustomLabel)onePanel.getComponent(6);
                downloadFMECLabel.setDisabled();
            }
        }
    }

    public void setDisabled() {
        int comCount = this.getComponentCount();
        if (comCount > 0) {
            for (int i = 0; i < comCount; ++i) {
                JPanel onePanel = (JPanel)this.getComponent(i);
                FMECustomLabel renameFMECLabel = (FMECustomLabel)onePanel.getComponent(4);
                renameFMECLabel.setDisabled();
                FMECustomLabel deleteFMECLabel = (FMECustomLabel)onePanel.getComponent(5);
                deleteFMECLabel.setDisabled();
                FMECustomLabel downloadFMECLabel = (FMECustomLabel)onePanel.getComponent(6);
                downloadFMECLabel.setDisabled();
                if (onePanel.getComponentCount() < 10) continue;
                FMECustomLabel openFMECLabel = (FMECustomLabel)onePanel.getComponent(7);
                openFMECLabel.setDisabled();
            }
        }
    }

    public void setEnabled() {
        int comCount = this.getComponentCount();
        if (comCount > 0) {
            for (int i = 0; i < comCount; ++i) {
                JPanel onePanel = (JPanel)this.getComponent(i);
                FMECustomLabel renameFMECLabel = (FMECustomLabel)onePanel.getComponent(4);
                renameFMECLabel.setEnabled();
                FMECustomLabel deleteFMECLabel = (FMECustomLabel)onePanel.getComponent(5);
                deleteFMECLabel.setEnabled();
                FMECustomLabel downloadFMECLabel = (FMECustomLabel)onePanel.getComponent(6);
                downloadFMECLabel.setEnabled();
                if (onePanel.getComponentCount() < 10) continue;
                FMECustomLabel openFMECLabel = (FMECustomLabel)onePanel.getComponent(7);
                openFMECLabel.setEnabled();
            }
        }
    }

    public long getAllFileSize() {
        long allFileSize = 0L;
        for (String oneKey : this.fmeValue.keySet()) {
            FMEFileElement oneElement = (FMEFileElement)this.fmeValue.get(oneKey);
            long oneSize = oneElement.getIntSize();
            allFileSize += oneSize;
        }
        return allFileSize;
    }

    public void addFileElement(FMEFileElement oneFileElement) throws Exception {
        this.addOneFile(oneFileElement);
    }
}

