/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.fme.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class FMEDataZipUtils {
    public static final float GZIPFACTOR = 0.75f;
    public static final String MAGICCODE = "###PACKER4.0.1###";

    public static byte[] pack(byte[] source) throws IOException {
        return FMEDataZipUtils.pack(source, 0.75f);
    }

    public static byte[] pack(byte[] source, float factor) throws IOException {
        if (source == null || source.length < 1) {
            return null;
        }
        if (factor < 0.1f) {
            factor = 0.75f;
        }
        float initCapacity = (float)source.length * Math.min(factor, 1.0f);
        ByteArrayOutputStream bout = new ByteArrayOutputStream((int)initCapacity);
        FMEDataZipUtils.writeMagic(bout, source.length);
        GZIPOutputStream zout = new GZIPOutputStream(bout);
        zout.write(source, 0, source.length);
        zout.close();
        bout.close();
        return bout.toByteArray();
    }

    public static byte[] UnDataZip(byte[] data) throws IOException {
        ByteArrayOutputStream newData = new ByteArrayOutputStream();
        if (data == null || data.length == 0) {
            return null;
        }
        ByteArrayInputStream i = new ByteArrayInputStream(data);
        GZIPInputStream gzin = new GZIPInputStream(i);
        Object tempFile = null;
        int b = 0;
        byte[] bufferByte = new byte[1024];
        while (gzin.available() == 1) {
            b = gzin.read(bufferByte);
            if (b <= 0) continue;
            newData.write(bufferByte, 0, b);
        }
        return newData.toByteArray();
    }

    public static byte[] unpack(byte[] source) throws IOException {
        int len;
        if (source == null || source.length < 1) {
            return null;
        }
        ByteArrayInputStream bin = new ByteArrayInputStream(source);
        int count = FMEDataZipUtils.readMagic(bin);
        if (count == Integer.MAX_VALUE) {
            bin.close();
            return source;
        }
        if (count < 1) {
            bin.close();
            return null;
        }
        GZIPInputStream zin = new GZIPInputStream(bin);
        byte[] res = new byte[count];
        int num = 0;
        while ((len = count - num) >= 0) {
            int n;
            if (len > 4096) {
                len = 4096;
            }
            if ((n = zin.read(res, num, len)) <= 0) break;
            num += n;
        }
        zin.close();
        bin.close();
        return num != count ? null : res;
    }

    private static boolean writeMagic(ByteArrayOutputStream output, int size) throws IOException {
        if (output == null) {
            return false;
        }
        int len = MAGICCODE.length();
        byte[] magic = new byte[len];
        for (int m = 0; m < len; ++m) {
            magic[m] = (byte)MAGICCODE.charAt(m);
        }
        output.write(magic);
        for (int i = 3; i >= 0; --i) {
            output.write(size >> i * 8 & 0xFF);
        }
        return true;
    }

    private static int readMagic(ByteArrayInputStream input) {
        if (input == null) {
            return 0;
        }
        int len = MAGICCODE.length();
        for (int m = 0; m < len; ++m) {
            if (MAGICCODE.charAt(m) == (char)input.read()) continue;
            return Integer.MAX_VALUE;
        }
        int res = 0;
        for (int i = 0; i < 4; ++i) {
            int sz = input.read();
            if (sz < 0) {
                return 0;
            }
            if (i > 0) {
                res <<= 8;
            }
            res |= sz;
        }
        return res;
    }
}

