/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.fme.util;

import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ObjectMultiPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.fme.util.FMEUuid;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.Base64Encoder;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FMEUtils {
    private static final Log log = LogFactory.getLog(FMEUtils.class);
    private static final long RANDOM_SEED = 999999L;
    private static long lastRandomLongValue;
    private static final String DEFAULT_FILE_EXT_NAME = ".tmp";
    public static final String COMMON_DATE_DATE = "yyyy-MM-dd";
    public static final String COMMON_DATE_TIMESTAMP = "yyyy-MM-dd kk:mm:ss";
    private static final int BASE64_ENCODING_LENGTH = 44;
    public static final String DEAULT_UNDEFINED_EXT_NAME = "udd";
    public static final String TEST_NULL_CONTEXT_USERID = "TestNullContextUserID";

    public static String formatDateValue(Date dateObj, String parseStr) {
        String dateString = "";
        SimpleDateFormat sdf = new SimpleDateFormat(parseStr);
        dateString = sdf.format(dateObj);
        return dateString;
    }

    public static Date getToday() {
        return FMEUtils.getCurrrentDate();
    }

    public static String getTodayString() {
        return FMEUtils.formatDateValue(FMEUtils.getToday(), COMMON_DATE_TIMESTAMP);
    }

    public static String getIntString(int iValue, int width) {
        StringBuffer sb = new StringBuffer();
        String iVStr = "" + iValue;
        for (int i = iVStr.length(); i < width; ++i) {
            sb.append("0");
        }
        sb.append(iValue);
        return sb.toString();
    }

    public static String getRandomFileName(String fileExtName) {
        Random rd = new Random(999999L);
        Calendar cd = Calendar.getInstance();
        if (fileExtName == null || fileExtName.trim().length() <= 0) {
            fileExtName = DEFAULT_FILE_EXT_NAME;
        }
        return "" + rd.nextLong() + cd.getTimeInMillis() + "." + fileExtName;
    }

    public static String getRandomPathName(String pathID) {
        String randomPath = FMEUtils.getSimpleUUIDString(pathID);
        randomPath = randomPath.replaceAll("\\/", "P");
        return randomPath;
    }

    public static String getRandomIconName() {
        BOSUuid documentIconid = BOSUuid.create((String)"DDD88DDD");
        String randomIconName = FMEUtils.getSimpleUUIDString(documentIconid.toString());
        randomIconName = randomIconName.replaceAll("\\/", "P");
        return randomIconName;
    }

    public static String getSimpleUUIDString(String type) {
        String uuidStr = "";
        try {
            FMEUuid uuid = FMEUuid.randomUUID();
            ByteArrayOutputStream baos = new ByteArrayOutputStream(44);
            DataOutputStream out = new DataOutputStream(baos);
            try {
                out.writeLong(uuid.getMostSignificantBits());
                out.writeLong(uuid.getLeastSignificantBits());
                out.writeInt(type.hashCode());
            }
            catch (IOException ioe) {
                throw new Exception(ioe);
            }
            uuidStr = Base64Encoder.byteArrayToBase64((byte[])baos.toByteArray());
        }
        catch (Exception se) {
            System.out.println("FMEUIUtils\u521b\u5efa SimpleUUID\u629b\u51fa\u5f02\u5e38:" + se.getMessage());
        }
        return uuidStr;
    }

    public static long getRandomFileSize() {
        Random rd = null;
        rd = lastRandomLongValue == 0L ? new Random(999999L) : new Random(lastRandomLongValue);
        Random rd2 = new Random(rd.nextLong());
        lastRandomLongValue = rd2.nextLong();
        return lastRandomLongValue;
    }

    public static IObjectPK getObjectPK(String keyField, String keyValue) {
        ObjectMultiPK onePK = new ObjectMultiPK();
        onePK.setKeyValue(keyField, (Object)keyValue);
        return onePK;
    }

    public static IObjectPK[] getObjectPKArray(String[] keyFieldArray, Object[] keyValueArray) {
        int keyLength = keyFieldArray.length;
        ObjectMultiPK[] pkArray = new ObjectMultiPK[keyLength];
        for (int i = 0; i < keyLength; ++i) {
            pkArray[i] = new ObjectMultiPK();
            pkArray[i].setKeyValue(keyFieldArray[i], keyValueArray[i]);
        }
        return pkArray;
    }

    public static void printObjectPK(IObjectPK[] dpk) {
        for (int i = 0; i < dpk.length; ++i) {
            IObjectPK onepk = dpk[i];
            String[] keyfields = onepk.getKeyFields();
            for (int j = 0; j < keyfields.length; ++j) {
                String oneKey = keyfields[j];
                System.out.println("The " + i + " PK No " + j + " key  is:" + oneKey + "----" + onepk.getKeyValue(oneKey));
            }
        }
    }

    public static Date getCurrrentDate() {
        return Calendar.getInstance().getTime();
    }

    public static Context getWebContext2() {
        Context ctx;
        block4: {
            ctx = null;
            try {
                try {
                    ctx = ContextUtils.getContextFromSession();
                }
                catch (Exception se) {
                    System.out.println("\u4eceWafContext\u83b7\u53d6 Context\u629b\u51fa\u5f02\u5e38:" + se.getMessage());
                }
            }
            catch (Exception se) {
                System.out.println("\u4eceContextUtils \u4e2d\u83b7\u53d6\u4e0a\u4e0b\u6587\u629b\u51fa\u5f02\u5e38:" + se.getMessage());
                if (!log.isErrorEnabled()) break block4;
                log.error((Object)("WafContext.getInstance().getContext() throw exception is:" + se.getMessage()), (Throwable)se);
            }
        }
        return ctx;
    }

    public static String getFileNameFromAbsolutePath(String name) {
        String fileName = "";
        int lastPos = name.lastIndexOf(File.separator);
        if (lastPos != -1) {
            fileName = name.substring(lastPos + 1);
        } else {
            lastPos = name.lastIndexOf("/");
            if (lastPos != -1) {
                fileName = name.substring(lastPos + 1);
            }
        }
        return fileName;
    }

    public static String getFileExtName(String name) {
        String fileExtName = "";
        int lastPos = name.lastIndexOf(".");
        fileExtName = lastPos != -1 ? name.substring(lastPos + 1) : DEAULT_UNDEFINED_EXT_NAME;
        return fileExtName;
    }

    public static boolean isBlankString(String validateStr) {
        if (validateStr == null) {
            return true;
        }
        return validateStr.trim().length() <= 0;
    }

    public static String getCurrentContextUser(Context ctx) {
        if (ctx == null || null == ContextUtil.getCurrentUserInfo((Context)ctx)) {
            return TEST_NULL_CONTEXT_USERID;
        }
        String userID = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        return userID.replaceAll("/", "G");
    }

    public static String makeObjectPropertiesToString(Object obj) {
        StringBuffer sb = new StringBuffer();
        Class<?> oneClass = obj.getClass();
        Field[] classField = oneClass.getDeclaredFields();
        for (int i = 0; i < classField.length; ++i) {
            Field oneField = classField[i];
            String fieldName = oneField.getName();
            String fieldMethod = "";
            try {
                fieldMethod = "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
                Method oneMethod = oneClass.getMethod(fieldMethod, null);
                Object result = oneMethod.invoke(obj, null);
                if (result != null) {
                    sb.append("\u5b57\u6bb5\uff1a" + fieldName + "\u7ed3\u679c\u4e3a\uff1a" + result.toString()).append("\n");
                    continue;
                }
                sb.append("\u5b57\u6bb5\uff1a" + fieldName + "\u7ed3\u679c\u4e3a\uff1anull").append("\n");
                continue;
            }
            catch (NoSuchMethodException nsme) {
                System.out.println("\u6ca1\u6709\u76f8\u5e94\u7684\u65b9\u6cd5:" + fieldMethod + "\u629b\u51fa\u5f02\u5e38" + nsme.getMessage());
                continue;
            }
            catch (IllegalAccessException iae) {
                System.out.println("\u8c03\u7528\u65b9\u6cd5:" + fieldMethod + "\u629b\u51fa\u5f02\u5e38" + iae.getMessage());
                continue;
            }
            catch (InvocationTargetException ite) {
                System.out.println("\u8c03\u7528\u65b9\u6cd5:" + fieldMethod + "\u629b\u51fa\u5f02\u5e38" + ite.getMessage());
            }
        }
        return sb.toString();
    }
}

