/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.cw.web.attachment.ui;

import com.enterprisedt.util.safe.SafeCheckUtils;
import com.kingdee.eas.base.fme.bo.DocumentBO;
import com.kingdee.eas.base.fme.service.ServiceResult;
import com.kingdee.eas.base.fme.uimodel.FMEParameter;
import com.kingdee.eas.base.fme.util.FMEUIUtils;
import com.kingdee.eas.base.fme.util.FtpUtils;
import com.kingdee.eas.cp.cw.web.attachment.service.AttachmentService;
import com.kingdee.eas.cp.cw.web.attachment.util.AppletUtil;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JApplet;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AttachmentBizPanel
extends JPanel {
    FMEParameter param = null;
    AttachmentService service = null;
    private int deleteType = 0;
    private HashMap<String, ArrayList<DocumentBO>> uploadFileMap;
    private HashMap<String, ArrayList<DocumentBO>> downloadFileMap;
    private HashMap<String, ArrayList<DocumentBO>> deleteFileMap;
    JApplet applet = null;

    public JApplet getApplet() {
        return this.applet;
    }

    public void setApplet(JApplet applet) {
        this.applet = applet;
    }

    public AttachmentBizPanel() {
        this.init();
    }

    private void init() {
        AppletUtil.showMsg("\u5b9e\u4f8b\u5316AttachmentBizPanel");
        this.uploadFileMap = new HashMap();
        this.downloadFileMap = new HashMap();
        this.deleteFileMap = new HashMap();
        this.service = new AttachmentService();
    }

    public String getUploadFile(String dir) {
        Frame myFrame = new Frame();
        FileDialog cfd = new FileDialog(myFrame, "\u9009\u62e9\u4e0a\u4f20\u6587\u4ef6", 0);
        cfd.setFile("*.*");
        cfd.setDirectory(dir);
        cfd.setVisible(true);
        String openFile = cfd.getFile();
        if (openFile == null) {
            AppletUtil.showMsg("\u6ca1\u6709\u6307\u5b9a\u6587\u4ef6");
        }
        cfd.setVisible(false);
        myFrame.setVisible(false);
        return openFile;
    }

    public List getMultiUploadFile(String dir) {
        AppletUtil.showMsg("\u521d\u59cb\u5316\u6587\u4ef6\u9009\u62e9\u6846");
        ArrayList<String> selectFile = new ArrayList<String>();
        JFileChooser cfd = new JFileChooser();
        cfd.setDialogTitle("\u9009\u62e9\u4e0a\u4f20\u6587\u4ef6");
        cfd.setMultiSelectionEnabled(true);
        cfd.setFileSelectionMode(0);
        cfd.setFont(new Font("\u5b8b\u4f53", 0, 12));
        cfd.setAcceptAllFileFilterUsed(true);
        cfd.setCurrentDirectory(new File(dir));
        cfd.setVisible(true);
        String retPath = "";
        AppletUtil.showMsg("\u663e\u793a\u6587\u4ef6\u9009\u62e9\u6846");
        int returnVal = cfd.showOpenDialog(null);
        AppletUtil.showMsg("returnVal\u503c\u4e3a" + returnVal);
        if (returnVal == 0) {
            File[] files = cfd.getSelectedFiles();
            AppletUtil.showMsg("\u6587\u4ef6\u4e2a\u6570" + files.length);
            for (int i = 0; i < files.length; ++i) {
                selectFile.add(files[i].getAbsolutePath());
            }
        } else {
            AppletUtil.showMsg("\u6ca1\u6709\u6307\u5b9a\u6587\u4ef6");
        }
        cfd.setVisible(false);
        return selectFile;
    }

    public List browserFile(String dir, String bizId) {
        AppletUtil.showMsg("===========\u6d4f\u89c8\u6587\u4ef6=========");
        List selectedpathList = this.getMultiUploadFile(dir);
        int countEmptyFile = 0;
        int countSameName = 0;
        int countFileNameLenOver = 0;
        int countFileNotExist = 0;
        ArrayList<String> pathList = new ArrayList<String>();
        String filepath = null;
        int len = selectedpathList.size();
        for (int i = 0; i < len; ++i) {
            filepath = (String)selectedpathList.get(i);
            if (!new File(filepath).exists()) {
                AppletUtil.showMsg("\u6587\u4ef6\u8def\u5f84\uff1a" + filepath + " \u4e0d\u5b58\u5728");
                ++countFileNotExist;
                continue;
            }
            if (FtpUtils.getFileNameFromAbsolutePath(filepath).length() > AppletUtil.FILENAME_TEXT_MAXLEN) {
                AppletUtil.showMsg("\u6587\u4ef6\u540d\uff1a" + FtpUtils.getFileNameFromAbsolutePath(filepath) + " \u8d85\u8fc7" + AppletUtil.FILENAME_TEXT_MAXLEN + "\u5b57\u7b26\u957f\u5ea6\u9650\u5236");
                AppletUtil.showMsg("\u6587\u4ef6\u540d\u957f\u5ea6\uff1a" + FtpUtils.getFileNameFromAbsolutePath(filepath).length());
                ++countFileNameLenOver;
                continue;
            }
            long fileNumSize = FtpUtils.getFileNumberSize(filepath);
            if (fileNumSize > 0L) {
                AppletUtil.showMsg("\u6587\u4ef6\u5927\u5c0f\uff1a" + fileNumSize + "\u5b57\u8282");
                if (!this.isSameName(bizId, filepath)) {
                    AppletUtil.showMsg("\u9009\u62e9\u6587\u4ef6\u540d:" + FtpUtils.getFileNameFromAbsolutePath(filepath));
                    AppletUtil.showMsg("\u9009\u62e9\u7684\u6587\u4ef6\u8def\u5f84\uff1a" + filepath);
                    pathList.add(filepath);
                    this.updateUploadData(filepath, bizId);
                    continue;
                }
                ++countSameName;
                continue;
            }
            filepath = "";
            ++countEmptyFile;
            AppletUtil.showMsg("\u4e0d\u80fd\u4e0a\u4f200\u5b57\u8282\u6587\u4ef6");
        }
        if (countEmptyFile > 0 || countSameName > 0 || countFileNameLenOver > 0 || countFileNotExist > 0) {
            StringBuffer sb = new StringBuffer();
            if (countEmptyFile > 0) {
                sb.append(countEmptyFile + "\u4efd\u6587\u4ef6\u5927\u5c0f\u4e3a0\u7684\u6587\u4ef6\u672a\u88ab\u52a0\u5165");
            }
            if (countSameName > 0) {
                if (countEmptyFile > 0) {
                    sb.append(",");
                }
                sb.append(countSameName + "\u4efd\u540c\u540d\u7684\u6587\u4ef6\u672a\u88ab\u52a0\u5165");
            }
            if (countFileNameLenOver > 0) {
                if (countEmptyFile > 0 || countSameName > 0) {
                    sb.append(",");
                }
                sb.append(countFileNameLenOver + "\u4efd\u6587\u4ef6\u540d\u957f\u5ea6\u8d85\u8fc7" + AppletUtil.FILENAME_TEXT_MAXLEN + "\u5b57\u7b26\u957f\u5ea6\u9650\u5236\u7684\u6587\u4ef6\u672a\u88ab\u52a0\u5165");
            }
            if (countFileNotExist > 0) {
                if (countEmptyFile > 0 || countSameName > 0 || countFileNameLenOver > 0) {
                    sb.append(",");
                }
                sb.append(countFileNotExist + "\u4efd\u8def\u5f84\u4e0d\u5b58\u5728\u7684\u6587\u4ef6\u672a\u88ab\u52a0\u5165");
            }
            AppletUtil.notify(this.getApplet(), bizId, sb.toString(), "notice");
        }
        return pathList;
    }

    public String getDownloadFilePath(String fileName) {
        String saveFile = "";
        Frame myFrame = new Frame();
        FileDialog saveDF = new FileDialog(myFrame, "\u8bf7\u9009\u62e9\u4e0b\u8f7d\u6587\u4ef6\u4f4d\u7f6e", 1);
        saveDF.setFile(fileName);
        saveDF.setDirectory(".");
        saveDF.setVisible(true);
        saveFile = saveDF.getFile();
        if (saveFile != null) {
            saveFile = saveDF.getDirectory() + saveFile;
            saveDF.setVisible(false);
            AppletUtil.showMsg("\u4fdd\u5b58\u6587\u4ef6\u4e3a:" + saveFile);
        }
        return saveFile;
    }

    public ServiceResult downloadFile(String fileName, String documentId, String bizId) {
        String downloadFileName = this.getDownloadFilePath(fileName);
        ServiceResult re = null;
        if (FtpUtils.isBlankString(downloadFileName)) {
            AppletUtil.notify(this.getApplet(), bizId, "\u6ca1\u6709\u6307\u5b9a\u4e0b\u8f7d\u8def\u5f84\uff0c\u4e0d\u80fd\u591f\u4e0b\u8f7d", "notice");
        } else {
            AppletUtil.showMsg("\u4e0b\u8f7d\u7684\u6587\u4ef6BusinessID is:" + bizId);
            if (FtpUtils.isBlankString(bizId)) {
                AppletUtil.showMsg("\u4e0b\u8f7d\u6587\u4ef6\u6307\u5b9a\u7684BusinessID\u4e3a\u7a7a");
            } else {
                AppletUtil.notify(this.getApplet(), bizId, "\u6b63\u5728\u4e0b\u8f7d\u6587\u4ef6: " + fileName, "waiting");
                re = this.service.downloadFile(bizId, documentId, downloadFileName);
                if (re.isResult()) {
                    AppletUtil.notify(this.getApplet(), bizId, "\u6587\u4ef6  " + fileName + " \u4e0b\u8f7d\u6210\u529f", "notice");
                } else {
                    AppletUtil.notify(this.getApplet(), bizId, re.getResultMessge(), "error");
                }
                AppletUtil.showMsg(re.toString());
            }
        }
        return re;
    }

    public ServiceResult uploadFile(String bizId) {
        ArrayList<DocumentBO> fileList = this.uploadFileMap.get(bizId);
        ServiceResult re = null;
        AppletUtil.showMsg("bizId\u4e3a" + bizId + "\u7684\u4e1a\u52a1\u5bf9\u8c61\u6b63\u5728\u4e0a\u4f20\u6587\u4ef6...");
        if (fileList != null) {
            int uploadFileCount = fileList.size();
            AppletUtil.showMsg("\u9700\u8981\u4ece\u672c\u6b21\u4e0a\u4f20\u7684\u6587\u4ef6\u6709:" + uploadFileCount);
            if (uploadFileCount > 0) {
                String[] filePaths = new String[uploadFileCount];
                int len = fileList.size();
                for (int i = 0; i < len; ++i) {
                    filePaths[i] = fileList.get(i).getPath();
                }
                re = this.service.uploadFile(filePaths, bizId);
                AppletUtil.showMsg(re.toString());
                if (re.isResult()) {
                    this.afterUploadSuccess(bizId);
                }
            } else {
                re = new ServiceResult();
                re.setResult(true);
                AppletUtil.showMsg("\u6ca1\u6709\u6587\u4ef6\u9700\u8981\u4e0a\u4f20");
            }
        } else {
            re = new ServiceResult();
            re.setResult(true);
            AppletUtil.showMsg("bizId\u4e3a" + bizId + "\u7684\u4e1a\u52a1\u5bf9\u8c61\u5c1a\u672a\u9009\u62e9\u6587\u4ef6\u4e0a\u4f20");
        }
        return re;
    }

    public void afterUploadSuccess(String bizId) {
        AppletUtil.showMsg("bizId\u4e3a" + bizId + "\u7684\u4e1a\u52a1\u5bf9\u8c61\u6587\u4ef6\u4e0a\u4f20\u6210\u529f,\u5904\u7406\u540e\u7eed\u5de5\u4f5c...");
        this.uploadFileMap.put(bizId, null);
        DocumentBO[] dbos = this.service.getFileInfo(bizId);
        if (dbos != null && dbos.length > 0) {
            ArrayList<DocumentBO> list = new ArrayList<DocumentBO>();
            int len = dbos.length;
            for (int i = 0; i < len; ++i) {
                list.add(dbos[i]);
            }
            this.downloadFileMap.put(bizId, list);
        }
    }

    public boolean deleteFile(String bizId, String documentId) {
        boolean delRe = false;
        if (FtpUtils.isBlankString(documentId)) {
            AppletUtil.showMsg("\u65e0\u6cd5\u5220\u9664Document ID\u4e3a\u7a7a\u7684\u6587\u4ef6");
        } else {
            AppletUtil.showMsg("Document Id\u4e3a" + documentId + "\u7684\u6587\u4ef6\u6b63\u5728\u5220\u9664...");
            delRe = this.service.deleteFile(bizId, documentId, this.deleteType);
        }
        return delRe;
    }

    public boolean submitDelFile(String bizId) {
        boolean delRe = false;
        if (FtpUtils.isBlankString(bizId)) {
            AppletUtil.showMsg("\u65e0\u6cd5\u5220\u9664bizId\u4e3a\u7a7a\u7684\u6587\u4ef6");
        } else {
            ArrayList<DocumentBO> deleteList = this.deleteFileMap.get(bizId);
            if (deleteList != null && deleteList.size() > 0) {
                AppletUtil.showMsg("bizId\u4e3a" + bizId + "\u4e1a\u52a1\u5bf9\u8c61\u6b63\u5728\u5220\u9664\u6587\u4ef6...");
                int delSuccessCount = 0;
                String did = null;
                int len = deleteList.size();
                for (int i = 0; i < len; ++i) {
                    did = deleteList.get(i).getDocumentID();
                    if (did == null || did.equals("")) continue;
                    delRe = this.deleteFile(bizId, did);
                    if (delRe) {
                        ++delSuccessCount;
                        deleteList.set(i, null);
                        continue;
                    }
                    AppletUtil.showMsg("Document Id\u4e3a" + did + "\u7684\u6587\u4ef6\u5220\u9664\u51fa\u9519");
                    break;
                }
                if (delSuccessCount == deleteList.size()) {
                    this.deleteFileMap.put(bizId, null);
                    AppletUtil.showMsg("bizId\u4e3a" + bizId + "\u4e1a\u52a1\u5bf9\u8c61\u5220\u9664\u6587\u4ef6\u5b8c\u6210");
                } else {
                    ArrayList<DocumentBO> newList = new ArrayList<DocumentBO>();
                    int len2 = deleteList.size();
                    for (int i = 0; i < len2; ++i) {
                        if (deleteList.get(i) == null) continue;
                        newList.add(deleteList.get(i));
                    }
                    this.deleteFileMap.put(bizId, newList);
                }
            } else {
                delRe = true;
                AppletUtil.showMsg("bizId\u4e3a" + bizId + "\u4e1a\u52a1\u5bf9\u8c61\u65e0\u53ef\u5220\u9664\u6587\u4ef6");
            }
        }
        return delRe;
    }

    public FMEParameter getParam() {
        return this.param;
    }

    public void setParam(FMEParameter param) {
        this.param = param;
    }

    public void loadDownloadFile(String[] bizIds) {
        AppletUtil.showMsg("\u9884\u52a0\u8f7d\u53ef\u4e0b\u8f7d\u7684\u6587\u4ef6");
        AppletUtil.showMsg("bizIds\u662f\u4e0d\u662fnull:" + (bizIds == null));
        if (bizIds != null && bizIds.length > 0) {
            int i;
            ArrayList<DocumentBO> dbosList = null;
            DocumentBO[] boinfo = null;
            int len = bizIds.length;
            for (i = 0; i < len; ++i) {
                boinfo = this.service.getFileInfo(bizIds[i]);
                if (boinfo == null || boinfo.length <= 0) continue;
                dbosList = new ArrayList<DocumentBO>();
                int l = boinfo.length;
                for (int j = 0; j < l; ++j) {
                    AppletUtil.showMsg(boinfo[j].toString());
                    dbosList.add(boinfo[j]);
                }
                this.updateDownloadData(dbosList, bizIds[i]);
            }
            if (AppletUtil.isDebug) {
                len = bizIds.length;
                for (i = 0; i < len; ++i) {
                    AppletUtil.showMsg("(" + i + ")\u9884\u4e0b\u8f7d\u7684\u6587\u4ef6BusinessID is:" + bizIds[i]);
                }
            }
        }
    }

    public void removeFromReadyUpload(String bizId, String path) {
        AppletUtil.showMsg("\u4ece\u4e1a\u52a1\u5bf9\u8c61" + bizId + "\u7684\u5f85\u4e0a\u4f20\u6587\u4ef6\u961f\u5217\u79fb\u9664\u8def\u5f84\u4e3a" + path + "\u7684\u6587\u4ef6");
        ArrayList<DocumentBO> uploadList = this.uploadFileMap.get(bizId);
        if (uploadList != null && path != null && !path.equals("")) {
            ArrayList<DocumentBO> newList = new ArrayList<DocumentBO>();
            int len = uploadList.size();
            for (int i = 0; i < len; ++i) {
                if (uploadList.get(i).getPath() != null && uploadList.get(i).getPath().equals(path)) continue;
                newList.add(uploadList.get(i));
            }
            this.uploadFileMap.put(bizId, newList);
        }
    }

    public void removeFromServer(String bizId, String did) {
        AppletUtil.showMsg("\u4ece\u4e1a\u52a1\u5bf9\u8c61" + bizId + "\u7684\u9884\u52a0\u8f7d\u6587\u4ef6\u961f\u5217\u79fb\u9664Document ID\u4e3a" + did + "\u7684\u6587\u4ef6");
        ArrayList<DocumentBO> downloadList = this.downloadFileMap.get(bizId);
        if (downloadList != null) {
            ArrayList<DocumentBO> newList = new ArrayList<DocumentBO>();
            int len = downloadList.size();
            for (int i = 0; i < len; ++i) {
                if (downloadList.get(i).getDocumentID().equals(did)) {
                    this.updateDeleteData(downloadList.get(i), bizId);
                    continue;
                }
                newList.add(downloadList.get(i));
            }
            this.downloadFileMap.put(bizId, newList);
        }
    }

    public JSONArray getAttachmentData(String[] bizIds) {
        JSONArray data = new JSONArray();
        JSONObject attachmentObj = null;
        DocumentBO dbo = null;
        String filename = null;
        int bizslen = bizIds.length;
        for (int m = 0; m < bizslen; ++m) {
            AppletUtil.showMsg("\u83b7\u53d6bizId\u4e3a" + bizIds[m] + "\u7684\u4e1a\u52a1\u5bf9\u8c61\u9644\u4ef6\u6570\u636e");
            AppletUtil.showMsg("============================================================");
            AppletUtil.showMsg("\u83b7\u53d6\u9884\u52a0\u8f7d\u6570\u636e");
            ArrayList<DocumentBO> downloadData = this.downloadFileMap.get(bizIds[m]);
            try {
                if (downloadData != null) {
                    AppletUtil.showMsg("\u9884\u52a0\u8f7d\u6570\u636e\u4e2a\u6570\uff1a" + downloadData.size());
                    int len = downloadData.size();
                    for (int i = 0; i < len; ++i) {
                        attachmentObj = new JSONObject();
                        dbo = downloadData.get(i);
                        filename = dbo.getDisplayName() != null && !dbo.getDisplayName().equals("") ? dbo.getDisplayName() : FtpUtils.getFileNameFromAbsolutePath(dbo.getDescription());
                        attachmentObj.put("name", filename);
                        AppletUtil.showMsg("name:" + attachmentObj.getString("name"));
                        attachmentObj.put("did", dbo.getDocumentID() == null ? "" : dbo.getDocumentID());
                        AppletUtil.showMsg("did:" + attachmentObj.getString("did"));
                        attachmentObj.put("bizId", dbo.getBusinessID());
                        AppletUtil.showMsg("bizId:" + attachmentObj.getString("bizId"));
                        attachmentObj.put("path", dbo.getPath());
                        AppletUtil.showMsg("path:" + attachmentObj.getString("path"));
                        data.put(attachmentObj);
                    }
                } else {
                    AppletUtil.showMsg("\u65e0\u9884\u52a0\u8f7d\u6570\u636e");
                }
            }
            catch (JSONException e) {
                AppletUtil.showMsg("\u83b7\u53d6\u9884\u52a0\u8f7d\u6570\u636e\u51fa\u9519");
            }
            AppletUtil.showMsg("\u83b7\u53d6\u5c06\u4e0a\u4f20\u6570\u636e");
            ArrayList<DocumentBO> uploadData = this.uploadFileMap.get(bizIds[m]);
            try {
                if (uploadData != null) {
                    AppletUtil.showMsg("\u5c06\u4e0a\u4f20\u6570\u636e\u4e2a\u6570\uff1a" + uploadData.size());
                    int len = uploadData.size();
                    for (int i = 0; i < len; ++i) {
                        attachmentObj = new JSONObject();
                        dbo = uploadData.get(i);
                        filename = dbo.getDisplayName() != null && !dbo.getDisplayName().equals("") ? dbo.getDisplayName() : FtpUtils.getFileNameFromAbsolutePath(dbo.getDescription());
                        attachmentObj.put("name", filename);
                        AppletUtil.showMsg("name:" + attachmentObj.getString("name"));
                        attachmentObj.put("did", dbo.getDocumentID() == null ? "" : dbo.getDocumentID());
                        AppletUtil.showMsg("did:" + attachmentObj.getString("did"));
                        attachmentObj.put("bizId", dbo.getBusinessID());
                        AppletUtil.showMsg("bizId:" + attachmentObj.getString("bizId"));
                        attachmentObj.put("path", dbo.getPath());
                        AppletUtil.showMsg("path:" + attachmentObj.getString("path"));
                        data.put(attachmentObj);
                    }
                    continue;
                }
                AppletUtil.showMsg("\u65e0\u5c06\u4e0a\u4f20\u6570\u636e");
                continue;
            }
            catch (JSONException e) {
                AppletUtil.showMsg("\u83b7\u53d6\u5c06\u4e0a\u4f20\u6570\u636e\u51fa\u9519");
            }
        }
        return data;
    }

    private void updateUploadData(String filename, String bizId) {
        if (filename != null && !filename.equals("")) {
            ArrayList<DocumentBO> fileList = this.uploadFileMap.get(bizId);
            if (fileList == null) {
                fileList = new ArrayList();
                this.uploadFileMap.put(bizId, fileList);
            }
            DocumentBO d = new DocumentBO();
            d.setBusinessID(bizId);
            d.setDisplayName(FtpUtils.getFileNameFromAbsolutePath(filename));
            d.setDescription(filename);
            d.setPath(filename);
            fileList.add(d);
        }
    }

    private void updateDownloadData(ArrayList<DocumentBO> newData, String bizId) {
        ArrayList<DocumentBO> oldData = this.downloadFileMap.get(bizId);
        if (oldData == null) {
            this.downloadFileMap.put(bizId, newData);
        } else {
            ArrayList<DocumentBO> mergerList = new ArrayList<DocumentBO>();
            boolean flag = false;
            int oldLen = oldData.size();
            for (int oldStep = 0; oldStep < oldLen; ++oldStep) {
                flag = false;
                int newLen = newData.size();
                for (int newStep = 0; newStep < newLen; ++newStep) {
                    if (newData.get(newStep).getDocumentID().equals("") || oldData.get(oldStep).getDocumentID().equals("") || !oldData.get(oldStep).getDocumentID().equals(newData.get(newStep).getDocumentID())) continue;
                    flag = true;
                    break;
                }
                if (flag) continue;
                mergerList.add(oldData.get(oldStep));
            }
            int newLen = newData.size();
            for (int newStep = 0; newStep < newLen; ++newStep) {
                mergerList.add(newData.get(newStep));
            }
            this.downloadFileMap.put(bizId, mergerList);
        }
    }

    private void updateDeleteData(DocumentBO dbo, String bizId) {
        ArrayList<DocumentBO> delList = this.deleteFileMap.get(bizId);
        if (delList == null) {
            delList = new ArrayList();
            this.deleteFileMap.put(bizId, delList);
        }
        delList.add(dbo);
    }

    private boolean isSizeOk(long fileNumberSize) {
        return true;
    }

    private boolean isSameName(String bizId, String filepath) {
        boolean flag = false;
        ArrayList<DocumentBO> dbos = this.uploadFileMap.get(bizId);
        if (dbos != null && dbos.size() > 0) {
            int len = dbos.size();
            for (int i = 0; i < len; ++i) {
                if (dbos.get(i).getDescription().equals(FtpUtils.getFileNameFromAbsolutePath(filepath))) {
                    flag = true;
                    break;
                }
                if (!dbos.get(i).getPath().equals(filepath)) continue;
                flag = true;
                break;
            }
        }
        return flag;
    }

    public long getBizFilesSizeFromServer(String bizId) {
        long size = 0L;
        DocumentBO[] files = this.service.getFileInfo(bizId);
        if (files != null) {
            int len = files.length;
            for (int i = 0; i < len; ++i) {
                size += Long.valueOf(Integer.valueOf(files[i].getSize()).toString()).longValue();
            }
        }
        return size;
    }

    public long getBizFilesSizeFromMap(String bizId) {
        long sizeSum = 0L;
        ArrayList<DocumentBO> uploadList = this.uploadFileMap.get(bizId);
        AppletUtil.showMsg("\u8ba1\u7b97\u5f85\u4e0a\u4f20\u6587\u4ef6\u5927\u5c0f");
        if (uploadList != null && uploadList.size() > 0) {
            int len = uploadList.size();
            for (int i = 0; i < len; ++i) {
                AppletUtil.showMsg("\u8ba1\u7b97\u5f85\u4e0a\u4f20\u6587\u4ef6\uff1a" + uploadList.get(i).getPath() + " \u7684\u6587\u4ef6\u5927\u5c0f");
                sizeSum += new File(uploadList.get(i).getPath()).length();
            }
        }
        ArrayList<DocumentBO> downloadList = this.downloadFileMap.get(bizId);
        AppletUtil.showMsg("\u8ba1\u7b97\u53ef\u4e0b\u8f7d\u6587\u4ef6\u5927\u5c0f");
        if (downloadList != null && downloadList.size() > 0) {
            int len = downloadList.size();
            for (int i = 0; i < len; ++i) {
                AppletUtil.showMsg("\u8ba1\u7b97\u53ef\u4e0b\u8f7d\u6587\u4ef6\uff1a" + downloadList.get(i).getPath() + " \u7684\u6587\u4ef6\u5927\u5c0f");
                sizeSum += (long)downloadList.get(i).getSize();
            }
        }
        return sizeSum;
    }

    public void downloadFile(String filename, String did, String bizId, String elId) {
        String downloadFileName = this.getDownloadFilePath(filename);
        ServiceResult re = null;
        if (FtpUtils.isBlankString(downloadFileName)) {
            AppletUtil.notify(this.getApplet(), elId, "\u6ca1\u6709\u6307\u5b9a\u4e0b\u8f7d\u8def\u5f84\uff0c\u4e0d\u80fd\u591f\u4e0b\u8f7d", "notice");
        } else {
            AppletUtil.showMsg("\u4e0b\u8f7d\u7684\u6587\u4ef6BusinessID is:" + bizId);
            if (FtpUtils.isBlankString(bizId)) {
                AppletUtil.showMsg("\u4e0b\u8f7d\u6587\u4ef6\u6307\u5b9a\u7684BusinessID\u4e3a\u7a7a");
            } else {
                AppletUtil.notify(this.getApplet(), elId, "\u6b63\u5728\u4e0b\u8f7d\u6587\u4ef6: " + filename, "waiting");
                re = this.service.downloadFile(bizId, did, downloadFileName);
                if (re.isResult()) {
                    AppletUtil.notify(this.getApplet(), elId, "\u6587\u4ef6  " + filename + " \u4e0b\u8f7d\u6210\u529f", "notice");
                } else {
                    AppletUtil.notify(this.getApplet(), elId, re.getResultMessge(), "error");
                }
                AppletUtil.showMsg(re.toString());
            }
        }
    }

    public int getUploadFileCount(String bizId) {
        int count = 0;
        if (this.uploadFileMap.get(bizId) != null) {
            count = this.uploadFileMap.get(bizId).size();
        }
        return count;
    }

    public int getDeleteFileCount(String bizId) {
        int count = 0;
        if (this.deleteFileMap.get(bizId) != null) {
            count = this.deleteFileMap.get(bizId).size();
        }
        return count;
    }

    public int getDownloadFileCount(String bizId) {
        int count = 0;
        if (this.downloadFileMap.get(bizId) != null) {
            count = this.downloadFileMap.get(bizId).size();
        }
        return count;
    }

    public boolean isPreLoad(String bizId) {
        return this.downloadFileMap.containsKey(bizId) || this.deleteFileMap.containsKey(bizId);
    }

    public boolean hasDownloadFile(String bizId) {
        boolean flag = false;
        if (this.downloadFileMap.get(bizId) != null && this.downloadFileMap.get(bizId).size() > 0) {
            flag = true;
        }
        return flag;
    }

    public boolean hasUploadFile(String bizId) {
        boolean flag = false;
        if (this.uploadFileMap.get(bizId) != null && this.uploadFileMap.get(bizId).size() > 0) {
            flag = true;
        }
        return flag;
    }

    public void openFile(String fileName, String documentId, String bizId) {
        String tempDir = FMEUIUtils.getClientTempDir();
        File file = new File(SafeCheckUtils.cleanPathString(tempDir + fileName));
        if (file.exists()) {
            file.delete();
        }
        ServiceResult re = null;
        AppletUtil.showMsg("\u4e34\u65f6\u4fdd\u5b58\u8def\u5f84:" + tempDir + fileName);
        AppletUtil.showMsg("\u4e0b\u8f7d\u7684\u6587\u4ef6BusinessID is:" + bizId);
        if (FtpUtils.isBlankString(bizId)) {
            AppletUtil.showMsg("\u4e0b\u8f7d\u6587\u4ef6\u6307\u5b9a\u7684BusinessID\u4e3a\u7a7a");
        } else {
            AppletUtil.notify(this.getApplet(), bizId, "\u6b63\u5728\u4e0b\u8f7d\u6587\u4ef6: " + fileName, "waiting");
            re = this.service.downloadFile(bizId, documentId, tempDir + fileName);
            if (re.isResult()) {
                AppletUtil.notify(this.getApplet(), bizId, "\u6587\u4ef6  " + fileName + " \u4e0b\u8f7d\u6210\u529f", "notice");
                this.invokeSystemOpenFile(bizId, tempDir + fileName);
            } else {
                AppletUtil.notify(this.getApplet(), bizId, re.getResultMessge(), "error");
            }
            AppletUtil.showMsg(re.toString());
        }
    }

    private void invokeSystemOpenFile(String bizId, String downloadFilePath) {
        try {
            Thread.sleep(1000L);
            AppletUtil.showMsg("\u6267\u884c\u6587\u4ef6\u6253\u5f00:" + downloadFilePath);
            AppletUtil.notify(this.getApplet(), bizId, "\u6b63\u5728\u6253\u5f00\u6587\u4ef6...", "waiting");
            String[] cmd = new String[5];
            cmd[0] = "cmd";
            cmd[1] = "/c";
            cmd[2] = "start";
            cmd[3] = "\"\"";
            downloadFilePath = downloadFilePath.replaceAll("\\\\", "/");
            cmd[4] = "\"" + downloadFilePath + "\"";
            Runtime rt = Runtime.getRuntime();
            Process proc = rt.exec(cmd);
            proc.waitFor();
            Thread.sleep(1000L);
            AppletUtil.closeMsg(this.getApplet(), bizId);
        }
        catch (Exception se) {
            AppletUtil.showMsg("\u6253\u5f00\u6587\u4ef6\u6267\u884c\u629b\u51fa\u5f02\u5e38:" + se.getMessage());
            se.printStackTrace();
        }
    }

    public void openFile(String fileName, String documentId, String bizId, String elId) {
        String tempDir = FMEUIUtils.getClientTempDir();
        File file = new File(SafeCheckUtils.cleanPathString(tempDir + fileName));
        if (file.exists()) {
            file.delete();
        }
        ServiceResult re = null;
        AppletUtil.showMsg("\u4e34\u65f6\u4fdd\u5b58\u8def\u5f84:" + tempDir + fileName);
        AppletUtil.showMsg("\u4e0b\u8f7d\u7684\u6587\u4ef6BusinessID is:" + bizId);
        if (FtpUtils.isBlankString(bizId)) {
            AppletUtil.showMsg("\u4e0b\u8f7d\u6587\u4ef6\u6307\u5b9a\u7684BusinessID\u4e3a\u7a7a");
        } else {
            AppletUtil.notify(this.getApplet(), elId, "\u6b63\u5728\u4e0b\u8f7d\u6587\u4ef6: " + fileName, "waiting");
            re = this.service.downloadFile(bizId, documentId, tempDir + fileName);
            if (re.isResult()) {
                AppletUtil.notify(this.getApplet(), elId, "\u6587\u4ef6  " + fileName + " \u4e0b\u8f7d\u6210\u529f", "notice");
                this.invokeSystemOpenFile(elId, tempDir + fileName);
            } else {
                AppletUtil.notify(this.getApplet(), elId, re.getResultMessge(), "error");
            }
            AppletUtil.showMsg(re.toString());
        }
    }
}

