/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.model;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.form.core.IPageQueryServer;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class PageQueryProxy {
    private static final String PAGE_QUERY_SERVER_CLASS_TYPE = "com.kingdee.eas.base.form.core.app.PageQueryServer";
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.form.core.app.PageQueryProxy");
    private String mainPk;
    private String entryPk;
    private String select;
    private String from;
    private String where;
    private String order;
    private Map rowSeq2rowIndex;
    private Context ctx;
    private IPageQueryServer.PageInfo pageInfo;
    private int maxRowCount = 2000;

    public PageQueryProxy(Context ctx, String mainPk, String entryPk, String select, String from, String where, String order) {
        this.ctx = ctx;
        this.mainPk = mainPk;
        if (entryPk != null && entryPk.trim().length() > 0) {
            this.entryPk = entryPk;
        }
        this.select = select;
        this.from = from;
        this.where = where;
        this.order = order;
    }

    public PageQueryProxy(Context ctx, String mainPk, String select, String from, String where, String order) {
        this(ctx, mainPk, null, select, from, where, order);
    }

    public String getSelect() {
        return this.select;
    }

    public void setSelect(String select) {
        this.select = select;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getWhere() {
        return this.where;
    }

    public void setWhere(String where) {
        this.where = where;
    }

    public String getOrder() {
        return this.order;
    }

    public void setOrder(String order) {
        this.order = order;
    }

    public int getMaxRowCount() {
        return this.maxRowCount;
    }

    public void setMaxRowCount(int maxRowCount) {
        this.maxRowCount = maxRowCount;
    }

    public String getMainTablePk() {
        return this.mainPk;
    }

    public void setMainTableId(String mainTablePk) {
        this.mainPk = mainTablePk;
    }

    public String getEntryTablePk() {
        return this.entryPk;
    }

    public void setEntryTableId(String entryTablePk) {
        this.entryPk = entryTablePk;
    }

    public int getRowCount() {
        return this.pageInfo == null ? 0 : this.pageInfo.getRowCount();
    }

    public void preparePageInfo() throws BOSException {
        IPageQueryServer queryServer = this.getPageQueryServer(this.ctx);
        this.pageInfo = queryServer.preparePageInfo(this.pageInfo == null ? null : this.pageInfo.getTempTableName(), this.mainPk, this.entryPk, this.select, this.from, this.where, this.order, this.maxRowCount);
        this.pageInfo.setStart(-1);
        this.pageInfo.setEnd(-1);
        this.clearRowSeq2rowIndexMap();
    }

    private void clearRowSeq2rowIndexMap() {
        if (this.rowSeq2rowIndex == null) {
            this.rowSeq2rowIndex = new HashMap();
        } else {
            this.rowSeq2rowIndex.clear();
        }
    }

    public IRowSet getData(int start, int end) throws BOSException {
        IPageQueryServer queryServer = this.getPageQueryServer(this.ctx);
        if (this.pageInfo == null) {
            this.preparePageInfo();
        }
        if (this.pageInfo.getStart() != start) {
            IRowSet rs = queryServer.getData(this.pageInfo.getTempTableName(), this.mainPk, this.entryPk, this.select, this.from, this.where, start, end);
            this.pageInfo.setStart(start);
            this.pageInfo.setEnd(end);
            this.pageInfo.setCurPageData(rs);
            this.clearRowSeq2rowIndexMap();
        }
        return this.pageInfo.getCurPageData();
    }

    public IRowSet getCurrentPageData() {
        return this.pageInfo.getCurPageData();
    }

    public IRowSet getAllData() throws BOSException {
        IPageQueryServer queryServer = this.getPageQueryServer(this.ctx);
        IRowSet rs = queryServer.getAllData(this.mainPk, this.entryPk, this.select, this.from, this.where, this.order);
        return rs;
    }

    private IPageQueryServer getPageQueryServer(Context ctx) throws BOSException {
        IPageQueryServer server = null;
        try {
            server = ctx == null ? (IPageQueryServer)BOSObjectFactory.createRemoteBOSObject((String)PAGE_QUERY_SERVER_CLASS_TYPE, IPageQueryServer.class) : (IPageQueryServer)BOSObjectFactory.getLocalBOSObjectFactory((Context)ctx).createBOSObject(PAGE_QUERY_SERVER_CLASS_TYPE);
        }
        catch (BOSException e) {
            logger.error((Object)("getPageQueryServer:" + e.getMessage()));
            throw e;
        }
        return server;
    }

    private synchronized void initRowSeq2RowIndex() throws SQLException {
        if (this.rowSeq2rowIndex == null || this.rowSeq2rowIndex.size() == 0) {
            IRowSet rs = this.pageInfo.getCurPageData();
            if (this.pageInfo != null && rs != null) {
                rs.beforeFirst();
                while (rs.next()) {
                    Object seq = rs.getObject(1);
                    Integer nSeq = seq instanceof BigDecimal ? new Integer(((BigDecimal)seq).intValue()) : (Integer)seq;
                    this.rowSeq2rowIndex.put(nSeq, new Integer(rs.getRow()));
                }
            }
        }
    }

    private synchronized String getBillIdAt(IRowSet rs, int row) throws SQLException {
        rs.absolute(row);
        return rs.getString(2);
    }

    private synchronized String getEntryIdAt(IRowSet rs, int row) throws SQLException {
        rs.absolute(row);
        return rs.getString(3);
    }

    public String[] getIdArray(List rowSeqList) throws BOSException {
        String[] ids = new String[rowSeqList.size()];
        try {
            this.initRowSeq2RowIndex();
            IRowSet rs = this.pageInfo.getCurPageData();
            for (int i = 0; i < rowSeqList.size(); ++i) {
                Integer seq = (Integer)rowSeqList.get(i);
                Integer index = (Integer)this.rowSeq2rowIndex.get(seq);
                if (index == null) {
                    logger.error((Object)("no corresponding id found for row seq:" + seq));
                    continue;
                }
                ids[i] = this.getBillIdAt(rs, index);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return ids;
    }

    public String[] getEntryIdArray(List rowSeqList) throws BOSException {
        String[] ids = new String[rowSeqList.size()];
        try {
            this.initRowSeq2RowIndex();
            IRowSet rs = this.pageInfo.getCurPageData();
            for (int i = 0; i < rowSeqList.size(); ++i) {
                Integer seq = (Integer)rowSeqList.get(i);
                Integer index = (Integer)this.rowSeq2rowIndex.get(seq);
                if (index == null) {
                    logger.error((Object)("no corresponding id found for row seq:" + seq));
                    continue;
                }
                ids[i] = this.getEntryIdAt(rs, index);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return ids;
    }

    public List getIdList(List rowSeqList) throws BOSException {
        ArrayList<String> idList = new ArrayList<String>();
        try {
            this.initRowSeq2RowIndex();
            for (Integer seq : rowSeqList) {
                Integer index = (Integer)this.rowSeq2rowIndex.get(seq);
                if (index == null) {
                    logger.error((Object)("no corresponding id found for row seq:" + seq));
                    continue;
                }
                IRowSet rs = this.pageInfo.getCurPageData();
                rs.absolute(index.intValue());
                idList.add(rs.getString(2));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return idList;
    }

    public LinkedList getCurrentPageBillIds() throws BOSException {
        LinkedList<String> idList = new LinkedList<String>();
        try {
            IRowSet rs = this.pageInfo.getCurPageData();
            if (this.pageInfo != null && rs != null) {
                rs.beforeFirst();
                while (rs.next()) {
                    idList.add(rs.getString(2));
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return idList;
    }

    public PkInfo getPk(int rowSeq) throws SQLException {
        this.initRowSeq2RowIndex();
        PkInfo pk = new PkInfo();
        Integer index = (Integer)this.rowSeq2rowIndex.get(new Integer(rowSeq));
        if (index == null) {
            logger.error((Object)("no corresponding id found for row seq:" + rowSeq));
        } else {
            IRowSet rs = this.pageInfo.getCurPageData();
            rs.absolute(index.intValue());
            pk.mainPk = rs.getString(2);
            if (this.entryPk != null) {
                pk.entryPk = rs.getString(3);
            }
        }
        return pk;
    }

    public List getRowDataInCurPage(List rowSeqList, List propertyKey) throws SQLException {
        this.initRowSeq2RowIndex();
        ArrayList<String> rows = new ArrayList<String>();
        for (Integer seq : rowSeqList) {
            Integer index = (Integer)this.rowSeq2rowIndex.get(seq);
            if (index == null) {
                logger.error((Object)("no corresponding id found for row seq:" + seq));
                continue;
            }
            IRowSet rs = this.pageInfo.getCurPageData();
            rs.absolute(index.intValue());
            HashMap<String, Object> row = new HashMap<String, Object>();
            for (String key : propertyKey) {
                row.put(key, rs.getObject(key));
            }
            rows.add(rs.getString(2));
        }
        return rows;
    }

    public void clearSession() throws BOSException {
        String tempTableName = this.pageInfo.getTempTableName();
        if (this.pageInfo != null && tempTableName != null) {
            IPageQueryServer queryServer = this.getPageQueryServer(this.ctx);
            queryServer.clearPageInfo(tempTableName);
        }
    }

    public class PkInfo {
        public String mainPk;
        public String entryPk;
    }
}

