/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.model.bill;

import java.util.LinkedList;

public final class IDList {
    private LinkedList idList = new LinkedList();
    private int currentIndex = -1;
    private String currentId = null;

    public IDList(LinkedList idList, String id) {
        if (idList != null) {
            for (Object o : idList) {
                if (this.idList.contains(o)) continue;
                this.idList.add(o);
            }
        }
        if (id == null) {
            return;
        }
        this.currentIndex = this.idList.indexOf(id);
        this.currentId = id;
    }

    public IDList() {
    }

    public void add(String id) {
        if (!this.idList.contains(id)) {
            return;
        }
        this.idList.addLast(id);
        this.currentId = id;
        this.currentIndex = this.idList.size() - 1;
    }

    public int getCurrentIndex() {
        return this.currentIndex;
    }

    public String getCurrentId() {
        return this.currentId;
    }

    public void remove() {
        if (this.currentIndex < 0) {
            return;
        }
        this.idList.remove(this.currentIndex);
        int size = this.idList.size();
        if (size == 0) {
            this.currentIndex = -1;
            this.currentId = null;
            return;
        }
        if (this.currentIndex >= size) {
            this.currentIndex = size - 1;
            this.currentId = (String)this.idList.getLast();
        } else {
            this.currentId = (String)this.idList.get(this.currentIndex);
        }
    }

    public String getPreviousId() {
        if (this.currentIndex > 0) {
            this.currentId = (String)this.idList.get(--this.currentIndex);
        }
        return this.currentId;
    }

    public String getNextId() {
        if (this.currentIndex < this.idList.size() - 1) {
            this.currentId = (String)this.idList.get(++this.currentIndex);
        }
        return this.currentId;
    }

    public String getFirstId() {
        if (this.currentIndex > 0) {
            this.currentIndex = 0;
            this.currentId = (String)this.idList.get(this.currentIndex);
        }
        return this.currentId;
    }

    public String getLastId() {
        if (this.currentIndex < this.idList.size() - 1) {
            this.currentIndex = this.idList.size() - 1;
            this.currentId = (String)this.idList.get(this.currentIndex);
        }
        return this.currentId;
    }
}

