/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.model.combin;

import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.form.model.AbstractDynamicFormPlugin;
import com.kingdee.eas.base.form.model.DynamicFormApplication;
import com.kingdee.eas.base.form.model.combin.CombinUIApplication;
import com.kingdee.eas.base.form.model.combin.ICombinViewListener;
import com.kingdee.eas.base.form.model.combin.IPlugUI;
import com.kingdee.eas.framework.client.CoreBillEditUI;
import com.kingdee.eas.framework.client.CoreBillListUI;
import com.kingdee.eas.framework.client.IIDList;
import java.util.Map;

public abstract class AbstractCombinUIPlugin
extends AbstractDynamicFormPlugin
implements ICombinViewListener {
    public static final String TYPE_BILLEDIT = "BILLEDIT";
    public static final String TYPE_BILLLIST = "BILLLIST";
    protected CombinUIApplication application;
    protected IUIObject uiObject;
    private String tabTitle;
    private boolean isVisible = true;
    boolean toActive = false;

    public void setToActive(boolean toActive) {
        this.toActive = toActive;
    }

    public boolean isToActive() {
        return this.toActive;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public void setVisible(boolean isVisible) {
        this.isVisible = isVisible;
    }

    @Override
    public void activate() {
        if (!this.application.isRefresh(this.getUIClassName())) {
            return;
        }
        if (TYPE_BILLEDIT.equals(this.getUIType())) {
            this.activateForBillEdit();
        } else if (TYPE_BILLLIST.equals(this.getUIType())) {
            this.activateForBillList();
        }
    }

    @Override
    public void onLoad(Map uiContext) throws Exception {
        if (TYPE_BILLEDIT.equals(this.getUIType())) {
            this.onLoadForBillEdit(uiContext);
        } else if (TYPE_BILLLIST.equals(this.getUIType())) {
            this.onLoadForBillList(uiContext);
        }
    }

    @Override
    public void refresh() {
        if (TYPE_BILLLIST.equals(this.getUIType())) {
            this.refreshForBillList();
        }
    }

    public void attachApplication(DynamicFormApplication application) {
        this.application = (CombinUIApplication)application;
    }

    public IUIObject getUIObject() {
        if (this.uiObject == null) {
            try {
                this.createUI();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.uiObject;
    }

    public boolean isUILoaded() {
        return this.uiObject != null;
    }

    private void createUI() throws Exception {
        if (this.getUIClassName() == null) {
            return;
        }
        this.uiObject = (IUIObject)Class.forName(this.getUIClassName()).newInstance();
        if (this.uiObject instanceof IPlugUI) {
            ((IPlugUI)this.uiObject).attach(this.application);
        }
    }

    public boolean destroyWindow() {
        boolean result = true;
        if (this.uiObject != null) {
            result = this.uiObject.destroyWindow();
        }
        return result;
    }

    public String getTabTitle() {
        return this.tabTitle;
    }

    public void setTabTitle(String tabTitle) {
        this.tabTitle = tabTitle;
    }

    protected abstract String getUIType();

    private void onLoadForBillEdit(Map uiContext) {
        boolean isBotp;
        boolean bl = isBotp = uiContext != null;
        if (isBotp) {
            Integer botpView = (Integer)uiContext.get("BOTPViewStatus");
            boolean bl2 = isBotp = botpView != null && botpView == 1;
        }
        if (isBotp) {
            this.uiObject.getUIContext().putAll(uiContext);
            this.uiObject.setOprtState("EDIT");
        } else {
            this.uiObject.setOprtState("ADDNEW");
        }
        try {
            this.uiObject.onLoad();
        }
        catch (Exception e) {
            this.uiObject.handUIException((Throwable)e);
        }
    }

    private void onLoadForBillList(Map uiContext) {
        CoreBillListUI listUI = (CoreBillListUI)this.getUIObject();
        listUI.setIsNeedDefaultFilter(false);
        listUI.setFilterForQuery(this.application.getView().getFilterInfo());
        try {
            listUI.onLoad();
        }
        catch (Exception e) {
            listUI.handUIException((Throwable)e);
        }
    }

    private void activateForBillEdit() {
        IIDList idList = this.application.getIdList();
        if (idList == null) {
            return;
        }
        CoreBillEditUI editUI = (CoreBillEditUI)this.getUIObject();
        if (editUI.isModify()) {
            // empty if block
        }
        IObjectValue objValue = editUI.getDataObject();
        String currentId = idList.getCurrentID();
        if (currentId == null || objValue != null && objValue.get(objValue.getPKField()) != null && currentId.equals(objValue.get(objValue.getPKField()).toString())) {
            return;
        }
        editUI.getUIContext().put("ID", idList.getCurrentID());
        editUI.getUIContext().put("IDList", idList);
        editUI.setOprtState("VIEW");
        try {
            editUI.onLoad();
        }
        catch (Exception e) {
            editUI.handUIException((Throwable)e);
        }
    }

    private void activateForBillList() {
        this.refresh();
    }

    private void refreshForBillList() {
        CoreBillListUI listUI = (CoreBillListUI)this.getUIObject();
        try {
            listUI.setFilterForQuery(this.application.getView().getFilterInfo());
            listUI.refreshList();
        }
        catch (Exception e) {
            listUI.handUIException((Throwable)e);
        }
    }
}

