/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.model.f7;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.QueryFieldInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.SelectorInfo;
import com.kingdee.bos.metadata.query.util.ConstDataType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.form.core.FormFactory;
import com.kingdee.eas.base.form.json.JSONArray;
import com.kingdee.eas.base.form.json.JSONObject;
import com.kingdee.eas.base.form.metadata.Field;
import com.kingdee.eas.base.form.metadata.FormMetaData;
import com.kingdee.eas.base.form.model.DynamicFormEventsProxy;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.jdbc.rowset.IRowSet;
import java.io.Serializable;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class PromptBoxModel {
    private QueryInfo queryInfo;
    private Context context;
    private IObjectValue prmtObjValue;
    private FieldItem[] filterItems = null;
    IQueryExecutor queryExecutor = null;
    private static String promptFormId = "vrZnhgZKTF+fkKK3eZoNTJp+rpI=";
    private static String numberAndName = "number+name";
    private static String likeOpr = "like";
    private static FormMetaData formMetaData = null;
    private static final Logger logger = Logger.getLogger(PromptBoxModel.class);

    public PromptBoxModel(Context context) {
        this.context = context;
    }

    private static synchronized FormMetaData getFormMetaData(Context ctx) {
        formMetaData = FormFactory.createFormMetaData((String)promptFormId, (Context)ctx);
        return formMetaData;
    }

    public FormMetaData getFormMetaData() {
        return PromptBoxModel.getFormMetaData(this.context);
    }

    public void setContext(Context ctx) {
        this.context = ctx;
    }

    public Context getContext() {
        return this.context;
    }

    public void initQueryInfo(String queryPk) {
        if (this.queryInfo == null) {
            this.queryInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)this.getContext()).getQuery((IMetaDataPK)new MetaDataPK(queryPk));
        }
    }

    public FieldItem[] getFieldItems() {
        if (this.filterItems == null) {
            SelectorInfo selectorInfo = this.queryInfo.getSelector();
            ArrayList<FieldItem> list = new ArrayList<FieldItem>();
            boolean isThereNumberField = false;
            boolean isThereNameField = false;
            for (int i = 0; i < selectorInfo.size(); ++i) {
                QueryFieldInfo fieldInfo = selectorInfo.get(i);
                ConstDataType dataType = null;
                try {
                    dataType = fieldInfo.getReturnType();
                }
                catch (Exception e) {
                    dataType = ConstDataType.STRING;
                }
                String theExtendPropertyValue = fieldInfo.getExtendedProperty("isCommonQueryFilter");
                int fieldAttr = 2;
                if (theExtendPropertyValue != null && theExtendPropertyValue.equals("true") && (dataType.equals((Object)ConstDataType.INT) || dataType.equals((Object)ConstDataType.NUMBER) || dataType.equals((Object)ConstDataType.STRING))) {
                    if ("number".equals(fieldInfo.getName())) {
                        isThereNumberField = true;
                    } else if ("name".equals(fieldInfo.getName())) {
                        isThereNumberField = true;
                    }
                    fieldAttr = 1;
                }
                if (fieldInfo.isIsSelector()) {
                    fieldAttr |= 2;
                }
                list.add(new FieldItem(fieldInfo.getName(), fieldInfo.getDisplayName(), dataType, fieldAttr));
            }
            int arraySize = list.size();
            FieldItem numberAndNameItem = new FieldItem(numberAndName, "\u7f16\u7801+\u540d\u79f0", ConstDataType.STRING);
            if (isThereNameField && isThereNumberField) {
                ++arraySize;
                list.add(0, numberAndNameItem);
            }
            this.filterItems = new FieldItem[arraySize];
            for (int i = 0; i < arraySize; ++i) {
                this.filterItems[i] = (FieldItem)list.get(i);
            }
            if (this.filterItems.length == 0) {
                this.filterItems = new FieldItem[3];
                this.filterItems[0] = new FieldItem("number", "\u7f16\u7801", ConstDataType.STRING);
                this.filterItems[1] = new FieldItem("name", "\u540d\u79f0", ConstDataType.STRING);
                this.filterItems[2] = numberAndNameItem;
            }
        }
        return this.filterItems;
    }

    private String getQuickFilterOql(String fieldName, ConstDataType theFieldType, String compareStr, String value) {
        String theValue = value;
        if (compareStr.equals(likeOpr)) {
            theValue = "%" + theValue + "%";
        }
        if (theFieldType.equals((Object)ConstDataType.STRING)) {
            theValue = "'" + theValue + "'";
        }
        return fieldName + " " + compareStr + " " + theValue;
    }

    public void setSetting(JSONArray jsSettings) throws Exception {
        EntityViewInfo view = null;
        if (jsSettings != null && jsSettings.length() > 0) {
            StringBuffer predicate = new StringBuffer(400);
            ArrayList array = new ArrayList();
            JSONObject jsfilterItem = (JSONObject)jsSettings.opt(0);
            String filterItemIndex = jsfilterItem.getString("value");
            JSONObject jsValueField = (JSONObject)jsSettings.opt(1);
            String value = jsValueField.getString("value");
            JSONObject jsFuzzy = (JSONObject)jsSettings.opt(2);
            String isFuzzy = jsFuzzy.getString("value");
            view = this.getFilterEntityViewInfo(Integer.parseInt(filterItemIndex), value, Boolean.valueOf(isFuzzy));
        }
        this.queryExecutor = this.getQueryExector(view);
    }

    private EntityViewInfo getFilterEntityViewInfo(int filterItemIndex, String value, boolean isFuzzy) {
        EntityViewInfo viewInfo = null;
        String compareOperator = "=";
        if (isFuzzy) {
            compareOperator = likeOpr;
        }
        FieldItem item = this.filterItems[filterItemIndex];
        StringBuffer oql = new StringBuffer("where ");
        if (numberAndName.equals(item.getName())) {
            oql.append(this.getQuickFilterOql("number", item.getType(), compareOperator, value));
            oql.append(" or ");
            oql.append(this.getQuickFilterOql("name", item.getType(), compareOperator, value));
        } else {
            oql.append(this.getQuickFilterOql(item.getName(), item.getType(), compareOperator, value));
        }
        try {
            viewInfo = new EntityViewInfo(oql.toString());
        }
        catch (Exception e) {
            viewInfo = null;
        }
        return viewInfo;
    }

    public IQueryExecutor getQueryExector(EntityViewInfo viewInfo) throws Exception {
        MetaDataPK metaDataPK = new MetaDataPK(this.queryInfo.getPackage(), this.queryInfo.getName());
        IQueryExecutor queryExecutor = QueryExecutorFactory.getLocalInstance((Context)this.getContext(), (IMetaDataPK)metaDataPK);
        queryExecutor.option().isIgnoreOrder = false;
        queryExecutor.option().isAutoTranslateBoolean = true;
        queryExecutor.option().isAutoTranslateEnum = true;
        queryExecutor.setObjectView(viewInfo);
        return queryExecutor;
    }

    public IRowSet getData(int start, int rows) throws Exception {
        if (this.queryExecutor == null) {
            this.queryExecutor = this.getQueryExector(null);
        }
        return this.queryExecutor.executeQuery(start, rows);
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        return sic;
    }

    public void setEventsProxy(DynamicFormEventsProxy.ModelEventsProxy eventsProxy) {
    }

    public void createNewData() throws BOSException, EASBizException {
        this.prmtObjValue = new PromptBoxObjectValue();
    }

    public String getDisplayValue(Object objValue, Field field) throws BOSException, EASBizException {
        return null;
    }

    public int getRowCount() throws BOSException {
        return this.queryExecutor.getRowCount();
    }

    private class PromptBoxObjectValue
    extends AbstractObjectValue {
        private PromptBoxObjectValue() {
        }

        public BOSObjectType getBOSType() {
            return null;
        }
    }

    public class FieldItem
    implements Serializable {
        private String name;
        private String displayName;
        private ConstDataType dataType;
        private int fieldAttr = 1;

        FieldItem(String name, String displayName, ConstDataType dataType) {
            this.name = name;
            this.displayName = displayName;
            this.dataType = dataType;
        }

        FieldItem(String name, String displayName, ConstDataType dataType, int fieldAttr) {
            this.name = name;
            this.displayName = displayName;
            this.dataType = dataType;
            this.fieldAttr = fieldAttr;
        }

        public String toString() {
            return this.displayName;
        }

        public String getName() {
            return this.name;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public ConstDataType getType() {
            return this.dataType;
        }

        public int getFieldAttr() {
            return this.fieldAttr;
        }

        public boolean isFilterField() {
            return (this.fieldAttr & 1) == 1;
        }

        public boolean isSeletorField() {
            return (this.fieldAttr & 2) == 2;
        }
    }
}

