/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.model.list;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.base.form.DAOHelper;
import com.kingdee.eas.base.form.metadata.Form;
import com.kingdee.eas.base.form.model.DynamicFormApplication;
import com.kingdee.eas.base.form.model.IDynamicFormModel;
import com.kingdee.eas.base.form.model.IDynamicFormView;
import com.kingdee.eas.base.form.model.IFormApplication;
import com.kingdee.eas.base.form.model.OperationStatus;
import com.kingdee.eas.base.form.model.list.IListModel;
import com.kingdee.eas.base.form.model.list.IListView;
import com.kingdee.eas.base.form.model.list.ListEventsProxy;
import com.kingdee.eas.base.form.model.list.ListPlugin;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import java.sql.SQLException;
import java.util.List;

public class ListApplication
extends DynamicFormApplication
implements IFormApplication {
    private ListEventsProxy eventsProxy;
    private IListModel listModel;
    private IListView listView;
    private Context context;
    private String loadedId;
    private IObjectValue objectValue;

    public Context getContext() {
        return this.context;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public ListApplication(IDynamicFormView listView, IDynamicFormModel listModel) {
        super(listView, listModel);
        this.listModel = (IListModel)listModel;
        this.listView = (IListView)listView;
        this.eventsProxy = new ListEventsProxy();
        this.listView.setEventsProxy(this.eventsProxy.getViewEventsProxy());
        this.listModel.setEventsProxy(this.eventsProxy.getModelEventsProxy());
    }

    public void registPlugIn(ListPlugin plugin) {
        plugin.attachApplication(this);
        this.eventsProxy.addListListener(plugin);
    }

    public void registPlugIn(List plugins) throws BOSException {
        if (plugins.size() == 0) {
            return;
        }
        try {
            for (String className : plugins) {
                ListPlugin plugin = (ListPlugin)Class.forName(className).newInstance();
                this.registPlugIn(plugin);
            }
        }
        catch (InstantiationException e) {
            throw new BOSException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new BOSException((Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public IListModel getListModel() {
        return this.listModel;
    }

    public IListView getListView() {
        return this.listView;
    }

    public void operateBill(OperationStatus status, String pk) throws BOSException {
        this.listView.operateBill(status, pk);
    }

    public void operateBill(OperationStatus status, String formId, String layoutId, String pk) throws Throwable, SQLException {
        this.listView.operateBill(status, formId, layoutId, pk);
    }

    public void delete(List rowList) throws BOSException, EASBizException {
        this.listView.delete(rowList);
    }

    public String getMainOrgId() {
        if (this.getListModel().getBusinessInfo().getMainOrgField() != null) {
            return this.getListModel().getMainOrg();
        }
        OrgUnitInfo mainOrg = this.getMainOrgUnit();
        return mainOrg == null ? null : mainOrg.getId().toString();
    }

    public String getLoginUserId() {
        return this.context.getCaller().toString();
    }

    public String getFieldName(String key, boolean isDisplayName) {
        return this.listModel.getFieldName(key, isDisplayName);
    }

    public void doCustomOperation(String operation) throws EASBizException, BOSException {
        this.eventsProxy.getViewEventsProxy().doCustomOperation(operation);
    }

    public IDynamicFormView getView() {
        return this.listView;
    }

    public Object getSelectedRowData(String entityKey, String property) throws BOSException {
        return this.getListView().getSelectedBillIds();
    }

    public Form getForm() {
        return this.listModel.getBusinessInfo().getForm();
    }

    public Object searchValue(String key, int row) throws BOSException {
        return this.listModel.searchValue(key, row);
    }

    public String getCustomWorkFlowID() throws EASBizException, BOSException {
        return this.eventsProxy.getViewEventsProxy().fireGetCustomWorkFlowID();
    }

    public IObjectValue getBillValue() throws BOSException {
        String[] ids = this.getListView().getSelectedBillIds();
        if (ids != null && ids.length > 0) {
            if (ids[0].equals(this.loadedId)) {
                return this.objectValue;
            }
            this.loadedId = ids[0];
            SelectorItemCollection selector = this.listModel.getBusinessInfo().getSelector();
            this.objectValue = DAOHelper.getDAO().load(this.getContext(), this.loadedId, selector);
            return this.objectValue;
        }
        return null;
    }

    public String getTableAlias(String key) {
        return this.getTableAlias(key, true);
    }

    public String getTableAlias(String key, boolean isBaseDataField) {
        return this.listModel.getTableAlias(key, isBaseDataField, false);
    }

    public String getTableAlias(String key, boolean isBaseDataField, boolean tableForDisplayField) {
        return this.listModel.getTableAlias(key, isBaseDataField, tableForDisplayField);
    }
}

