/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.model.list;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.base.form.json.JSONArray;
import com.kingdee.eas.base.form.json.JSONException;
import com.kingdee.eas.base.form.json.JSONObject;
import com.kingdee.eas.base.form.metadata.Appearance;
import com.kingdee.eas.base.form.metadata.BusinessInfo;
import com.kingdee.eas.base.form.metadata.ControlAppearance;
import com.kingdee.eas.base.form.metadata.EntityAppearance;
import com.kingdee.eas.base.form.metadata.Field;
import com.kingdee.eas.base.form.metadata.FieldAppearance;
import com.kingdee.eas.base.form.metadata.LayoutInfo;
import com.kingdee.eas.base.form.metadata.SelectField;
import com.kingdee.eas.base.form.model.DynamicFormApplication;
import com.kingdee.eas.base.form.model.command.QuickQueryDefaultValue;
import com.kingdee.eas.base.form.model.list.ListApplication;
import com.kingdee.eas.base.form.model.list.RangeFilterValidator;
import com.kingdee.eas.base.form.util.SQLHelper;
import com.kingdee.eas.base.form.util.UnifiedEnumUtils;
import com.kingdee.eas.common.EASBizException;
import java.awt.Rectangle;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class ListQuickFilterModel {
    public static String KEY_QUERY = "btnQuery";
    public static String KEY_RESET = "btnReset";
    public static String KEY_ADV_QUERY = "btnAdvQuery";
    private static final int DEFAULT_HEIGHT = 21;
    private static final int DEFAULT_WIDTH = 240;
    private static final int DEFAULT_MARGIN = 25;
    private List quickFilterFields;
    private LayoutInfo filterLayout;
    private BusinessInfo bizInfo;
    private ListApplication application;
    private String filterString;
    private String mainOrgFilter;
    private Object[] filterParameters;
    private Map defaultValues;
    private int lowestLineY = 0;
    private QuickQueryDefaultValue dvalueArg;

    public ListQuickFilterModel(BusinessInfo bizInfo, LayoutInfo layoutinfo, List quickFilterFields, QuickQueryDefaultValue dvalueArg) {
        this.bizInfo = bizInfo;
        this.quickFilterFields = quickFilterFields;
        this.dvalueArg = dvalueArg;
        this.defaultValues = new HashMap();
        this.createQuickFilterLayout(layoutinfo, quickFilterFields);
    }

    public List getQuickFilterFields() {
        return this.quickFilterFields;
    }

    public void setApplication(ListApplication application) {
        this.application = application;
    }

    private EntityAppearance createEntity() {
        EntityAppearance entity = new EntityAppearance("QuickFilterPanel");
        entity.setElementType(201);
        entity.setControlType(-1);
        entity.setBounds(0, 0, 0, 100);
        return entity;
    }

    public DynamicFormApplication getApplication() {
        return this.application;
    }

    public void applyDefaultValue() throws EASBizException, BOSException {
        this.defaultValues.clear();
        for (SelectField selectfield : this.quickFilterFields) {
            Field field = selectfield.getField();
            Object value = this.dvalueArg.getValue(field.getKey());
            if (field.getElementType() == 4 || field.getElementType() == 5 || field.getElementType() == 26 || field.getElementType() == 28) {
                value = this.dvalueArg.getValue(field.getKey() + "$1");
                this.application.setDateValue(field.getKey() + "$1", value, 0);
                this.application.setDateValue(field.getKey() + "$2", this.dvalueArg.getValue(field.getKey() + "$2"), 0);
                this.application.setValue(field.getKey(), value, 0);
                continue;
            }
            this.application.setValue(field.getKey(), value, 0);
        }
    }

    private FieldAppearance cloneField(LayoutInfo layout, String key, int tabIndex) {
        FieldAppearance ap = (FieldAppearance)layout.getAppearance(key).clone();
        ap.setVisible(1);
        ap.setStyle(1);
        ap.setTabindex(tabIndex);
        ap.setEntityKey("QuickFilterPanel");
        if (ap.getControlType() == 999 || ap.getControlType() == 1015) {
            ap.setControlType(1);
        }
        return ap;
    }

    private FieldAppearance cloneField(LayoutInfo layout, String key, String caption, String keySuffix, int tabIndex) {
        FieldAppearance ap = this.cloneField(layout, key, tabIndex);
        ap.setCaption(caption);
        ap.setKeyWithoutChangeEvent(key + keySuffix);
        return ap;
    }

    private void createQuickFilterLayout(LayoutInfo layout, List quickFilterFields) {
        this.filterLayout = new LayoutInfo("QuickFilter");
        EntityAppearance entity = this.createEntity();
        this.filterLayout.add((Appearance)entity);
        int i = -1;
        for (SelectField field : quickFilterFields) {
            FieldAppearance fieldAp = layout.getFieldAppearance(field.getKey());
            ++i;
            if (field.isRangeFilter()) {
                if (i % 3 == 2) {
                    ++i;
                }
                FieldAppearance apFrom = this.cloneField(layout, field.getKey(), fieldAp.getCaption() + " \u4ece", "$1", i);
                this.addFilterField(apFrom, i / 3, i % 3);
                FieldAppearance apTo = this.cloneField(layout, field.getKey(), " \u81f3", "$2", ++i);
                this.addFilterField(apTo, i / 3, i % 3);
                continue;
            }
            FieldAppearance ap = this.cloneField(layout, field.getKey(), i);
            this.addFilterField(ap, i / 3, i % 3);
        }
        if (++i % 3 == 0) {
            this.lowestLineY = this.lowestLineY + 21 + 10 + 5;
        }
        if (quickFilterFields.size() > 0) {
            this.filterLayout.add((Appearance)this.createButton(KEY_QUERY, "\u67e5\u8be2", 545, this.lowestLineY, 50, -1));
            this.filterLayout.add((Appearance)this.createButton(KEY_RESET, "\u91cd\u7f6e", 600, this.lowestLineY, 50, -2));
            this.filterLayout.add((Appearance)this.createButton(KEY_ADV_QUERY, "\u7b5b\u9009", 670, this.lowestLineY, 60, -3));
        } else {
            this.filterLayout.add((Appearance)this.createButton(KEY_ADV_QUERY, "\u7b5b\u9009", 25, this.lowestLineY + 5, 60, -1));
        }
    }

    private void addFilterField(FieldAppearance ap, int line, int column) {
        this.adjustFieldLocation(ap, line, column);
        this.filterLayout.add((Appearance)ap);
    }

    private void adjustFieldLocation(FieldAppearance field, int line, int column) {
        Rectangle rect = field.getBounds();
        rect.x = (column + 1) * 25 + column * 240;
        rect.y = 5 + line * 31;
        rect.height = 21;
        rect.width = 240;
        this.lowestLineY = rect.y;
    }

    private ControlAppearance createButton(String key, String caption, int x, int y, int width, int tabIndex) {
        ControlAppearance btn = new ControlAppearance(key);
        btn.setCaption(caption);
        btn.setControlType(1002);
        btn.setBounds(x, y, width, 21);
        btn.setEntityKey("QuickFilterPanel");
        btn.setTabindex(tabIndex);
        return btn;
    }

    public LayoutInfo getLayoutInfo() {
        return this.filterLayout;
    }

    public void setSetting(JSONArray jsSettings) throws JSONException, ParseException, BOSException {
        if (jsSettings != null && jsSettings.length() > 0) {
            StringBuffer predicate = new StringBuffer(400);
            ArrayList array = new ArrayList();
            String mainOrgField = null;
            if (this.bizInfo.getMainOrgField() != null) {
                mainOrgField = this.bizInfo.getMainOrgField().getKey();
                this.mainOrgFilter = null;
            }
            RangeFilterValidator rangeValidator = new RangeFilterValidator();
            for (int i = 0; i < jsSettings.length(); ++i) {
                boolean isRangeFilter;
                JSONObject jsField = (JSONObject)jsSettings.opt(i);
                String fieldKey = jsField.getString("key");
                int lenOfFieldKey = fieldKey.length();
                boolean bl = lenOfFieldKey <= 2 ? false : (isRangeFilter = fieldKey.charAt(lenOfFieldKey - 2) == '$');
                boolean isFrom = isRangeFilter ? fieldKey.charAt(fieldKey.length() - 1) == '1' : false;
                String fieldValue = jsField.getString("value");
                if (isRangeFilter) {
                    fieldKey = fieldKey.substring(0, lenOfFieldKey - 2);
                }
                if (isRangeFilter && !rangeValidator.validate(fieldKey, fieldValue, isFrom)) {
                    FieldAppearance ap1 = this.filterLayout.getFieldAppearance(fieldKey + "$1");
                    FieldAppearance ap2 = this.filterLayout.getFieldAppearance(fieldKey + "$2");
                    fieldKey = fieldKey.substring(0, lenOfFieldKey - 2);
                    throw new BOSException(ap1.getCaption() + ap2.getCaption() + " \u6761\u4ef6\u8303\u56f4\u8bbe\u7f6e\u4e0d\u5f53\uff0c\u524d\u8005  \u5e94\u8be5\u5c0f\u4e8e\u7b49\u4e8e  \u540e\u8005!");
                }
                if (fieldKey.equalsIgnoreCase(mainOrgField) && !StringUtils.isEmpty((String)fieldValue)) {
                    this.mainOrgFilter = fieldValue;
                    continue;
                }
                if (fieldValue.trim().length() <= 0) continue;
                for (SelectField field : this.quickFilterFields) {
                    if (!field.getKey().equalsIgnoreCase(fieldKey)) continue;
                    if (field.getField().getElementType() == 24) {
                        String[] f7Objs = fieldValue.split(";");
                        for (int j = 0; j < f7Objs.length; ++j) {
                            predicate.append(" AND ");
                            SQLHelper.appendPredicate((StringBuffer)predicate, (Field)field.getField(), (String)field.getFieldName(this.application.getContext()), (String)f7Objs[j], (boolean)isRangeFilter, (boolean)isFrom, (int)UnifiedEnumUtils.getFieldEnumColType((BusinessInfo)this.bizInfo, (Field)field.getField()));
                        }
                        continue;
                    }
                    predicate.append(" AND ");
                    SQLHelper.appendPredicate((StringBuffer)predicate, (Field)field.getField(), (String)field.getFieldName(this.application.getContext()), (String)fieldValue, (boolean)isRangeFilter, (boolean)isFrom, (int)UnifiedEnumUtils.getFieldEnumColType((BusinessInfo)this.bizInfo, (Field)field.getField()));
                }
            }
            if (predicate.length() > 0) {
                this.filterString = predicate.substring(4);
                this.filterParameters = array.toArray();
            } else {
                this.filterString = "";
            }
        }
    }

    public String getFilterString() {
        return this.filterString;
    }

    public Object[] getFilterParameters() {
        return this.filterParameters;
    }

    public int getLowestY() {
        return this.lowestLineY;
    }

    public String getMainOrgFilter() {
        return this.mainOrgFilter;
    }

    public Object getValue(String key, int row) {
        return this.defaultValues.get(key.toUpperCase());
    }

    public void setValue(String key, Object value, int row) throws BOSException, EASBizException {
        this.defaultValues.put(key.toUpperCase(), value);
    }
}

