/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.plugin;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.eas.base.form.model.IFormApplication;
import com.kingdee.eas.base.form.model.bill.BillApplication;
import com.kingdee.eas.base.form.model.command.ActionArgs;
import com.kingdee.eas.base.form.plugin.AbstractFormBusiness;
import com.kingdee.eas.base.form.util.WorkCalendarFacade;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;

public class CalcAmountOfWorkdayAction
extends AbstractFormBusiness {
    public CalcAmountOfWorkdayAction(IFormApplication application) {
        super(application);
    }

    public void doAction(ActionArgs e) throws BOSException, EASBizException {
        boolean defaultIsNatureDay = false;
        int defaultMeasureType = 1;
        if (this.application instanceof BillApplication) {
            BillApplication ba = (BillApplication)this.application;
            String[] params = e.getParamenter();
            this.validateParam(params);
            Date start = (Date)ba.getValue(params[0], e.getRow());
            Date end = (Date)ba.getValue(params[1], e.getRow());
            String updateFieldKey = params[2];
            boolean isNatureDay = params.length == 4 ? Integer.parseInt(params[3]) == 1 : defaultIsNatureDay;
            int measureType = params.length == 5 ? Integer.parseInt(params[4]) : defaultMeasureType;
            int updateFieldKeyType = ba.getBillModel().getBusinessInfo().getField(updateFieldKey).getElementType();
            int dateType = ba.getBillModel().getBusinessInfo().getField(params[0]).getElementType();
            if (start != null && end != null) {
                if (end.before(start)) {
                    ((BillApplication)this.application).showMessage("\u5f00\u59cb\u65e5\u671f\u9700\u5c0f\u4e8e\u7ed3\u675f\u65e5\u671f\uff01");
                    ba.setValue(params[2], null, e.getRow());
                    return;
                }
                if (4 == dateType) {
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(end);
                    calendar.add(13, 86399);
                    end = calendar.getTime();
                }
                AdminOrgUnitInfo orgUnit = WorkCalendarFacade.getOrgUnitOfPrimaryOccupation((Context)this.application.getContext());
                BigDecimal amountOfDay = null;
                try {
                    amountOfDay = WorkCalendarFacade.getAmountOfWorkTime((String)orgUnit.getId().toString(), (Date)start, (Date)end, (boolean)isNatureDay, (int)measureType);
                }
                catch (ObjectNotFoundException e1) {
                    if (e1.getMessage() != null && e1.getMessage().indexOf("MissingRecord:WorkCalendar") >= 0) {
                        ((BillApplication)this.application).showMessage("\u8bf7\u68c0\u67e5\u662f\u5426\u5df2\u6b63\u786e\u8bbe\u7f6e\u5de5\u4f5c\u65e5\u5386\uff01");
                    }
                    ba.setValue(params[2], null, e.getRow());
                    return;
                }
                if (3 == updateFieldKeyType) {
                    ba.setValue(updateFieldKey, amountOfDay.toBigInteger(), e.getRow());
                } else {
                    ba.setValue(updateFieldKey, amountOfDay, e.getRow());
                }
            } else {
                ba.setValue(params[2], null, e.getRow());
            }
        }
    }

    private void validateParam(String[] parameters) {
        if (parameters == null) {
            throw new IllegalArgumentException("parameter is null");
        }
    }
}

