/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.plugin;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.base.form.json.JSONException;
import com.kingdee.eas.base.form.json.JSONObject;
import com.kingdee.eas.base.form.model.DynamicFormApplication;
import com.kingdee.eas.base.form.model.IFormApplication;
import com.kingdee.eas.base.form.model.command.ActionArgs;
import com.kingdee.eas.base.form.plugin.AbstractFormBusiness;
import com.kingdee.eas.base.form.plugin.ActionUtil;
import com.kingdee.eas.base.form.util.ExpressionUtil;
import com.kingdee.eas.base.form.util.ResourceUtil;
import com.kingdee.eas.base.form.web.IDynamicWebFormView;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.StringUtils;

public class ShowPopupAction
extends AbstractFormBusiness {
    private DynamicFormApplication application;

    public ShowPopupAction(IFormApplication application) {
        super(application);
        this.application = (DynamicFormApplication)application;
    }

    public void doAction(ActionArgs e) throws BOSException, EASBizException {
        String[] parameters = e.getParamenter();
        if (parameters.length < 2) {
            return;
        }
        int idxUrlParam = 2;
        int idxWinParam = 3;
        String linkFunc = parameters[0];
        String url = ActionUtil.parseUrl(linkFunc);
        if (url.equalsIgnoreCase("Custom")) {
            if (parameters.length < 3) {
                throw new IllegalArgumentException("\u81ea\u5b9a\u4e49\u94fe\u63a5\u7c7b\u578b\u5fc5\u987b\u63d0\u4f9b\u771f\u5b9e\u7684URL");
            }
            url = parameters[2];
            idxUrlParam = 3;
            idxWinParam = 4;
        }
        boolean isStringWithMark = "BillList".equalsIgnoreCase(linkFunc);
        String popupMode = parameters[1];
        if (popupMode == null || !"openNewWindow".equalsIgnoreCase(popupMode) && !"openDialog".equalsIgnoreCase(popupMode)) {
            throw new UnsupportedOperationException("The popupMode is unsupported!");
        }
        String urlParam = parameters[idxUrlParam];
        try {
            urlParam = this.attachNeededParam(popupMode, urlParam);
        }
        catch (JSONException e2) {
            throw new BOSException((Throwable)e2);
        }
        url = ResourceUtil.buildUrlEncodeParam((String)url, parameters.length < idxUrlParam ? null : ExpressionUtil.handleParamFillingValue((DynamicFormApplication)this.application, (String)urlParam, (int)e.getRow(), (boolean)isStringWithMark));
        if (url == null) {
            return;
        }
        String name = null;
        String title = null;
        int x = 0;
        int y = 0;
        if (parameters.length > idxWinParam) {
            try {
                JSONObject js = new JSONObject(parameters[idxWinParam]);
                name = js.getString("name");
                title = js.getString("title");
                x = js.getInt("x");
                y = js.getInt("y");
            }
            catch (JSONException e1) {
                throw new BOSException((Throwable)e1);
            }
        }
        if (name == null) {
            name = "";
        }
        if (title == null) {
            title = "";
        }
        if (x <= 0) {
            x = 800;
        }
        if (y <= 0) {
            y = 800;
        }
        this.application.popupWindow(url, popupMode, name, title, x, y);
    }

    private String attachNeededParam(String popupMode, String urlParam) throws JSONException {
        String sessionId;
        JSONObject js = StringUtils.isEmpty((String)urlParam) ? new JSONObject() : new JSONObject(urlParam);
        if (this.application != null && "openNewWindow".equalsIgnoreCase(popupMode) && (sessionId = (String)this.application.getCustomParameter("JSESSIONID")) != null) {
            js.put("JSESSIONID", (Object)sessionId);
        }
        js.put("parentPageId", (Object)((IDynamicWebFormView)this.application.getDynamicFormView()).getPageId());
        return js.toString();
    }
}

