/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.plugin;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.biz.trans.AssignatePersonsInfo;
import com.kingdee.bos.workflow.monitor.PostParticipantUtil;
import com.kingdee.bos.workflow.participant.ActivityPersonsInfo;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.form.metadata.Field;
import com.kingdee.eas.base.form.metadata.FormOperation;
import com.kingdee.eas.base.form.model.DynamicFormApplication;
import com.kingdee.eas.base.form.model.IFormApplication;
import com.kingdee.eas.base.form.model.bill.BillApplication;
import com.kingdee.eas.base.form.model.bill.BillBusinessUtil;
import com.kingdee.eas.base.form.util.ResourceUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.util.BusinessProcessUtil;
import com.kingdee.eas.framework.batchaction.ActionCommonException;
import com.kingdee.util.enums.Enum;
import com.kingdee.util.enums.EnumUtils;
import com.kingdee.util.enums.IntEnum;

public final class UpdateStateHelper {
    private IFormApplication application;

    public UpdateStateHelper(IFormApplication application) {
        this.application = application;
    }

    public boolean updateBillState(FormOperation fo, int row) throws ActionCommonException, EASBizException, BOSException {
        boolean result = false;
        if (fo == null || fo.getStateField() == null || fo.getSuccessSateValue() == null || this.application.getView().getWfState().isFromWorkflow()) {
            return false;
        }
        DynamicFormApplication application = (DynamicFormApplication)this.application;
        Field stateField = application.getDynamicFormModel().getBusinessInfo().getField(fo.getStateField());
        if (stateField == null) {
            return false;
        }
        int elementType = stateField.getElementType();
        try {
            this.checkPreState(fo, row, elementType);
            if (elementType == 9) {
                BizEnumValueType enumType = this.getEnumType(stateField.getPropertyName());
                if (enumType == null) {
                    return false;
                }
                if (BizEnumValueType.INTEGER.equals((Object)enumType)) {
                    if (application instanceof BillApplication) {
                        application.setValue(fo.getStateField(), (Object)Integer.valueOf(fo.getSuccessSateValue()), row);
                    } else {
                        String prperty = application.getDynamicFormModel().getBusinessInfo().getFullPropertyName(stateField.getKey());
                        this.application.getBillValue().put(prperty, (Object)Integer.valueOf(fo.getSuccessSateValue()));
                    }
                    result = true;
                } else if (BizEnumValueType.STRING.equals((Object)enumType)) {
                    application.setValue(fo.getStateField(), (Object)fo.getSuccessSateValue(), row);
                    result = true;
                }
            } else if (elementType == 8) {
                application.setValue(fo.getStateField(), (Object)Boolean.valueOf(fo.getSuccessSateValue()), row);
                result = true;
            }
        }
        catch (NumberFormatException e1) {
            throw new BOSException((Throwable)e1);
        }
        catch (ClassNotFoundException e1) {
            throw new BOSException((Throwable)e1);
        }
        return result;
    }

    private void checkPreState(FormOperation fo, int row, int elementType) throws ClassNotFoundException, ActionCommonException, BOSException {
        if (elementType == 8) {
            return;
        }
        if (fo.getPreStateValue() == null || fo.getPreStateValue().length() == 0) {
            return;
        }
        String fieldKey = fo.getStateField();
        if (BillBusinessUtil.isEnabledState(this.application, fo, row)) {
            return;
        }
        Object oldState = BillBusinessUtil.searchValue((DynamicFormApplication)this.application, this.application.getBillValue(), fieldKey, row);
        Enum oldStateEnum = this.getEnum(fieldKey, oldState);
        throw new ActionCommonException(null, ResourceUtil.getMessage((Context)this.application.getContext(), (String)"NOT_ALLOW", (String[])new String[]{oldStateEnum == null ? "\u7a7a" : oldStateEnum.toString(), fo.getName()}));
    }

    private Enum getEnum(String feildKey, Object enumValue) throws ClassNotFoundException {
        if (enumValue == null) {
            return null;
        }
        IntEnum oldStateEnum = null;
        DynamicFormApplication application = (DynamicFormApplication)this.application;
        int enumType = application.getDynamicFormModel().getBusinessInfo().getField(feildKey).getEnumType();
        String enumClassName = application.getDynamicFormModel().getBusinessInfo().getEnumInfo().get(String.valueOf(enumType)).getEnumClassName();
        if (enumValue instanceof Integer) {
            oldStateEnum = EnumUtils.getEnum(Class.forName(enumClassName), (int)((Integer)enumValue));
        } else if (enumValue instanceof String) {
            oldStateEnum = EnumUtils.getEnumByValue(Class.forName(enumClassName), (String)((String)enumValue));
        }
        return oldStateEnum;
    }

    private BizEnumValueType getEnumType(String propertyName) throws BOSException {
        if (propertyName == null) {
            return null;
        }
        PropertyInfo property = BusinessProcessUtil.getPropertyInfo((Context)this.application.getContext(), (BOSObjectType)BOSObjectType.create((String)this.application.getForm().getBosType()), (String)propertyName);
        if (!(property instanceof OwnPropertyInfo)) {
            return null;
        }
        BizEnumInfo enumInfo = ((OwnPropertyInfo)property).getEnumType();
        if (enumInfo == null) {
            return null;
        }
        BizEnumValueType enumType = enumInfo.getDataType();
        return enumType;
    }

    private String checkNextParticipants(IEnactmentService wfService, String processDefID, String userId) throws WfException {
        String msg = null;
        AssignatePersonsInfo assignatePersons = wfService.checkPostActivitiesPersonsResult(processDefID, userId);
        if (assignatePersons != null) {
            msg = PostParticipantUtil.checkPostActivityPersons(null, (ActivityPersonsInfo[])assignatePersons.getActivityPersons());
        }
        return msg;
    }

    public boolean havePersonId(String processDefID) throws BOSException, WfException {
        String userId = this.application.getContext().getCaller().toString();
        IEnactmentService wfService = EnactmentServiceFactory.createEnactService((Context)this.application.getContext());
        String msg = this.checkNextParticipants(wfService, processDefID, userId);
        return msg == null;
    }
}

