/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.app;

import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.base.form.app.PropertyNameParser;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class EntityViewParser {
    private List filterTables;
    private List filters;
    private String filterMask;
    private String mainTableAlias;
    private String locale;
    private StringBuffer filterString;
    private Map property2filterTable;
    private EntityViewInfo evi;
    private EntityObjectInfo mainEO;

    public EntityViewParser(EntityViewInfo evi, EntityObjectInfo mainEO, Map property2table, String mainTableAlias, String locale) {
        this.mainTableAlias = mainTableAlias;
        this.mainEO = mainEO;
        this.evi = evi;
        this.locale = locale;
        this.filters = new ArrayList();
        this.filterString = new StringBuffer();
        this.property2filterTable = property2table;
        this.filterTables = new ArrayList();
        this.parseFilter();
    }

    public List getFilterTables() {
        return this.filterTables;
    }

    public void setFilterTables(List filterTables) {
        this.filterTables = filterTables;
    }

    public String getFilterString() {
        return this.filterString.toString();
    }

    private void parseFilter() {
        FilterInfo fi = this.evi.getFilter();
        this.parseFilterInfo(fi);
        this.filterMask = fi.getMaskString();
        this.constructFilterString();
    }

    private void parseFilterInfo(FilterInfo fi) {
        FilterItemCollection fic = fi.getFilterItems();
        if (fic.size() > 0) {
            PropertyNameParser pnp = new PropertyNameParser(this.mainEO, this.property2filterTable, this.mainTableAlias, this.filterTables, this.locale);
            for (FilterItemInfo filterItem : fic) {
                String propertyName = filterItem.getPropertyName();
                pnp.parseProperty(propertyName);
                this.filters.add(this.getCondition(pnp.getFieldName(), filterItem, propertyName));
            }
        }
    }

    private String getCondition(String fieldName, FilterItemInfo filterItem, String completePropName) {
        String filter = filterItem.toString();
        String condition = filter.replaceFirst(completePropName, fieldName);
        return condition;
    }

    private void constructFilterString() {
        int from = 0;
        int SHARP = 35;
        if (StringUtils.isEmpty((String)this.filterMask)) {
            this.filterString.append(this.filters.get(0));
        } else {
            do {
                int sharpPos;
                if ((sharpPos = this.filterMask.indexOf(SHARP, from)) >= 0) {
                    int nonDigitPos;
                    if (sharpPos > from) {
                        this.filterString.append(this.filterMask.substring(from, sharpPos));
                    }
                    for (nonDigitPos = sharpPos + 1; nonDigitPos < this.filterMask.length() && Character.isDigit(this.filterMask.charAt(nonDigitPos)); ++nonDigitPos) {
                    }
                    int filterIndex = Integer.parseInt(this.filterMask.substring(sharpPos + 1, nonDigitPos));
                    this.filterString.append(this.filters.get(filterIndex));
                    from = nonDigitPos;
                    continue;
                }
                this.filterString.append(this.filterMask.substring(from));
                from = this.filterMask.length();
            } while (from < this.filterMask.length());
        }
    }
}

