/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.app;

import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.form.metadata.FilterTable;
import com.kingdee.eas.base.form.metadata.LookUpTable;
import com.kingdee.eas.base.form.metadata.Table;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class PropertyNameParser {
    private List filterTables;
    private String fieldName;
    private String mainTableAlias;
    private String locale;
    private Map property2filterTable;
    private EntityObjectInfo mainEO;

    public PropertyNameParser(Map property2table, String mainTableAlias, String locale) {
        this.mainTableAlias = mainTableAlias;
        this.locale = locale;
        this.property2filterTable = property2table;
        this.filterTables = new ArrayList();
    }

    public PropertyNameParser(EntityObjectInfo mainEO, Map property2table, String mainTableAlias, List filterTables, String locale) {
        this.mainTableAlias = mainTableAlias;
        this.mainEO = mainEO;
        this.locale = locale;
        this.property2filterTable = property2table;
    }

    public List getFilterTables() {
        return this.filterTables;
    }

    private void convert2fieldName(String tableAlias, PropertyInfo property) {
        ColumnInfo columnInfo = property.getMappingField();
        this.fieldName = columnInfo.isMultilingual() ? tableAlias + "." + columnInfo.getName() + "_" + this.locale : tableAlias + "." + columnInfo.getName();
    }

    private Table getFilterTable(String key, EntityObjectInfo eoiSupplier, String tableAliasClient, String propertyName, RelationshipInfo relation) {
        Table table = (Table)this.property2filterTable.get(key);
        if (table == null) {
            PropertyInfo propSupplier = relation.getSupplierProperty();
            PropertyInfo propClient = relation.getClientProperty();
            String tableAliasSupplier = tableAliasClient + "_" + propertyName;
            table = new FilterTable(eoiSupplier.getTable().getName(), tableAliasSupplier, tableAliasSupplier + "." + propSupplier.getMappingField().getName(), tableAliasClient + "." + propClient.getMappingField().getName());
            this.filterTables.add(table);
            this.property2filterTable.put(key, table);
        } else if (table instanceof LookUpTable) {
            this.filterTables.add(table);
        }
        return table;
    }

    private void validateProperty(PropertyInfo property, String propertyName, String entityName) throws IllegalArgumentException {
        if (property == null) {
            throw new IllegalArgumentException("XML\u914d\u7f6e\u6587\u4ef6\u914d\u7f6e\u7684\u5c5e\u6027" + propertyName + "\u4e0d\u662f\u5b9e\u4f53" + entityName + "\u6709\u6548\u7684\u5c5e\u6027");
        }
    }

    public void parseProperty(Context ctx, String bosType, String propertyName) {
        this.mainEO = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx).getEntity(BOSObjectType.create((String)bosType));
        this.parseProperty(propertyName);
    }

    public void parseProperty(String propertyName) {
        if (propertyName != null && propertyName.trim().length() > 0) {
            String[] splits = propertyName.split("\\.");
            if (splits.length == 1) {
                PropertyInfo property = this.mainEO.getPropertyByNameRuntime(propertyName);
                this.convert2fieldName(this.mainTableAlias, property);
            } else {
                this.parseProperty(propertyName, splits);
            }
        }
    }

    private void parseProperty(String name, String[] splits) {
        EntityObjectInfo eoi = null;
        String propNameWithPrefix = null;
        String tableAlias = this.mainTableAlias;
        Table table = null;
        RelationshipInfo relation = null;
        eoi = this.mainEO;
        int idx = 0;
        do {
            String propName = splits[idx];
            propNameWithPrefix = tableAlias + "_" + propName;
            LinkPropertyInfo linkedPropInfo = (LinkPropertyInfo)eoi.getPropertyByNameRuntime(splits[idx]);
            this.validateProperty((PropertyInfo)linkedPropInfo, name, eoi.getAlias());
            relation = linkedPropInfo.getRelationship();
            eoi = relation.getSupplierObject();
            if (idx == splits.length - 2) {
                String lastname = splits[splits.length - 1];
                PropertyInfo prop = eoi.getPropertyByNameRuntime(lastname);
                this.validateProperty(prop, name, eoi.getAlias());
                if (!prop.equals((Object)relation.getClientProperty()) && !prop.equals((Object)relation.getSupplierProperty())) {
                    table = this.getFilterTable(propNameWithPrefix, eoi, tableAlias, propName, relation);
                    tableAlias = table.getTableNameAs();
                    this.convert2fieldName(tableAlias, prop);
                    break;
                }
                this.convert2fieldName(tableAlias, (PropertyInfo)linkedPropInfo);
                break;
            }
            table = this.getFilterTable(propNameWithPrefix, eoi, tableAlias, propName, relation);
            tableAlias = table.getTableNameAs();
        } while (++idx < splits.length);
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }
}

