/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.app;

import com.kingdee.bos.AbstractBOSObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.event.adapter.EventServiceProviderManager;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.IServiceContext;
import com.kingdee.bos.service.ServiceContext;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.workflow.ProcessDefInfo;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.biz.trans.AssignatePersonsInfo;
import com.kingdee.bos.workflow.define.ActivityCollection;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.ManpowerActivityDef;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.StartActivityDef;
import com.kingdee.bos.workflow.metas.AssignCollection;
import com.kingdee.bos.workflow.metas.AssignInfo;
import com.kingdee.bos.workflow.monitor.PostParticipantUtil;
import com.kingdee.bos.workflow.participant.ActivityPersonsInfo;
import com.kingdee.bos.workflow.service.EnactmentServiceProxy;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.form.DAOHelper;
import com.kingdee.eas.base.form.RemoteObjectFacade;
import com.kingdee.eas.base.form.app.PropertyNameParser;
import com.kingdee.eas.base.form.core.app.FormDBUtils;
import com.kingdee.eas.base.form.json.JSONArray;
import com.kingdee.eas.base.form.json.JSONObject;
import com.kingdee.eas.base.form.metadata.FormMetaData;
import com.kingdee.eas.base.form.metadata.LookUpObject;
import com.kingdee.eas.base.form.web.FormMetaCacheManager;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.app.processor.TransactionInvokeUtil;
import com.kingdee.eas.dynbusiness.config.PropertyCheckConfigItems;
import com.kingdee.eas.dynbusiness.util.BusinessProcessUtil;
import com.kingdee.eas.dynbusiness.util.StringUtil;
import com.kingdee.eas.framework.batchaction.BatchActionUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class RemoteObjectFacadeBean
extends AbstractBOSObject
implements RemoteObjectFacade {
    private static Logger logger = Logger.getLogger(DbUtil.class);

    public RemoteObjectFacadeBean() {
    }

    public RemoteObjectFacadeBean(Context ctx) {
        super(ctx);
    }

    public BOSObjectType getType() {
        return null;
    }

    @Override
    public JSONArray getFormList(String sql, String prefix, Object[] params) throws BOSException {
        IRowSet forms = DbUtil.executeQuery((Context)this.getContext(), (String)sql, (Object[])params);
        JSONArray jsForms = new JSONArray();
        try {
            while (forms.next()) {
                JSONObject jsForm = new JSONObject();
                jsForm.put("text", forms.getString("FName_" + this.getContext().getLocale().toString()));
                jsForm.put("id", prefix + forms.getString("FID"));
                jsForm.put("leaf", true);
                jsForms.put(jsForm);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return jsForms;
    }

    @Override
    public FormMetaData getFormMeta(String formId, String bosType) throws BOSException {
        return FormMetaCacheManager.getFormMeta(this.getContext(), formId, bosType);
    }

    public String saveBill(IObjectValue objectValue, String billId, IObjectCollection botRelations) throws BOSException {
        if (this.notExist(billId)) {
            billId = DAOHelper.getDAO().addnew(this.getContext(), objectValue);
        } else {
            DAOHelper.getDAO().update(this.getContext(), objectValue);
        }
        if (botRelations != null) {
            this.saveBOTRelations(botRelations);
        }
        return billId;
    }

    @Override
    public String saveBillInTransaction(IObjectValue objectValue, String billId, IObjectCollection botRelations) throws BOSException, EASBizException {
        return (String)TransactionInvokeUtil.invokeRequired((Object)this, (String)"saveBill", (Object[])new Object[]{objectValue, billId, botRelations}, (Class[])new Class[]{IObjectValue.class, String.class, IObjectCollection.class});
    }

    private boolean notExist(String billId) throws DataAccessException {
        return billId == null || !DAOHelper.getDAO().exists(this.getContext(), billId.toString());
    }

    @Override
    public void invokeRequired(Object invoker, String methodName, Object[] params, Class[] classType) throws EASBizException, BOSException {
        TransactionInvokeUtil.invokeRequired((Object)invoker, (String)methodName, (Object[])params, (Class[])classType);
    }

    private void saveBOTRelations(IObjectCollection botRelations) throws BOSException {
        IBOTRelation iBOTRelation = BOTRelationFactory.getLocalInstance((Context)this.getContext());
        for (int i = 0; i < botRelations.size(); ++i) {
            BOTRelationInfo info = (BOTRelationInfo)botRelations.getObject(i);
            info.setIsEffected(false);
            if (info.getId() != null && iBOTRelation.exists((IObjectPK)new ObjectUuidPK(info.getId()))) {
                iBOTRelation.update((IObjectPK)new ObjectUuidPK(info.getId()), info);
                continue;
            }
            iBOTRelation.addnew(info);
        }
    }

    @Override
    public boolean isBillInWorkFlow(String billId) throws BOSException {
        IEnactmentService wfService = this.getEnactmentService();
        ProcessInstInfo[] procInsts = wfService.getProcessInstanceByHoldedObjectId(billId);
        for (int i = 0; i < procInsts.length; ++i) {
            if (!procInsts[i].getState().startsWith("closed")) {
                return true;
            }
            wfService.unregistProcessBizObj(billId);
        }
        AssignCollection assignCol = wfService.getAssignInfoCollection("where bizobjid = '" + billId + "'");
        if (assignCol != null) {
            int i;
            ArrayList<String> procInstIdList = new ArrayList<String>();
            for (i = assignCol.size(); i > 0; --i) {
                AssignInfo assign = assignCol.get(i - 1);
                if (assign == null) continue;
                procInstIdList.add(assign.getProcInstID().toString());
            }
            procInsts = wfService.getProcessInstInfos(procInstIdList.toArray(new String[procInstIdList.size()]));
            for (i = 0; i < procInsts.length; ++i) {
                if (procInsts[i].getState().startsWith("closed")) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isFirstNodeManualNode(String processDefId) throws BOSException {
        ProcessDefInfo pdi;
        IEnactmentService wfService = this.getEnactmentService();
        ProcessDef pd = wfService.getProcessDefByDefineHashValue((pdi = wfService.getProcessDefInfo(processDefId)).getMd5HashValue());
        StartActivityDef startActivity = pd.getStartActivity();
        ActivityCollection collection = startActivity.getPostActivities();
        if (collection == null || collection.size() == 0) {
            return false;
        }
        ActivityDef ad = collection.get(0);
        return ad instanceof ManpowerActivityDef;
    }

    @Override
    public void startNewProcessInstance(String billId, String processDefId, String userId, Map processParams) throws BOSException {
        IEnactmentService wfService = this.getEnactmentService();
        HashMap<String, String> boMap = new HashMap<String, String>();
        boMap.put(billId, billId);
        wfService.createAndCompleteFiristActivity(processDefId, processParams, userId, boMap);
    }

    @Override
    public boolean hasParticipantsInNextNode(String processDefId, String userId) throws BOSException {
        return this.hasParticipantsInNextNode(this.getEnactmentService(), processDefId, userId);
    }

    private boolean hasParticipantsInNextNode(IEnactmentService wfService, String processDefId, String userId) throws BOSException {
        String msg;
        boolean has = true;
        AssignatePersonsInfo assignatePersons = wfService.checkPostActivitiesPersonsResult(processDefId, userId);
        if (assignatePersons != null && (msg = PostParticipantUtil.checkPostActivityPersons(null, (ActivityPersonsInfo[])assignatePersons.getActivityPersons())) != null) {
            logger.info((Object)("DYNFORM:hasParticipantsInNextNode, msg=" + msg));
            has = false;
        }
        return has;
    }

    private IEnactmentService getEnactmentService() throws BOSException {
        return EnactmentServiceFactory.createEnactService((Context)this.getContext());
    }

    @Override
    public void sendWorkFlowEvent(String bosType, Object[] params) throws BOSException {
        ServiceContext srvContext = new ServiceContext(MetaDataTypeList.ENTITY, BOSObjectType.create((String)bosType), null, params);
        EventServiceProviderManager.getDynamicBillEventServiceProvider().sendEvent((IServiceContext)srvContext);
    }

    @Override
    public boolean isExistsSameData(IObjectValue objValue, String checkProp, String[] controlProps) throws BOSException {
        return RemoteObjectFacadeBean.isExistsForData(this.getContext(), objValue, checkProp, controlProps);
    }

    public static boolean isExistsForData(Context ctx, IObjectValue objValue, String checkProp, String[] controlProps) throws BOSException {
        String number = objValue.getString(checkProp);
        if (number == null || number.trim().length() == 0) {
            return false;
        }
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo(checkProp, (Object)number, CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (objValue.get("id") != null) {
            filterItem = new FilterItemInfo("id", (Object)objValue.get("id").toString(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        if (controlProps != null) {
            for (int i = 0; i < controlProps.length; ++i) {
                String ctrlProp = controlProps[i];
                if (objValue.get(ctrlProp) != null) {
                    Object value = objValue.get(ctrlProp);
                    if (value instanceof IObjectValue) {
                        value = ((IObjectValue)value).get("id");
                    }
                    filterItem = new FilterItemInfo(ctrlProp, (Object)value.toString(), CompareType.EQUALS);
                    filter.getFilterItems().add(filterItem);
                    continue;
                }
                filterItem = new FilterItemInfo(ctrlProp, null, CompareType.EQUALS);
                filter.getFilterItems().add(filterItem);
            }
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        return DAOHelper.getDAO().exists(ctx, objValue.getBOSType(), filter);
    }

    @Override
    public void update(IObjectValue value) throws DataAccessException {
        DAOHelper.getDAO().update(this.getContext(), value);
    }

    @Override
    public void delete(String pk) throws DataAccessException {
        DAOHelper.getDAO().delete(this.getContext(), pk);
    }

    @Override
    public void delete(String[] pks) throws DataAccessException {
        DAOHelper.getDAO().delete(this.getContext(), pks);
    }

    @Override
    public IObjectValue load(String pk, SelectorItemCollection selector) throws DataAccessException {
        return DAOHelper.getDAO().load(this.getContext(), pk, selector);
    }

    @Override
    public String addnew(IObjectValue value) throws DataAccessException {
        return DAOHelper.getDAO().addnew(this.getContext(), value);
    }

    @Override
    public IObjectPK[] getPKList(BOSObjectType bosType, FilterInfo filter, SorterItemCollection sorter) throws DataAccessException {
        return DAOHelper.getDAO().getPKList(this.getContext(), bosType, filter, sorter);
    }

    @Override
    public PropertyInfo getPropertyInfo(BOSObjectType bosType, String propName) throws BOSException {
        PropertyInfo property;
        if (propName == null) {
            return null;
        }
        EntityObjectInfo mainEO = RemoteObjectFacadeBean.getEntityInfo(this.getContext(), bosType);
        String[] splits = propName.split("\\.");
        if (splits.length == 1) {
            property = mainEO.getPropertyByNameRuntime(propName);
        } else {
            HashMap subEntities = new HashMap();
            property = RemoteObjectFacadeBean.getPropertyInfo(mainEO, propName, splits, subEntities);
        }
        return property;
    }

    public static PropertyInfo getPropertyInfo(EntityObjectInfo mainEo, String name, String[] splits, Map subEntities) {
        String lastname;
        PropertyInfo prop;
        EntityObjectInfo eoi = null;
        eoi = mainEo;
        if (splits.length > 1) {
            int idx = 0;
            do {
                String propName;
                if (!subEntities.containsKey(propName = eoi.getName() + StringUtil.nameFromSplits((String[])splits, (int)(idx + 1)))) {
                    LinkPropertyInfo linkedPropInfo = (LinkPropertyInfo)eoi.getPropertyByNameRuntime(splits[idx]);
                    if (linkedPropInfo == null) {
                        throw new IllegalArgumentException("XML\u914d\u7f6e\u6587\u4ef6\u914d\u7f6e\u7684\u5c5e\u6027" + name + "\u4e0d\u662f\u5b9e\u4f53" + eoi.getAlias() + "\u6709\u6548\u7684\u5c5e\u6027");
                    }
                    RelationshipInfo relation = linkedPropInfo.getRelationship();
                    EntityObjectInfo childEo = relation.getChildObject(eoi);
                    subEntities.put(propName, childEo);
                    eoi = childEo;
                    continue;
                }
                eoi = (EntityObjectInfo)subEntities.get(propName);
            } while (++idx < splits.length - 1);
        }
        if ((prop = eoi.getPropertyByNameRuntime(lastname = splits[splits.length - 1])) == null) {
            throw new IllegalArgumentException("XML\u914d\u7f6e\u6587\u4ef6\u914d\u7f6e\u7684\u5c5e\u6027" + name + "\u4e0d\u662f\u5b9e\u4f53" + eoi.getAlias() + "\u6709\u6548\u7684\u5c5e\u6027");
        }
        return prop;
    }

    public static EntityObjectInfo getEntityInfo(Context ctx, BOSObjectType bosType) {
        EntityObjectInfo mainEO = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx).getEntity(bosType);
        return mainEO;
    }

    @Override
    public OrgType getOrgTypeFromEntity(BOSObjectType type) {
        EntityObjectInfo mainEO = RemoteObjectFacadeBean.getEntityInfo(this.getContext(), type);
        String orgType = (String)mainEO.getExtendedProperties().get("OrgType");
        if (orgType == null) {
            orgType = "NONE";
        }
        OrgType ot = OrgType.getEnum((String)orgType);
        return ot;
    }

    @Override
    public IObjectCollection getCollectionInstance(BOSObjectType bosType) throws BOSException {
        return BatchActionUtil.getCollectionInstance((Context)this.getContext(), (BOSObjectType)bosType);
    }

    @Override
    public void validateAtSave(PropertyCheckConfigItems checkItems, String bosType, IObjectValue objValue) throws EASBizException, BOSException {
    }

    @Override
    public IObjectValue createNewObject(String bosType) throws BOSException, EASBizException {
        EntityObjectInfo eo = MetaDataLoaderFactory.getMetaDataLoader((Context)this.getContext()).getEntity(BOSObjectType.create((String)bosType));
        String ovc = eo.getObjectValueClass();
        IObjectValue ov = null;
        try {
            ov = (IObjectValue)Class.forName(ovc).newInstance();
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return ov;
    }

    @Override
    public IEnactmentService getEnacementService() throws BOSException {
        IEnactmentService wfService = EnactmentServiceProxy.getEnacementService((Context)this.getContext());
        return wfService;
    }

    @Override
    public void parseProperty(PropertyNameParser pnp, String bosType, String propertyName) {
        pnp.parseProperty(this.getContext(), bosType, propertyName);
    }

    @Override
    public EntityObjectInfo getEntityInfo(BOSObjectType bosType) {
        EntityObjectInfo mainEO = MetaDataLoaderFactory.getMetaDataLoader((Context)this.getContext()).getEntity(bosType);
        return mainEO;
    }

    @Override
    public IObjectValue getBaseDataByKey(LookUpObject lookupObj, String key, String value, String filter, String[] selectors) throws BOSException, EASBizException {
        IObjectCollection collection = this.getBaseDatasByFilter(this.getContext(), selectors, lookupObj, new FilterItemInfo[][]{{new FilterItemInfo(key, (Object)value, CompareType.EQUALS)}});
        if (collection == null || collection.size() == 0) {
            return null;
        }
        return collection.getObject(0);
    }

    @Override
    public IObjectCollection getBaseDatasByKeys(LookUpObject lookupObj, String key, String value, String filter, String[] selectors) throws BOSException, EASBizException {
        IObjectCollection collection = this.getBaseDatasByFilter(this.getContext(), selectors, lookupObj, new FilterItemInfo[][]{{new FilterItemInfo(key, (Object)value, CompareType.INCLUDE)}});
        return collection;
    }

    private IObjectCollection getBaseDatasByFilter(Context ctx, String[] selectors, LookUpObject lookupObj, FilterItemInfo[][] filterItems) throws BOSException, EASBizException {
        String bosType = lookupObj.getBosType();
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        if (selectors != null) {
            for (int i = 0; i < selectors.length; ++i) {
                sic.add(new SelectorItemInfo(selectors[i]));
            }
        }
        viewInfo.setSelector(sic);
        IObjectCollection collection = BusinessProcessUtil.getCollectionByBosType((Context)ctx, (String)bosType, (EntityViewInfo)viewInfo, (FilterItemInfo[][])filterItems, null);
        return collection;
    }

    @Override
    public IObjectCollection getCollectionByBosType(String bosType, EntityViewInfo view, FilterItemInfo[][] filterItems, FilterInfo fixedFilter) throws BOSException, EASBizException {
        return BusinessProcessUtil.getCollectionByBosType((Context)this.getContext(), (String)bosType, (EntityViewInfo)view, (FilterItemInfo[][])filterItems, (FilterInfo)fixedFilter);
    }

    @Override
    public boolean isDynWebForm(String bosType) {
        return FormDBUtils.isDynWebForm(this.getContext(), bosType);
    }
}

