/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.form.app.EntityViewParser;
import com.kingdee.eas.base.form.app.PropertyNameParser;
import com.kingdee.eas.base.form.metadata.BaseTableReference;
import com.kingdee.eas.base.form.metadata.BusinessInfo;
import com.kingdee.eas.base.form.metadata.Entity;
import com.kingdee.eas.base.form.metadata.EntityTable;
import com.kingdee.eas.base.form.metadata.FilterTable;
import com.kingdee.eas.base.form.metadata.LookUpTable;
import com.kingdee.eas.base.form.metadata.QueryInfo;
import com.kingdee.eas.base.form.metadata.SelectField;
import com.kingdee.eas.base.form.metadata.Table;
import com.kingdee.eas.base.form.util.PermissionHelper;
import com.kingdee.eas.base.form.util.ResourceUtil;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SQLBuilder {
    private QueryInfo queryInfo;
    private String masterEntityKey;
    private List selectEntitys = new ArrayList();
    private List selectFields;
    private List filterTables;
    private List filterFields;
    private String sqlFrom = "";
    private String sqlWhere = "";
    private String sqlSelect = "";
    private String permissionRule;
    private String mergedFilter;
    private FilterInfo filterInfo;
    private Map baseReferTables;

    public SQLBuilder(QueryInfo queryInfo) {
        this.queryInfo = queryInfo;
    }

    public String getSQLWhere() {
        return this.sqlWhere;
    }

    public List getSelectFields() {
        return this.selectFields;
    }

    public void setSelectFields(List selectFields) {
        this.selectFields = selectFields;
    }

    public String getSQLSelect() {
        return this.sqlSelect;
    }

    public void setSQLSelect(String sqlSelect) {
        this.sqlSelect = sqlSelect;
    }

    public String getSQLFrom() {
        return this.sqlFrom;
    }

    public String getPk() {
        EntityTable entityTable = this.queryInfo.getEntityTable(this.masterEntityKey);
        if (entityTable.getPkFieldName() != null) {
            return entityTable.getPkFieldName();
        }
        return entityTable.getEntryPkFieldName();
    }

    public String getMasterEntityKey() {
        return this.masterEntityKey;
    }

    public void setMasterEntityKey(String masterEntityKey) {
        this.masterEntityKey = masterEntityKey.toUpperCase();
    }

    public List getSelectEntitys() {
        return this.selectEntitys;
    }

    public void setSelectEntitys(List selectEntitys) {
        this.selectEntitys = selectEntitys;
        this.selectFields = new ArrayList();
        for (String entityKey : selectEntitys) {
            this.selectFields.addAll(this.queryInfo.getEntitySelectFields(entityKey));
        }
    }

    public void setSelectEntitys(List selectEntitys, boolean useDefaultSelectFields) {
        if (useDefaultSelectFields) {
            this.selectEntitys = selectEntitys;
        } else {
            this.setSelectEntitys(selectEntitys);
        }
    }

    public void buildSQL(Context ctx) throws BOSException {
        this.buildSQLSelect(ctx);
        this.buildSQLFrom(ctx);
    }

    private void add2FilterTables(List tables) {
        if (this.filterTables == null) {
            this.filterTables = tables;
        } else {
            for (Table table1 : tables) {
                boolean matched = false;
                for (Table table2 : this.filterTables) {
                    if (!table1.getTableNameAs().equals(table2.getTableNameAs())) continue;
                    matched = true;
                    break;
                }
                if (matched) continue;
                this.filterTables.add(table1);
            }
        }
    }

    private String getFieldNameFromProerpty(Context ctx, String bosType, String propertyName) {
        PropertyNameParser pnp = new PropertyNameParser(this.queryInfo.getProperty2tableMap(), this.queryInfo.getMainTableAlias(), ResourceUtil.getLanguage(ctx));
        pnp.parseProperty(ctx, bosType, propertyName);
        this.add2FilterTables(pnp.getFilterTables());
        return pnp.getFieldName();
    }

    private void buildSQLSelect(Context ctx) {
        StringBuffer sb = new StringBuffer();
        this.clearBaseReferTables();
        for (SelectField field : this.getSelectFields()) {
            if (field.getLookupTable() != null) {
                LookUpTable lookup = field.getLookupTable();
                if (lookup.getReferTable() != null) {
                    this.addLookWithBaseReferTable(field.getKey(), lookup);
                }
                sb.append(field.getLookupTable().getDisplayFieldName(ctx));
            } else {
                sb.append(field.getFieldName(ctx));
            }
            sb.append(" as \"");
            sb.append(field.getFieldNameAs());
            sb.append("\",");
        }
        this.sqlSelect = sb.toString().substring(0, sb.length() - 1);
    }

    private void buildLeftJoin(Map joinedTables, StringBuffer sql, String tableName, String tableNameAs, String aFieldName, String bFieldName) {
        if (joinedTables.containsKey(tableNameAs)) {
            return;
        }
        sql.append(" LEFT JOIN ");
        sql.append(tableName);
        sql.append(" ");
        sql.append(tableNameAs);
        sql.append(" ON ");
        sql.append(aFieldName);
        sql.append("=");
        sql.append(bFieldName);
        sql.append("\n");
        joinedTables.put(tableNameAs, "1");
    }

    private void buildLeftJoin(Map joinedTables, StringBuffer sql, Table joinedTable, String aFieldName, String bFieldName) {
        this.buildLeftJoin(joinedTables, sql, joinedTable.getTableName(), joinedTable.getTableNameAs(), aFieldName, bFieldName);
    }

    private void buildSQLFrom(Context ctx) throws BOSException {
        LookUpTable lookupTable;
        HashMap<String, String> selectTable = new HashMap<String, String>();
        EntityTable entityTable22 = this.queryInfo.getEntityTable(this.masterEntityKey);
        String mastertablePk = entityTable22.getPkFieldName();
        if (entityTable22.getTableName() == null) {
            return;
        }
        StringBuffer sb = new StringBuffer(entityTable22.getTableName());
        sb.append(" ");
        sb.append(entityTable22.getTableNameAs());
        selectTable.put(entityTable22.getTableNameAs(), "1");
        for (EntityTable entityTable22 : this.queryInfo.getEntityTables()) {
            if (entityTable22.getKey().equals("FBillHead") || !this.selectEntitys.contains(entityTable22.getKey())) continue;
            this.buildLeftJoin(selectTable, sb, entityTable22, entityTable22.getEntryPkFieldName(), mastertablePk);
        }
        for (SelectField selectField : this.getSelectFields()) {
            lookupTable = selectField.getLookupTable();
            this.leftJoinLookupTable(selectTable, sb, lookupTable);
        }
        this.joinTableIntroducedByFilter(selectTable, sb);
        if (this.baseReferTables != null) {
            for (Map.Entry entry : this.baseReferTables.entrySet()) {
                lookupTable = (LookUpTable)entry.getValue();
                BaseTableReference referTable = lookupTable.getReferTable();
                this.buildLeftJoin(selectTable, sb, referTable.getSrcTableName(), lookupTable.getReferTableNameAs(), lookupTable.getReferTableNameAs() + "." + referTable.getSrcFieldName(), lookupTable.getTableNameAs() + "." + referTable.getFieldName());
            }
        }
        if (this.filterTables != null) {
            for (Object object : this.filterTables) {
                if (object instanceof LookUpTable) {
                    this.leftJoinLookupTable(selectTable, sb, (LookUpTable)object);
                    continue;
                }
                FilterTable filterTable = (FilterTable)object;
                this.buildLeftJoin(selectTable, sb, filterTable, filterTable.getT1Field(), filterTable.getT2Field());
            }
        }
        this.sqlFrom = sb.toString();
    }

    private void leftJoinLookupTable(Map selectTables, StringBuffer sql, LookUpTable table) {
        if (table != null) {
            this.buildLeftJoin(selectTables, sql, table, table.getPkFieldName(), table.getEntityTableFieldName());
        }
    }

    public void handlePermission(Context ctx, String permItemName, List orgList, String mainOrgPropertyName) throws BOSException {
        this.permissionRule = PermissionHelper.getPersmissionRule(ctx, permItemName, orgList, mainOrgPropertyName);
    }

    public void setQueryFilter(FilterInfo filter2append) throws BOSException {
        if (filter2append != null && filter2append.getFilterItems().size() > 0) {
            if (filter2append.getFilterItems().size() > 1 && StringUtils.isEmpty((String)filter2append.getMaskString())) {
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < filter2append.getFilterItems().size(); ++i) {
                    sb.append(" and #" + i);
                }
                filter2append.setMaskString(sb.substring(4));
            }
            this.filterInfo = filter2append;
        }
    }

    public FilterInfo getFilterInfo() {
        return this.filterInfo;
    }

    public void mergeFilter(Context ctx, BusinessInfo bizInfo, Map property2table, String mainTableAlias) throws BOSException {
        this.mergedFilter = null;
        this.filterTables = null;
        try {
            EntityViewInfo evi = !StringUtils.isEmpty((String)this.permissionRule) ? new EntityViewInfo(this.permissionRule) : new EntityViewInfo();
            if (this.filterInfo != null) {
                if (evi.getFilter() != null) {
                    evi.getFilter().mergeFilter(this.filterInfo, "AND");
                } else {
                    evi.setFilter(this.filterInfo);
                }
            }
            if (evi.getFilter() != null) {
                EntityObjectInfo eo = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx).getEntity(BOSObjectType.create((String)bizInfo.getEntity("FBillHead").getBosType()));
                EntityViewParser parser = new EntityViewParser(evi, eo, property2table, mainTableAlias, ResourceUtil.getLanguage(ctx));
                this.mergedFilter = parser.getFilterString();
                this.filterTables = parser.getFilterTables();
            }
        }
        catch (ParserException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public String getMergedFilter() {
        return this.mergedFilter;
    }

    private void clearBaseReferTables() {
        if (this.baseReferTables != null) {
            this.baseReferTables.clear();
        }
    }

    public void addLookWithBaseReferTable(String fieldKey, LookUpTable lookup) {
        if (this.baseReferTables == null) {
            this.baseReferTables = new HashMap();
        }
        this.baseReferTables.put(fieldKey, lookup);
    }

    public void addFilterFields(List fieldNames) {
        this.filterFields = fieldNames;
    }

    private void joinTableIntroducedByFilter(Map selectTable, StringBuffer sb) {
        if (this.filterFields != null) {
            for (String fieldName : this.filterFields) {
                LookUpTable lookupTable;
                SelectField sf = this.queryInfo.getSelectFieldByFieldName(fieldName);
                if (sf == null) {
                    int _pos = fieldName.indexOf(95);
                    sf = this.queryInfo.getSelectFieldByFieldName(fieldName.substring(0, _pos));
                }
                if ((lookupTable = sf.getLookupTable()) == null) continue;
                this.leftJoinLookupTable(selectTable, sb, lookupTable);
                if (lookupTable.getReferTable() == null) continue;
                this.addLookWithBaseReferTable(sf.getKey(), lookupTable);
            }
        }
    }

    public boolean isEntitySelected(Entity entity) {
        boolean selected = false;
        Iterator it = this.selectEntitys.iterator();
        while (it.hasNext()) {
            if (!entity.getKey().equals(it.next())) continue;
            selected = true;
            break;
        }
        return selected;
    }
}

