/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.metadata;

import com.kingdee.eas.base.form.metadata.Appearance;
import com.kingdee.eas.base.form.metadata.EnumBarItemProperty;
import com.kingdee.eas.base.form.metadata.EnumBarItemStyle;
import com.kingdee.eas.base.form.model.BarDataManager;
import com.kingdee.eas.base.form.model.BarEventsProxy;
import com.kingdee.eas.base.form.model.BarItemPropertyChangedEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class BarItem
extends Appearance {
    private BarEventsProxy.BarItemPropertyChangedEventProxy propertyChangeEventProxy;
    private String name;
    private String caption;
    private String caption_l2;
    private String caption_l1;
    private String caption_l3;
    private String description_l2;
    private String description_l1;
    private String description_l3;
    private String toolTip_l2;
    private String toolTip_l1;
    private String toolTip_l3;
    private String shortcut;
    private char mnemonicKey = (char)12;
    private String imageKey;
    private Object image;
    private EnumBarItemStyle style;
    private int checked;
    private int enabled;
    private boolean isBeginGroup;
    private int visible;
    private boolean showDescOnToolbar;
    private ArrayList clickActions;
    private Locale _locale;
    private int seq;
    private String templateName;
    private List children = new ArrayList();
    private List parents = new ArrayList();
    private boolean _nameKey_Synchronizing = false;
    private BarDataManager _barDataManagerOfSubCategory = null;

    public ArrayList getClickActions() {
        return this.clickActions;
    }

    public void setClickActions(ArrayList clickActions) {
        this.clickActions = clickActions;
    }

    public BarItem(String name, String caption_l2, String caption_l1, String caption_l3, String description_l2, String description_l1, String description_l3, String tooltip_l2, String tooltip_l1, String tooltip_l3, EnumBarItemStyle style, String imagekey, String shortcut, boolean enabled, boolean visible, boolean checked, boolean begingroup, int elementType, int seq) {
        super(name);
        this.name = name;
        this.caption_l2 = caption_l2;
        this.caption_l1 = caption_l1;
        this.caption_l3 = caption_l3;
        this.parseMnemonic();
        this.description_l2 = description_l2;
        this.description_l1 = description_l1;
        this.description_l3 = description_l3;
        this.toolTip_l2 = tooltip_l2;
        this.toolTip_l1 = tooltip_l1;
        this.toolTip_l3 = tooltip_l3;
        this.style = style;
        this.imageKey = imagekey;
        this.shortcut = shortcut;
        this.enabled = enabled ? 1 : 0;
        this.visible = visible ? 1 : 0;
        this.checked = checked ? 1 : 0;
        this.isBeginGroup = begingroup;
        this.elementType = elementType;
        this.key = name;
        this.seq = seq;
    }

    public BarItem(String name, String caption_l2, String caption_l1, String caption_l3, String description_l2, String description_l1, String description_l3, int elementType, int seq) {
        super(name);
        this.name = name;
        this.caption_l2 = caption_l2;
        this.caption_l1 = caption_l1;
        this.caption_l3 = caption_l3;
        this.parseMnemonic();
        this.description_l2 = description_l2;
        this.description_l1 = description_l1;
        this.description_l3 = description_l3;
        this.style = EnumBarItemStyle.BarSubCategory;
        this.elementType = elementType;
        this.key = name;
        this.seq = seq;
    }

    private void parseMnemonic() {
        int index = this.caption_l2.indexOf("(&");
        if (index > 0) {
            char vk = this.caption_l2.charAt(index + 2);
            if (vk >= 'a' && vk <= 'z') {
                vk = (char)(vk - 32);
            }
            this.mnemonicKey = vk;
        }
    }

    public char getMnemonicKey() {
        return this.mnemonicKey;
    }

    public String getShortcut() {
        return this.shortcut;
    }

    public void setShortcut(String shortcut) {
        this.shortcut = shortcut;
    }

    public void fireBarItemPropertyChange(EnumBarItemProperty property, Object newValue) {
        if (this.propertyChangeEventProxy != null) {
            this.propertyChangeEventProxy.fireBarItemPropertyChanged(new BarItemPropertyChangedEvent(this.name, property, newValue));
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.fireBarItemPropertyChange(EnumBarItemProperty.Name, this);
        if (!this._nameKey_Synchronizing) {
            try {
                this._nameKey_Synchronizing = true;
                this.setKey(name);
            }
            finally {
                this._nameKey_Synchronizing = false;
            }
        }
    }

    @Override
    public String getCaption() {
        return this.caption;
    }

    @Override
    public void setCaption(String caption) {
        super.setCaption(caption);
        this.caption = caption;
        this.fireBarItemPropertyChange(EnumBarItemProperty.Caption, this);
    }

    @Override
    public String getCaption_L2() {
        return this.caption_l2;
    }

    @Override
    public void setCaption_L2(String caption) {
        super.setCaption_L2(caption);
        this.caption_l2 = caption;
        this.parseMnemonic();
        this.fireBarItemPropertyChange(EnumBarItemProperty.Caption_l2, this);
    }

    @Override
    public String getCaption_L1() {
        return this.caption_l1;
    }

    @Override
    public void setCaption_L1(String caption) {
        super.setCaption_L1(caption);
        this.caption_l1 = caption;
        this.fireBarItemPropertyChange(EnumBarItemProperty.Caption_l1, this);
    }

    @Override
    public String getCaption_L3() {
        return this.caption_l3;
    }

    @Override
    public void setCaption_L3(String caption) {
        super.setCaption_L3(caption);
        this.caption_l3 = caption;
        this.fireBarItemPropertyChange(EnumBarItemProperty.Caption_l3, this);
    }

    public String getDescription_L2() {
        return this.description_l2;
    }

    public void setDescription_L2(String description) {
        this.description_l2 = description;
        this.fireBarItemPropertyChange(EnumBarItemProperty.Description_l2, this);
    }

    public String getDescription_L1() {
        return this.description_l1;
    }

    public void setDescription_L1(String description) {
        this.description_l1 = description;
        this.fireBarItemPropertyChange(EnumBarItemProperty.Description_l1, this);
    }

    public String getDescription_L3() {
        return this.description_l3;
    }

    public void setDescription_L3(String description) {
        this.description_l3 = description;
        this.fireBarItemPropertyChange(EnumBarItemProperty.Description_l3, this);
    }

    public String getToolTip_L2() {
        return this.toolTip_l2;
    }

    public void setToolTip_L2(String toolTip) {
        this.toolTip_l2 = toolTip;
        this.fireBarItemPropertyChange(EnumBarItemProperty.Tooltip_l2, this);
    }

    public String getToolTip_L1() {
        return this.toolTip_l1;
    }

    public void setToolTip_L1(String toolTip) {
        this.toolTip_l1 = toolTip;
        this.fireBarItemPropertyChange(EnumBarItemProperty.Tooltip_l1, this);
    }

    public String getToolTip_L3() {
        return this.toolTip_l3;
    }

    public void setToolTip_L3(String toolTip) {
        this.toolTip_l3 = toolTip;
        this.fireBarItemPropertyChange(EnumBarItemProperty.Tooltip_l3, this);
    }

    public String getImageKey() {
        return this.imageKey;
    }

    public void setImageKey(String imageKey) {
        this.imageKey = imageKey;
        this.fireBarItemPropertyChange(EnumBarItemProperty.ImageKey, this);
    }

    public Object getImage() {
        return this.image;
    }

    public void setImage(Object image) {
        this.image = image;
        this.fireBarItemPropertyChange(EnumBarItemProperty.Image, this);
    }

    public EnumBarItemStyle getStyle() {
        return this.style;
    }

    public void setStyle(EnumBarItemStyle style) {
        this.style = style;
        this.fireBarItemPropertyChange(EnumBarItemProperty.Style, this);
    }

    public int getChecked() {
        return this.checked;
    }

    public void setChecked(int checked) {
        this.checked = checked;
        this.fireBarItemPropertyChange(EnumBarItemProperty.Checked, this);
    }

    public int getEnabled() {
        return this.enabled;
    }

    public void setEnabled(int enabled) {
        this.enabled = enabled;
        this.fireBarItemPropertyChange(EnumBarItemProperty.Enabled, this);
    }

    public boolean isBeginGroup() {
        return this.isBeginGroup;
    }

    public void setBeginGroup(boolean isBeginGroup) {
        this.isBeginGroup = isBeginGroup;
        this.fireBarItemPropertyChange(EnumBarItemProperty.BeginGroup, this);
    }

    @Override
    public int getVisible() {
        return this.visible;
    }

    @Override
    public void setVisible(int visible) {
        this.visible = visible;
        this.fireBarItemPropertyChange(EnumBarItemProperty.Visible, this);
    }

    public boolean isShowDescOnToolbar() {
        return this.showDescOnToolbar;
    }

    public void setShowDescOnToolbar(boolean showDescOnToolbar) {
        this.showDescOnToolbar = showDescOnToolbar;
    }

    public boolean containChild(String barItemName) {
        boolean ret = false;
        for (BarItem item : this.children) {
            if (item.getName().compareToIgnoreCase(barItemName) != 0) continue;
            ret = true;
            break;
        }
        return ret;
    }

    public void addChildBarItem(int index, BarItem childItem) {
        this.children.add(index, childItem);
        childItem.setParent(this);
    }

    public void removeChildBarItem(BarItem childItem) {
        int idx = this.children.indexOf(childItem);
        if (idx >= 0) {
            this.children.remove(idx);
        }
        if (childItem.getParent() != null) {
            childItem.getParent().remove(this);
        }
    }

    public boolean containParent(String barItemName) {
        boolean ret = false;
        for (BarItem item : this.parents) {
            if (item.getName().compareToIgnoreCase(barItemName) != 0) continue;
            ret = true;
            break;
        }
        return ret;
    }

    public void setParent(BarItem parent) {
        if (!this.containParent(parent.getName())) {
            this.parents.add(parent);
        }
    }

    public int getChildrenSize() {
        return this.children.size();
    }

    public List getChildren() {
        return this.children;
    }

    public List getParent() {
        return this.parents;
    }

    public int getChildIndex(String barItemName) {
        int ret = this.children.size();
        for (int i = 0; i < this.children.size(); ++i) {
            BarItem barItem = (BarItem)this.children.get(i);
            if (!barItem.getName().equalsIgnoreCase(barItemName)) continue;
            ret = i + 1;
        }
        return ret;
    }

    public BarItem getParent(String parentItemName) {
        BarItem parent = null;
        for (BarItem item : this.parents) {
            if (item.getName().compareToIgnoreCase(parentItemName) != 0) continue;
            parent = item;
            break;
        }
        return parent;
    }

    public void setPropertyChangeEventProxy(BarEventsProxy.BarItemPropertyChangedEventProxy propertyChangeEventProxy) {
        this.propertyChangeEventProxy = propertyChangeEventProxy;
    }

    @Override
    public void setKey(String key) {
        super.setKey(key);
        if (!this._nameKey_Synchronizing) {
            try {
                this._nameKey_Synchronizing = true;
                this.setName(key);
            }
            finally {
                this._nameKey_Synchronizing = false;
            }
        }
    }

    public BarDataManager getBarDataManagerOfSubCategory() {
        return this._barDataManagerOfSubCategory;
    }

    public void setBarDataManagerOfSubCategory(BarDataManager dataManagerOfSubCategory) {
        this._barDataManagerOfSubCategory = dataManagerOfSubCategory;
    }

    public int getSeq() {
        return this.seq;
    }

    public void setSeq(int seq) {
        this.seq = seq;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }
}

