/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.metadata;

import com.kingdee.eas.base.form.metadata.Field;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;

public class EnumColType
implements Serializable {
    public static final int DATE = 0;
    public static final int QTY = 2;
    public static final int PRICE = 4;
    public static final int AMOUNT = 6;
    public static final int INT = 10;
    public static final int FLOAT = 9;
    public static final int STRING = 500;
    public static final int BOOLEAN = 501;
    public static final int DATETIME = 502;
    public static final int NUMERIC = 503;
    public static final int UINT = 998;

    public static boolean isDate(Field field) {
        return field.getFieldColType() == 0 || field.getFieldColType() == 502;
    }

    public static Object convert2Object(int type, String sValue) throws ParseException {
        Object oValue = null;
        try {
            switch (type) {
                case 2: 
                case 4: 
                case 6: 
                case 9: {
                    oValue = new BigDecimal(sValue);
                    break;
                }
                case 10: {
                    oValue = new Integer(sValue);
                    break;
                }
                case 501: {
                    oValue = new Boolean(sValue);
                    break;
                }
                case 0: {
                    oValue = "to_date('" + sValue.substring(0, 10) + "')";
                    break;
                }
                case 502: {
                    oValue = "to_date('" + sValue + "')";
                    break;
                }
                default: {
                    oValue = sValue;
                    break;
                }
            }
        }
        catch (Exception e) {
            if (e instanceof ParseException) {
                throw (ParseException)e;
            }
            throw new ParseException(e.getMessage(), 0);
        }
        return oValue;
    }

    private static String boolStr2IntStr(String bool) {
        if (bool.equalsIgnoreCase("true")) {
            return "1";
        }
        return "0";
    }

    public static String c2DBPredicate(int type, String sValue, boolean isLikeOp, boolean isFrom, boolean isUcase) throws ParseException {
        String retValue = null;
        try {
            switch (type) {
                case 2: 
                case 4: 
                case 6: 
                case 9: {
                    retValue = new BigDecimal(sValue).toString();
                    break;
                }
                case 10: {
                    if (Character.isDigit(sValue.charAt(0)) || '-' == sValue.charAt(0)) {
                        retValue = sValue;
                        break;
                    }
                    retValue = EnumColType.boolStr2IntStr(sValue);
                    break;
                }
                case 501: {
                    retValue = EnumColType.boolStr2IntStr(sValue);
                    break;
                }
                case 0: {
                    sValue = isFrom ? sValue.substring(0, 10) + " 00:00:00" : sValue.substring(0, 10) + " 23:59:59";
                }
                case 502: {
                    retValue = "to_date('" + sValue + "')";
                    break;
                }
                case 500: {
                    String like = isLikeOp ? "%" : "";
                    retValue = isUcase ? "ucase('" + like + sValue + like + "')" : "'" + like + sValue + like + "'";
                }
            }
        }
        catch (Exception e) {
            if (e instanceof ParseException) {
                throw (ParseException)e;
            }
            throw new ParseException(e.getMessage(), 0);
        }
        return retValue;
    }

    public static String getCompareGroupByElementType(int elementType) {
        String group = "0";
        switch (elementType) {
            case 1: 
            case 6: 
            case 12: 
            case 19: {
                group = "0";
                break;
            }
            case 2: 
            case 3: 
            case 20: 
            case 21: 
            case 22: {
                group = "1";
                break;
            }
            case 4: 
            case 5: 
            case 26: 
            case 28: {
                group = "2";
                break;
            }
            case 7: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 23: 
            case 24: 
            case 27: 
            case 10011: {
                group = "14";
                break;
            }
            case 9: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                group = "5";
                break;
            }
            case 8: {
                group = "7";
            }
        }
        return group;
    }
}

