/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.metadata;

import com.kingdee.bos.Context;
import com.kingdee.eas.base.form.metadata.BaseDataLookupInfo;
import com.kingdee.eas.base.form.metadata.BaseTableReference;
import com.kingdee.eas.base.form.metadata.BusinessInfo;
import com.kingdee.eas.base.form.metadata.Entity;
import com.kingdee.eas.base.form.metadata.EntityTable;
import com.kingdee.eas.base.form.metadata.Field;
import com.kingdee.eas.base.form.metadata.FieldAppearance;
import com.kingdee.eas.base.form.metadata.LayoutInfo;
import com.kingdee.eas.base.form.metadata.LookUpObject;
import com.kingdee.eas.base.form.metadata.LookUpTable;
import com.kingdee.eas.base.form.metadata.SelectField;
import com.kingdee.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class QueryInfo
implements Serializable {
    private List entityTables = new ArrayList();
    private List quickFilterFields = new ArrayList();
    private List listVisibleSelectFields;
    private List orderedQKFilterFields;
    private Map property2table;
    private Map key2selectField;
    private Map fieldName2selectField;
    private Map entityKey2sfList;
    private BusinessInfo businessinfo;
    private LayoutInfo layoutInfo;
    private String mainEntityTableAlias;
    private String mergedFilter;
    private boolean queryDefaultMainOrgOnly = true;
    private int firstRangeFilterIndex = -1;
    private Map entityTableMap = new HashMap();
    private Map field2baseDataLookupInfo;
    private int tableAliasCounter = 0;

    public List getEntityTables() {
        return this.entityTables;
    }

    public QueryInfo(BusinessInfo businessinfo, LayoutInfo layoutInfo) {
        this.property2table = new HashMap();
        this.key2selectField = new HashMap();
        this.entityKey2sfList = new HashMap();
        this.fieldName2selectField = new HashMap();
        this.field2baseDataLookupInfo = new HashMap();
        this.businessinfo = businessinfo;
        this.layoutInfo = layoutInfo;
        this.tableAliasCounter = businessinfo.getEntryCount();
        for (Entity entity : businessinfo.getEntrys()) {
            this.addEntity(entity);
        }
    }

    public QueryInfo(BusinessInfo businessinfo, List orderedFields, List orderedQKFilterFields, LayoutInfo layoutInfo) {
        this(businessinfo, layoutInfo);
        this.listVisibleSelectFields = this.createOrderedSelectFields(orderedFields);
        this.orderedQKFilterFields = orderedQKFilterFields;
    }

    private void addEntity(Entity entity) {
        String tableName = entity.getTableName();
        String tableNameAs = entity.getTableAlias();
        String pkFieldName = tableNameAs + "." + entity.getPkFieldName();
        String entryPkFieldName = null;
        if (entity.getEntryPkFieldName() != null) {
            entryPkFieldName = tableNameAs + "." + entity.getEntryPkFieldName();
        }
        EntityTable entityTable = new EntityTable(entity.getKey(), pkFieldName, entryPkFieldName, tableName, tableNameAs);
        if (entity.getEntityType() == 0) {
            this.mainEntityTableAlias = tableNameAs;
        } else {
            this.property2table.put(this.mainEntityTableAlias + "_" + entity.getEntryName(), entityTable);
        }
        int fieldsAdded = 0;
        for (Field field : entity.getFields()) {
            if (!this.addField(entityTable, field)) continue;
            ++fieldsAdded;
        }
        if (fieldsAdded > 0) {
            this.entityTables.add(entityTable);
            this.entityTableMap.put(entity.getKey().toUpperCase(), entityTable);
        }
    }

    public EntityTable getEntityTable(String key) {
        return (EntityTable)this.entityTableMap.get(key);
    }

    private String getFieldName(Field field) {
        return this.getFieldName(field, false);
    }

    private String getFieldName(Field field, boolean isGetDisplayField) {
        String fieldName = null;
        if (isGetDisplayField) {
            fieldName = field.getSrcDisplayFieldName();
            if (fieldName == null || fieldName.equals("")) {
                return "";
            }
            BaseTableReference refTable = this.getBaseTableReference(field.getKey());
            if (refTable != null) {
                fieldName = refTable.getDisplayFieldName();
            }
        } else {
            fieldName = field.getFieldName();
        }
        return fieldName;
    }

    private boolean addField(EntityTable entityTable, Field field) {
        int elementType = field.getElementType();
        if (elementType != 14 && StringUtils.isEmpty((String)field.getFieldName())) {
            return false;
        }
        String displayFieldName = null;
        SelectField selectField = new SelectField();
        String fieldName = null;
        switch (elementType) {
            case 14: {
                Field ctrlField = this.businessinfo.getField(field.getControlFieldKey());
                displayFieldName = this.getFieldName(field, true);
                if (ctrlField == null || displayFieldName.equals("")) {
                    return false;
                }
                fieldName = entityTable.getTableNameAs() + "." + ctrlField.getFieldName();
                selectField.setLookupTable(this.getLookUpTable(field.getElementType(), ctrlField, displayFieldName, fieldName));
                fieldName = selectField.getLookupTable().getTableNameAs() + "." + displayFieldName;
                this.property2table.put(entityTable.getTableNameAs() + "_" + field.getPropertyName(), selectField.getLookupTable());
                break;
            }
            case 7: 
            case 13: 
            case 17: 
            case 18: 
            case 27: {
                displayFieldName = this.getFieldName(field, true);
                if (displayFieldName.equals("")) {
                    return false;
                }
                fieldName = entityTable.getTableNameAs() + "." + this.getFieldName(field);
                selectField.setLookupTable(this.getLookUpTable(field.getElementType(), field, displayFieldName, fieldName));
                this.property2table.put(entityTable.getTableNameAs() + "_" + field.getPropertyName(), selectField.getLookupTable());
                break;
            }
            default: {
                fieldName = entityTable.getTableNameAs() + "." + this.getFieldName(field);
            }
        }
        FieldAppearance fap = this.layoutInfo.getFieldAppearance(field.getKey());
        selectField.setDefaultListVisible(fap.isDefaultVisible());
        selectField.setField(field);
        selectField.setFieldName(fieldName);
        selectField.setEntityKey(entityTable.getKey());
        selectField.setFieldType(field.getFieldColType());
        this.key2selectField.put(field.getKey(), selectField);
        this.fieldName2selectField.put(fieldName, selectField);
        this.put2EntitySelectList(entityTable.getKey(), selectField);
        return true;
    }

    public String getSelectFieldName(String key, Context ctx) {
        if (this.key2selectField == null) {
            return null;
        }
        SelectField selectField = (SelectField)this.key2selectField.get(key);
        if (selectField == null) {
            return null;
        }
        return selectField.getFieldName(ctx);
    }

    private void put2EntitySelectList(String entityKey, SelectField sf) {
        ArrayList<SelectField> sfList = (ArrayList<SelectField>)this.entityKey2sfList.get(entityKey);
        if (sfList == null) {
            sfList = new ArrayList<SelectField>();
            this.entityKey2sfList.put(entityKey, sfList);
        }
        sfList.add(sf);
    }

    private void addQuickFilterField(SelectField selectField) {
        Field mainOrgField;
        if (selectField.isRangeFilter()) {
            this.quickFilterFields.add(selectField);
            if (this.firstRangeFilterIndex < 0) {
                this.firstRangeFilterIndex = this.quickFilterFields.size();
            }
        } else if (this.firstRangeFilterIndex > 0) {
            this.quickFilterFields.add(this.firstRangeFilterIndex - 1, selectField);
        } else {
            this.quickFilterFields.add(selectField);
        }
        if ((mainOrgField = this.businessinfo.getMainOrgField()) != null && mainOrgField.getKey().equals(selectField.getKey())) {
            this.queryDefaultMainOrgOnly = false;
        }
    }

    public Field getField(String fieldKey) {
        return this.businessinfo.getField(fieldKey);
    }

    public String getLookUpObjectQueryInfo(int lookupObjId) {
        String queryInfo = null;
        LookUpObject lookupObj = this.businessinfo.getLookUpObject(lookupObjId);
        if (lookupObj != null) {
            queryInfo = lookupObj.getQueryInfo();
        }
        return queryInfo;
    }

    private LookUpTable getLookUpTable(int elementType, Field field, String displayFieldName, String fieldName) {
        LookUpObject lookupObject;
        LookUpTable lookupTable = null;
        if (lookupTable == null && (lookupObject = this.businessinfo.getLookUpObject(field.getLookUpObjectID())) != null) {
            BaseDataLookupInfo lookupInfo = this.getBaseDataLookupInfo(field.getKey(), this.getFieldName(field, true), lookupObject);
            boolean isBaseDataProperty = elementType == 14;
            lookupTable = new LookUpTable(isBaseDataProperty ? lookupInfo.getTableNameAs() + "." + displayFieldName : "", isBaseDataProperty, lookupInfo);
            BaseTableReference refTable = this.getBaseTableReference(field.getKey());
            if (refTable != null) {
                lookupTable.setReferTable(refTable);
            }
            lookupTable.setEntityTableFieldName(fieldName);
            return lookupTable;
        }
        return lookupTable;
    }

    private BaseDataLookupInfo getBaseDataLookupInfo(String key, String displayFieldName, LookUpObject lookupObject) {
        BaseDataLookupInfo lookupInfo = (BaseDataLookupInfo)this.field2baseDataLookupInfo.get(key);
        if (lookupInfo == null) {
            String tableNameAs = "t" + ++this.tableAliasCounter;
            String pkFieldName = tableNameAs + "." + lookupObject.getPkFieldName();
            String dspFieldName = tableNameAs + "." + displayFieldName;
            String numberName = tableNameAs + "." + lookupObject.getNumberFieldName();
            lookupInfo = new BaseDataLookupInfo(lookupObject.getTableName(), tableNameAs, pkFieldName, dspFieldName, numberName, lookupObject);
            this.field2baseDataLookupInfo.put(key, lookupInfo);
        }
        return lookupInfo;
    }

    private List getOrderedSelectFieldList(List orderRefList) {
        ArrayList<SelectField> retList = null;
        if (orderRefList != null) {
            retList = this.createOrderedSelectFields(orderRefList);
        } else {
            retList = new ArrayList<SelectField>();
            for (Map.Entry entry : this.key2selectField.entrySet()) {
                SelectField field = (SelectField)entry.getValue();
                retList.add(field);
            }
        }
        return retList;
    }

    private List createOrderedSelectFields(List fieldListInOrder) {
        ArrayList<SelectField> retList = new ArrayList<SelectField>();
        for (Field field : fieldListInOrder) {
            SelectField selectField = (SelectField)this.key2selectField.get(field.getKey());
            if (selectField == null) continue;
            retList.add(selectField);
        }
        return retList;
    }

    public List getFields() {
        return this.getOrderedSelectFieldList(null);
    }

    public List getListVisibleSelectFields() {
        return this.listVisibleSelectFields;
    }

    public Map getAllFields() {
        return this.key2selectField;
    }

    public List getQuickFilterFields() {
        if (this.quickFilterFields.size() == 0) {
            List orderFilterField = this.getOrderedSelectFieldList(this.orderedQKFilterFields);
            for (SelectField field : orderFilterField) {
                this.addQuickFilterField(field);
            }
        }
        return this.quickFilterFields;
    }

    public String getMergedFilter() {
        return this.mergedFilter;
    }

    public boolean isQueryDefaultMainOrgOnly() {
        return this.queryDefaultMainOrgOnly;
    }

    public SelectField getSelectField(String key) {
        return (SelectField)this.key2selectField.get(key);
    }

    public SelectField getSelectFieldByFieldName(String fieldName) {
        return (SelectField)this.fieldName2selectField.get(fieldName);
    }

    public List getEntitySelectFields(String entityKey) {
        return (List)this.entityKey2sfList.get(entityKey);
    }

    public Map getProperty2tableMap() {
        return this.property2table;
    }

    public String getMainTableAlias() {
        return this.mainEntityTableAlias;
    }

    public String getEntityBosType(String entityKey) {
        return this.businessinfo.getEntity(entityKey).getBosType();
    }

    public BaseTableReference getBaseTableReference(String fieldKey) {
        HashMap baseTableRefers = this.businessinfo.getBaseReferTables();
        return baseTableRefers == null ? null : (BaseTableReference)baseTableRefers.get(fieldKey);
    }
}

