/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.model;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.base.form.model.DynamicFormApplication;
import com.kingdee.eas.common.EASBizException;

public abstract class OperationStatus {
    private String status;
    public static final OperationStatus ADDNEW = new AddNewStatus("ADDNEW");
    public static final OperationStatus VIEW = new ViewStatus("VIEW");
    public static final OperationStatus EDIT = new EditStatus("EDIT");
    public static final OperationStatus VIEWTEMPLATE = new EditStatus("VIEWTEMPLATE");

    OperationStatus(String status) {
        this.status = status;
    }

    public static OperationStatus getStatus(String status) {
        if ("ADDNEW".equalsIgnoreCase(status)) {
            return ADDNEW;
        }
        if ("VIEW".equalsIgnoreCase(status)) {
            return VIEW;
        }
        if ("EDIT".equalsIgnoreCase(status)) {
            return EDIT;
        }
        if ("VIEWTEMPLATE".equalsIgnoreCase(status)) {
            return VIEWTEMPLATE;
        }
        throw new IllegalArgumentException("\u72b6\u6001" + status + "\u4e0d\u662f\u4e00\u4e2a\u6709\u6548\u7684\u72b6\u6001\uff01");
    }

    public String getStatus() {
        return this.status;
    }

    public boolean canTransfer(OperationStatus newStatus, DynamicFormApplication application) throws EASBizException, BOSException {
        return newStatus != null;
    }

    static class EditStatus
    extends OperationStatus {
        EditStatus(String status) {
            super(status);
        }

        @Override
        public boolean canTransfer(OperationStatus newStatus, DynamicFormApplication application) throws EASBizException, BOSException {
            if (EDIT.equals(newStatus) || super.canTransfer(newStatus, application)) {
                // empty if block
            }
            return true;
        }
    }

    static class ViewStatus
    extends OperationStatus {
        ViewStatus(String status) {
            super(status);
        }

        @Override
        public boolean canTransfer(OperationStatus newStatus, DynamicFormApplication application) throws EASBizException, BOSException {
            if (!super.canTransfer(newStatus, application) || newStatus.equals(EDIT)) {
                // empty if block
            }
            return true;
        }
    }

    static class ViewTemplateStatus
    extends OperationStatus {
        ViewTemplateStatus(String status) {
            super(status);
        }
    }

    static class AddNewStatus
    extends OperationStatus {
        AddNewStatus(String status) {
            super(status);
        }
    }
}

