/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.eas.base.form.core.FormFactory;
import com.kingdee.eas.base.form.json.JSONArray;
import com.kingdee.eas.base.form.json.JSONException;
import com.kingdee.eas.base.form.metadata.BusinessInfo;
import com.kingdee.eas.base.form.metadata.EnumItem;
import com.kingdee.eas.base.form.metadata.EnumObject;
import com.kingdee.eas.base.form.metadata.Field;
import com.kingdee.eas.base.form.util.UnifiedEnumUtils;
import com.kingdee.eas.dynbusiness.util.DataConverter;
import com.kingdee.eas.dynbusiness.util.ValidationUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.Enum;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public final class StringUtil {
    public static String formatString(Context ctx, Field field, String bosType, Object fldData, BusinessInfo bizInfo, String displayPattern) throws BOSException {
        if (fldData == null) {
            return "";
        }
        int elementType = field.getElementType();
        String result = null;
        switch (elementType) {
            case 2: 
            case 20: 
            case 21: 
            case 22: {
                result = StringUtil.formatStringByColType(field, fldData, displayPattern);
                break;
            }
            case 4: 
            case 5: 
            case 26: 
            case 28: {
                result = StringUtil.formatStringByColType(field, fldData, displayPattern);
                break;
            }
            case 32: {
                if (fldData instanceof Enum) {
                    return ((Enum)fldData).getAlias();
                }
                EnumObject enumObj = bizInfo.getEnumInfo().get(String.valueOf(field.getEnumType()));
                if (enumObj == null) {
                    return "";
                }
                String className = enumObj.getEnumClassName();
                if (StringUtils.isEmpty((String)className)) {
                    int enumValue;
                    if (fldData instanceof Integer) {
                        enumValue = (Integer)fldData;
                    } else if (fldData instanceof BigDecimal) {
                        enumValue = ((BigDecimal)fldData).intValue();
                    } else if (fldData instanceof String) {
                        enumValue = Integer.parseInt((String)fldData);
                    } else {
                        return "";
                    }
                    EnumItem item = enumObj.getEnumItem(enumValue);
                    if (item == null) {
                        return "";
                    }
                    return item.getDisplayValue();
                }
                DataType dt = DataType.ENUM;
                try {
                    Object returnValue = DataConverter.convertToRealType((Object)fldData, (DataType)dt, (String)className);
                    if (returnValue instanceof Enum) {
                        Enum e = (Enum)returnValue;
                        if (e == null) {
                            return "";
                        }
                        return e.getAlias();
                    }
                    break;
                }
                catch (DataConverter.DataConvertException e1) {
                    throw new BOSException((Throwable)e1);
                }
            }
            case 9: {
                EnumObject enumObj = bizInfo.getEnumInfo().get(String.valueOf(field.getEnumType()));
                try {
                    return UnifiedEnumUtils.getDisplayString(enumObj, elementType, fldData);
                }
                catch (DataConverter.DataConvertException e) {
                    throw new BOSException((Throwable)e);
                }
            }
            case 3: {
                if (fldData instanceof Integer && (Integer)fldData == 0 && !field.isZeroShow()) {
                    return "";
                }
                return fldData.toString();
            }
            case 14: {
                result = StringUtil.formatStringByColType(field, fldData, displayPattern);
                break;
            }
            default: {
                result = fldData.toString();
            }
        }
        return result;
    }

    public static String formatStringByColType(Field field, Object fldData, String displayPattern) throws BOSException {
        String result = null;
        if (fldData == null) {
            return "";
        }
        int colType = field.getFieldColType();
        switch (colType) {
            case 0: 
            case 502: {
                if (!(fldData instanceof Date) && !(fldData instanceof Timestamp)) {
                    return fldData.toString();
                }
                int style = field.getElementType();
                if (StringUtils.isEmpty((String)displayPattern)) {
                    displayPattern = style == 5 ? "yyyy-MM-dd HH:mm:ss" : "yyyy-MM-dd";
                }
                SimpleDateFormat formatter = new SimpleDateFormat(displayPattern);
                result = formatter.format(fldData);
                break;
            }
            case 9: {
                if (!(fldData instanceof BigDecimal)) {
                    return fldData.toString();
                }
                int scale = field.getScale();
                BigDecimal value = (BigDecimal)fldData;
                if (value.compareTo(ValidationUtils.ZERO) == 0 && !field.isZeroShow()) {
                    return "";
                }
                if (value.scale() != scale) {
                    value = value.setScale(scale, 4);
                }
                DecimalFormat df = (DecimalFormat)DecimalFormat.getInstance();
                df.applyPattern(StringUtils.isEmpty((String)displayPattern) ? StringUtil.getFormatPattern(scale) : displayPattern);
                result = df.format(value);
                break;
            }
            default: {
                result = fldData.toString();
            }
        }
        return result;
    }

    public static String formatAssistData(String data, Context ctx) {
        String desc = FormFactory.getAssistantDataDesc(data, ctx);
        return desc;
    }

    private static String getFormatPattern(int scale) {
        String pattern = null;
        String temp = "000000000000000000";
        String end = temp.substring(0, scale);
        pattern = scale == 0 ? "###0" : "###0." + end;
        pattern = pattern + ";-" + pattern;
        return pattern;
    }

    public static String buildStringForObjArray(Object[] fldDatas, String prop) {
        JSONArray obj = new JSONArray();
        for (int i = 0; i < fldDatas.length; ++i) {
            IObjectValue objValue = (IObjectValue)fldDatas[i];
            if (objValue == null) continue;
            obj.put(objValue.get(prop));
        }
        return obj.toString();
    }

    public static String buildStringForObjNameAndNumber(Object[] fldDatas) {
        JSONArray obj = new JSONArray();
        JSONArray number = new JSONArray();
        JSONArray name = new JSONArray();
        obj.put(number);
        obj.put(name);
        for (int i = 0; i < fldDatas.length; ++i) {
            IObjectValue objValue = (IObjectValue)fldDatas[i];
            if (objValue == null) continue;
            name.put(objValue.get("name"));
            number.put(objValue.get("number"));
        }
        return obj.toString();
    }

    public static JSONArray buildStringForObjArray(Object[] fldDatas) {
        JSONArray array = new JSONArray();
        for (int i = 0; i < fldDatas.length; ++i) {
            IObjectValue objValue = (IObjectValue)fldDatas[i];
            if (objValue == null) continue;
            JSONArray obj = new JSONArray();
            obj.put(objValue.get("id"));
            obj.put(objValue.get("number"));
            obj.put(objValue.get("name"));
            array.put(obj);
        }
        return array;
    }

    public static String[] handleMulDatabase(String value, int idx) throws BOSException {
        if (idx < 0 || idx > 1) {
            throw new IllegalArgumentException("The idx value must be 0 or 1.");
        }
        if (StringUtils.isEmpty((String)value)) {
            return new String[0];
        }
        try {
            JSONArray rec = new JSONArray(value);
            String[] recs = ((JSONArray)rec.get(idx)).toArray();
            return recs;
        }
        catch (JSONException e) {
            throw new BOSException((Throwable)e);
        }
    }
}

