/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.IWorkCalendar;
import com.kingdee.eas.basedata.assistant.IWorkCalendarDayEntry;
import com.kingdee.eas.basedata.assistant.WorkCalendarDayEntryFactory;
import com.kingdee.eas.basedata.assistant.WorkCalendarException;
import com.kingdee.eas.basedata.assistant.WorkCalendarFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.util.BusinessProcessUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WorkCalendarFacade {
    private static final Log log = LogFactory.getLog(WorkCalendarFacade.class);

    public static BigDecimal getAmountOfWorkday(String orgUnitId, Date start, Date end) throws EASBizException, BOSException {
        BigDecimal amount = null;
        if (start != null && start.equals(end)) {
            amount = BigDecimal.valueOf(0L);
            return amount;
        }
        try {
            IWorkCalendar wc = WorkCalendarFactory.getRemoteInstance();
            amount = wc.getWorkDays(orgUnitId, start, end);
        }
        catch (WorkCalendarException e) {
            e.printStackTrace();
        }
        catch (ObjectNotFoundException oe) {
            oe.printStackTrace();
        }
        return amount;
    }

    public static BigDecimal getAmountOfWorkTime(String orgUnitId, Date start, Date end, boolean isNatureDay, int measureType) throws EASBizException, BOSException {
        BigDecimal amount = null;
        if (start != null && start.equals(end)) {
            amount = BigDecimal.valueOf(0L);
            return amount;
        }
        try {
            IWorkCalendar wc = WorkCalendarFactory.getRemoteInstance();
            amount = wc.getWorkTime(orgUnitId, start, end, isNatureDay, measureType);
        }
        catch (WorkCalendarException e) {
            if (e.getMessage() != null && e.getMessage().indexOf("\u5f00\u59cb\u6216\u7ed3\u675f\u65e5\u671f\u4e3a\u7a7a\uff0c\u6216\u7ed3\u675f\u65e5\u671f\u4e0d\u5927\u4e8e\u5f00\u59cb\u65e5\u671f") >= 0) {
                amount = BigDecimal.valueOf(0L);
            }
            e.printStackTrace();
        }
        catch (ObjectNotFoundException oe) {
            oe.printStackTrace();
            throw new ObjectNotFoundException(oe.getMessage());
        }
        return amount;
    }

    public static long getWorkCalendarVersion(Context ctx) throws EASBizException, BOSException {
        AdminOrgUnitInfo orgUnit = WorkCalendarFacade.getOrgUnitOfPrimaryOccupation(ctx);
        return WorkCalendarFacade.getWorkCalendarVersion(orgUnit);
    }

    public static long getWorkCalendarVersion(AdminOrgUnitInfo orgUnit) throws EASBizException, BOSException {
        long version = 0L;
        if (orgUnit != null) {
            IWorkCalendar wc = WorkCalendarFactory.getRemoteInstance();
            try {
                if (wc != null) {
                    version = wc.getVersion((IObjectPK)new ObjectUuidPK(orgUnit.getId()));
                }
            }
            catch (WorkCalendarException e) {
                e.printStackTrace();
            }
            catch (ObjectNotFoundException oe) {
                oe.printStackTrace();
            }
        }
        return version;
    }

    public Map getHolidays(String orgUnit, int year) throws EASBizException, BOSException {
        IWorkCalendarDayEntry wc = WorkCalendarDayEntryFactory.getRemoteInstance();
        Map holidays = null;
        try {
            holidays = wc.getHolidayName((IObjectPK)new ObjectUuidPK(orgUnit), year);
        }
        catch (WorkCalendarException e) {
            e.printStackTrace();
        }
        catch (ObjectNotFoundException oe) {
            oe.printStackTrace();
        }
        return holidays;
    }

    private void truncTime(Calendar date) {
        if (date != null) {
            date.set(10, 0);
            date.set(12, 0);
            date.set(13, 0);
            date.set(14, 0);
        }
    }

    private Map getHoliday4Year4Test() {
        HashMap holidays = new HashMap();
        ArrayList<Calendar> days = new ArrayList<Calendar>();
        for (int i = 0; i < 7; ++i) {
            Calendar date = Calendar.getInstance();
            date.add(5, i);
            this.truncTime(date);
            days.add(date);
        }
        holidays.put("\u56fd\u5e86\u8282", days);
        return holidays;
    }

    public static AdminOrgUnitInfo getOrgUnitOfPrimaryOccupation(Context ctx) throws EASBizException, BOSException {
        AdminOrgUnitInfo orgUnit = null;
        BOSUuid person = WorkCalendarFacade.getCurrentPersonId(ctx);
        if (person != null) {
            orgUnit = WorkCalendarFacade.getOrgUnitOfPrimaryOccupation(person);
        }
        return orgUnit;
    }

    private static AdminOrgUnitInfo getOrgUnitOfPrimaryOccupation(BOSUuid person) throws EASBizException, BOSException {
        AdminOrgUnitInfo org = PersonFactory.getRemoteInstance().getPrimaryAdminOrgUnit(person);
        if (org == null) {
            log.info((Object)("personId = " + (person == null ? "null" : person.toString()) + ", getPrimaryAdminOrgUnit() return null"));
        }
        return org;
    }

    private static BOSUuid getCurrentPersonId(Context ctx) throws BOSException, EASBizException {
        PersonInfo person;
        UserInfo userInfo = (UserInfo)ctx.get((Object)"UserInfo");
        BOSUuid personId = null;
        int path = 1;
        if (userInfo == null) {
            path = 2;
            IObjectPK userPK = ctx.getCaller();
            SelectorItemCollection selectors = new SelectorItemCollection();
            selectors.add("id");
            selectors.add("person.id");
            if (userPK == null) {
                log.info((Object)"ctx.getCaller() returns null");
            }
            IUser user = (IUser)BusinessProcessUtil.getBizInterface(null, UserFactory.class);
            userInfo = user.getUserInfo(userPK, selectors);
        }
        if (userInfo != null && (person = userInfo.getPerson()) != null) {
            personId = person.getId();
        }
        log.info((Object)("personId = " + (personId == null ? "null" : personId.toString()) + ", execution path=" + path));
        return personId;
    }
}

