/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.web;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.base.form.json.JSONArray;
import com.kingdee.eas.base.form.json.JSONException;
import com.kingdee.eas.base.form.json.JSONObject;
import com.kingdee.eas.base.form.metadata.Appearance;
import com.kingdee.eas.base.form.metadata.BusinessInfo;
import com.kingdee.eas.base.form.metadata.Entity;
import com.kingdee.eas.base.form.metadata.FieldAppearance;
import com.kingdee.eas.base.form.metadata.LayoutInfo;
import com.kingdee.eas.base.form.model.OperationStatus;
import com.kingdee.eas.base.form.util.ResourceUtil;
import com.kingdee.eas.base.form.web.IWebFormState;
import java.util.HashMap;

public class DynamicWebFormState
implements IWebFormState {
    public static String FS_VALUE = "value";
    public static String FS_NUMBER = "number";
    public static String FS_NAME = "name";
    public static String FS_MUL_F7_VALUE = "mulF7value";
    public static String FS_PK = "pk";
    public static String FS_BINDVALUE = "bindDatabaseValue";
    public static String FS_ID = "id";
    public static String FS_DISABLED = "disabled";
    public static String FS_VISIBLE = "visible";
    public static final String FS_MUSTINPUT = "mustinput";
    public static String FS_ERROR = "err";
    public static String FS_ROW = "row";
    public static String FS_MULTIVALUE = "multi_value";
    public static String FS_STORE = "store";
    public static String CTRL_TEXT = "text";
    private JSONArray fieldStates;
    private JSONArray entryStates;
    private JSONArray actions;
    private HashMap dctControlsStates;
    private HashMap dctactions;
    private LayoutInfo layoutInfo;
    private BusinessInfo businessInfo;
    private JSONObject msgBox;

    public DynamicWebFormState(LayoutInfo layoutInfo, BusinessInfo bInfo) {
        this.layoutInfo = layoutInfo;
        this.businessInfo = bInfo;
        this.fieldStates = new JSONArray();
        this.entryStates = new JSONArray();
        this.actions = new JSONArray();
        this.dctControlsStates = new HashMap();
        this.dctactions = new HashMap();
    }

    private JSONObject getEntryField(String entryKey, String fldKey) throws JSONException {
        JSONObject entry = this.getEntry(entryKey);
        if (!entry.has("fieldstates")) {
            entry.put("fieldstates", new JSONArray());
        }
        JSONArray entryfieldStates = (JSONArray)entry.get("fieldstates");
        JSONObject field = new JSONObject();
        field.put("key", fldKey.toUpperCase());
        this.dctControlsStates.put(fldKey, field);
        entryfieldStates.put(field);
        return field;
    }

    public JSONObject getEntry(String key) throws JSONException {
        JSONObject entry = (JSONObject)this.dctControlsStates.get(key);
        if (entry == null) {
            entry = new JSONObject();
            entry.put("key", key.toUpperCase());
            this.dctControlsStates.put(key, entry);
            this.entryStates.put(entry);
        }
        return entry;
    }

    public JSONObject getField(String key) throws JSONException {
        Appearance fld = this.layoutInfo.getAppearance(key);
        Appearance entry = null;
        if (fld instanceof FieldAppearance) {
            entry = this.layoutInfo.getEntityAppearance(((FieldAppearance)fld).getEntityKey());
        }
        JSONObject field = null;
        if (entry != null && entry.getControlType() != -1) {
            field = this.getEntryField(entry.getKey(), fld.getKey());
        } else {
            field = (JSONObject)this.dctControlsStates.get(key = key.toUpperCase());
            if (field == null) {
                field = new JSONObject();
                field.put("key", key);
                this.dctControlsStates.put(key, field);
                this.fieldStates.put(field);
            }
        }
        return field;
    }

    public JSONObject addAction(String actionName, Object param) throws JSONException {
        return this.addAction2ActionList(this.actions, actionName, actionName, param);
    }

    public void addEntryAction(String entryKey, String actionName, Object param) throws JSONException {
        JSONArray actions;
        JSONObject entry = this.getEntry(entryKey);
        if (entry.has("actions")) {
            actions = entry.getJSONArray("actions");
        } else {
            actions = new JSONArray();
            entry.put("actions", actions);
        }
        this.addAction2ActionList(actions, entryKey + "_" + actionName, actionName, param);
    }

    private void addCallbackAction(String actionName, Object param) throws JSONException {
        if (this.msgBox == null) {
            this.addAction2ActionList(this.actions, actionName, actionName, param);
        } else {
            JSONArray actions = this.getJSONArrayFrom(this.msgBox, "cbActions");
            this.addAction2ActionList(actions, actionName, actionName, param);
        }
    }

    private JSONArray getJSONArrayFrom(JSONObject dic, String key) throws JSONException {
        JSONArray prop = null;
        if (dic != null) {
            if (!dic.has(key)) {
                prop = new JSONArray();
                dic.put(key, prop);
            } else {
                prop = dic.getJSONArray(key);
            }
        }
        return prop;
    }

    public JSONObject addAction2ActionList(JSONArray actionList, String actionKey, String actionName, Object param) throws JSONException {
        JSONObject action = (JSONObject)this.dctactions.get(actionKey);
        if (action == null) {
            action = new JSONObject();
            this.dctactions.put(actionKey, action);
            action.put("actionname", actionName);
            actionList.put(action);
        }
        JSONArray paras = this.getJSONArrayFrom(action, "params");
        if (param instanceof JSONArray) {
            JSONArray p = (JSONArray)param;
            for (int i = 0; i < p.length(); ++i) {
                try {
                    paras.put(p.get(i));
                    continue;
                }
                catch (Exception e) {
                    System.out.println("***** wrs addAction2ActionList param " + p);
                    e.printStackTrace();
                }
            }
        } else {
            paras.put(param);
        }
        return action;
    }

    @Override
    public JSONArray getActions() throws JSONException {
        boolean have = false;
        for (int i = 0; i < this.actions.length(); ++i) {
            try {
                if (!"UpdateFields".equals(this.actions.getJSONObject(i).getString("actionname"))) continue;
                have = true;
            }
            catch (Exception e) {
                System.out.println("***** wrs actions.getJSONObject(" + i + ") error " + e.getMessage());
            }
            break;
        }
        if (!have && this.fieldStates.length() > 0) {
            this.addAction("UpdateFields", this.fieldStates);
        }
        if (this.entryStates.length() > 0) {
            this.addAction("UpdateEntrys", this.entryStates);
        }
        return this.actions;
    }

    private boolean isEntryField(Appearance fld) {
        int type = 0;
        if (fld instanceof FieldAppearance) {
            Entity entity = null;
            entity = this.businessInfo.getEntity(((FieldAppearance)fld).getEntityKey());
            type = entity.getEntityType();
        }
        return type != 0;
    }

    private JSONObject getFieldState(String key) throws JSONException {
        Appearance fld = this.layoutInfo.getAppearance(key);
        if (fld != null) {
            return this.getFieldState(fld);
        }
        return null;
    }

    private JSONObject getFieldState(Appearance field) throws JSONException {
        JSONObject fieldState = this.isEntryField(field) ? this.getEntryField(((FieldAppearance)field).getEntityKey(), field.getKey()) : this.getField(field.getKey());
        return fieldState;
    }

    public void setEnabled(String key, boolean enabled, int row) {
        try {
            Appearance fld = this.layoutInfo.getAppearance(key);
            if (this.isEntryField(fld)) {
                JSONObject fieldState = this.getEntryField(((FieldAppearance)fld).getEntityKey(), key);
                JSONObject disabled = null;
                if (fieldState.has(FS_DISABLED)) {
                    disabled = fieldState.getJSONObject(FS_DISABLED);
                } else {
                    disabled = new JSONObject();
                    fieldState.put(FS_DISABLED, disabled);
                }
                disabled.put("" + row, !enabled);
            } else {
                JSONObject fieldState = this.getField(key);
                fieldState.put(FS_DISABLED, !enabled);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private void setEntryFieldEnabled(FieldAppearance fld, JSONObject fieldState, boolean enabled) {
        try {
            JSONObject disabled = null;
            if (fieldState.has(FS_DISABLED)) {
                disabled = fieldState.getJSONObject(FS_DISABLED);
            } else {
                disabled = new JSONObject();
                fieldState.put(FS_DISABLED, disabled);
            }
            disabled.put("column", !enabled);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private void setEntryFieldMustInput(FieldAppearance fld, JSONObject fieldState, boolean isMustInput) {
        try {
            JSONObject mustInput = null;
            if (fieldState.has(FS_MUSTINPUT)) {
                mustInput = fieldState.getJSONObject(FS_MUSTINPUT);
            } else {
                mustInput = new JSONObject();
                fieldState.put(FS_MUSTINPUT, mustInput);
            }
            mustInput.put("column", isMustInput);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private void setEntryFieldTitle(FieldAppearance fld, JSONObject fieldState, String text) {
        try {
            JSONObject title = null;
            if (fieldState.has(CTRL_TEXT)) {
                title = fieldState.getJSONObject(CTRL_TEXT);
            } else {
                title = new JSONObject();
                fieldState.put(CTRL_TEXT, text);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private void setEntryFieldProperty(FieldAppearance fld, JSONObject fieldState, String propertyName, Object value) {
        try {
            JSONObject property = null;
            if (fieldState.has(propertyName)) {
                property = fieldState.getJSONObject(propertyName);
            } else {
                property = new JSONObject();
                fieldState.put(propertyName, value);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void setEnabled(String key, boolean enabled) {
        try {
            Appearance fld = this.layoutInfo.getAppearance(key);
            if (this.isEntryField(fld)) {
                JSONObject fieldState = this.getEntryField(((FieldAppearance)fld).getEntityKey(), key);
                this.setEntryFieldEnabled((FieldAppearance)fld, fieldState, enabled);
            } else {
                JSONObject fieldState = this.getField(key);
                fieldState.put(FS_DISABLED, !enabled);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void setMustInput(String key, boolean mustInput) {
        try {
            Appearance fld = this.layoutInfo.getAppearance(key);
            if (this.isEntryField(fld)) {
                JSONObject fieldState = this.getEntryField(((FieldAppearance)fld).getEntityKey(), key);
                this.setEntryFieldMustInput((FieldAppearance)fld, fieldState, mustInput);
            } else {
                JSONObject fieldState = this.getField(key);
                fieldState.put(FS_MUSTINPUT, mustInput);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void setControlText(String key, String text) {
        Appearance ap = this.layoutInfo.getAppearance(key);
        if (ap == null) {
            return;
        }
        if (ap.getControlType() == 1001) {
            this.setExtProperty(ap, CTRL_TEXT, text);
        } else {
            this.setExtProperty(ap, FS_VALUE, text);
        }
    }

    private void setExtProperty(Appearance fld, String propertyName, Object value) {
        try {
            if (fld == null) {
                return;
            }
            JSONObject fieldState = this.isEntryField(fld) ? this.getEntryField(((FieldAppearance)fld).getEntityKey(), fld.getKey()) : this.getField(fld.getKey());
            JSONArray extProps = null;
            if (!fieldState.has("extProps")) {
                extProps = new JSONArray();
                fieldState.put("extProps", extProps);
            } else {
                extProps = fieldState.getJSONArray("extProps");
            }
            JSONObject prop = new JSONObject();
            prop.put(propertyName, value);
            extProps.put(prop);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void setControlProperty(String key, String propertyName, Object value) {
        Appearance fld = this.layoutInfo.getAppearance(key);
        this.setExtProperty(fld, propertyName, value);
    }

    public void setVisible(String key, boolean isVisible) {
        try {
            JSONObject feildState = this.getFieldState(key);
            if (feildState != null) {
                feildState.put(FS_VISIBLE, isVisible);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void setComboStore(FieldAppearance fieldAp, JSONArray store) throws JSONException {
        JSONObject fieldState = this.getFieldState(fieldAp);
        fieldState.put(FS_STORE, store);
    }

    public void close() throws JSONException {
        this.addCallbackAction("WindowClose", null);
    }

    public void alert(String msg) {
        try {
            this.addAction("Alert", msg);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void alert(String operation, String msg, int result, String key) {
        try {
            JSONObject param = new JSONObject();
            param.put("operation", operation);
            param.put("result", result);
            param.put("msg", msg);
            if (key != null) {
                param.put("key", key);
            }
            this.msgBox = this.addAction("Alert", param);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void addErrorMessage(String msg) {
        try {
            this.addAction("ErrorMsg", msg);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void addError(String key, String msg) {
        try {
            JSONObject feildState = this.getField(key);
            feildState.put(FS_ERROR, msg);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void openNewWindow(String url, String name, String title, int x, int y) throws JSONException, BOSException {
        JSONObject para = new JSONObject();
        para.put("url", url);
        para.put("name", name);
        para.put("title", title);
        para.put("x", x);
        para.put("y", y);
        this.addAction("OpenNewWindow", para);
    }

    public void openJCpDialog(String url, String name, String title, int w, int y) throws JSONException, BOSException {
        JSONObject para = new JSONObject();
        para.put("url", url);
        para.put("name", name);
        para.put("title", title);
        para.put("x", w);
        para.put("y", y);
        this.addAction("OpenJCpDialog", para);
    }

    public void openDialog(String url, String name, String title, int w, int y) throws JSONException, BOSException {
        JSONObject para = new JSONObject();
        para.put("url", url);
        para.put("name", name);
        para.put("title", title);
        para.put("x", w);
        para.put("y", y);
        this.addAction("OpenDialog", para);
    }

    public void updateListMultiF7(JSONObject param) throws JSONException, BOSException {
        this.addAction("updateList", param);
    }

    public void setContentURL(String key, String url, String param) throws JSONException, BOSException {
        JSONObject para = new JSONObject();
        para.put("key", key.toUpperCase());
        String fullUrl = ResourceUtil.buildUrlEncodeParam(url, param);
        para.put("html", fullUrl);
        this.addAction("SetContentURL", para);
    }

    public void outputDynmaicAction(String script) throws JSONException {
        JSONObject para = (JSONObject)this.dctactions.get("OutScript");
        if (para == null) {
            para = new JSONObject();
            para.put("script", script);
            this.addAction("OutScript", para);
        } else {
            JSONArray params = para.getJSONArray("params");
            JSONObject jScript = params.getJSONObject(0);
            String combinedScript = jScript.getString("script");
            combinedScript = combinedScript + "\n" + script;
            jScript.put("script", combinedScript);
        }
    }

    public void showConfirm(String title, String msg) throws JSONException {
        JSONObject para = new JSONObject();
        para.put("title", title);
        para.put("msg", msg);
        this.addAction("Confirm", para);
    }

    public void showConfirm(String id, String title, String msg, int option) {
        this.showConfirm(id, title, msg, option, null);
    }

    public void showConfirm(String id, String title, String msg, int option, String script) {
        JSONObject para = new JSONObject();
        try {
            para.put("title", title);
            para.put("msg", msg);
            para.put("msgType", option);
            if (script != null) {
                para.put("script", script);
            }
            if (id != null) {
                para.put("id", id);
            }
            this.addAction("Confirm", para);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void handleEntry(String function, String entityKey) throws JSONException {
        JSONObject para = new JSONObject();
        para.put("operation", function);
        para.put("key", entityKey.toUpperCase());
        this.addAction("HandleEntry", para);
    }

    public void handleEntrySuccess(String function, String entityKey, int row) throws JSONException {
        JSONObject para = new JSONObject();
        para.put("operation", function);
        para.put("key", entityKey.toUpperCase());
        para.put("row", row);
        this.addAction("HandleEntrySuccess", para);
    }

    public void setBarItemVisible(String barItemKey, boolean Visible) throws JSONException {
        JSONObject param = new JSONObject();
        param.put("key", barItemKey);
        param.put("visible", Visible);
        this.addAction("updateBarItems", param);
    }

    public void setBarItemDisabled(String barItemKey, boolean disabled) throws JSONException {
        JSONObject param = new JSONObject();
        param.put("key", barItemKey);
        param.put("disabled", disabled);
        this.addAction("updateBarItems", param);
    }

    public void showBillOperateForm(OperationStatus status, String formId, String pk, int width, int height) throws JSONException {
        JSONObject param = new JSONObject();
        param.put("status", status.getStatus());
        if (pk != null) {
            param.put("pk", pk);
        }
        param.put("formID", formId);
        param.put("width", width);
        param.put("height", height);
        param.put("fromList", status.equals(OperationStatus.VIEW));
        this.addAction("ShowBillOperateForm", param);
    }

    public void showBillOperateForm(OperationStatus status, String formId, String layoutID, String pk, int width, int height) throws JSONException {
        JSONObject param = new JSONObject();
        param.put("status", status.getStatus());
        if (pk != null) {
            param.put("pk", pk);
        }
        param.put("formID", formId);
        param.put("width", width);
        param.put("height", height);
        param.put("fromList", status.equals(OperationStatus.VIEW));
        this.addAction("ShowBillOperateForm", param);
    }

    public void showResultDisplayForm(int type) throws JSONException {
        JSONObject para = new JSONObject();
        para.put("operation", type);
        this.addAction("ShowResultDisplayForm", para);
    }

    public void showAdvancedFilter(String formID) throws JSONException {
        JSONObject para = new JSONObject();
        para.put("formID", formID);
        this.addAction("showAdvancedFilter", para);
    }

    public void refresh() throws JSONException {
        JSONObject para = new JSONObject();
        this.addAction("refresh", para);
    }

    public void reloadPage(boolean curPage) throws JSONException {
        String reloadCurPage = curPage ? "true" : "false";
        this.outputDynmaicAction("this.list.reloadData(" + reloadCurPage + ");");
    }

    public void reloadPage(boolean curPage, String pageId) throws JSONException {
        String reloadCurPage = curPage ? "true" : "false";
        this.outputDynmaicAction("this.list.reloadData(" + reloadCurPage + ",'" + pageId + "');");
    }

    public void setListSingleSelect(boolean singleSelect) throws JSONException {
        String sss = singleSelect ? "true" : "false";
        this.outputDynmaicAction("this.list.grid.getSelectionModel().singleSelect=" + sss + ";");
    }

    public void setFormTitle(String title) {
        try {
            JSONObject para = new JSONObject();
            para.put("title", title);
            this.addAction("setFormTitle", para);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void setBillId2OfficeControl(String billId, Appearance office) {
        this.setExtProperty(office, "billId", billId);
    }

    public void setOfficeEditable(boolean editable, JSONArray officeCtrlKeys) {
        try {
            JSONObject para = new JSONObject();
            para.put("editable", editable);
            para.put("officeCtrlKeys", officeCtrlKeys);
            this.addAction("setOfficeEditable", para);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void saveOfficeDocuments(String billId, JSONArray officeCtrlKeys) {
        try {
            JSONObject para = new JSONObject();
            para.put("billId", billId);
            para.put("officeCtrlKeys", officeCtrlKeys);
            this.addAction("saveOfficeDocuments", para);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void editOfficeDocument(String billId, String docName) {
        try {
            JSONObject para = new JSONObject();
            para.put("billId", billId);
            para.put("docName", docName);
            this.addAction("editOfficeDocument", para);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void focusEntryCell(String entryKey, String fieldKey, int row) {
        try {
            JSONObject param = new JSONObject();
            param.put("field", fieldKey);
            param.put("row", row);
            this.addEntryAction(entryKey, "focusEntryCell", param);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void query4listData() throws JSONException {
        if (this.fieldStates.length() > 0) {
            this.addAction("UpdateFields", this.fieldStates);
        }
        this.addAction("query4listData", Boolean.TRUE);
    }

    public void initImgPanel(String imgPanelKey, JSONObject imgPanelConfig) {
        try {
            if (imgPanelConfig == null) {
                imgPanelConfig = new JSONObject();
            }
            imgPanelConfig.put("key", imgPanelKey);
            this.addAction("initImgPanel", imgPanelConfig);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void initFtpPanel(String ftpPanelKey, JSONObject ftpPanelConfig) {
        try {
            JSONObject action;
            if (ftpPanelConfig == null) {
                ftpPanelConfig = new JSONObject();
            }
            if ((action = (JSONObject)this.dctactions.get("initFtpPanel")) != null) {
                JSONArray paras = new JSONArray();
                paras.put(ftpPanelConfig);
                action.put("params", paras);
            } else {
                ftpPanelConfig.put("key", ftpPanelKey);
                this.addAction("initFtpPanel", ftpPanelConfig);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void applyFTPPanelPolicy(String ftpPanelKey, JSONObject ftpPanelConfig) {
        try {
            JSONObject action;
            if (ftpPanelConfig == null) {
                ftpPanelConfig = new JSONObject();
            }
            if ((action = (JSONObject)this.dctactions.get("initFtpPanel")) != null) {
                JSONObject ftpPanelConfigOld;
                JSONArray paras;
                if (!action.has("params")) {
                    paras = new JSONArray();
                    action.put("params", paras);
                } else {
                    paras = (JSONArray)action.get("params");
                }
                if (paras.length() > 0 && paras.get(0) instanceof JSONObject) {
                    ftpPanelConfigOld = (JSONObject)paras.get(0);
                } else {
                    ftpPanelConfigOld = new JSONObject();
                    paras.put(ftpPanelConfigOld);
                }
                String[] names = JSONObject.getNames(ftpPanelConfig);
                if (names != null && names.length > 0) {
                    for (int i = 0; i < names.length; ++i) {
                        ftpPanelConfigOld.put(names[i], ftpPanelConfig.get(names[i]));
                    }
                }
            } else {
                ftpPanelConfig.put("key", ftpPanelKey);
                this.addAction("applyFTPPanelPolicy", ftpPanelConfig);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void ftpUpload(String ftpPanelKey, String billId) {
        try {
            JSONObject para = new JSONObject();
            para.put("key", ftpPanelKey);
            para.put("businessId", billId);
            this.addAction("ftpUpload", para);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }
}

