/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.web;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.cache.CacheServiceFactory;
import com.kingdee.bos.framework.cache.ICacheService;
import com.kingdee.bos.framework.cache.MultiParamKey;
import com.kingdee.bos.framework.cache.config.CacheConfigManager;
import com.kingdee.bos.framework.cache.config.ICacheConfig;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.form.core.FormFactory;
import com.kingdee.eas.base.form.core.app.FormDBUtils;
import com.kingdee.eas.base.form.metadata.FormMetaData;
import com.kingdee.jdbc.rowset.IRowSet;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Hashtable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FormMetaCacheManager {
    private static final Log log = LogFactory.getLog(FormMetaCacheManager.class);
    private static Hashtable formMetas = new Hashtable();
    public static BOSObjectType formMetaBosType = BOSObjectType.create((String)"AAAAFFFF");

    private static int getFormMetaSize(FormMetaData formMeta) throws BOSException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(formMeta);
            oos.flush();
            oos.close();
        }
        catch (IOException e) {
            throw new BOSException((Throwable)e);
        }
        byte[] buffer = bos.toByteArray();
        return buffer.length;
    }

    private static FormMetaData validateFormMeta(Context ctx, FormMetaData formMeta, String formId, String bosType, ResultSet rs) throws BOSException {
        if (formMeta == null) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Requested FormMetaData not found in cache, load it from db, formId=" + formId + ", bosType=" + bosType));
            }
            formMeta = FormFactory.createFormMetaData(formId, (IRowSet)rs, ctx);
        } else {
            try {
                if (rs.next()) {
                    String version = rs.getString("FVersion");
                    if (!formMeta.getBusinessInfo().getForm().getVersion().equals(version)) {
                        if (log.isInfoEnabled()) {
                            log.info((Object)("Requested FormMetaData found in cache with stale version, reload it from db, formId=" + formId + ", bosType=" + bosType));
                        }
                        formMeta = FormFactory.createFormMetaData(formId, (IRowSet)rs, ctx);
                    }
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        return formMeta;
    }

    public static void refreshFormMeta(Context ctx, String formId, String bosType) throws BOSException {
        log.info((Object)"Force reload dynamic form framework from database");
        FormDBUtils.updateFormVersion(ctx, formId);
        FormMetaData formMeta = null;
        ICacheConfig config = CacheConfigManager.getConfig();
        MultiParamKey key = MultiParamKey.create((String)(ctx.getAIS() + "_" + formId), null);
        ResultSet rs = null;
        rs = formId != null ? FormDBUtils.getFormType(formId, ctx) : FormDBUtils.getFormByBosType(bosType, ctx);
        formMeta = FormFactory.createFormMetaData(formId, (IRowSet)rs, ctx);
        if (ctx != null && config != null && config.needServerCache()) {
            ICacheService svc = CacheServiceFactory.getInstance();
            svc.put(formMetaBosType, key, (Object)formMeta, (long)FormMetaCacheManager.getFormMetaSize(formMeta));
        } else {
            if (log.isInfoEnabled()) {
                log.info((Object)"Force reload dynamic use framework default cache manager");
            }
            formMetas.put(key, formMeta);
        }
    }

    public static FormMetaData getFormMeta(Context ctx, String formId, String bosType) throws BOSException {
        ICacheConfig config = CacheConfigManager.getConfig();
        FormMetaData formMeta = null;
        MultiParamKey key = MultiParamKey.create((String)(ctx.getAIS() + "_" + formId), null);
        ResultSet rs = null;
        rs = formId != null ? FormDBUtils.getFormType(formId, ctx) : FormDBUtils.getFormByBosType(bosType, ctx);
        if (ctx != null && config != null && config.needServerCache()) {
            FormMetaData validatedFormMeta;
            ICacheService svc = CacheServiceFactory.getInstance();
            if (svc.contains(formMetaBosType, key)) {
                formMeta = (FormMetaData)svc.get(formMetaBosType, key);
            }
            if ((validatedFormMeta = FormMetaCacheManager.validateFormMeta(ctx, formMeta, formId, bosType, rs)) != formMeta) {
                formMeta = validatedFormMeta;
                svc.put(formMetaBosType, key, (Object)formMeta, (long)FormMetaCacheManager.getFormMetaSize(formMeta));
            }
        } else {
            FormMetaData validatedFormMeta;
            if (log.isInfoEnabled()) {
                log.info((Object)"CacheService is not enabled(/Server/server/profiles/serverx/config/CacheConfig.xml), apply dynamic form framework default cache manager");
            }
            if ((validatedFormMeta = FormMetaCacheManager.validateFormMeta(ctx, formMeta = (FormMetaData)formMetas.get(key), formId, bosType, rs)) != formMeta) {
                formMeta = validatedFormMeta;
                formMetas.put(key, formMeta);
            }
        }
        return formMeta;
    }
}

