/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.web;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.workflow.ActivityInstInfo;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.ProcessDefInfo;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.SubmitAssignResult;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.ActivityCollection;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.ActivityType;
import com.kingdee.bos.workflow.define.ManpowerActivityDef;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.StartActivityDef;
import com.kingdee.bos.workflow.define.WebBillManpowerActivityDef;
import com.kingdee.bos.workflow.metas.AssignCollection;
import com.kingdee.bos.workflow.metas.AssignInfo;
import com.kingdee.bos.workflow.service.EnactmentServiceProxy;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.dynbusiness.util.StringUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class WfState {
    public static final int NOT_IN_PROCESS = 0;
    public static final int ALREADY_IN_PROCESS = 1;
    public static final int ASSIGNMENT_MATCH = 2;
    public static final int HAS_ASSIGNMENT_SUBMIT = 3;
    public static final int ASSIGNMENT_NOT_MATCH = 4;
    private boolean isFromWorkflow = false;
    private String uiStatus = "VIEW";
    private String assignmentID;
    private String operation;
    private String billID;
    private String nodeID;
    private String procDefId;

    public static WfState initWebUIWfState(HttpServletRequest req, Context ctx) throws BOSException {
        IEnactmentService wfService;
        int type;
        WfState state = new WfState();
        state.billID = req.getParameter("billId");
        state.assignmentID = req.getParameter("assignmentId");
        if (!(StringUtils.isEmpty((String)state.assignmentID) || (type = (wfService = EnactmentServiceProxy.getEnacementService((Context)ctx)).getActTypeByAssignment(state.assignmentID)) != 3 && type != 4 && type != 15)) {
            Map act = wfService.getActivityDefAndActivityInstInfo(state.assignmentID);
            ManpowerActivityDef actDef = (ManpowerActivityDef)act.get("ACTIVITYDEF");
            state.nodeID = actDef.getID();
            state.procDefId = wfService.getAssignmentById(state.assignmentID).getProcDefId();
            if (actDef instanceof WebBillManpowerActivityDef) {
                WebBillManpowerActivityDef webActDef = (WebBillManpowerActivityDef)actDef;
                if (webActDef.getUiState() != null) {
                    state.uiStatus = webActDef.getUiState();
                }
                state.operation = webActDef.getOperation();
            }
        }
        if (state.assignmentID == null) {
            state.assignmentID = req.getParameter("assigmentId");
        }
        state.isFromWorkflow = !StringUtils.isEmpty((String)state.assignmentID);
        String uiStatus = req.getParameter("operateState");
        if (!StringUtils.isEmpty((String)uiStatus)) {
            state.uiStatus = uiStatus;
        }
        if (state.procDefId == null || state.nodeID == null) {
            if (state.billID == null) {
                state.billID = req.getParameter("pk");
            }
            try {
                int workflowStatus;
                String getWorkflowStatusSql = "select fworkflowStatus workflowStatus from t_bas_documentinfo where fsourcepk='" + state.billID + "'";
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)getWorkflowStatusSql.toString());
                if (rs.next() && 0 != (workflowStatus = rs.getInt("workflowStatus"))) {
                    WfState.getAssignFlow(ctx, state);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return state;
    }

    private static void getAssignFlow(Context ctx, WfState state) {
        try {
            String personId = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString();
            StringBuffer getAssignFlowSQL = new StringBuffer();
            getAssignFlowSQL.append("select top 10 FACTDEFID,FPROCDEFID").append(" from T_WFR_AssignDetail where FBIZOBJID = '" + state.billID + "' and FPERSONEMPID = '" + personId + "'").append(" union all").append(" select top 10 FACTDEFID,FPROCDEFID").append(" from T_WFR_Assign where FBIZOBJID = '" + state.billID + "' and FPERSONEMPID = '" + personId + "'");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)getAssignFlowSQL.toString());
            if (rs != null && rs.next()) {
                state.nodeID = rs.getString("FACTDEFID");
                state.procDefId = rs.getString("FPROCDEFID");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getProcDefId() {
        return this.procDefId;
    }

    public boolean isFromWorkflow() {
        return this.isFromWorkflow;
    }

    public String getUiStatus() {
        return this.uiStatus;
    }

    public String getAssignmentID() {
        return this.assignmentID;
    }

    public String getOperation() {
        return this.operation;
    }

    public String getBillID() {
        return this.billID;
    }

    public String getNodeID() {
        return this.nodeID;
    }

    public boolean submitAssigment(Context ctx, String pk, String operation) throws BOSException {
        if (this.isFromWorkflow() && operation.equalsIgnoreCase(this.operation)) {
            IEnactmentService wfService = EnactmentServiceProxy.getEnacementService((Context)ctx);
            HashMap<String, String> boMap = new HashMap<String, String>();
            boMap.put(pk, pk);
            String userId = ctx.getCaller().toString();
            SubmitAssignResult re = wfService.submitAssignment(boMap, userId, wfService.getAssignmentById(this.assignmentID));
            if (re != null && re.getStatus()) {
                return true;
            }
        }
        return false;
    }

    public int checkBeforeAction(Context ctx, String billId, String operation) throws BOSException {
        IEnactmentService wfService = EnactmentServiceProxy.getEnacementService((Context)ctx);
        if (this.isFromWorkflow()) {
            if (operation.equalsIgnoreCase(this.operation)) {
                return 2;
            }
            return 4;
        }
        if (!StringUtils.isEmpty((String)billId)) {
            ProcessInstInfo[] procInsts = wfService.getProcessInstanceByHoldedObjectId(billId);
            for (int i = 0; i < procInsts.length; ++i) {
                if (!procInsts[i].getState().startsWith("closed")) {
                    return 1;
                }
                wfService.unregistProcessBizObj(billId);
            }
            AssignCollection assignCol = wfService.getAssignInfoCollection("where bizobjid = '" + billId + "'");
            if (assignCol != null) {
                int i;
                ArrayList<String> procInstIdList = new ArrayList<String>();
                for (i = assignCol.size(); i > 0; --i) {
                    AssignInfo assign = assignCol.get(i - 1);
                    if (assign == null) continue;
                    procInstIdList.add(assign.getProcInstID().toString());
                }
                procInsts = wfService.getProcessInstInfos(procInstIdList.toArray(new String[procInstIdList.size()]));
                for (i = 0; i < procInsts.length; ++i) {
                    if (procInsts[i].getState().startsWith("closed")) continue;
                    return 1;
                }
            }
        }
        return 0;
    }

    public boolean isManPowerActivity(Context ctx, String processDefID) throws BOSException {
        ProcessDefInfo pi;
        IEnactmentService wfService = EnactmentServiceProxy.getEnacementService((Context)ctx);
        ProcessDef pd = wfService.getProcessDefByDefineHashValue((pi = wfService.getProcessDefInfo(processDefID)).getMd5HashValue());
        StartActivityDef startActivity = pd.getStartActivity();
        ActivityCollection collection = startActivity.getPostActivities();
        if (collection == null || collection.size() == 0) {
            return false;
        }
        ActivityDef ad = collection.get(0);
        return ad instanceof ManpowerActivityDef;
    }

    public static boolean hasProcessInstance(Context ctx, String pk) throws BOSException {
        IEnactmentService wfService = EnactmentServiceProxy.getEnacementService((Context)ctx);
        ProcessInstInfo[] processInstances = wfService.getAllProcessInstancesByBizobjId(pk);
        return processInstances != null && processInstances.length > 0;
    }

    public boolean isSetPostActivitiesPerson(Context ctx, String processDefID) throws WfException {
        boolean flag = false;
        try {
            IEnactmentService wfService = EnactmentServiceFactory.createEnactService((Context)ctx);
            ProcessDef procDef = wfService.getProcessDefByDefineHashValue(wfService.getProcessDefInfo(processDefID).getMd5HashValue());
            if (procDef != null && procDef.getProcessHeader().isSetPostActivitiesPerson()) {
                flag = true;
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return flag;
    }

    public static boolean checkNextHasManPowerActivitys(String assignmentID) throws BOSException {
        ActivityInstInfo actInstInfo;
        ActivityDef actDef;
        ActivityCollection activityCol;
        if (StringUtil.isEmpty((String)assignmentID)) {
            return false;
        }
        IEnactmentService service = EnactmentServiceFactory.createRemoteEnactService();
        AssignmentInfo assignmentInfo = service.getAssignmentById(assignmentID);
        if (assignmentInfo != null && (activityCol = (actDef = service.getActDefByActInstInfo(actInstInfo = service.getActivityInstByActInstId(assignmentInfo.getActInstId()))).getAllPostActivities()) != null) {
            for (int i = 0; i < activityCol.size(); ++i) {
                ActivityDef actPost = activityCol.get(i);
                if (ActivityType.MANPOWER.getValue() != actPost.getType().getValue()) continue;
                return true;
            }
        }
        return false;
    }
}

