/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.bs.ml.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.ResourceListener;
import com.kingdee.bos.metadata.management.LanguageInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.common.DCInfo;
import com.kingdee.eas.base.common.DCManager;
import com.kingdee.eas.bs.ml.ResourceFacadeFactory;
import com.kingdee.eas.bs.ml.smartmalle.MallEAssistor;
import com.kingdee.eas.bs.ml.util.EASResourceListenerHelper;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;

public class EASResourceListenerServer
implements ResourceListener {
    private static String defaultAis = null;

    public String getString(IMetaDataPK mdPK, BOSObjectType bosType, LanguageInfo lgInfo, String key, Context ctx) {
        Object vl;
        String metaType;
        if (mdPK == null || key == null) {
            return null;
        }
        String name = mdPK.getName();
        if (name == null) {
            return null;
        }
        String pkg = mdPK.getPackage();
        if (pkg != null) {
            pkg = pkg.replaceAll("\\.", "\\\\");
        }
        if ((metaType = EASResourceListenerHelper.getMetaDataType(bosType)) == null) {
            return null;
        }
        if ("entity".equals(metaType) || "query".equals(metaType)) {
            key = key.substring(key.indexOf("].") + 2, key.length());
        }
        if ("wbpage".equals(metaType)) {
            String suffix;
            int j = key.lastIndexOf("[");
            int k = key.lastIndexOf("].");
            if (j > 0 && k > 0 && ("caption".equals(suffix = key.substring(j + 1, k)) || "label".equals(suffix) || "title".equals(suffix))) {
                String s1 = key.substring(0, j);
                j = s1.lastIndexOf("[");
                k = s1.lastIndexOf("].");
                if (j > 0 && k > 0) {
                    String prefix = key.substring(j + 1, k);
                    key = prefix + "." + suffix;
                }
            }
        }
        if (("enum".equals(metaType) || "exception".equals(metaType) || "mdbview".equals(metaType)) && key.lastIndexOf(91) > 0 && key.lastIndexOf(93) > 0) {
            key = key.substring(key.lastIndexOf(91) + 1, key.lastIndexOf(93));
        }
        String lan = "";
        lan = lgInfo == null ? "zh_CN" : lgInfo.getLocaleString();
        if ("ui".equals(metaType) && name.startsWith("Abstract")) {
            name = name.substring(8, name.length());
        }
        Map map = null;
        try {
            map = ResourceFacadeFactory.getLocalInstance(ctx).getFileResource(pkg, name, lan, metaType);
        }
        catch (Exception ex) {
            Logger.error((Throwable)ex);
        }
        if (map != null && map.containsKey(key) && (vl = map.get(key)) != null) {
            return vl.toString();
        }
        try {
            MallEAssistor.AutoFetcher.autoFetch(ctx, mdPK, bosType, null, pkg, name, lan, metaType);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        return "";
    }

    public Map getRemoteWebResource(String packageName, String resFileName, Locale lc) {
        try {
            return EASResourceListenerHelper.getWebResource(packageName, resFileName, lc);
        }
        catch (BOSException e) {
            Logger.error((Throwable)e);
            return null;
        }
    }

    public Map getRemoteWebPageResource(String packageName, String resFileName, Locale lc) {
        try {
            return EASResourceListenerHelper.getWebPageResource(packageName, resFileName, lc);
        }
        catch (BOSException e) {
            Logger.error((Throwable)e);
            return null;
        }
    }

    public void deploy(IMetaDataPK arg0, BOSObjectType arg1, LanguageInfo arg2, Map arg3) {
    }

    public void deploy(IMetaDataPK arg0, BOSObjectType arg1, LanguageInfo arg2, String arg3, String arg4, boolean arg5) {
    }

    public String getDefaultAis() {
        if (defaultAis != null) {
            return defaultAis;
        }
        ArrayList dc = null;
        try {
            dc = DCManager.getInstance().getDCList();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (dc != null && dc.size() > 0) {
            defaultAis = ((DCInfo)dc.get(0)).getNumber();
        }
        return defaultAis;
    }
}

