/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.bs.ml.app;

import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.bs.ml.PrintTemplateResourceInfo;
import com.kingdee.eas.bs.ml.WorkFlowResourceInfo;
import com.kingdee.eas.bs.ml.util.MLConstonts;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MLTemplateToolsHelper {
    public static Map getWFTranslatedWords(Context ctx, String sourceId, String lan) throws Exception {
        HashMap<String, String> hashMap;
        if (sourceId == null || lan == null) {
            return Collections.EMPTY_MAP;
        }
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            StringBuffer sql = new StringBuffer();
            sql.append(" select ml.FCNMd5 md5,ml.FMLRes res ");
            sql.append(" from T_RES_workflow wf ");
            sql.append(" left join T_RES_TempRes res on wf.FId = res.FWorkFlowTempID ");
            sql.append(" left join T_RES_TempMultiLan ml on res.FId = ml.FResId ");
            sql.append(" where WF.FSourceId = ? and ml.FLanguage = ? and ml.FMLRes is not null");
            HashMap<String, String> map = new HashMap<String, String>();
            ps = conn.prepareStatement(sql.toString());
            ps.setString(1, sourceId);
            ps.setString(2, lan);
            rs = ps.executeQuery();
            while (rs.next()) {
                map.put(rs.getString("md5"), rs.getString("res"));
            }
            hashMap = map;
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps);
                SQLUtils.cleanup(rs);
                SQLUtils.cleanup((Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps);
        SQLUtils.cleanup((ResultSet)rs);
        SQLUtils.cleanup((Connection)conn);
        return hashMap;
    }

    public static Map saveWFTemplate(Context ctx, String procId, String code) throws Exception {
        Map map;
        if (procId == null) {
            return MLTemplateToolsHelper.getExistTemp(ctx, MLConstonts.Template_Type_WorkFlow);
        }
        String insSql = " insert into T_RES_workflow(fid,FSourceId,FSourceCode) values(?,?,?)";
        String id = BOSUuid.create((String)"4DD128CB").toString();
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            ps = conn.prepareStatement(insSql);
            ps.setString(1, id);
            ps.setString(2, procId);
            if (code == null) {
                ps.setNull(3, 12);
            } else {
                ps.setString(3, code);
            }
            ps.execute();
            map = MLTemplateToolsHelper.getExistTemp(ctx, MLConstonts.Template_Type_WorkFlow);
        }
        catch (Exception ex) {
            try {
                throw ex;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps);
                SQLUtils.cleanup((Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps);
        SQLUtils.cleanup((Connection)conn);
        return map;
    }

    public static Map getExistTemp(Context ctx, int type) throws Exception {
        Object sql;
        Connection conn = null;
        Statement st = null;
        ResultSet rs = null;
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            st = conn.createStatement();
            if (type == MLConstonts.Template_Type_WorkFlow) {
                sql = " select FId id, FSourceID srcId from T_RES_workflow ";
                rs = st.executeQuery(((String)sql).toString());
                while (rs.next()) {
                    map.put(rs.getString("srcId"), rs.getString("id"));
                }
            } else if (type == MLConstonts.Template_Type_Print) {
                sql = " select FId id, FFilePath fp,FFileName fn from T_RES_PrintTemp ";
                rs = st.executeQuery(((String)sql).toString());
                while (rs.next()) {
                    map.put(rs.getString("fp") + "\\" + rs.getString("fn"), rs.getString("id"));
                }
            }
            sql = map;
        }
        catch (Exception ex) {
            try {
                throw ex;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                SQLUtils.cleanup((Statement)st);
                SQLUtils.cleanup((Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        SQLUtils.cleanup((Statement)st);
        SQLUtils.cleanup((Connection)conn);
        return sql;
    }

    public static void saveWFWords(Context ctx, List list) throws Exception {
        if (list == null || list.size() <= 0) {
            return;
        }
        Connection conn = null;
        PreparedStatement ps = null;
        PreparedStatement mlPS = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            String insSql = "insert into T_RES_TempRes(FID,FWorkFlowTempID,FRes,FMD5) values(?,?,?,?)";
            ps = conn.prepareStatement(insSql);
            String insMLSql = "insert into T_RES_TempMultiLan(FID,FResID,FLanguage,FMLRes,FCNMD5) values(?,?,?,?,?)";
            mlPS = conn.prepareStatement(insMLSql);
            for (int i = 0; i < list.size(); ++i) {
                WorkFlowResourceInfo info = (WorkFlowResourceInfo)list.get(i);
                String resId = BOSUuid.create((String)"7050EC94").toString();
                ps.setString(1, resId);
                ps.setString(2, info.getWorkFlowTempID());
                ps.setString(3, info.getZh_CN());
                ps.setString(4, info.getMd5());
                ps.addBatch();
                mlPS.setString(1, BOSUuid.create((String)"378F422C").toString());
                mlPS.setString(2, resId);
                mlPS.setString(3, "en_US");
                if (info.getEn_US() != null) {
                    mlPS.setString(4, info.getEn_US());
                } else {
                    mlPS.setNull(4, 12);
                }
                mlPS.setString(5, info.getMd5());
                mlPS.addBatch();
                mlPS.setString(1, BOSUuid.create((String)"378F422C").toString());
                mlPS.setString(2, resId);
                mlPS.setString(3, "zh_TW");
                if (info.getZh_TW() != null) {
                    mlPS.setString(4, info.getZh_TW());
                } else {
                    mlPS.setNull(4, 12);
                }
                mlPS.setString(5, info.getMd5());
                mlPS.addBatch();
            }
            ps.executeBatch();
            mlPS.executeBatch();
        }
        catch (Exception ex) {
            try {
                throw ex;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps);
                SQLUtils.cleanup(mlPS);
                SQLUtils.cleanup((Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps);
        SQLUtils.cleanup((Statement)mlPS);
        SQLUtils.cleanup((Connection)conn);
    }

    public static Set getWFExistWords(Context ctx, String sourceId) throws Exception {
        HashSet<String> hashSet;
        if (sourceId == null) {
            return Collections.EMPTY_SET;
        }
        Connection conn = null;
        Statement st = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            StringBuffer sql = new StringBuffer();
            sql.append(" select FMD5 md5 from T_RES_TempRes res ");
            sql.append(" left join T_RES_workflow wf on res.FWorkFlowTempID = wf.FId ");
            sql.append(" where wf.FSourceId = '").append(sourceId).append("'");
            st = conn.createStatement();
            rs = st.executeQuery(sql.toString());
            HashSet<String> set = new HashSet<String>();
            while (rs.next()) {
                set.add(rs.getString("md5"));
            }
            hashSet = set;
        }
        catch (Exception ex) {
            try {
                throw ex;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(st);
                SQLUtils.cleanup(rs);
                SQLUtils.cleanup((Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)st);
        SQLUtils.cleanup((ResultSet)rs);
        SQLUtils.cleanup((Connection)conn);
        return hashSet;
    }

    public static Set getPTExistFileWords(Context ctx, String filePath, String fileName) throws Exception {
        HashSet<String> hashSet;
        if (filePath == null || fileName == null) {
            return Collections.EMPTY_SET;
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" select FMD5 md5 from T_RES_TempRes res ");
        sql.append(" left join T_RES_PrintTemp pf on res.FPrintTempID = pf.FId ");
        sql.append(" where FFilePath = '").append(filePath).append("'");
        sql.append(" and FFileName = '").append(fileName).append("'");
        Connection conn = null;
        Statement st = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            st = conn.createStatement();
            rs = st.executeQuery(sql.toString());
            HashSet<String> set = new HashSet<String>();
            while (rs.next()) {
                set.add(rs.getString("md5"));
            }
            hashSet = set;
        }
        catch (Exception ex) {
            try {
                throw ex;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                SQLUtils.cleanup((Statement)st);
                SQLUtils.cleanup((Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        SQLUtils.cleanup((Statement)st);
        SQLUtils.cleanup((Connection)conn);
        return hashSet;
    }

    public static Map savePTTemplate(Context ctx, String filePath, String fileName) throws Exception {
        Map map;
        if (filePath == null || fileName == null) {
            return MLTemplateToolsHelper.getExistTemp(ctx, MLConstonts.Template_Type_Print);
        }
        String insSql = " insert into T_RES_printTemp(fid,FFilePath,FFileName) values(?,?,?)";
        String id = BOSUuid.create((String)"BFFA4289").toString();
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            ps = conn.prepareStatement(insSql);
            ps.setString(1, id);
            ps.setString(2, filePath);
            ps.setString(3, fileName);
            ps.execute();
            map = MLTemplateToolsHelper.getExistTemp(ctx, MLConstonts.Template_Type_Print);
        }
        catch (Exception ex) {
            try {
                throw ex;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps);
                SQLUtils.cleanup((Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps);
        SQLUtils.cleanup((Connection)conn);
        return map;
    }

    public static void savePTWords(Context ctx, List list) throws Exception {
        if (list == null || list.size() <= 0) {
            return;
        }
        Connection conn = null;
        PreparedStatement ps = null;
        PreparedStatement mlPS = null;
        String insSql = "insert into T_RES_TempRes(FID,FPrintTempID,FRes,FMD5) values(?,?,?,?)";
        String insMLSql = "insert into T_RES_TempMultiLan(FID,FResID,FLanguage,FMLRes,FCNMD5) values(?,?,?,?,?)";
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            ps = conn.prepareStatement(insSql);
            mlPS = conn.prepareStatement(insMLSql);
            for (int i = 0; i < list.size(); ++i) {
                PrintTemplateResourceInfo info = (PrintTemplateResourceInfo)list.get(i);
                String resId = BOSUuid.create((String)"7050EC94").toString();
                ps.setString(1, resId);
                ps.setString(2, info.getPrintTempID());
                ps.setString(3, info.getZh_CN());
                ps.setString(4, info.getMd5());
                ps.addBatch();
                mlPS.setString(1, BOSUuid.create((String)"378F422C").toString());
                mlPS.setString(2, resId);
                mlPS.setString(3, "en_US");
                if (info.getEn_US() != null) {
                    mlPS.setString(4, info.getEn_US());
                } else {
                    mlPS.setNull(4, 12);
                }
                mlPS.setString(5, info.getMd5());
                mlPS.addBatch();
                mlPS.setString(1, BOSUuid.create((String)"378F422C").toString());
                mlPS.setString(2, resId);
                mlPS.setString(3, "zh_TW");
                if (info.getZh_TW() != null) {
                    mlPS.setString(4, info.getZh_TW());
                } else {
                    mlPS.setNull(4, 12);
                }
                mlPS.setString(5, info.getMd5());
                mlPS.addBatch();
            }
            ps.executeBatch();
            mlPS.executeBatch();
        }
        catch (Exception ex) {
            try {
                throw ex;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(mlPS);
                SQLUtils.cleanup(ps);
                SQLUtils.cleanup((Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)mlPS);
        SQLUtils.cleanup((Statement)ps);
        SQLUtils.cleanup((Connection)conn);
    }

    public static Map getPTTranslatedWords(Context ctx, String filePath, String fileName, String lan) throws Exception {
        HashMap<String, String> hashMap;
        if (filePath == null || fileName == null || lan == null) {
            return Collections.EMPTY_MAP;
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" select ml.FCNMd5 md5,ml.FMLRes res ");
        sql.append(" from T_RES_TempRes res ");
        sql.append(" left join T_RES_PrintTemp pf on pf.FId = res.FPrintTempID ");
        sql.append(" left join T_RES_TempMultiLan ml on res.FId = ml.FResId ");
        sql.append(" where pf.FFilePath = ? and pf.FFileName = ? and ml.FLanguage = ? and ml.FMLRes is not null");
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            ps = conn.prepareStatement(sql.toString());
            ps.setString(1, filePath);
            ps.setString(2, fileName);
            ps.setString(3, lan);
            rs = ps.executeQuery();
            while (rs.next()) {
                map.put(rs.getString("md5"), rs.getString("res"));
            }
            hashMap = map;
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                SQLUtils.cleanup(ps);
                SQLUtils.cleanup((Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        SQLUtils.cleanup((Statement)ps);
        SQLUtils.cleanup((Connection)conn);
        return hashMap;
    }
}

