/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.bs.ml.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.bs.ml.EASResourceDomainCollection;
import com.kingdee.eas.bs.ml.EASResourceDomainFactory;
import com.kingdee.eas.bs.ml.EASResourceDomainInfo;
import com.kingdee.eas.bs.ml.IEASResourceDomain;
import com.kingdee.eas.bs.ml.ILanguage;
import com.kingdee.eas.bs.ml.LanguageCollection;
import com.kingdee.eas.bs.ml.LanguageFactory;
import com.kingdee.eas.bs.ml.LanguageInfo;
import com.kingdee.eas.bs.ml.MultiFieldInfo;
import com.kingdee.eas.bs.ml.ResourceInfo;
import com.kingdee.eas.bs.ml.util.MLToolsConstonts;
import com.kingdee.eas.bs.ml.util.MLUtils;
import com.kingdee.eas.bs.ml.util.SafeCheckUtil;
import com.kingdee.eas.framework.bireport.bimanager.util.StringUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class MLToolsFacadeHelper {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.bs.ml.app.MLToolsFacadeHelper");
    private static String[] tabs = new String[]{"t_res_uiMultiLan", "t_res_resMultiLan", "t_res_enumMultiLan", "t_res_entityMultiLan", "t_res_queryMultiLan", "T_Res_PermMultiLan"};
    private static List list = new ArrayList();
    private static Map mlTableMap = new HashMap();
    private static Map tableMap;
    private static List domainList;
    private static HashMap domainMap;
    private static Set ignoreTables;

    public static void updateMLResource(Context ctx) throws Exception {
        String sql = " select FCNMD5Code md5, FContent en from t_res_EASMultiLanRes where FLanguageId = 'en_US' and (FISTranslated = 1 or FISTranslated = 2)";
        Connection conn = EJBFactory.getConnection((Context)ctx);
        ResultSet rs = conn.createStatement().executeQuery(sql);
        HashMap<String, String> map = new HashMap<String, String>(2000, 0.75f);
        while (rs.next()) {
            String md5 = rs.getString("md5");
            String en = rs.getString("en");
            if (md5 == null || en == null) continue;
            map.put(md5, en);
            if (map.size() <= 2000) continue;
            MLToolsFacadeHelper.updateMetasMLResource(conn, "en_US", map);
            MLToolsFacadeHelper.updateTemplateMLResource(conn, "en_US", map);
            map.clear();
        }
        MLToolsFacadeHelper.updateMetasMLResource(conn, "en_US", map);
        MLToolsFacadeHelper.updateTemplateMLResource(conn, "en_US", map);
        map.clear();
        SQLUtils.cleanup((Connection)conn);
    }

    private static void updateMetasMLResource(Connection conn, String lang, Map map) throws Exception {
        if (conn == null || lang == null || map == null) {
            return;
        }
        for (int i = 0; i < tabs.length; ++i) {
            String upd_sql = " update " + tabs[i] + " set FMLRes = ?,FMLRes2 = ? where FCNMD5 = ? and FLanguage = ? ";
            PreparedStatement ps = conn.prepareStatement(upd_sql);
            Set set = map.entrySet();
            for (Map.Entry entry : set) {
                String en = entry.getValue().toString();
                ps.setString(1, en);
                ps.setString(2, en);
                ps.setString(3, entry.getKey().toString());
                ps.setString(4, lang);
                ps.addBatch();
            }
            ps.executeBatch();
            SQLUtils.cleanup((Statement)ps);
        }
    }

    private static void updateTemplateMLResource(Connection conn, String lan, Map map) throws Exception {
        if (conn == null || map == null || lan == null) {
            return;
        }
        String upd_sql = " update T_RES_TempMultiLan set FMLRes = ? where FCNMD5 = ? and FLanguage = ? ";
        PreparedStatement ps = conn.prepareStatement(upd_sql);
        Set set = map.entrySet();
        for (Map.Entry entry : set) {
            String en = entry.getValue().toString();
            ps.setString(1, en);
            ps.setString(2, entry.getKey().toString());
            ps.setString(3, lan);
            ps.addBatch();
        }
        ps.executeBatch();
        SQLUtils.cleanup((Statement)ps);
    }

    public static void updateL1FeildResource(Context ctx) throws Exception {
        Connection conn = null;
        Statement st = null;
        ResultSet rs = null;
        ResultSet lenRS = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            st = conn.createStatement();
            list.add("t_hr_cmpitemfname_l1");
            String sql = "select distinct FTableName tn,FFieldName_L1 fn1 ,FFieldName_L2 fn2 from t_res_multifieldmeta order by ftableName,FFieldName_L2,FFieldName_L1";
            rs = st.executeQuery(sql);
            String quyLen = "select distinct FTableName tn,FFieldName_L2 fn ,FFieldLen len from t_res_multifieldmeta where FISBigField = 0 and FFieldLen > 0 order by ftableName";
            lenRS = st.executeQuery(quyLen);
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            while (lenRS.next()) {
                String key = lenRS.getString("tn") + lenRS.getString("fn");
                map.put(key, new Integer(lenRS.getInt("len")));
            }
            SQLUtils.cleanup((ResultSet)lenRS);
            String resQuery = "select FContent en from t_res_easmultilanres where FCNMD5Code = ? and FLanguageID = 'en_US' and FContent is not null";
            PreparedStatement quyResPS = conn.prepareStatement(resQuery);
            String oldTabName = "";
            String oldFN1 = "";
            String oldFN2 = "";
            while (rs.next()) {
                String tn = rs.getString("tn");
                String fn1 = rs.getString("fn1");
                String fn2 = rs.getString("fn2");
                if (oldTabName.equals(tn) && oldFN2.equals(fn2)) continue;
                MLToolsFacadeHelper.updateDB(tn, fn1, fn2, conn, quyResPS, map);
                oldTabName = tn;
                oldFN2 = fn2;
                oldFN1 = fn1;
            }
        }
        catch (Exception ex) {
            try {
                throw ex;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                SQLUtils.cleanup(lenRS);
                SQLUtils.cleanup((Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        SQLUtils.cleanup((ResultSet)lenRS);
        SQLUtils.cleanup((Connection)conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateDB(String tableName, String fn1, String fn2, Connection conn, PreparedStatement quyResPS, Map map) {
        block17: {
            if (tableName == null || fn1 == null || fn2 == null) {
                return;
            }
            String[] params = new String[]{tableName, fn2, fn1};
            if (!SafeCheckUtil.checkSql(params)) {
                logger.error((Object)"MlEToolsFacadeHelper.updateDB(String, String, String, Connection, PreparedStatement, Map) : check sql error !");
                return;
            }
            Statement st = null;
            ResultSet rs = null;
            PreparedStatement updPS = null;
            try {
                StringBuffer quySql = new StringBuffer();
                quySql.append("select FID id ");
                quySql.append(",").append(fn2);
                quySql.append(" from ").append(tableName);
                quySql.append(" where ").append(fn2).append(" is not null");
                st = conn.createStatement();
                rs = st.executeQuery(quySql.toString());
                StringBuffer sb = new StringBuffer();
                sb.append(" update ").append(tableName).append(" set ");
                sb.append(fn1).append(" = ? ");
                sb.append(" where FID = ? ");
                updPS = conn.prepareStatement(sb.toString());
                int c = 0;
                while (rs.next()) {
                    String zh = MLUtils.myTrim(rs.getString(fn2));
                    if (zh == null || zh.length() <= 0) continue;
                    if (MLUtils.containChinese(zh)) {
                        String md5 = MLUtils.md5HashCode(zh);
                        quyResPS.setString(1, md5);
                        ResultSet r = quyResPS.executeQuery();
                        if (r.next()) {
                            String en = r.getString("en");
                            if (list.contains(tableName.toLowerCase() + fn1.toLowerCase())) {
                                en = en.replaceAll("(\\s)+", "_");
                            }
                            if (map.containsKey(tableName + fn2)) {
                                int len = (Integer)map.get(tableName + fn2);
                                if (len > 0 && en.length() > len) {
                                    updPS.setString(1, en.substring(0, len));
                                } else {
                                    updPS.setString(1, en);
                                }
                            } else {
                                updPS.setString(1, en);
                            }
                        } else {
                            updPS.setString(1, zh);
                        }
                        SQLUtils.cleanup((ResultSet)r);
                    } else {
                        updPS.setString(1, zh);
                    }
                    updPS.setString(2, rs.getString("id"));
                    updPS.addBatch();
                    if (++c <= 5000) continue;
                    updPS.executeBatch();
                    updPS.clearBatch();
                    c = 0;
                }
                updPS.executeBatch();
                SQLUtils.cleanup((Statement)st);
            }
            catch (Exception ex) {
                logger.info((Object)(tableName + "  :" + fn1 + " :" + fn2 + ex.getMessage()));
                break block17;
            }
            finally {
                SQLUtils.cleanup(st);
                SQLUtils.cleanup(rs);
                SQLUtils.cleanup(updPS);
            }
            SQLUtils.cleanup((ResultSet)rs);
            SQLUtils.cleanup((Statement)updPS);
        }
    }

    public static Map getExistFileResource(Context ctx, String pkg, String fileName, String metaType) throws Exception {
        HashMap<String, Object> hashMap;
        HashMap<String, Object> map;
        PreparedStatement ps;
        Connection conn;
        block24: {
            String sql;
            block23: {
                if (fileName == null || metaType == null) {
                    return Collections.EMPTY_MAP;
                }
                if (pkg == null) {
                    pkg = "";
                }
                pkg = pkg.replaceAll("\\.", "\\\\");
                conn = null;
                ps = null;
                map = new HashMap<String, Object>(200, 0.75f);
                conn = EJBFactory.getConnection((Context)ctx);
                sql = "";
                if ("ui".equalsIgnoreCase(metaType) || "wbpage".equalsIgnoreCase(metaType)) {
                    sql = QuerySql.ui_sql;
                    break block23;
                }
                if ("query".equalsIgnoreCase(metaType)) {
                    sql = QuerySql.qy_sql;
                    break block23;
                }
                if ("resource".equalsIgnoreCase(metaType)) {
                    sql = QuerySql.res_sql;
                    break block23;
                }
                if ("enum".equalsIgnoreCase(metaType) || "exception".equalsIgnoreCase(metaType)) {
                    sql = QuerySql.em_sql;
                    break block23;
                }
                if ("entity".equalsIgnoreCase(metaType)) {
                    sql = QuerySql.et_sql;
                    break block23;
                }
                if ("table".equalsIgnoreCase(metaType)) {
                    sql = QuerySql.mlField_sql;
                    break block23;
                }
                if ("permission".equalsIgnoreCase(metaType) || "log".equalsIgnoreCase(metaType)) {
                    sql = QuerySql.perm_sql;
                    break block23;
                }
                if ("mdbview".equalsIgnoreCase(metaType)) {
                    sql = QuerySql.mdbview_sql;
                    break block23;
                }
                Map map2 = Collections.EMPTY_MAP;
                SQLUtils.cleanup((Statement)ps);
                SQLUtils.cleanup((Connection)conn);
                return map2;
            }
            ps = conn.prepareStatement(sql);
            if (!"table".equalsIgnoreCase(metaType)) break block24;
            ps.setString(1, fileName.toUpperCase());
            ResultSet rs = ps.executeQuery();
            ArrayList<CharSequence> list = new ArrayList<CharSequence>();
            while (rs.next()) {
                int idx;
                String fieldName = rs.getString("fn");
                if (fieldName == null || (idx = fieldName.lastIndexOf(95)) < 0) continue;
                list.add(fieldName.toLowerCase().subSequence(0, idx));
            }
            map.put(fileName.toUpperCase(), list);
            HashMap<String, Object> hashMap2 = map;
            SQLUtils.cleanup((Statement)ps);
            SQLUtils.cleanup((Connection)conn);
            return hashMap2;
        }
        try {
            if ("permission".equalsIgnoreCase(metaType) || "log".equalsIgnoreCase(metaType)) {
                ps.setString(1, fileName);
                ps.setString(2, metaType);
            } else if ("mdbview".equalsIgnoreCase(metaType)) {
                ps.setString(1, fileName);
            } else {
                ps.setString(1, pkg);
                ps.setString(2, fileName);
                if ("enum".equalsIgnoreCase(metaType) || "exception".equalsIgnoreCase(metaType)) {
                    ps.setString(3, metaType);
                }
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                map.put(rs.getString("k"), rs.getString("vl"));
            }
            hashMap = map;
        }
        catch (Exception ex) {
            try {
                throw ex;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps);
                SQLUtils.cleanup((Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps);
        SQLUtils.cleanup((Connection)conn);
        return hashMap;
    }

    public static Map getFileResourceID(Context ctx, String pkg, String fileName, String metaType) throws Exception {
        HashMap<String, String> hashMap;
        String sql;
        ResultSet rs;
        PreparedStatement ps;
        Connection conn;
        block20: {
            if (fileName == null || metaType == null) {
                return Collections.EMPTY_MAP;
            }
            if (pkg == null) {
                pkg = "";
            }
            pkg = pkg.replaceAll("\\.", "\\\\");
            conn = null;
            ps = null;
            rs = null;
            conn = EJBFactory.getConnection((Context)ctx);
            sql = "";
            if ("ui".equalsIgnoreCase(metaType) || "wbpage".equalsIgnoreCase(metaType)) {
                sql = QuerySql.ui_sql;
                break block20;
            }
            if ("query".equalsIgnoreCase(metaType)) {
                sql = QuerySql.qy_sql;
                break block20;
            }
            if ("resource".equalsIgnoreCase(metaType)) {
                sql = QuerySql.res_sql;
                break block20;
            }
            if ("enum".equalsIgnoreCase(metaType) || "exception".equalsIgnoreCase(metaType)) {
                sql = QuerySql.em_sql;
                break block20;
            }
            if ("entity".equalsIgnoreCase(metaType)) {
                sql = QuerySql.et_sql;
                break block20;
            }
            if ("permission".equalsIgnoreCase(metaType) || "log".equalsIgnoreCase(metaType)) {
                sql = QuerySql.perm_sql;
                break block20;
            }
            if ("mdbview".equalsIgnoreCase(metaType)) {
                sql = QuerySql.mdbview_sql;
                break block20;
            }
            Map map = Collections.EMPTY_MAP;
            SQLUtils.cleanup((ResultSet)rs);
            SQLUtils.cleanup((Statement)ps);
            SQLUtils.cleanup((Connection)conn);
            return map;
        }
        try {
            ps = conn.prepareStatement(sql);
            if ("permission".equalsIgnoreCase(metaType) || "log".equalsIgnoreCase(metaType)) {
                ps.setString(1, fileName);
                ps.setString(2, metaType);
            } else if ("mdbview".equalsIgnoreCase(metaType)) {
                ps.setString(1, fileName);
            } else {
                ps.setString(1, pkg);
                ps.setString(2, fileName);
                if ("enum".equalsIgnoreCase(metaType) || "exception".equalsIgnoreCase(metaType)) {
                    ps.setString(3, metaType);
                }
            }
            rs = ps.executeQuery();
            HashMap<String, String> map = new HashMap<String, String>(200, 0.75f);
            while (rs.next()) {
                map.put(rs.getString("k"), rs.getString("id"));
            }
            hashMap = map;
        }
        catch (Exception ex) {
            try {
                throw ex;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                SQLUtils.cleanup(ps);
                SQLUtils.cleanup((Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        SQLUtils.cleanup((Statement)ps);
        SQLUtils.cleanup((Connection)conn);
        return hashMap;
    }

    public static void saveDataToDB(Context ctx, List list, String metaType) throws Exception {
        if (list == null || metaType == null || list.size() <= 0) {
            return;
        }
        if ("table".equalsIgnoreCase(metaType)) {
            MLToolsFacadeHelper.savaMultiFields(ctx, list, metaType);
        } else if ("ui".equalsIgnoreCase(metaType) || "enum".equalsIgnoreCase(metaType) || "entity".equalsIgnoreCase(metaType) || "exception".equalsIgnoreCase(metaType) || "query".equalsIgnoreCase(metaType) || "resource".equalsIgnoreCase(metaType) || "wbpage".equalsIgnoreCase(metaType) || "webui".equalsIgnoreCase(metaType) || "mdbview".equalsIgnoreCase(metaType)) {
            MLToolsFacadeHelper.saveMetasResource(ctx, list, metaType);
        } else if ("permission".equals(metaType) || "log".equals(metaType)) {
            MLToolsFacadeHelper.savePermAndLogResource(ctx, list, metaType);
        }
    }

    public static void updateDomainIdToDB(Context ctx) throws BOSException {
        HashMap<String, String> domainMap = new HashMap<String, String>();
        IRowSet rs = null;
        PreparedStatement updPS = null;
        PreparedStatement updResourcePS = null;
        Connection conn = null;
        String newDomainId = null;
        String tableName = null;
        String updTabDomainSql = null;
        String selectSql = null;
        String pkg = null;
        String domainId = null;
        String md5 = null;
        String oldDomainId = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            boolean isAutoCommit = conn.getAutoCommit();
            conn.setAutoCommit(false);
            String updResourceSql = "update t_res_EASResource eas set fDomainId=? where FMD5Code=? ";
            updResourcePS = conn.prepareStatement(updResourceSql);
            int k = 0;
            int count = 0;
            int size = domainList.size();
            for (int i = 0; i < size; ++i) {
                tableName = (String)domainList.get(i);
                updTabDomainSql = "update " + tableName + " set fDomainID=? where fPackage=?";
                updPS = conn.prepareStatement(updTabDomainSql);
                selectSql = "select fPackage,FMD5 from " + tableName + " where fDomainId is null or fDomainId=''";
                int c = 0;
                rs = DbUtil.executeQuery((Context)ctx, (String)selectSql);
                while (rs.next()) {
                    ++count;
                    pkg = rs.getString("fPackage");
                    domainId = MLToolsFacadeHelper.getDomain(ctx, pkg);
                    if (StringUtils.isEmpty((String)domainId)) continue;
                    updPS.setString(1, domainId);
                    updPS.setString(2, pkg);
                    updPS.addBatch();
                    md5 = rs.getString("FMD5");
                    oldDomainId = (String)domainMap.get(md5);
                    if (StringUtils.isEmpty((String)oldDomainId)) {
                        domainMap.put(md5, domainId);
                        newDomainId = domainId;
                    } else if (oldDomainId.indexOf(domainId) < 0) {
                        newDomainId = oldDomainId + "#" + domainId;
                        domainMap.put(md5, newDomainId);
                    } else {
                        newDomainId = oldDomainId;
                    }
                    updResourcePS.setString(1, newDomainId);
                    updResourcePS.setString(2, md5);
                    updResourcePS.addBatch();
                    ++k;
                    if (++c > 4000) {
                        updPS.executeBatch();
                        conn.commit();
                        updPS.clearBatch();
                        c = 0;
                    }
                    if (k <= 4000) continue;
                    updResourcePS.executeBatch();
                    conn.commit();
                    updResourcePS.clearBatch();
                    k = 0;
                }
                updPS.executeBatch();
                conn.commit();
                count = 0;
            }
            updResourcePS.executeBatch();
            conn.commit();
            conn.setAutoCommit(isAutoCommit);
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e.getMessage());
                throw new BOSException(e.getMessage());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(updPS);
                SQLUtils.cleanup(updResourcePS);
                SQLUtils.cleanup(rs);
                SQLUtils.cleanup((Connection)conn);
                long l = System.currentTimeMillis();
                throw throwable;
            }
        }
        SQLUtils.cleanup(updPS);
        SQLUtils.cleanup((Statement)updResourcePS);
        SQLUtils.cleanup(rs);
        SQLUtils.cleanup((Connection)conn);
        long isAutoCommit = System.currentTimeMillis();
    }

    private static void saveMetasResource(Context ctx, List list, String metaType) throws Exception {
        Connection conn = null;
        PreparedStatement insPS = null;
        PreparedStatement updPS = null;
        PreparedStatement mlInsPS = null;
        PreparedStatement mlUpdPS = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            String ins_sql = "insert into " + tableMap.get(metaType.toLowerCase()) + "(fid,FPackage,FFileName,FKey,FProject,FMetaType,FRes,FRes2,FMD5,fDomainID) values(?,?,?,?,?,?,?,?,?,?) ";
            insPS = conn.prepareStatement(ins_sql);
            String upd_sql = "update " + tableMap.get(metaType.toLowerCase()) + " set Fres = ? , FRes2 = ?,FMD5 = ? where FID = ? ";
            updPS = conn.prepareStatement(upd_sql);
            String mlIns_Sql = "insert into " + mlTableMap.get(metaType.toLowerCase()) + "(fid,FResId,FLanguage,FMLRes,FMLRes2,FCNMD5,FForbidSysUpd) values(?,?,?,?,?,?,?)";
            mlInsPS = conn.prepareStatement(mlIns_Sql);
            String mlUpd_sql = "update " + mlTableMap.get(metaType.toLowerCase()) + " set FForbidSysUpd = 0, FCNMD5 = ? where FResId = ? ";
            mlUpdPS = conn.prepareStatement(mlUpd_sql);
            ILanguage language = LanguageFactory.getLocalInstance(ctx);
            EntityViewInfo view = new EntityViewInfo();
            LanguageCollection languageCollection = language.getLanguageCollection(view);
            boolean hasUpdate = false;
            boolean hasInsert = false;
            ResourceInfo info = null;
            Map keyIDMap = Collections.EMPTY_MAP;
            boolean hasInitKeyIdMap = false;
            int j = list.size();
            for (int i = 0; i < j; ++i) {
                info = (ResourceInfo)list.get(i);
                String pkg = info.getPkg();
                String fileName = info.getFileName();
                String key = info.getKey();
                String zhCN = info.getZh_CN();
                if (zhCN == null || zhCN.length() > 500) {
                    logger.info((Object)("file:" + pkg + "\\" + fileName + "key:" + key));
                    continue;
                }
                String md5 = MLUtils.md5HashCode(zhCN);
                if (info.isUpdate()) {
                    Object redId;
                    if (!hasInitKeyIdMap) {
                        keyIDMap = MLToolsFacadeHelper.getFileResourceID(ctx, pkg, fileName, metaType);
                        if (keyIDMap == null) {
                            keyIDMap = Collections.EMPTY_MAP;
                        }
                        hasInitKeyIdMap = true;
                    }
                    if ((redId = keyIDMap.get(key)) == null) continue;
                    updPS.setString(1, zhCN);
                    updPS.setString(2, zhCN);
                    updPS.setString(3, md5);
                    updPS.setString(4, redId.toString());
                    updPS.addBatch();
                    mlUpdPS.setString(1, md5);
                    mlUpdPS.setString(2, redId.toString());
                    mlUpdPS.addBatch();
                    hasUpdate = true;
                    continue;
                }
                String resId = BOSUuid.create((String)MLToolsConstonts.getBOSType(metaType, false)).toString();
                insPS.setString(1, resId);
                insPS.setString(2, pkg);
                insPS.setString(3, fileName);
                insPS.setString(4, key);
                insPS.setString(5, info.getPrj());
                insPS.setString(6, metaType);
                insPS.setString(7, zhCN);
                insPS.setString(8, zhCN);
                insPS.setString(9, md5);
                insPS.setString(10, MLToolsFacadeHelper.getDomain(ctx, pkg));
                insPS.addBatch();
                for (int l = 0; l < languageCollection.size(); ++l) {
                    LanguageInfo languageInfo = languageCollection.get(l);
                    String languageNumber = languageInfo.getNumber();
                    mlInsPS.setString(1, BOSUuid.create((String)MLToolsConstonts.getBOSType(metaType, true)).toString());
                    mlInsPS.setString(2, resId);
                    mlInsPS.setString(3, languageNumber);
                    String enUS = info.getEn_US();
                    String zhTW = info.getZh_TW();
                    if ("en_US".equalsIgnoreCase(languageNumber) && enUS != null) {
                        if (enUS.length() > 2000) {
                            enUS = enUS.substring(0, 2000);
                        }
                        mlInsPS.setString(4, enUS);
                        mlInsPS.setString(5, enUS);
                    } else if ("zh_TW".equalsIgnoreCase(languageNumber) && zhTW != null) {
                        if (zhTW.length() > 2000) {
                            zhTW = zhTW.substring(0, 2000);
                        }
                        mlInsPS.setString(4, zhTW);
                        mlInsPS.setString(5, zhTW);
                    } else {
                        mlInsPS.setNull(4, 12);
                        mlInsPS.setNull(5, 12);
                    }
                    mlInsPS.setString(6, md5);
                    mlInsPS.setInt(7, 0);
                    mlInsPS.addBatch();
                }
                hasInsert = true;
            }
            if (hasInsert) {
                insPS.executeBatch();
                mlInsPS.executeBatch();
            }
            if (hasUpdate) {
                updPS.executeBatch();
                mlUpdPS.executeBatch();
            }
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(insPS);
                SQLUtils.cleanup(updPS);
                SQLUtils.cleanup(mlInsPS);
                SQLUtils.cleanup(mlUpdPS);
                SQLUtils.cleanup((Connection)conn);
                list.clear();
                list = null;
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)insPS);
        SQLUtils.cleanup((Statement)updPS);
        SQLUtils.cleanup((Statement)mlInsPS);
        SQLUtils.cleanup((Statement)mlUpdPS);
        SQLUtils.cleanup((Connection)conn);
        list.clear();
        list = null;
    }

    public static HashMap getDomainMap(Context ctx) throws BOSException {
        if (domainMap.isEmpty()) {
            IEASResourceDomain iResDomain = EASResourceDomainFactory.getLocalInstance(ctx);
            EASResourceDomainCollection domainColl = iResDomain.getEASResourceDomainCollection();
            int size = domainColl.size();
            for (int i = 0; i < size; ++i) {
                EASResourceDomainInfo domainInfo = domainColl.get(i);
                String packageName = domainInfo.getPackageName();
                String[] packageNameStr = packageName.split(";");
                if (packageNameStr != null && packageNameStr.length > 0) {
                    int length = packageNameStr.length;
                    for (int k = 0; k < length; ++k) {
                        domainMap.put(packageNameStr[k], domainInfo);
                    }
                    continue;
                }
                domainMap.put(packageName, domainInfo);
            }
        }
        return domainMap;
    }

    private static String getDomain(Context ctx, String pkg) throws BOSException {
        if (StringUtils.isEmpty((String)pkg)) {
            return null;
        }
        HashMap domainMap = MLToolsFacadeHelper.getDomainMap(ctx);
        StringBuffer domainId = new StringBuffer();
        MLToolsFacadeHelper.getDomainId(domainMap, pkg, domainId);
        return domainId.toString();
    }

    private static void getDomainId(HashMap domainMap, String pkg, StringBuffer domainId) {
        EASResourceDomainInfo domainInfo = (EASResourceDomainInfo)domainMap.get(pkg);
        if (domainInfo != null) {
            domainId.append(domainInfo.getId().toString());
        }
        if (StringUtils.isEmpty((String)domainId.toString()) && pkg.indexOf("\\") > 0) {
            pkg = pkg.substring(0, pkg.lastIndexOf("\\"));
            MLToolsFacadeHelper.getDomainId(domainMap, pkg, domainId);
        }
    }

    private static void savaMultiFields(Context ctx, List list, String metaType) throws Exception {
        String ins_sql = "insert into t_res_multiFieldMeta(fid,FTableName,FProject,FFieldName_l1,FFieldName_l2,FFieldName_l3,FIsInvalid) values(?,?,?,?,?,?,?) ";
        Connection conn = null;
        PreparedStatement insPS = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            insPS = conn.prepareStatement(ins_sql);
            for (int i = 0; i < list.size(); ++i) {
                MultiFieldInfo info = (MultiFieldInfo)list.get(i);
                insPS.setString(1, BOSUuid.create((String)MLToolsConstonts.multiFieldMetaBosType).toString());
                insPS.setString(2, info.getTableName());
                insPS.setString(3, info.getProject());
                insPS.setString(4, info.get_l1());
                insPS.setString(5, info.get_l2());
                insPS.setString(6, info.get_l3());
                insPS.setInt(7, 1);
                insPS.addBatch();
            }
            insPS.executeBatch();
        }
        catch (Exception ex) {
            try {
                throw ex;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(insPS);
                SQLUtils.cleanup((Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)insPS);
        SQLUtils.cleanup((Connection)conn);
    }

    private static void savePermAndLogResource(Context ctx, List list, String metaType) throws Exception {
        Connection conn = null;
        PreparedStatement insPS = null;
        PreparedStatement updPS = null;
        PreparedStatement mlInsPS = null;
        PreparedStatement mlUpdPS = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            String ins_sql = "insert into t_Res_PermResource(fid,FPackage,FFileName,FKey,FProject,FMetaType,FRes,FRes2,FMD5,FInnerID) values(?,?,?,?,?,?,?,?,?,?) ";
            insPS = conn.prepareStatement(ins_sql);
            String upd_sql = "update t_Res_PermResource set Fres = ? , FRes2 = ?,FMD5 = ? where FID = ? ";
            updPS = conn.prepareStatement(upd_sql);
            String mlIns_Sql = "insert into T_Res_PermMultiLan(fid,FResId,FLanguage,FMLRes,FMLRes2,FCNMD5) values(?,?,?,?,?,?)";
            mlInsPS = conn.prepareStatement(mlIns_Sql);
            String mlUpd_sql = "update T_Res_PermMultiLan set FForbidSysUpd = 0, FCNMD5 = ? where FResId = ? ";
            mlUpdPS = conn.prepareStatement(mlUpd_sql);
            ILanguage language = LanguageFactory.getLocalInstance(ctx);
            EntityViewInfo view = new EntityViewInfo();
            LanguageCollection languageCollection = language.getLanguageCollection(view);
            boolean hasUpdate = false;
            boolean hasInsert = false;
            ResourceInfo info = null;
            Map keyIDMap = Collections.EMPTY_MAP;
            boolean hasInitKeyIdMap = false;
            int j = list.size();
            for (int i = 0; i < j; ++i) {
                info = (ResourceInfo)list.get(i);
                String pkg = info.getPkg();
                if (pkg == null || "".equals(pkg)) {
                    pkg = " ";
                }
                String fileName = info.getFileName();
                String key = info.getKey();
                String zhCN = info.getZh_CN();
                String innerId = info.getInnerId();
                if (zhCN == null || zhCN.length() > 500) {
                    logger.info((Object)("file:" + pkg + "\\" + fileName + "key:" + key));
                    continue;
                }
                String md5 = MLUtils.md5HashCode(zhCN);
                if (info.isUpdate()) {
                    Object redId;
                    if (!hasInitKeyIdMap) {
                        keyIDMap = MLToolsFacadeHelper.getFileResourceID(ctx, pkg, fileName, metaType);
                        if (keyIDMap == null) {
                            keyIDMap = Collections.EMPTY_MAP;
                        }
                        hasInitKeyIdMap = true;
                    }
                    if ((redId = keyIDMap.get(key)) == null) continue;
                    updPS.setString(1, zhCN);
                    updPS.setString(2, zhCN);
                    updPS.setString(3, md5);
                    updPS.setString(4, redId.toString());
                    updPS.addBatch();
                    mlUpdPS.setString(1, md5);
                    mlUpdPS.setString(2, redId.toString());
                    mlUpdPS.addBatch();
                    hasUpdate = true;
                    continue;
                }
                String resId = BOSUuid.create((String)MLToolsConstonts.getBOSType(metaType, false)).toString();
                insPS.setString(1, resId);
                insPS.setString(2, pkg);
                insPS.setString(3, fileName);
                insPS.setString(4, key);
                insPS.setString(5, info.getPrj());
                insPS.setString(6, metaType);
                insPS.setString(7, zhCN);
                insPS.setString(8, zhCN);
                insPS.setString(9, md5);
                insPS.setString(10, innerId);
                insPS.addBatch();
                for (int l = 0; l < languageCollection.size(); ++l) {
                    LanguageInfo languageInfo = languageCollection.get(l);
                    String languageNumber = languageInfo.getNumber();
                    mlInsPS.setString(1, BOSUuid.create((String)MLToolsConstonts.getBOSType(metaType, true)).toString());
                    mlInsPS.setString(2, resId);
                    mlInsPS.setString(3, languageNumber);
                    String enUS = info.getEn_US();
                    String zhTW = info.getZh_TW();
                    if ("en_US".equalsIgnoreCase(languageNumber) && enUS != null) {
                        if (enUS.length() > 2000) {
                            enUS = enUS.substring(0, 2000);
                        }
                        mlInsPS.setString(4, enUS);
                        mlInsPS.setString(5, enUS);
                    } else if ("zh_TW".equalsIgnoreCase(languageNumber) && zhTW != null) {
                        if (zhTW.length() > 2000) {
                            zhTW = zhTW.substring(0, 2000);
                        }
                        mlInsPS.setString(4, zhTW);
                        mlInsPS.setString(5, zhTW);
                    } else {
                        mlInsPS.setNull(4, 12);
                        mlInsPS.setNull(5, 12);
                    }
                    mlInsPS.setString(6, md5);
                    mlInsPS.addBatch();
                }
                hasInsert = true;
            }
            if (hasInsert) {
                insPS.executeBatch();
                mlInsPS.executeBatch();
            }
            if (hasUpdate) {
                updPS.executeBatch();
                mlUpdPS.executeBatch();
            }
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup((Connection)conn);
                SQLUtils.cleanup(insPS);
                SQLUtils.cleanup(updPS);
                SQLUtils.cleanup(mlInsPS);
                SQLUtils.cleanup(mlUpdPS);
                list.clear();
                list = null;
                throw throwable;
            }
        }
        SQLUtils.cleanup((Connection)conn);
        SQLUtils.cleanup((Statement)insPS);
        SQLUtils.cleanup((Statement)updPS);
        SQLUtils.cleanup((Statement)mlInsPS);
        SQLUtils.cleanup((Statement)mlUpdPS);
        list.clear();
        list = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void fetchNewWordsFromInitDB(Context ctx, boolean isFetchMenuResource, boolean isFetchPresetDataResource) throws Exception {
        Connection conn = null;
        Statement st = null;
        ResultSet rs = null;
        ResultSet rs2 = null;
        PreparedStatement insPS = null;
        PreparedStatement updPS = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            String quy_sql = " select FID id, FTableName tn,FFieldName_l2 fn from T_RES_MultiFieldMeta WHERE FIsInvalid=1 ";
            if (isFetchMenuResource && isFetchPresetDataResource) {
                quy_sql = quy_sql + " and FType in (0,1,2) ";
            } else if (!isFetchMenuResource && isFetchPresetDataResource) {
                quy_sql = quy_sql + " and FType IN (0,1) ";
            } else if (isFetchMenuResource && !isFetchPresetDataResource) {
                quy_sql = quy_sql + " and FType = 2 ";
            }
            rs = conn.createStatement().executeQuery(quy_sql);
            st = conn.createStatement();
            String ins_sql = " insert into t_Res_presetDataRes(FID,FParentID,FSourceID,FText_zh_CN,FMD5) values(?,?,?,?,?)";
            insPS = conn.prepareStatement(ins_sql);
            String upd_sql = " update t_Res_presetDataRes set FText_zh_CN = ? ,FMD5 = ?,FText_en_US = ?, FText_zh_TW = ? where FParentId = ? and FSourceId = ?";
            updPS = conn.prepareStatement(upd_sql);
            boolean hasInsert = false;
            boolean hasUpdate = false;
            while (rs.next()) {
                Map existWords;
                String parentId;
                String fieldName;
                String tabName;
                block20: {
                    hasInsert = false;
                    hasUpdate = false;
                    tabName = rs.getString("tn");
                    String[] params = new String[]{tabName, fieldName = rs.getString("fn"), parentId = rs.getString("id")};
                    if (SafeCheckUtil.checkSql(params)) {
                        if (tabName == null || fieldName == null || parentId == null || ignoreTables.contains(tabName.toLowerCase()) || tabName.toLowerCase().startsWith("t_wf_") || tabName.toLowerCase().startsWith("t_wfr_") || (existWords = MLToolsFacadeHelper.getExistWords(conn, parentId)) == null) continue;
                        String str = "select fid id, " + fieldName + " cn from " + tabName;
                        try {
                            rs2 = st.executeQuery(str);
                            break block20;
                        }
                        catch (Exception ex) {
                            logger.info((Object)("tabeName: " + tabName + "  fieldName: " + fieldName + ex.getMessage()));
                            continue;
                        }
                    }
                    logger.error((Object)"MLToolsFacadeHelper.fetchNewWordsFromInitDB(Context, boolean, boolean) : check sql error !");
                    SQLUtils.cleanup((Statement)st);
                    SQLUtils.cleanup((ResultSet)rs);
                    SQLUtils.cleanup(rs2);
                    SQLUtils.cleanup((Statement)updPS);
                    SQLUtils.cleanup((Statement)insPS);
                    SQLUtils.cleanup((Connection)conn);
                    return;
                }
                while (rs2.next()) {
                    String srcId;
                    String cn = MLUtils.myTrim(rs2.getString("cn"));
                    if (cn == null || cn.length() <= 0 || (srcId = rs2.getString("id")) == null) continue;
                    String md5 = MLUtils.md5HashCode(cn);
                    if (!existWords.containsKey(srcId)) {
                        insPS.setString(1, BOSUuid.create((String)MLToolsConstonts.presetDataResBosType).toString());
                        insPS.setString(2, parentId);
                        insPS.setString(3, srcId);
                        if (cn.length() > 1000) {
                            logger.info((Object)("tabeName: " + tabName + "  fieldName: " + fieldName + cn));
                            continue;
                        }
                        insPS.setString(4, cn);
                        insPS.setString(5, md5);
                        insPS.addBatch();
                        hasInsert = true;
                        continue;
                    }
                    Object oldCNMD5 = existWords.get(srcId);
                    if (md5.equals(oldCNMD5)) continue;
                    if (cn.length() > 1000) {
                        logger.info((Object)("tabeName: " + tabName + "  fieldName: " + fieldName + cn));
                        continue;
                    }
                    updPS.setString(1, cn);
                    updPS.setString(2, md5);
                    updPS.setNull(3, 12);
                    updPS.setNull(4, 12);
                    updPS.setString(5, parentId);
                    updPS.setString(6, srcId);
                    updPS.addBatch();
                    hasUpdate = true;
                }
                if (hasInsert) {
                    insPS.executeBatch();
                    insPS.clearBatch();
                    hasInsert = false;
                }
                if (hasUpdate) {
                    updPS.executeBatch();
                    updPS.clearBatch();
                    hasUpdate = false;
                }
                rs2.close();
            }
        }
        catch (Exception ex) {
            try {
                throw ex;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(st);
                SQLUtils.cleanup(rs);
                SQLUtils.cleanup(rs2);
                SQLUtils.cleanup(updPS);
                SQLUtils.cleanup(insPS);
                SQLUtils.cleanup((Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)st);
        SQLUtils.cleanup((ResultSet)rs);
        SQLUtils.cleanup(rs2);
        SQLUtils.cleanup((Statement)updPS);
        SQLUtils.cleanup((Statement)insPS);
        SQLUtils.cleanup((Connection)conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map getExistWords(Connection conn, String parentId) {
        String quy_sql = " select FSourceId srcId ,FMD5 md5 from t_res_presetDataRes where FParentId = ?";
        PreparedStatement st = null;
        ResultSet rs = null;
        HashMap<String, String> map = null;
        try {
            st = conn.prepareStatement(quy_sql);
            st.setString(1, parentId);
            rs = st.executeQuery();
            map = new HashMap<String, String>();
            while (rs.next()) {
                String md5 = rs.getString("md5");
                String srcId = rs.getString("srcId");
                if (md5 == null || srcId == null) continue;
                map.put(srcId, md5);
            }
        }
        catch (Exception ex) {
            Map map2;
            try {
                logger.info((Object)("query_sql:" + quy_sql + parentId));
                map2 = null;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup((Statement)st);
                SQLUtils.cleanup(rs);
                throw throwable;
            }
            SQLUtils.cleanup((Statement)st);
            SQLUtils.cleanup((ResultSet)rs);
            return map2;
        }
        SQLUtils.cleanup((Statement)st);
        SQLUtils.cleanup((ResultSet)rs);
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, Map<String, String>> getExistWordsForOverride(Connection conn, String parentId) {
        String quy_sql = " select FSourceId srcId ,FMD5 md5, FText_zh_CN zh_CN, FText_zh_TW zh_TW, FText_en_US en_US from t_res_presetDataRes where FParentId = '" + parentId + "'";
        Statement st = null;
        ResultSet rs = null;
        HashMap<String, Map<String, String>> map = null;
        try {
            st = conn.createStatement();
            rs = st.executeQuery(quy_sql);
            map = new HashMap<String, Map<String, String>>();
            while (rs.next()) {
                String md5 = rs.getString("md5");
                String srcId = rs.getString("srcId");
                if (md5 == null || srcId == null) continue;
                HashMap<String, String> each = new HashMap<String, String>(4);
                each.put("md5", md5);
                each.put("zh_CN", rs.getNString("zh_CN"));
                each.put("zh_TW", rs.getNString("zh_TW"));
                each.put("en_US", rs.getNString("en_US"));
                map.put(srcId, each);
            }
        }
        catch (Exception ex) {
            Map<String, Map<String, String>> map2;
            try {
                logger.info((Object)("query_sql:" + quy_sql + parentId));
                map2 = null;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup((Statement)st);
                SQLUtils.cleanup(rs);
                throw throwable;
            }
            SQLUtils.cleanup((Statement)st);
            SQLUtils.cleanup((ResultSet)rs);
            return map2;
        }
        SQLUtils.cleanup((Statement)st);
        SQLUtils.cleanup((ResultSet)rs);
        return map;
    }

    private static String getFTableNameCondition(List tables) {
        StringBuffer sb = new StringBuffer();
        sb.append(" upper(FTableName) in (");
        for (int i = 0; i < tables.size(); ++i) {
            if (i != 0) {
                sb.append(",");
                sb.append("'").append(tables.get(i).toString().toUpperCase()).append("'");
                continue;
            }
            sb.append("'").append(tables.get(i).toString().toUpperCase()).append("'");
        }
        sb.append(" ) ");
        return sb.toString();
    }

    public static void fetchWordsFromDBByLan(Context ctx, String language, boolean isOverride, List tabs) throws Exception {
        Connection conn = null;
        Statement st = null;
        ResultSet rs = null;
        ResultSet rs2 = null;
        PreparedStatement insPS = null;
        PreparedStatement updPS = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            String quy_sql = " select FID id, FTableName tn,FFieldName_l2 fn2,FFieldName_l1 fn1,FFieldName_l3 fn3 from T_RES_MultiFieldMeta WHERE FIsInvalid=1 ";
            quy_sql = quy_sql + " and " + MLToolsFacadeHelper.getFTableNameCondition(tabs);
            rs = conn.createStatement().executeQuery(quy_sql);
            st = conn.createStatement();
            String ins_sql = " insert into t_Res_presetDataRes(FID,FParentID,FSourceID,FText_zh_CN,FMD5,FText_zh_TW,FText_en_US) values(?,?,?,?,?,?,?)";
            insPS = conn.prepareStatement(ins_sql);
            String upd_sql = " update t_Res_presetDataRes set FText_zh_CN = ? ,FMD5 = ?,FText_en_US = ?, FText_zh_TW = ? where FParentId = ? and FSourceId = ?";
            updPS = conn.prepareStatement(upd_sql);
            boolean hasInsert = false;
            boolean hasUpdate = false;
            while (rs.next()) {
                Map<String, Map<String, String>> existWords;
                hasInsert = false;
                hasUpdate = false;
                String tabName = rs.getString("tn");
                String fieldName1 = rs.getString("fn1");
                String fieldName2 = rs.getString("fn2");
                String fieldName3 = rs.getString("fn3");
                String parentId = rs.getString("id");
                if (tabName == null || fieldName2 == null || parentId == null || ignoreTables.contains(tabName.toLowerCase()) || tabName.toLowerCase().startsWith("t_wf_") || tabName.toLowerCase().startsWith("t_wfr_") || (existWords = MLToolsFacadeHelper.getExistWordsForOverride(conn, parentId)) == null) continue;
                String str = "select fid id, " + fieldName1 + " cn1, " + fieldName2 + " cn2," + fieldName3 + " cn3 from " + tabName;
                try {
                    rs2 = st.executeQuery(str);
                }
                catch (Exception ex) {
                    logger.info((Object)("tabeName: " + tabName + "  fieldName: " + fieldName2 + ex.getMessage()));
                    continue;
                }
                while (rs2.next()) {
                    String srcId;
                    String cn2 = MLUtils.myTrim(rs2.getString("cn2"));
                    String cn1 = MLUtils.myTrim(rs2.getString("cn1"));
                    String cn3 = MLUtils.myTrim(rs2.getString("cn3"));
                    if (cn2 == null || cn2.length() <= 0 || (srcId = rs2.getString("id")) == null) continue;
                    String md5 = MLUtils.md5HashCode(cn2);
                    if (!existWords.containsKey(srcId)) {
                        insPS.setString(1, BOSUuid.create((String)MLToolsConstonts.presetDataResBosType).toString());
                        insPS.setString(2, parentId);
                        insPS.setString(3, srcId);
                        if (cn2.length() > 1000) {
                            logger.info((Object)("tabeName: " + tabName + "  fieldName: " + fieldName2 + cn2));
                            continue;
                        }
                        insPS.setString(4, cn2);
                        insPS.setString(5, md5);
                        if (isOverride) {
                            insPS.setString(6, cn3);
                            insPS.setString(7, cn1);
                        } else {
                            insPS.setNull(6, -9);
                            insPS.setNull(7, -9);
                        }
                        insPS.addBatch();
                        hasInsert = true;
                        continue;
                    }
                    Map<String, String> oldData = existWords.get(srcId);
                    if (!md5.equals(oldData.get("md5"))) {
                        if (cn2.length() > 1000) {
                            logger.info((Object)("tabeName: " + tabName + "  fieldName: " + fieldName2 + cn2));
                            continue;
                        }
                        updPS.setString(1, cn2);
                        updPS.setString(2, md5);
                        if (isOverride) {
                            if ("en_US".equals(language)) {
                                if (!StringUtils.isEmpty((String)cn1)) {
                                    updPS.setString(3, cn1);
                                }
                                updPS.setString(4, oldData.get("zh_TW"));
                            } else if ("zh_TW".equals(language)) {
                                updPS.setString(3, oldData.get("en_US"));
                                updPS.setString(4, cn3);
                            } else {
                                updPS.setString(3, oldData.get("en_US"));
                                updPS.setString(4, oldData.get("zh_TW"));
                            }
                        } else {
                            updPS.setString(3, oldData.get("en_US"));
                            updPS.setString(4, oldData.get("zh_TW"));
                        }
                        updPS.setString(5, parentId);
                        updPS.setString(6, srcId);
                        updPS.addBatch();
                        hasUpdate = true;
                        continue;
                    }
                    if (!isOverride) continue;
                    if (cn2.length() > 1000) {
                        logger.info((Object)("tabeName: " + tabName + "  fieldName: " + fieldName2 + cn2));
                        continue;
                    }
                    updPS.setString(1, cn2);
                    updPS.setString(2, md5);
                    if ("en_US".equals(language)) {
                        updPS.setString(3, cn1);
                        updPS.setString(4, oldData.get("zh_TW"));
                    } else if ("zh_TW".equals(language)) {
                        updPS.setString(3, oldData.get("en_US"));
                        updPS.setString(4, cn3);
                    } else {
                        updPS.setString(3, oldData.get("en_US"));
                        updPS.setString(4, oldData.get("zh_TW"));
                    }
                    updPS.setString(5, parentId);
                    updPS.setString(6, srcId);
                    updPS.addBatch();
                    hasUpdate = true;
                }
                if (hasInsert) {
                    insPS.executeBatch();
                    insPS.clearBatch();
                    hasInsert = false;
                }
                if (hasUpdate) {
                    updPS.executeBatch();
                    updPS.clearBatch();
                    hasUpdate = false;
                }
                rs2.close();
            }
        }
        catch (Exception ex) {
            try {
                logger.error((Object)ex.getMessage(), (Throwable)ex);
                throw ex;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(st);
                SQLUtils.cleanup(rs);
                SQLUtils.cleanup(rs2);
                SQLUtils.cleanup(updPS);
                SQLUtils.cleanup(insPS);
                SQLUtils.cleanup((Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)st);
        SQLUtils.cleanup((ResultSet)rs);
        SQLUtils.cleanup(rs2);
        SQLUtils.cleanup((Statement)updPS);
        SQLUtils.cleanup((Statement)insPS);
        SQLUtils.cleanup((Connection)conn);
    }

    static {
        mlTableMap.put("ui", "t_res_UIMultiLan");
        mlTableMap.put("wbpage", "t_res_UIMultiLan");
        mlTableMap.put("webui", "t_res_UIMultiLan");
        mlTableMap.put("resource", "t_res_resMultiLan");
        mlTableMap.put("enum", "t_res_EnumMultiLan");
        mlTableMap.put("exception", "t_res_EnumMultiLan");
        mlTableMap.put("entity", "t_res_EntityMultiLan");
        mlTableMap.put("query", "t_res_QueryMultiLan");
        mlTableMap.put("permission", "t_res_PermMultiLan");
        mlTableMap.put("mdbview", "t_res_mdbviewMultiLan");
        tableMap = new HashMap();
        tableMap.put("ui", "t_res_UIResource");
        tableMap.put("wbpage", "t_res_UIResource");
        tableMap.put("webui", "t_res_UIResource");
        tableMap.put("resource", "t_res_resResource");
        tableMap.put("enum", "t_res_EnumResource");
        tableMap.put("exception", "t_res_EnumResource");
        tableMap.put("entity", "t_res_EntityResource");
        tableMap.put("query", "t_res_QueryResource");
        tableMap.put("permission", "t_res_PermResource");
        tableMap.put("mdbview", "t_res_mdbviewResource");
        domainList = new ArrayList();
        domainList.add("t_res_UIResource");
        domainList.add("t_res_resResource");
        domainList.add("t_res_EntityResource");
        domainList.add("t_res_EnumResource");
        domainList.add("t_res_QueryResource");
        domainList.add("t_res_mdbviewResource");
        domainMap = new HashMap();
        ignoreTables = new HashSet();
        ignoreTables.add("t_log_app");
        ignoreTables.add("t_log_his");
        ignoreTables.add("t_pm_user");
        ignoreTables.add("t_pm_permitemchangereport");
        ignoreTables.add("t_bas_message");
        ignoreTables.add("t_fa_assistactitem");
        ignoreTables.add("t_query_querysolution");
        ignoreTables.add("t_bas_comfunction");
        ignoreTables.add("t_fw_usercustomconfig");
        ignoreTables.add("t_log_logitem");
    }

    private static class QuerySql {
        public static String ui_sql = " select FID id, FKey k, FMD5 vl from T_Res_UIResource where FPackage = ? and FFileName = ? ";
        public static String res_sql = " select FID id, FKey k, FMD5 vl from T_Res_resResource where FPackage = ? and FFileName = ? ";
        public static String em_sql = " select FID id, FKey k, FMD5 vl from T_Res_EnumResource where FPackage = ? and FFileName = ? and FMetaType = ? ";
        public static String et_sql = " select FID id, FKey k, FMD5 vl from T_Res_EntityResource where FPackage = ? and FFileName = ? ";
        public static String qy_sql = " select FID id, FKey k, FMD5 vl from T_Res_QueryResource where FPackage = ? and FFileName = ? ";
        public static String mlField_sql = " select FFieldName_l2 fn from T_RES_MultiFieldMeta where upper(FTableName) = ? ";
        public static String perm_sql = " select FID id, fkey k, FMD5 vl from t_Res_PermResource where FFileName = ? and FMetaType = ? ";
        public static String mdbview_sql = " select FID id, fkey k, FMD5 vl from T_RES_MdbviewResource where FFileName = ? ";

        private QuerySql() {
        }
    }
}

