/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.bs.ml.app;

import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.bs.ml.util.MLUtils;
import com.kingdee.eas.bs.ml.util.SafeCheckUtil;
import com.kingdee.eas.bs.ml.util.SoftMap;
import com.kingdee.util.Configuration;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class UpdateMLFieldResourceHelper {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.bs.ml.app.UpdateMLFieldResourceHelper");
    private Set set = new HashSet();
    private Map resCache = new SoftMap(1000, 0.75f);
    private Set ignoreTables = new HashSet();
    private static UpdateMLFieldResourceHelper obj;

    private UpdateMLFieldResourceHelper() {
    }

    public static synchronized UpdateMLFieldResourceHelper getInstance() {
        if (obj == null) {
            obj = new UpdateMLFieldResourceHelper();
            obj.init();
        }
        return obj;
    }

    private void init() {
        this.set.add("t_hr_cmpitemfname_l1");
        this.ignoreTables.add("t_log_app");
        this.ignoreTables.add("t_log_his");
        this.ignoreTables.add("t_pm_user");
        this.ignoreTables.add("t_pm_permitemchangereport");
        this.ignoreTables.add("t_bas_message");
        this.ignoreTables.add("t_fa_assistactitem");
        this.ignoreTables.add("t_bd_person");
        this.ignoreTables.add("t_fw_usercustomconfig");
    }

    private String getDBLanguage(String language) {
        Map properties = Configuration.getInstance().getConfigItem("supportlanguage").getProperties();
        String[] keys = null;
        for (Map.Entry key : properties.entrySet()) {
            keys = ((String)key.getKey()).split("#");
            if ("en_US".equals(language) && "L1".equalsIgnoreCase(keys[0])) {
                return keys[1];
            }
            if (!"zh_TW".equals(language) || !"L3".equalsIgnoreCase(keys[0])) continue;
            return keys[1];
        }
        return "zh_CN";
    }

    public void startUpdate(Context ctx, String language, boolean isUpdateAllMlField, List tables) throws Exception {
        if (language == null || !language.equals("en_US") && !language.equals("zh_TW")) {
            return;
        }
        if (!(isUpdateAllMlField || tables != null && tables.size() > 0)) {
            return;
        }
        Connection conn = null;
        PreparedStatement quyResPS = null;
        ResultSet rs = null;
        ResultSet lenRS = null;
        String dbLanguage = this.getDBLanguage(language);
        if ("zh_CN".equals(dbLanguage)) {
            return;
        }
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            StringBuffer sb = new StringBuffer();
            sb.append("select distinct FTableName tn,FFieldName_L2 fn2,");
            if (language.equals("en_US")) {
                sb.append(" FFieldName_L1 fn1 ");
            } else if (language.equals("zh_TW")) {
                sb.append(" FFieldName_L3 fn1 ");
            }
            sb.append(", FPrimeryKey pk from t_res_multifieldmeta ");
            if (!isUpdateAllMlField) {
                sb.append(" where ").append(this.getFTableNameCondition(tables));
            } else {
                sb.append(" where FIsInvalid = 1 ");
            }
            sb.append(" order by tn,fn2,fn1");
            rs = conn.createStatement().executeQuery(sb.toString());
            StringBuffer quyLen = new StringBuffer();
            quyLen.append("select distinct FTableName tn,FFieldName_L2 fn ,FFieldLen len from t_res_multifieldmeta");
            quyLen.append(" where FISBigField = 0 and FFieldLen > 0 ");
            if (!isUpdateAllMlField) {
                quyLen.append(" and ").append(this.getFTableNameCondition(tables));
            } else {
                sb.append(" where FIsInvalid = 1 ");
            }
            quyLen.append(" order by ftableName ");
            lenRS = conn.createStatement().executeQuery(quyLen.toString());
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            while (lenRS.next()) {
                String key = lenRS.getString("tn") + lenRS.getString("fn");
                map.put(key, new Integer(lenRS.getInt("len")));
            }
            StringBuffer updatePresetDataResSQL = new StringBuffer();
            updatePresetDataResSQL.append(" update T_RES_PresetDataRes                                        ");
            updatePresetDataResSQL.append(" set ftext_" + language + " = (                                    ");
            updatePresetDataResSQL.append(" select FContent from T_RES_EASMultiLanRes                         ");
            updatePresetDataResSQL.append(" where T_RES_EASMultiLanRes.FCNMD5Code = T_RES_PresetDataRes.FMD5  ");
            updatePresetDataResSQL.append(" and FLanguageID = '" + dbLanguage + "'                              ");
            updatePresetDataResSQL.append(" and FContent is not null                        ");
            updatePresetDataResSQL.append(" and ((FContent is null and ftext_" + language + " is not null) ");
            updatePresetDataResSQL.append(" \tor (FContent is not null and ftext_" + language + " is null) ");
            updatePresetDataResSQL.append(" \tor (FContent is not null and ftext_" + language + " is not null and FContent <> ftext_" + language + ")) ");
            updatePresetDataResSQL.append(")                           ");
            updatePresetDataResSQL.append(" where (ftext_" + language + " is null                          ");
            updatePresetDataResSQL.append(" or ftext_" + language + " = '')                          ");
            updatePresetDataResSQL.append(" and exists(                                                     ");
            updatePresetDataResSQL.append(" select FContent from T_RES_EASMultiLanRes                         ");
            updatePresetDataResSQL.append(" where T_RES_EASMultiLanRes.FCNMD5Code = T_RES_PresetDataRes.FMD5  ");
            updatePresetDataResSQL.append(" and FLanguageID = '" + dbLanguage + "'                              ");
            updatePresetDataResSQL.append(" and FContent is not null                        ");
            updatePresetDataResSQL.append(" and ((FContent is null and ftext_" + language + " is not null) ");
            updatePresetDataResSQL.append(" \tor (FContent is not null and ftext_" + language + " is null) ");
            updatePresetDataResSQL.append(" \tor (FContent is not null and ftext_" + language + " is not null and FContent <> ftext_" + language + ")) ");
            updatePresetDataResSQL.append(")                           ");
            if (!isUpdateAllMlField) {
                updatePresetDataResSQL.append(" and exists(select fid from T_RES_MultiFieldMeta ");
                updatePresetDataResSQL.append(" where T_RES_MultiFieldMeta.fid = T_RES_PresetDataRes.FParentID ");
                updatePresetDataResSQL.append(" and " + this.getFTableNameCondition(tables) + " ) ");
            }
            conn.createStatement().executeUpdate(updatePresetDataResSQL.toString());
            String resQuery = "select pdr.ftext_" + language + " ml from T_RES_PresetDataRes pdr left outer join T_RES_MultiFieldMeta mfd on mfd.fid = pdr.FParentID where pdr.FMD5 = ? and mfd.FTableName = ? and mfd.FFieldName_l2 = ? and pdr.ftext_" + language + " is not null";
            quyResPS = conn.prepareStatement(resQuery);
            String oldTabName = "";
            String oldFN1 = "";
            String oldFN2 = "";
            boolean updateEntityRes = false;
            while (rs.next()) {
                String tn = rs.getString("tn");
                if (this.ignoreTables.contains(tn.toLowerCase()) || tn.toLowerCase().startsWith("t_wf_") || tn.toLowerCase().startsWith("t_wfr_")) continue;
                if ("t_sys_entityref".equalsIgnoreCase(tn)) {
                    updateEntityRes = true;
                    continue;
                }
                String fn1 = rs.getString("fn1");
                String fn2 = rs.getString("fn2");
                String pk = rs.getString("pk");
                if (pk == null || pk.trim().length() == 0) {
                    pk = "FID";
                }
                if (oldTabName.equals(tn) && oldFN2.equals(fn2)) continue;
                this.updateDB(tn, fn1, fn2, pk, conn, quyResPS, map);
                oldTabName = tn;
                oldFN2 = fn2;
                oldFN1 = fn1;
            }
            if (updateEntityRes) {
                this.updateEntityRes(ctx, language);
            }
        }
        catch (Exception ex) {
            try {
                throw ex;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                SQLUtils.cleanup(lenRS);
                SQLUtils.cleanup(quyResPS);
                SQLUtils.cleanup((Connection)conn);
                this.resCache.clear();
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        SQLUtils.cleanup((ResultSet)lenRS);
        SQLUtils.cleanup((Statement)quyResPS);
        SQLUtils.cleanup((Connection)conn);
        this.resCache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDB(String tableName, String fn1, String fn2, String primeryKey, Connection conn, PreparedStatement quyResPS, Map map) {
        block26: {
            if (tableName == null || fn1 == null || fn2 == null) {
                return;
            }
            ResultSet rs = null;
            PreparedStatement updPS = null;
            Statement st = null;
            try {
                String[] params = new String[]{fn2, fn1, tableName, primeryKey};
                if (!SafeCheckUtil.checkSql(params)) {
                    logger.error((Object)"UpdateMLFieldResourceHelper.updateDB : check sql error !");
                }
                StringBuffer quySql = new StringBuffer();
                quySql.append("select " + primeryKey + " id ");
                quySql.append(",").append(fn2);
                quySql.append(",").append(fn1);
                quySql.append(" from ").append(tableName);
                quySql.append(" where ").append(fn2).append(" is not null");
                st = conn.createStatement();
                rs = st.executeQuery(quySql.toString());
                StringBuffer sb = new StringBuffer();
                sb.append(" update ").append(tableName).append(" set ");
                sb.append(fn1).append(" = ? ");
                sb.append(" where " + primeryKey + " = ? ");
                updPS = conn.prepareStatement(sb.toString());
                int c = 0;
                boolean hasUpd = false;
                while (rs.next()) {
                    String zh = MLUtils.myTrim(rs.getString(fn2));
                    String ml = MLUtils.myTrim(rs.getString(fn1));
                    if (zh == null || zh.length() <= 0) continue;
                    hasUpd = true;
                    String mlRes = null;
                    if (MLUtils.containChinese(zh)) {
                        String md5 = MLUtils.md5HashCode(zh);
                        Object obj = this.resCache.get(md5);
                        if (obj != null) {
                            mlRes = obj.toString();
                        } else {
                            quyResPS.setString(1, md5);
                            quyResPS.setString(2, tableName);
                            quyResPS.setString(3, fn2);
                            ResultSet r = quyResPS.executeQuery();
                            if (r.next()) {
                                mlRes = r.getString("ml");
                                this.resCache.put(md5, mlRes);
                            }
                            SQLUtils.cleanup((ResultSet)r);
                        }
                        if (mlRes != null) {
                            if (this.set.contains(tableName.toLowerCase() + fn1.toLowerCase())) {
                                mlRes = mlRes.replaceAll("(\\s)+", "_");
                            }
                            if (map.containsKey(tableName + fn2)) {
                                int len = (Integer)map.get(tableName + fn2);
                                if (len > 0 && mlRes.length() > len) {
                                    updPS.setString(1, mlRes.substring(0, len));
                                } else {
                                    updPS.setString(1, mlRes);
                                }
                            } else {
                                updPS.setString(1, mlRes);
                            }
                        } else if (ml == null || ml.length() <= 0) {
                            updPS.setString(1, zh);
                        } else if (mlRes == null || ml.equals(mlRes)) {
                            hasUpd = false;
                        }
                    } else if (ml == null || ml.length() <= 0) {
                        updPS.setString(1, zh);
                    } else if (mlRes == null || ml.equals(mlRes)) {
                        hasUpd = false;
                    }
                    if (!hasUpd) continue;
                    updPS.setString(2, rs.getString("id"));
                    updPS.addBatch();
                    if (++c <= 5000) continue;
                    updPS.executeBatch();
                    updPS.clearBatch();
                    c = 0;
                }
                updPS.executeBatch();
                SQLUtils.cleanup((Statement)st);
            }
            catch (Exception ex) {
                logger.info((Object)(tableName + "  :" + fn1 + " :" + fn2 + ex.getMessage()));
                break block26;
            }
            finally {
                SQLUtils.cleanup(st);
                SQLUtils.cleanup(rs);
                SQLUtils.cleanup(updPS);
            }
            SQLUtils.cleanup((ResultSet)rs);
            SQLUtils.cleanup((Statement)updPS);
        }
    }

    protected void updateEntityRes(Context ctx, String lan) throws Exception {
        Connection conn = null;
        PreparedStatement updPS = null;
        PreparedStatement quyPS = null;
        ResultSet rs = null;
        try {
            String upd_sql;
            conn = EJBFactory.getConnection((Context)ctx);
            if ("en_US".equals(lan)) {
                upd_sql = " update T_SYS_EntityRef set FEntityAlias_L1 = ?, FRefEntityAlias_L1 = ? where FbosType = ? and freftableName = ? and freffieldName = ? ";
            } else if ("zh_TW".equals(lan)) {
                upd_sql = " update T_SYS_EntityRef set FEntityAlias_L3 = ?, FRefEntityAlias_L3 = ? where FbosType = ? and freftableName = ? and freffieldName = ? ";
            } else {
                return;
            }
            updPS = conn.prepareStatement(upd_sql);
            String sql = "select FbosType bt, freftableName tn,freffieldName fn,FEntityAlias_L2 ea,FRefEntityAlias_L2 ra from T_SYS_EntityRef";
            rs = conn.createStatement().executeQuery(sql);
            String resQuery = "select FContent en from t_res_easmultilanres where FCNMD5Code = ? and FLanguageID = '" + lan + "'";
            quyPS = conn.prepareStatement(resQuery);
            int c = 0;
            String mlRes = null;
            while (rs.next()) {
                ResultSet r;
                String bt = rs.getString("bt");
                String tn = rs.getString("tn");
                String fn = rs.getString("fn");
                String ea = MLUtils.myTrim(rs.getString("ea"));
                String ra = MLUtils.myTrim(rs.getString("ra"));
                if (!MLUtils.containChinese(ea) && !MLUtils.containChinese(ra)) continue;
                mlRes = null;
                String md5 = MLUtils.md5HashCode(ea);
                Object obj = this.resCache.get(md5);
                if (obj != null) {
                    mlRes = obj.toString();
                } else {
                    quyPS.setString(1, md5);
                    r = quyPS.executeQuery();
                    if (r.next()) {
                        mlRes = r.getString("en");
                        this.resCache.put(md5, mlRes);
                    }
                    SQLUtils.cleanup((ResultSet)r);
                }
                if (mlRes != null) {
                    if (mlRes.length() > 255) {
                        mlRes = mlRes.substring(0, 255);
                    }
                    updPS.setString(1, mlRes);
                } else {
                    updPS.setString(1, ea);
                }
                mlRes = null;
                md5 = MLUtils.md5HashCode(ra);
                obj = this.resCache.get(md5);
                if (obj != null) {
                    mlRes = obj.toString();
                } else {
                    quyPS.setString(1, md5);
                    r = quyPS.executeQuery();
                    if (r.next()) {
                        mlRes = r.getString("en");
                        this.resCache.put(md5, mlRes);
                    }
                    SQLUtils.cleanup((ResultSet)r);
                }
                if (mlRes != null) {
                    if (mlRes.length() > 255) {
                        mlRes = mlRes.substring(0, 255);
                    }
                    updPS.setString(2, mlRes);
                } else {
                    updPS.setString(2, ra);
                }
                updPS.setString(3, bt);
                updPS.setString(4, tn);
                updPS.setString(5, fn);
                updPS.addBatch();
                if (++c <= 5000) continue;
                updPS.executeBatch();
                updPS.clearBatch();
                c = 0;
            }
            if (c > 0) {
                updPS.executeBatch();
            }
            SQLUtils.cleanup((Statement)updPS);
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            SQLUtils.cleanup(updPS);
            SQLUtils.cleanup(quyPS);
            SQLUtils.cleanup(rs);
            SQLUtils.cleanup((Connection)conn);
        }
        SQLUtils.cleanup((Statement)quyPS);
        SQLUtils.cleanup((ResultSet)rs);
        SQLUtils.cleanup((Connection)conn);
    }

    private String getFTableNameCondition(List tables) {
        StringBuffer sb = new StringBuffer();
        sb.append(" upper(FTableName) in (");
        for (int i = 0; i < tables.size(); ++i) {
            if (i != 0) {
                sb.append(",");
                sb.append("'").append(tables.get(i).toString().toUpperCase()).append("'");
                continue;
            }
            sb.append("'").append(tables.get(i).toString().toUpperCase()).append("'");
        }
        sb.append(" ) ");
        return sb.toString();
    }
}

