/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.bs.ml.app;

import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.bs.ml.TranslateStatusEnum;
import com.kingdee.eas.bs.ml.util.MLUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class UpdateMetasResourceHelper {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.bs.ml.app.UpdateMetasResourceHelper");
    private static String[] tabs = new String[]{"t_res_uiMultiLan", "t_res_resMultiLan", "t_res_enumMultiLan", "t_res_entityMultiLan", "t_res_queryMultiLan", "t_res_permmultilan", "t_res_mdbviewMultiLan"};

    public static void updateSystemRes(Context ctx, String tempTable, String language) throws SQLException {
        try {
            for (int i = 0; i < tabs.length; ++i) {
                StringBuffer upsb = new StringBuffer();
                upsb.append(" update " + tabs[i] + " set FMLRes2 = ( ");
                upsb.append("   select en ");
                upsb.append("     from " + tempTable + " ");
                upsb.append("    where " + tempTable + ".md5 = " + tabs[i] + ".FCNMD5 ");
                upsb.append("  ) ");
                upsb.append("  where exists ( ");
                upsb.append("    select 1 ");
                upsb.append(" \t from " + tempTable + " ");
                upsb.append(" \t where " + tabs[i] + ".FCNMD5 = " + tempTable + ".md5 ");
                upsb.append(" \t   and " + tabs[i] + ".FLanguage='" + language + "' ");
                upsb.append(" \t   and " + tabs[i] + ".FForbidSysUpd = 0 ");
                upsb.append("  ) ");
                DbUtil.execute((Context)ctx, (String)upsb.toString());
                if ("t_res_uiMultiLan".equals(tabs[i])) {
                    StringBuffer sb = new StringBuffer();
                    sb.append(" update t_res_uiMultiLan set FMLRes2 = ( ");
                    sb.append("   select case mety when 0 then en when 1 then men else en end ");
                    sb.append("     from " + tempTable + "  ");
                    sb.append("    where " + tempTable + ".md5 = t_res_uiMultiLan.FCNMD5 ");
                    sb.append(" )  ");
                    sb.append(" where exists ( ");
                    sb.append("   select 1 from " + tempTable + " ");
                    sb.append("    where t_res_uiMultiLan.FCNMD5 =" + tempTable + ".md5 ");
                    sb.append(" \t and t_res_uiMultiLan.FLanguage='" + language + "' ");
                    sb.append(" \t and t_res_uiMultiLan.FForbidSysUpd = 0 ");
                    sb.append(" ) ");
                    sb.append(" and exists( ");
                    sb.append("   select 1 from T_RES_UIResource ");
                    sb.append("    where t_res_uiMultiLan.FResID =  T_RES_UIResource.fid ");
                    sb.append("      and T_RES_UIResource.FResUiType in(1,2,3) ");
                    sb.append(" ) ");
                    DbUtil.execute((Context)ctx, (String)sb.toString());
                }
                upsb = new StringBuffer();
                upsb.append(" update " + tabs[i] + " set fmlres  = fmlres2  ");
                upsb.append(" WHERE flanguage = '" + language + "' ");
                DbUtil.execute((Context)ctx, (String)upsb.toString());
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage());
            throw new SQLException(ex.getMessage());
        }
    }

    public static void updatePresetData(Context ctx, Map map, String language) throws SQLException {
        if (ctx == null || map == null || language == null) {
            return;
        }
        if (!language.equals("zh_TW") && !language.equals("en_US")) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(" update t_res_presetDataRes set ");
        if (language.equals("en_US")) {
            sb.append(" FText_en_US = ? ");
        } else if (language.equals("zh_TW")) {
            sb.append(" FText_zh_TW = ? ");
        }
        sb.append(" where FMD5 = ? ");
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            ps = conn.prepareStatement(sb.toString());
            Set set = map.entrySet();
            for (Map.Entry entry : set) {
                String en = entry.getValue().toString();
                ps.setString(1, en);
                ps.setString(2, entry.getKey().toString());
                ps.addBatch();
            }
            ps.executeBatch();
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex.getMessage());
                throw ex;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps);
                SQLUtils.cleanup((Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps);
        SQLUtils.cleanup((Connection)conn);
    }

    public static void updatePresetDataToSys(Context ctx, String lang) throws Exception {
        if (ctx == null || lang == null) {
            return;
        }
        if (!lang.equals("zh_TW") && !lang.equals("en_US")) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(" select mf.FTableName tn ");
        if (lang.equals("en_US")) {
            sb.append(",mf.FFieldName_l1 fn ");
        } else if (lang.equals("zh_TW")) {
            sb.append(",mf.FFieldName_l3 fn ");
        }
        sb.append(",res.FSourceId srcId, res.FText_en_US en ,mf.FFieldLen len ");
        sb.append(" from t_res_presetDataRes res ");
        sb.append(" left join t_res_multifieldmeta mf on res.fparentID = mf.fid ");
        sb.append(" where res.FText_en_US is not null and res.FSourceId is not null ");
        sb.append(" order by mf.FTableName ,mf.FFieldName_l1 ");
        Connection conn = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            rs = conn.createStatement().executeQuery(sb.toString());
            ArrayList<PresetDataInfo> list = new ArrayList<PresetDataInfo>();
            String oldTabName = "";
            String oldFieldName = "";
            while (rs.next()) {
                String tn = rs.getString("tn");
                String fn = rs.getString("fn");
                if (!oldTabName.equals(tn) || !oldFieldName.equals(fn)) {
                    UpdateMetasResourceHelper.updatePresetDataToDB(conn, list);
                    oldTabName = tn;
                    oldFieldName = fn;
                    list.clear();
                }
                PresetDataInfo pInfo = new PresetDataInfo();
                pInfo.setSourceId(rs.getString("srcId"));
                pInfo.setTableName(tn);
                pInfo.setFieldName(fn);
                String en = MLUtils.myTrim(rs.getString("en"));
                int len = rs.getInt("len");
                if (len > 0 && en.length() > len) {
                    pInfo.setEn(en.substring(0, len));
                } else {
                    pInfo.setEn(en);
                }
                list.add(pInfo);
            }
            UpdateMetasResourceHelper.updatePresetDataToDB(conn, list);
            list.clear();
        }
        catch (Exception ex) {
            try {
                logger.error((Object)ex.getMessage());
                throw ex;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                SQLUtils.cleanup((Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        SQLUtils.cleanup((Connection)conn);
    }

    public static void updatePresetDataToDB(Connection conn, List list) throws SQLException {
        if (list.size() <= 0) {
            return;
        }
        PresetDataInfo pInfo = (PresetDataInfo)list.get(0);
        String tableName = pInfo.getTableName();
        String fieldName = pInfo.getFieldName();
        String sql = "update " + tableName + " set " + fieldName + " = ? where FID = ?";
        PreparedStatement ps = conn.prepareStatement(sql);
        int j = list.size();
        for (int i = 0; i < j; ++i) {
            pInfo = (PresetDataInfo)list.get(i);
            String en = pInfo.getEn();
            ps.setString(1, en);
            ps.setString(2, pInfo.getSourceId());
            ps.addBatch();
        }
        try {
            ps.executeBatch();
        }
        catch (Exception ex) {
            logger.error((Object)("error sql:" + sql));
        }
        if (ps != null) {
            ps.close();
        }
    }

    public static void updateEASTransResourceState(Connection conn, boolean isSelectedUpdate, List selectes, String language, TranslateStatusEnum state) throws SQLException {
        if (isSelectedUpdate && (selectes == null || selectes.size() <= 0)) {
            return;
        }
        if (language == null) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("update t_res_EASMultiLanRes set FISTranslated = ").append(state.getValue()).append(" where ");
        if (isSelectedUpdate && selectes.size() > 0) {
            sb.append(" fid in (");
            for (int i = 0; i < selectes.size(); ++i) {
                if (i != 0) {
                    sb.append(",");
                }
                sb.append("'").append(selectes.get(i).toString()).append("'");
            }
            sb.append(")");
            sb.append(" and FLanguageId = '").append(language).append("'");
            sb.append(" and FISTransLated = ").append(1);
        } else {
            sb.append(" FLanguageId = '").append(language).append("'");
            sb.append(" and FISTransLated = ").append(1);
        }
        Statement st = null;
        try {
            st = conn.createStatement();
            st.executeUpdate(sb.toString());
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            SQLUtils.cleanup((Statement)st);
        }
    }

    private static class PresetDataInfo {
        private String sourceId;
        private String tableName;
        private String fieldName;
        private String en;

        private PresetDataInfo() {
        }

        public String getSourceId() {
            return this.sourceId;
        }

        public void setSourceId(String sourceId) {
            this.sourceId = sourceId;
        }

        public String getTableName() {
            return this.tableName;
        }

        public void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        public String getEn() {
            return this.en;
        }

        public void setEn(String en) {
            this.en = en;
        }
    }
}

