/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.bs.ml.smartmalle;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.xml.impl.MDLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.configure.ConfigMDUtil;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.bs.ml.EASMultiLanResFactory;
import com.kingdee.eas.bs.ml.EASMultiLanResInfo;
import com.kingdee.eas.bs.ml.EASResourceFactory;
import com.kingdee.eas.bs.ml.EASResourceInfo;
import com.kingdee.eas.bs.ml.IEASMultiLanRes;
import com.kingdee.eas.bs.ml.IEASResource;
import com.kingdee.eas.bs.ml.TranslateStatusEnum;
import com.kingdee.eas.bs.ml.smartmalle.CloudTranslate.CloudTraEnum;
import com.kingdee.eas.bs.ml.smartmalle.CloudTranslate.ICloudTranslate;
import com.kingdee.eas.bs.ml.smartmalle.CloudTranslate.YouDao.YouDaoTranslate;
import com.kingdee.eas.bs.ml.smartmalle.CloudTranslateEnum;
import com.kingdee.eas.bs.ml.smartmalle.IMallEAssistorFacade;
import com.kingdee.eas.bs.ml.smartmalle.IMallERecord;
import com.kingdee.eas.bs.ml.smartmalle.IMallERob;
import com.kingdee.eas.bs.ml.smartmalle.MallEAssistorFacadeFactory;
import com.kingdee.eas.bs.ml.smartmalle.MallERecordFactory;
import com.kingdee.eas.bs.ml.smartmalle.MallERecordInfo;
import com.kingdee.eas.bs.ml.smartmalle.MallERobComponentClient;
import com.kingdee.eas.bs.ml.smartmalle.MallERobComponentServer;
import com.kingdee.eas.bs.ml.smartmalle.MallERobFactory;
import com.kingdee.eas.bs.ml.smartmalle.MallERobInfo;
import com.kingdee.eas.bs.ml.smartmalle.app.RecordQueue;
import com.kingdee.eas.bs.ml.smartmalle.tool.MallEFetchWordsFromJarOrFileUtil;
import com.kingdee.eas.bs.ml.util.MLUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public class MallEAssistor {
    private static List<String> suffixList = new ArrayList<String>();
    private static Logger logger = Logger.getLogger((String)MallEAssistor.class.getName());

    private MallEAssistor() {
    }

    private static void verifyInput(String file) {
        int idx;
        if (file == null || file.trim().length() <= 0) {
            SysUtil.abort();
        }
        if ((idx = file.lastIndexOf(".")) >= 0) {
            if (!suffixList.contains(file.substring(idx + 1).toLowerCase())) {
                SysUtil.abort();
            }
        } else if (!new File(file).exists()) {
            SysUtil.abort();
        }
    }

    static {
        suffixList.add("query");
        suffixList.add("entity");
        suffixList.add("resource");
        suffixList.add("ui");
        suffixList.add("enum");
        suffixList.add("exception");
        suffixList.add("permission");
        suffixList.add("jar");
    }

    public static class MallERecorder {
        private static Logger logger = Logger.getLogger((String)MallERecorder.class.getName());

        public static void record(MallERecordInfo info) {
            RecordQueue.getInstance().enqueue(info);
        }

        public static void record(Context ctx, String cn, String trans, String lan, String transBy, String metaType, String cnmd5) {
            MallERecordInfo rec = new MallERecordInfo();
            rec.setCnWords(cn);
            rec.setTrans(trans);
            rec.setTargetLan(lan);
            rec.setTransBy(transBy);
            rec.setMetaType(metaType);
            rec.setCnMD5(cnmd5);
            boolean shouldApply = !StringUtils.isEmpty((String)trans);
            rec.setHasApplyToSys(shouldApply);
            IMallERecord iRec = null;
            try {
                iRec = ctx == null ? MallERecordFactory.getRemoteInstance() : MallERecordFactory.getLocalInstance(ctx);
                iRec.submit((CoreBaseInfo)rec);
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
        }
    }

    public static class AutoExtractor {
        public static boolean autoExtract(Context ctx, String pkg, String fileName, String cn, String lan, String cnmd5, String metaType, String resid, String mulid, boolean haseasreswords, boolean haseasmulwords, boolean hastrans, String trans) throws BOSException, EASBizException {
            TranslateStatusEnum istransEnum;
            IEASResource ieas = null;
            IEASMultiLanRes imul = null;
            EASResourceInfo easInfo = new EASResourceInfo();
            EASMultiLanResInfo mulInfo = new EASMultiLanResInfo();
            IObjectPK easpk = null;
            if (ctx != null) {
                ieas = EASResourceFactory.getLocalInstance(ctx);
                imul = EASMultiLanResFactory.getLocalInstance(ctx);
            } else {
                ieas = EASResourceFactory.getRemoteInstance();
                imul = EASMultiLanResFactory.getRemoteInstance();
            }
            TranslateStatusEnum translateStatusEnum = istransEnum = hastrans ? TranslateStatusEnum.submit : TranslateStatusEnum.save;
            if (StringUtils.isEmpty((String)resid)) {
                easInfo.setRes(cn);
                easInfo.setIsInvalid(true);
                easInfo.setMd5Code(cnmd5);
                easInfo.setDomainId("]");
                easpk = ieas.addnew(easInfo);
                easInfo.setId(BOSUuid.read((String)easpk.toString()));
                mulInfo.setParent(easInfo);
                mulInfo.setLanguage(lan);
                mulInfo.setIsTranslated(istransEnum);
                mulInfo.setCnMd5Code(cnmd5);
                mulInfo.setRemarks("MallE Rob");
                imul.submit(mulInfo);
            } else {
                easInfo.setId(BOSUuid.read((String)resid));
                if (mulid != null) {
                    mulInfo.setId(BOSUuid.read((String)mulid));
                }
                mulInfo.setParent(easInfo);
                mulInfo.setLanguage(lan);
                mulInfo.setIsTranslated(istransEnum);
                mulInfo.setCnMd5Code(cnmd5);
                mulInfo.setContent(trans);
                mulInfo.setRemarks("MallE Rob");
                imul.submit(mulInfo);
            }
            return true;
        }
    }

    public static class AutoTranslator {
        private static Map<String, String> traCache = new ConcurrentHashMap<String, String>();
        private static Logger logger = Logger.getLogger((String)AutoTranslator.class.getName());
        private static volatile MallERobInfo mallEInfo = null;

        public static void clearTransCache() {
            traCache.clear();
            mallEInfo = null;
        }

        public static Map getTransCache() {
            return traCache;
        }

        public static String autoTranslate(Context ctx, String pkg, String fileName, String cn, String lan, String cnmd5, String metaType) throws BOSException, EASBizException {
            if (!MLUtils.containChinese(cn)) {
                return cn;
            }
            if (traCache.containsKey(cnmd5)) {
                return traCache.get(cnmd5);
            }
            IMallEAssistorFacade iassistor = null;
            iassistor = ctx != null ? MallEAssistorFacadeFactory.getLocalInstance(ctx) : MallEAssistorFacadeFactory.getRemoteInstance();
            String EASTranslate = iassistor.autoTranslate(cn, lan, pkg, fileName, metaType);
            if (!StringUtils.isEmpty((String)EASTranslate)) {
                traCache.put(cnmd5, EASTranslate);
                MallERecorder.record(ctx, cn, EASTranslate, lan, "EAS", metaType, cnmd5);
                return EASTranslate;
            }
            CloudTranslateEnum aiType = CloudTranslateEnum.YOUDAOCloud;
            String aiTrans = AutoTranslator.AITranslate(ctx, cn, lan, cnmd5, aiType, metaType);
            if (!StringUtils.isEmpty((String)aiTrans)) {
                traCache.put(cnmd5, aiTrans);
                MallERecorder.record(ctx, cn, aiTrans, lan, aiType.getName(), metaType, cnmd5);
                return aiTrans;
            }
            MallERecorder.record(ctx, cn, "", lan, "", metaType, cnmd5);
            traCache.put(cnmd5, "");
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static String AITranslate(Context ctx, String cn, String targetLan, String cnmd5, CloudTranslateEnum aiType, String metaType) throws BOSException {
            AutoTranslator.init(ctx);
            if (mallEInfo == null || !mallEInfo.isIsEnbaledCloudTranslate()) {
                return null;
            }
            ICloudTranslate iCloudTran = null;
            String cloudTrans = null;
            aiType = mallEInfo.getCloudTranslateEnum();
            iCloudTran = mallEInfo.getCloudTranslateEnum() == CloudTranslateEnum.YOUDAOCloud ? YouDaoTranslate.getInstance((MallERobInfo)mallEInfo.clone()) : AutoTranslator.getCustomCloudTransImpl((MallERobInfo)mallEInfo.clone());
            long t1 = System.currentTimeMillis();
            try {
                if (iCloudTran != null) {
                    cloudTrans = iCloudTran.translate(ctx, cn, CloudTraEnum.ZH.getValue(), CloudTraEnum.EN.getValue());
                }
            }
            catch (IOException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            finally {
                long t2 = System.currentTimeMillis();
                logger.error((Object)("\u4e91\u7ffb\u8bd1\u8017\u65f6 cn : " + (t2 - t1)));
            }
            return cloudTrans;
        }

        public static ICloudTranslate getCustomCloudTransImpl(MallERobInfo info) {
            return null;
        }

        private static void init(Context ctx) throws BOSException {
            IMallERob iMallE = null;
            if (mallEInfo == null) {
                iMallE = ctx != null ? MallERobFactory.getLocalInstance(ctx) : MallERobFactory.getRemoteInstance();
                CoreBaseCollection mallEColl = iMallE.getCollection();
                for (int i = 0; i < mallEColl.size(); ++i) {
                    mallEInfo = (MallERobInfo)mallEColl.get(0);
                }
            }
        }
    }

    public static class AutoFetcher {
        static Map cacheFetch = new ConcurrentHashMap();
        private static Logger logger = Logger.getLogger((String)AutoFetcher.class.getName());

        public static void clearFetchCache() {
            cacheFetch.clear();
        }

        public static Map getFetchCache() {
            return cacheFetch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void autoFetch(Context ctx, IMetaDataPK mdPK, BOSObjectType bosType, String ais, String pkg, String fileName, String lan, String metaType) throws Exception {
            String filePath = null;
            String MDFullName = null;
            if (StringUtils.isEmpty((String)lan) || lan.equals("zh_CN")) {
                return;
            }
            if (StringUtils.isEmpty((String)fileName)) {
                return;
            }
            if (metaType.equals("mdbview")) {
                MDFullName = fileName + ".mdbview";
            } else {
                if (StringUtils.isEmpty((String)pkg)) {
                    return;
                }
                MDFullName = pkg.replace('\\', '/') + "/" + fileName + "." + metaType;
            }
            try {
                if (ConfigMDUtil.isClient()) {
                    boolean isClientMallEOn = MallERobComponentClient.isthisClientMallEOn(lan, ais);
                    if (!isClientMallEOn) {
                        return;
                    }
                    URL url = MDLoader.getInstance().cl.getResource(MDFullName);
                    if (url == null) {
                        return;
                    }
                    filePath = url.toString().indexOf(".jar") > -1 ? url.getPath().substring(url.getPath().indexOf("file:") + 5, url.getPath().indexOf(".jar!") + 4) : url.getFile();
                    if (cacheFetch.containsKey(filePath)) {
                        return;
                    }
                    MallEFetchWordsFromJarOrFileUtil util = new MallEFetchWordsFromJarOrFileUtil(null);
                    util.setRootPath(filePath);
                    util.setLanguage(lan);
                    logger.error((Object)("\u62bd\u53d6\u6587\u4ef6\uff1afile: " + filePath));
                    util.start();
                } else {
                    boolean isServerMallEOn = MallERobComponentServer.isThisServerMallEon(ctx);
                    if (isServerMallEOn) {
                        MallEFetchWordsFromJarOrFileUtil util = new MallEFetchWordsFromJarOrFileUtil(ctx);
                        URL url = MDLoader.getInstance().cl.getResource(MDFullName);
                        if (url == null) {
                            return;
                        }
                        filePath = url.toString().indexOf(".jar") > -1 ? url.getPath().substring(url.getPath().indexOf("file:") + 5, url.getPath().indexOf(".jar!") + 4) : url.getFile();
                        if (cacheFetch.containsKey(filePath)) {
                            return;
                        }
                        util.setRootPath(filePath);
                        util.setLanguage(lan);
                        MallEFetchWordsFromJarOrFileUtil.removeSuffixList("ui");
                        logger.error((Object)("\u62bd\u53d6\u6587\u4ef6\uff1afile: " + filePath));
                        util.start();
                    }
                }
            }
            catch (Throwable th) {
                logger.error((Object)("mdPK : " + mdPK + " ais : " + ais + " pkg : " + pkg + " fileName : " + fileName + " lan : " + lan + " metaType : " + metaType), th);
            }
            finally {
                cacheFetch.put(filePath, lan);
            }
        }
    }
}

