/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.bs.ml.smartmalle;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.configure.ConfigMDUtil;
import com.kingdee.bos.orm.IORMModel;
import com.kingdee.bos.orm.ORMCoreException;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexLockType;
import com.kingdee.eas.base.netctrl.MutexParameter;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.bs.ml.smartmalle.ISynCleanMallECachesAndMarksUtil;
import com.kingdee.eas.bs.ml.smartmalle.MallEAssistor;
import com.kingdee.eas.bs.ml.smartmalle.SynCleanMallECachesAndMarksUtilFactory;
import com.kingdee.eas.bs.ml.smartmalle.util.IMallERobCachesAndMarksUtil;
import com.kingdee.eas.bs.ml.smartmalle.util.MallEWebCache;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.Uuid;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class MallERobComponentServer
implements IMallERobCachesAndMarksUtil {
    private static Logger logger = Logger.getLogger((String)MallERobComponentServer.class.getName());
    public static final String MALLE_MUTEX_NAME = "MALLE_MUTEX_SERVER";
    private static volatile boolean isServerMallEOn;
    private static volatile String mallEctxid;
    private static volatile Uuid mutexUuid;
    private static volatile String lang;
    private static volatile String ais;

    @Override
    public void clearCache() {
        MallEAssistor.AutoFetcher.clearFetchCache();
        MallEAssistor.AutoTranslator.clearTransCache();
        MallEWebCache.cleanCache();
    }

    @Override
    public Map getCache() {
        return MallEAssistor.AutoFetcher.getFetchCache();
    }

    public static boolean isThisServerMallEon(Context ctx) {
        if (ctx == null || !ctx.getAIS().equals(ais)) {
            return false;
        }
        if (!BOSLocaleUtil.getLanguage((Locale)ctx.getOriginLocale()).getLocaleString().equals(lang)) {
            return false;
        }
        return ctx.getContextID().equals(mallEctxid);
    }

    private static Locale getLocale(Locale l) {
        if (l == null) {
            Context ctx = ConfigMDUtil.getContext();
            if (ctx != null) {
                l = ctx.getOriginLocale();
            }
            if (l == null) {
                l = LocaleUtils.getDefaultOriginLocale();
            }
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean openServerMallEOn(Context ctx, String lan, String ais1) throws BOSException {
        IMutexServiceControl iMutexService = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        mutexUuid = Uuid.create();
        MutexParameter mutexParam = new MutexParameter();
        mutexParam.setRequestId(mutexUuid);
        mutexParam.setMutexLockType(MutexLockType.EXCLUSIVE_LOCK);
        mutexParam.setActionName("MallE\u673a\u5668\u4eba-\u670d\u52a1\u7aef\uff0c\u767b\u9646\u7528\u6237\uff1a " + ctx.getUserName());
        mutexParam.setMutexName(MALLE_MUTEX_NAME);
        MutexParameter memoryMutex = iMutexService.requestMutex3(ctx, mutexParam);
        MallEAssistor.AutoFetcher.clearFetchCache();
        Class<MallERobComponentServer> clazz = MallERobComponentServer.class;
        synchronized (MallERobComponentServer.class) {
            if (memoryMutex == null) {
                mallEctxid = ctx.getContextID();
                lang = lan;
                ais = ais1;
            } else {
                if (ctx.getContextID().equals(mallEctxid)) {
                    // ** MonitorExit[var7_7] (shouldn't be in output)
                    return true;
                }
                Map mutex = iMutexService.getMutexList();
                Iterator ite = mutex.entrySet().iterator();
                Object entry = null;
                Collection values = mutex.values();
                MutexParameter currentLock2 = null;
                for (MutexParameter currentLock2 : values) {
                    if (!currentLock2.getMutexName().equals(MALLE_MUTEX_NAME)) continue;
                    Uuid uid = currentLock2.getRequestId();
                    iMutexService.releaseMutex(uid);
                }
                this.closeServerMallEOn(null);
                ISynCleanMallECachesAndMarksUtil iClean = SynCleanMallECachesAndMarksUtilFactory.getInstance();
                iClean.synCleanCache();
                iClean.closeServerMallEOn(ctx);
                mallEctxid = ctx.getContextID();
                lang = lan;
                ais = ais1;
            }
            // ** MonitorExit[var7_7] (shouldn't be in output)
            return true;
        }
    }

    @Override
    public void closeServerMallEOn(Context ctx) throws BOSException {
        mallEctxid = "";
        lang = "";
        ais = "";
    }

    public IORMModel queryInterface(Class type) throws ORMCoreException {
        return null;
    }

    public static class MallEisAliveThread
    extends Thread {
        private static final long sleepTimeInMinutes = 3L;
        private volatile MallERobComponentServer rob;

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        long sleepTime = 180000L;
                        Thread.sleep(sleepTime);
                    }
                }
                catch (Throwable th) {
                    logger.error((Object)th.getMessage(), th);
                    continue;
                }
                break;
            }
        }
    }
}

