/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.bs.ml.smartmalle.app;

import com.kingdee.eas.bs.ml.smartmalle.MallERecordInfo;

public class RecordQueue {
    public static final int MAXIMUM_CAPACITY = 1024;
    public static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static RecordQueue instance;
    private MallERecordInfo[] recordDatas = new MallERecordInfo[16];
    private int size = 0;
    private int head = 0;
    private int tail = 0;

    private RecordQueue() {
    }

    public static RecordQueue getInstance() {
        if (instance == null) {
            instance = new RecordQueue();
        }
        return instance;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public synchronized void enqueue(MallERecordInfo rec) {
        if (this.size == this.recordDatas.length) {
            this.reSize();
        }
        this.recordDatas[this.tail] = rec;
        this.tail = (this.tail + 1) % this.recordDatas.length;
        ++this.size;
        if (this.size != 0) {
            this.notifyAll();
        }
    }

    public synchronized MallERecordInfo dequeue() throws InterruptedException {
        while (this.size == 0) {
            this.wait();
        }
        MallERecordInfo logData = this.recordDatas[this.head];
        this.head = (this.head + 1) % this.recordDatas.length;
        --this.size;
        return logData;
    }

    private void reSize() {
        int oldCapacity = this.recordDatas.length;
        MallERecordInfo[] oldArray = this.recordDatas;
        int newCapacity = oldCapacity << 1;
        MallERecordInfo[] newArray = new MallERecordInfo[newCapacity];
        int i = this.head;
        for (int j = 0; j < this.size; ++j) {
            newArray[j] = oldArray[i];
            i = (i + 1) % oldCapacity;
        }
        this.recordDatas = newArray;
        this.head = 0;
        this.tail = this.size;
    }
}

