/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.bs.ml.smartmalle.tool;

import com.kingdee.bos.Context;
import com.kingdee.eas.bs.ml.smartmalle.util.MallEParserHelper;
import com.kingdee.eas.bs.ml.util.MLToolsConstonts;
import com.kingdee.eas.bs.ml.util.MetaDocConst;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class MallEFetchWordsFromJarOrFileUtil {
    private static Logger logger = Logger.getLogger((String)MallEFetchWordsFromJarOrFileUtil.class.getName());
    private static List suffixList = new ArrayList();
    private String rootPath;
    private String language;
    private Context ctx;

    public MallEFetchWordsFromJarOrFileUtil(Context ctx) {
        this.ctx = ctx;
    }

    public static void removeSuffixList(String suffix) {
        suffixList.remove(suffix);
    }

    public void MallEFetchWordsFromJarOrFileUtil(String rootPath) {
        this.rootPath = rootPath;
    }

    public void MallEFetchWordsFromJarOrFileUtil() {
    }

    public void start() throws Exception {
        if (this.rootPath == null || this.rootPath.trim().length() <= 0) {
            return;
        }
        if (StringUtils.isEmpty((String)this.language)) {
            return;
        }
        File file = new File(this.rootPath);
        this.fetchWords(file);
    }

    public void startBGA(Context ctx) throws Exception {
        if (this.rootPath == null || this.rootPath.trim().length() <= 0) {
            return;
        }
        if (StringUtils.isEmpty((String)this.language)) {
            return;
        }
        File file = new File(this.rootPath);
        if (!file.exists()) {
            throw new Exception("The file path is incorrect , please check");
        }
        this.fetchWordsDir(ctx, file);
    }

    private void fetchWordsDir(Context ctx, File dic) throws Exception {
        if (dic.isDirectory()) {
            File[] arr = dic.listFiles(new FileFilterImpl());
            for (int i = 0; i < arr.length; ++i) {
                this.fetchWordsDir(ctx, arr[i]);
            }
        } else {
            String fileName = dic.getName();
            int idx = fileName.lastIndexOf(".");
            if (idx < 0) {
                return;
            }
            String suffix = fileName.substring(idx + 1);
            if (!suffixList.contains(suffix)) {
                return;
            }
            try {
                if (suffix.equals(MLToolsConstonts.JAR_SUFFIX)) {
                    this.parseJar(dic);
                }
                MallEParserHelper.parse(ctx, dic, suffix, this.language);
            }
            catch (Exception e) {
                logger.error((Object)("parse file " + dic.getName() + " error!"), (Throwable)e);
                throw e;
            }
        }
    }

    private void fetchWords(File file) throws Exception {
        String fileName = file.getName();
        int idx = fileName.lastIndexOf(".");
        if (idx < 0) {
            return;
        }
        String suffix = fileName.substring(idx + 1);
        if (!suffixList.contains(suffix)) {
            return;
        }
        try {
            if (suffix.equals(MLToolsConstonts.JAR_SUFFIX)) {
                this.parseJar(file);
            } else {
                MallEParserHelper.parse(null, file, suffix, this.language);
            }
        }
        catch (Exception e) {
            logger.error((Object)("parse file " + file.getName() + " error!"), (Throwable)e);
            throw e;
        }
    }

    private void parseJar(File jarFile) throws Exception {
        JarFile jf = null;
        try {
            jf = new JarFile(jarFile);
        }
        catch (IOException e) {
            logger.error((Object)("error file:" + jarFile.getName()));
            logger.error((Object)e.getMessage());
            throw e;
        }
        Enumeration<JarEntry> en = jf.entries();
        String pkg = "";
        while (en.hasMoreElements()) {
            String suffix;
            String name;
            int idx;
            JarEntry entry = en.nextElement();
            if (entry.isDirectory() || (idx = (name = entry.getName()).lastIndexOf(46)) < 0 || !suffixList.contains(suffix = name.substring(idx + 1))) continue;
            InputStream is = null;
            try {
                is = jf.getInputStream(entry);
            }
            catch (IOException e) {
                logger.error((Object)("error file:" + entry.getName()));
                logger.error((Object)e.getMessage());
                throw e;
            }
            SAXReader reader = new SAXReader();
            Document doc = null;
            try {
                doc = reader.read(is);
            }
            catch (Exception ex) {
                logger.error((Object)("error file:" + name));
                logger.error((Object)ex.getMessage());
                throw ex;
            }
            Element root = doc.getRootElement();
            if ("ui".equals(suffix) || "wbpage".equals(suffix)) {
                pkg = root.elementText(MetaDocConst.NODE_UI_ReleasePackage);
                if (pkg == null || "".equals(pkg)) {
                    pkg = root.elementText(MetaDocConst.NODE_PKG);
                }
                if ((name = root.elementText(MetaDocConst.NODE_UI_ReleaseClass)) == null || "".equals(name)) {
                    name = root.elementText(MetaDocConst.NODE_NAME);
                }
            } else if ("enum".equalsIgnoreCase(suffix) || "exception".equalsIgnoreCase(suffix) || "resource".equalsIgnoreCase(suffix)) {
                String clName = root.elementText(MetaDocConst.NODE_CLASS);
                if (clName == null) {
                    pkg = root.elementText(MetaDocConst.NODE_PKG);
                    name = root.elementText(MetaDocConst.NODE_NAME);
                } else {
                    int idex = clName.lastIndexOf(46);
                    if (idex >= 0) {
                        name = clName.substring(idex + 1);
                        pkg = clName.substring(0, idex);
                    }
                }
            } else {
                pkg = root.elementText(MetaDocConst.NODE_PKG);
                name = root.elementText(MetaDocConst.NODE_NAME);
            }
            MallEParserHelper.parse(this.ctx, doc, pkg, name, suffix, this.language);
        }
    }

    public String getRootPath() {
        return this.rootPath;
    }

    public void setRootPath(String rootPath) {
        this.rootPath = rootPath;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getLanguage() {
        return this.language;
    }

    static {
        suffixList.add("query");
        suffixList.add("entity");
        suffixList.add("resource");
        suffixList.add("ui");
        suffixList.add("enum");
        suffixList.add("exception");
        suffixList.add(MLToolsConstonts.JAR_SUFFIX);
        suffixList.add("permission");
        suffixList.add("table");
        suffixList.add("mdbview");
        suffixList.add("wbpage");
        suffixList.add("webui");
    }

    private static class FileFilterImpl
    implements FileFilter {
        private FileFilterImpl() {
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String name = file.getName();
            if (name.lastIndexOf(".") < 0) {
                return false;
            }
            String suffix = name.substring(name.lastIndexOf(".") + 1);
            return suffixList.contains(suffix);
        }
    }
}

