/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.bs.ml.smartmalle.util;

import com.kingdee.bos.Context;
import com.kingdee.eas.bs.ml.smartmalle.IMallEAssistorFacade;
import com.kingdee.eas.bs.ml.smartmalle.MallEAssistorFacadeFactory;
import com.kingdee.eas.bs.ml.smartmalle.MallEToolsFacadeFactory;
import com.kingdee.eas.bs.ml.smartmalle.util.MallECommonResourceParser;
import com.kingdee.eas.bs.ml.smartmalle.util.MallEPermAndLogResourceParser;
import com.kingdee.eas.bs.ml.smartmalle.util.MallEUIResourceParser;
import com.kingdee.eas.bs.ml.smartmalle.util.MallEWebPageResourceParser;
import com.kingdee.eas.bs.ml.util.MetaDocConst;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class MallEParserHelper {
    private static Logger logger = Logger.getLogger((String)MallEParserHelper.class.getName());

    public static void parse(Document doc, String pkg, String fileName, String metaType, String lan) throws Exception {
        MallEParserHelper.parse(null, doc, pkg, fileName, metaType, lan);
    }

    public static void parse(Context ctx, Document doc, String pkg, String fileName, String metaType, String lan) throws Exception {
        if (doc == null || fileName == null || metaType == null) {
            return;
        }
        if (pkg == null) {
            pkg = "";
        }
        Map mulExistsWords = null;
        Map completedWords = null;
        Map resWords = null;
        IMallEAssistorFacade iAssistor = null;
        try {
            iAssistor = ctx == null ? MallEAssistorFacadeFactory.getRemoteInstance() : MallEAssistorFacadeFactory.getLocalInstance(ctx);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        completedWords = iAssistor.getCompleteWords(pkg, fileName, metaType, lan);
        mulExistsWords = iAssistor.getMulExistsWords(pkg, fileName, metaType, lan);
        resWords = iAssistor.getResWords(pkg, fileName, metaType, lan);
        List list = null;
        if ("entity".equals(metaType) || "query".equals(metaType) || "enum".equals(metaType) || "exception".equals(metaType) || "resource".equals(metaType) || "mdbview".equals(metaType)) {
            list = MallECommonResourceParser.getInstance().parser(ctx, doc, completedWords, mulExistsWords, resWords, metaType, lan);
        } else if ("ui".equals(metaType)) {
            list = MallEUIResourceParser.getInstance().parser(ctx, doc, completedWords, mulExistsWords, resWords, metaType, lan);
        } else {
            if ("table".equals(metaType)) {
                return;
            }
            if ("permission".equals(metaType) || "log".equals(metaType)) {
                list = MallEPermAndLogResourceParser.getInstance().parser(ctx, doc, completedWords, mulExistsWords, resWords, metaType, lan);
            } else if ("wbpage".equals(metaType)) {
                list = MallEWebPageResourceParser.getInstance().parser(ctx, doc, completedWords, mulExistsWords, resWords, metaType, lan);
            }
        }
        boolean MallE = false;
        if (list != null && list.size() > 0) {
            if (ctx == null) {
                MallEToolsFacadeFactory.getRemoteInstance().saveResource(list, metaType, lan);
            } else {
                MallEToolsFacadeFactory.getLocalInstance(ctx).saveResource(list, metaType, lan);
            }
        }
    }

    public static void parse(File metaFile, String metaType, String language) throws Exception {
        MallEParserHelper.parse(null, metaFile, metaType, language);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void parse(Context ctx, File metaFile, String metaType, String language) throws Exception {
        if (metaFile == null || metaType == null) {
            return;
        }
        Document doc = null;
        try (FileInputStream fi = null;){
            SAXReader reader = new SAXReader();
            fi = new FileInputStream(metaFile);
            doc = reader.read((InputStream)fi);
        }
        Element root = doc.getRootElement();
        if (root == null) {
            return;
        }
        String pkg = null;
        String name = null;
        if ("enum".equalsIgnoreCase(metaType) || "exception".equalsIgnoreCase(metaType) || "resource".equalsIgnoreCase(metaType) || "mdbview".equalsIgnoreCase(metaType)) {
            String clName = root.elementText(MetaDocConst.NODE_CLASS);
            if (clName == null) {
                return;
            }
            int idx = clName.lastIndexOf(46);
            if (idx >= 0) {
                name = clName.substring(idx + 1);
                pkg = clName.substring(0, idx);
            }
        } else if ("ui".equalsIgnoreCase(metaType)) {
            pkg = root.elementText(MetaDocConst.NODE_UI_ReleasePackage);
            name = root.elementText(MetaDocConst.NODE_UI_ReleaseClass).trim();
        } else {
            pkg = root.elementText(MetaDocConst.NODE_PKG);
            name = root.elementText(MetaDocConst.NODE_NAME);
        }
        MallEParserHelper.parse(ctx, doc, pkg, name, metaType, language);
    }

    private static boolean domainCheck(Set domainSet, String pkg) {
        String tempPkg;
        Iterator it;
        boolean result = false;
        if (domainSet == null || domainSet.size() == 0) {
            result = true;
            return result;
        }
        if (domainSet.contains(pkg)) {
            result = true;
            return result;
        }
        if (domainSet.size() == 1) {
            it = domainSet.iterator();
            tempPkg = null;
            while (it.hasNext()) {
                tempPkg = (String)it.next();
                if (tempPkg.indexOf("EAS") != 0) continue;
                result = true;
                return result;
            }
        }
        it = domainSet.iterator();
        tempPkg = null;
        while (it.hasNext()) {
            tempPkg = (String)it.next();
            if (pkg.indexOf(tempPkg) != 0) continue;
            result = true;
            domainSet.add(pkg);
            return result;
        }
        return result;
    }
}

