/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.bs.ml.util;

import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.md5;
import com.kingdee.eas.bs.ml.util.MLConstonts;
import com.kingdee.util.BOSResourceBundle;
import com.kingdee.util.ResourceBundleUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.nio.channels.Channel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class MLUtils {
    private static final Logger logger = CoreUIObject.getLogger(MLUtils.class);
    private static Pattern ChinesePtn = Pattern.compile("^.*?[\\u4e00-\\u9fa5]+.*?$", 32);
    private static Pattern trimPatt = Pattern.compile("^[\\u3000\\u0020\\u0009]*(.*?)[\\u3000\\u0020\\u0009]*$");

    public static String getStringFromFile(String className, Locale locale, String key) {
        String str = "";
        ResourceBundle resourceBundle = BOSResourceBundle.getBundle((String)className, (Locale)locale, (boolean)false);
        try {
            str = ResourceBundleUtil.getString((ResourceBundle)resourceBundle, (String)key);
        }
        catch (RuntimeException ex) {
            logger.error((Object)(ex.getMessage() + className + "." + key));
        }
        return str;
    }

    public static String md5HashCode(String str) {
        if (str == null) {
            return str;
        }
        md5 md = new md5(str);
        md.processString();
        return md.getStringDigest();
    }

    public static boolean containChinese(String value) {
        if (value == null || value.trim().length() <= 0) {
            return false;
        }
        return ChinesePtn.matcher(value).matches();
    }

    public static String cacheResource(Map map) {
        Properties prop = System.getProperties();
        return prop.getProperty("user.home");
    }

    public static String myTrim(String str) {
        if (str == null) {
            return str;
        }
        if (str.trim().length() <= 0) {
            return str.trim();
        }
        Matcher m = trimPatt.matcher(str);
        if (m.find()) {
            return m.group(1);
        }
        return str;
    }

    public static boolean isEmpty(String str) {
        return str == null || str.trim().length() <= 0;
    }

    public static Map getFormatXmlRes(String tblName, String formatXml) throws Exception {
        if (tblName == null || formatXml == null) {
            return Collections.EMPTY_MAP;
        }
        SAXReader reader = new SAXReader();
        StringReader in = new StringReader(formatXml);
        Document doc = reader.read((Reader)in);
        String colPath = "//*[name() = 'Table']/*[name() = 't:Sheet']/*[name() = 't:Table']/*[name() = 't:ColumnGroup']/*[name() = 't:Column']";
        List colList = doc.selectNodes(colPath);
        ArrayList<String> keyList = new ArrayList<String>();
        int j = colList.size();
        for (int i = 0; i < j; ++i) {
            Element el = (Element)colList.get(i);
            keyList.add(el.attribute("key").getValue());
        }
        String headRowPath = "//*[name() = 't:Head']/*[name() = 't:Row']";
        List rowList = doc.selectNodes(headRowPath);
        String prefix = tblName + ".";
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < rowList.size(); ++i) {
            Element rowEl = (Element)rowList.get(i);
            List cells = rowEl.elements();
            if (cells.size() != keyList.size()) continue;
            int n = cells.size();
            for (int m = 0; m < n; ++m) {
                Element cellEl = (Element)cells.get(m);
                String resKey = prefix + keyList.get(m);
                if (i > 0) {
                    resKey = resKey + MLConstonts.TABLE_MULTI_HEADER + (i + 1);
                }
                map.put(resKey, cellEl.getTextTrim());
            }
        }
        return map;
    }

    public static String getProject(String path) {
        String[] patternes = new String[]{"^(.)*/AM/(.)*$", "^(.)*/HR/(.)*$", "^(.)*/BG/(.)*$,", "^(.)*/cp/(.)*$", "(.)*/FI/(.)*", "(.)*/FM/(.)*", "(.)*/MA/(.)*", "(.)*/MM/(.)*", "(.)*/QM/(.)*", "(.)*/SCM/(.)*", "(.)*/report/*(.)*"};
        for (int i = 0; i < patternes.length; ++i) {
            String patt = patternes[i];
            Pattern pt = Pattern.compile(patt, 2);
            Matcher mt = pt.matcher(path);
            if (!mt.matches()) continue;
            return patt.substring(6, patt.length() - 6);
        }
        return "";
    }

    public static boolean isValidValue_zh_CN(String value) {
        if (value == null || value.trim().length() <= 0) {
            return false;
        }
        String pattern = "(.)*[\\u4e00-\\u9fa5]+(.)*";
        Pattern p = Pattern.compile(pattern);
        return p.matcher(value).matches();
    }

    public static void closeInputStream(InputStream in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void closeInputStream(Reader reader) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void closeOutputStream(OutputStream out) {
        if (out != null) {
            try {
                out.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void closeWriter(Writer writer) {
        if (writer != null) {
            try {
                writer.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void closeChaneel(Channel channel) {
        if (channel != null) {
            try {
                channel.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void writeXML(Document doc, String filePath) throws Exception {
        if (doc == null || filePath == null) {
            return;
        }
        OutputFormat opf = OutputFormat.createPrettyPrint();
        opf.setEncoding("UTF-8");
        opf.setNewlines(true);
        opf.setLineSeparator("\r\n");
        XMLWriter xmlWriter = null;
        File file = new File(filePath);
        FileOutputStream fs = new FileOutputStream(file);
        try {
            xmlWriter = new XMLWriter((OutputStream)fs, opf);
            xmlWriter.write(doc);
            xmlWriter.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (xmlWriter != null) {
                try {
                    xmlWriter.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            fs.close();
        }
    }
}

