/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.bs.ml.util;

import com.kingdee.bos.Context;
import com.kingdee.eas.bs.ml.MLToolsFacadeFactory;
import com.kingdee.eas.bs.ml.util.CommonResourceParser;
import com.kingdee.eas.bs.ml.util.MetaDocConst;
import com.kingdee.eas.bs.ml.util.PermAndLogResourceParser;
import com.kingdee.eas.bs.ml.util.TableMultiFieldParser;
import com.kingdee.eas.bs.ml.util.UIResourceParser;
import com.kingdee.eas.bs.ml.util.WebPageResourceParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class ParserHelper {
    private static Logger logger = Logger.getLogger((String)ParserHelper.class.getName());

    public static void parse(Document doc, String pkg, String fileName, String metaType) throws Exception {
        ParserHelper.parse(null, doc, pkg, fileName, metaType);
    }

    public static void parse(Context ctx, Document doc, String pkg, String fileName, String metaType) throws Exception {
        if (doc == null || fileName == null || metaType == null) {
            return;
        }
        if (pkg == null) {
            pkg = "";
        }
        Map existWords = null;
        try {
            existWords = ctx == null ? MLToolsFacadeFactory.getRemoteInstance().getExistResource(pkg, fileName, metaType) : MLToolsFacadeFactory.getLocalInstance(ctx).getExistResource(pkg, fileName, metaType);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            throw e;
        }
        List list = null;
        if ("entity".equals(metaType) || "query".equals(metaType) || "enum".equals(metaType) || "exception".equals(metaType) || "resource".equals(metaType) || "mdbview".equals(metaType)) {
            list = CommonResourceParser.getInstance().parser(doc, existWords, metaType);
        } else if ("ui".equals(metaType)) {
            list = UIResourceParser.getInstance().parser(doc, existWords, metaType);
        } else if ("table".equals(metaType)) {
            list = TableMultiFieldParser.getInstance().parser(doc, existWords, metaType);
        } else if ("permission".equals(metaType) || "log".equals(metaType)) {
            list = PermAndLogResourceParser.getInstance().parser(doc, existWords, metaType);
        } else if ("wbpage".equals(metaType)) {
            list = WebPageResourceParser.getInstance().parser(doc, existWords, metaType);
        }
        if (list != null && list.size() > 0) {
            if (ctx == null) {
                MLToolsFacadeFactory.getRemoteInstance().saveResource(list, metaType);
            } else {
                MLToolsFacadeFactory.getLocalInstance(ctx).saveResource(list, metaType);
            }
        }
    }

    public static void parse(File metaFile, String metaType) throws Exception {
        ParserHelper.parse(null, metaFile, metaType, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void parse(Context ctx, File metaFile, String metaType, Set domainSet) throws Exception {
        if (metaFile == null || metaType == null) {
            return;
        }
        Document doc = null;
        try (FileInputStream fi = null;){
            SAXReader reader = new SAXReader();
            fi = new FileInputStream(metaFile);
            doc = reader.read((InputStream)fi);
        }
        Element root = doc.getRootElement();
        if (root == null) {
            return;
        }
        String pkg = null;
        String name = null;
        if ("enum".equalsIgnoreCase(metaType) || "exception".equalsIgnoreCase(metaType) || "resource".equalsIgnoreCase(metaType) || "mdbview".equalsIgnoreCase(metaType)) {
            String clName = root.elementText(MetaDocConst.NODE_CLASS);
            if (clName == null) {
                return;
            }
            int idx = clName.lastIndexOf(46);
            if (idx >= 0) {
                name = clName.substring(idx + 1);
                pkg = clName.substring(0, idx);
            }
        } else if ("ui".equalsIgnoreCase(metaType)) {
            pkg = root.elementText(MetaDocConst.NODE_UI_ReleasePackage);
            name = root.elementText(MetaDocConst.NODE_UI_ReleaseClass).trim();
        } else {
            pkg = root.elementText(MetaDocConst.NODE_PKG);
            name = root.elementText(MetaDocConst.NODE_NAME);
        }
        if (!ParserHelper.domainCheck(domainSet, pkg)) {
            return;
        }
        ParserHelper.parse(ctx, doc, pkg, name, metaType);
    }

    private static boolean domainCheck(Set domainSet, String pkg) {
        String tempPkg;
        Iterator it;
        boolean result = false;
        if (domainSet == null || domainSet.size() == 0) {
            result = true;
            return result;
        }
        if (domainSet.contains(pkg)) {
            result = true;
            return result;
        }
        if (domainSet.size() == 1) {
            it = domainSet.iterator();
            tempPkg = null;
            while (it.hasNext()) {
                tempPkg = (String)it.next();
                if (tempPkg.indexOf("EAS") != 0) continue;
                result = true;
                return result;
            }
        }
        it = domainSet.iterator();
        tempPkg = null;
        while (it.hasNext()) {
            tempPkg = (String)it.next();
            if (pkg.indexOf(tempPkg) != 0) continue;
            result = true;
            domainSet.add(pkg);
            return result;
        }
        return result;
    }
}

